/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.alloc.elements.FilterAllocatedArraysByLength;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;
import java.util.Arrays;

public final class LengthSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedLengths";
    private static final int MAX_RENDER_LENGTHS = 3;
    private static final int MAX_TOOL_TIP_LENGTHS = 20;
    private TextNode lengthsNode;
    private RendererNode root;

    public LengthSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.lengthsNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.lengthsNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        this.lengthsNode.setText(this.getRenderText((FilterAllocatedArraysByLength)element));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        return this.getToolTipText((FilterAllocatedArraysByLength)element);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{FilterAllocatedArraysByLength.class};
    }

    private String getRenderText(FilterAllocatedArraysByLength base) {
        int[] lengths = this.getSortedLengths(base);
        int[] froms = new int[3];
        int[] tos = new int[3];
        int nrOfGroups = this.getGroupLengths(lengths, froms, tos);
        StringBuilder result = new StringBuilder("[");
        for (int i = 0; i < Math.min(3, nrOfGroups); ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append(froms[i]);
            if (froms[i] == tos[i]) continue;
            result.append('-');
            result.append(tos[i]);
        }
        if (nrOfGroups > froms.length) {
            result.append(",...");
        }
        result.append(']');
        return result.toString();
    }

    private String getToolTipText(FilterAllocatedArraysByLength base) {
        int[] lengths = this.getSortedLengths(base);
        int[] froms = new int[20];
        int[] tos = new int[20];
        int nrOfGroups = this.getGroupLengths(lengths, froms, tos);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < Math.min(20, nrOfGroups); ++i) {
            result.append("   [");
            result.append(froms[i]);
            if (froms[i] != tos[i]) {
                result.append('-');
                result.append(tos[i]);
            }
            result.append("]\n");
        }
        if (nrOfGroups > froms.length) {
            result.append("   ...");
        }
        return result.toString();
    }

    private int[] getSortedLengths(FilterAllocatedArraysByLength base) {
        int[] result = base.getLengths();
        Arrays.sort(result);
        return result;
    }

    private int getGroupLengths(int[] lengths, int[] froms, int[] tos) {
        int maxGroups = froms.length;
        int index = 0;
        for (int group = 0; group < maxGroups; ++group) {
            froms[group] = lengths[index];
            tos[group] = lengths[index];
            boolean keepGoing = false;
            for (int i = index + 1; i < lengths.length; ++i) {
                if (lengths[i] != lengths[index] + i - index) {
                    index = i;
                    keepGoing = true;
                    break;
                }
                tos[group] = lengths[i];
            }
            if (keepGoing) continue;
            return group + 1;
        }
        return maxGroups + 1;
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        return this.getRenderText((FilterAllocatedArraysByLength)element);
    }
}

