/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.UseLoadersAsCalledRoots;
import com.sap.jvm.profiling.snapshot.elements.UseLoadersAsCallingRoots;
import com.sap.jvm.profiling.snapshot.elements.util.LoadersWithInlineBase;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class LoaderSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedLoaders";
    private static final int MAX_RENDER_LOADERS = 3;
    private static final int MAX_LOADER_NAME = 15;
    private static final int MAX_TOOL_TIP_LOADERS = 20;
    private TextNode loaderNode;
    private RendererNode root;

    public LoaderSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.loaderNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.loaderNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        this.loaderNode.setText(this.getRenderText((LoadersWithInlineBase)element));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        return this.getToolTipText((LoadersWithInlineBase)element);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{UseLoadersAsCalledRoots.class, UseLoadersAsCallingRoots.class};
    }

    private String getRenderText(LoadersWithInlineBase base) {
        ClassLoaderObject[] loaders = base.getLoaders();
        int nrOfLoaders = Math.min(3, loaders.length);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < nrOfLoaders; ++i) {
            String name;
            if (i > 0) {
                result.append(",");
            }
            if ((name = loaders[i].getDisplayName()).length() > 15) {
                result.append(".." + name.substring(name.length() - 15 + 2));
                continue;
            }
            result.append(name);
        }
        if (nrOfLoaders < loaders.length) {
            result.append(",...");
        }
        return result.toString();
    }

    private String getToolTipText(LoadersWithInlineBase base) {
        ClassLoaderObject[] loaders = base.getLoaders();
        int nrOfLoaders = Math.min(20, loaders.length);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < nrOfLoaders; ++i) {
            result.append("   ");
            result.append(loaders[i].getDisplayName());
            result.append('\n');
        }
        if (nrOfLoaders < loaders.length) {
            result.append("   ...\n");
        }
        return result.toString();
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        return this.getRenderText((LoadersWithInlineBase)element);
    }
}

