/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.presentation.impl.resource.context.Utils;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.FilterByMethodParameter;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class MethodParameterSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedMethodParameters";
    private static final int MAX_RENDER_PARAMETERS = 3;
    private static final int MAX_PARAMETER_NAME = 17;
    private static final int MAX_TOOL_TIP_PARAMETERS = 20;
    private TextNode parameterNode;
    private RendererNode root;

    public MethodParameterSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.parameterNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.parameterNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        FilterByMethodParameter impl = (FilterByMethodParameter)element;
        this.parameterNode.setText(Utils.getRenderText(new String[]{impl.getMethodParameterName()}, 3, 17));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        FilterByMethodParameter impl = (FilterByMethodParameter)element;
        return Utils.getToolTipText(new String[]{impl.getMethodParameterName()}, 20);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{FilterByMethodParameter.class};
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        FilterByMethodParameter impl = (FilterByMethodParameter)element;
        return Utils.getRenderText(new String[]{impl.getMethodParameterName()}, 3, 17);
    }
}

