/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.ElementWithMethodPath;
import com.sap.jvm.profiling.snapshot.elements.ShiftByCalledMethodPath;
import com.sap.jvm.profiling.snapshot.elements.ShiftByCallingMethodPath;
import com.sap.jvm.profiling.snapshot.util.MethodPath;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class MethodPathSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedMethodPaths";
    private static final int MAX_RENDER_PATHS = 3;
    private static final int MAX_RENDER_METHODS_PER_PATH = 2;
    private static final int MAX_TOOL_TIP_PATHS = 5;
    private static final int MAX_TOOL_TIP_METHODS_PER_PATH = 5;
    private TextNode pathsNode;
    private RendererNode root;

    public MethodPathSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.pathsNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.pathsNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        this.pathsNode.setText(this.createRendererNodeText(element));
        return this.root;
    }

    private String createRendererNodeText(ResourceNameElement element) {
        ElementWithMethodPath impl = (ElementWithMethodPath)element;
        MethodPath[] paths = impl.getPaths();
        int nrOfPaths = Math.min(paths.length, 3);
        StringBuilder text = new StringBuilder();
        boolean isCalling = element instanceof ShiftByCallingMethodPath;
        for (int i = 0; i < nrOfPaths; ++i) {
            MethodLocation[] path;
            int nrOfMethods;
            if (i > 0) {
                text.append(',');
            }
            if ((nrOfMethods = Math.min((path = paths[i].getPath()).length, 2)) < path.length) {
                text.append(isCalling ? "..<-" : "..->");
            }
            for (int j = 0; j < nrOfMethods; ++j) {
                if (j > 0) {
                    text.append(isCalling ? "<-" : "->");
                }
                MethodLocation location = path[j + path.length - nrOfMethods];
                MethodObject method = location.getMethod();
                int lineNr = location.getLineNumber();
                text.append(method.getName());
                if (method.getSignature().length() == 0) {
                    text.append("()");
                } else {
                    text.append("(..)");
                }
                if (lineNr == 0) continue;
                text.append(':');
                text.append(lineNr);
            }
        }
        if (nrOfPaths < paths.length) {
            text.append(",..");
        }
        return text.toString();
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        ElementWithMethodPath impl = (ElementWithMethodPath)element;
        MethodPath[] paths = impl.getPaths();
        int nrOfPaths = Math.min(paths.length, 5);
        StringBuilder text = new StringBuilder();
        String indent = "  ";
        for (int i = 0; i < nrOfPaths; ++i) {
            MethodLocation[] path;
            int nrOfMethods;
            if (i > 0) {
                text.append('\n');
            }
            if ((nrOfMethods = Math.min((path = paths[i].getPath()).length, 5)) < path.length) {
                text.append(indent + "...\n");
            }
            for (int j = 0; j < nrOfMethods; ++j) {
                for (int k = 0; k < j + 2; ++k) {
                    text.append(indent);
                }
                MethodLocation location = path[j + path.length - nrOfMethods];
                text.append(location.getMethod().getFullNameWithoutReturnType());
                if (location.getLineNumber() != 0) {
                    text.append(':');
                    text.append(location.getLineNumber());
                }
                text.append('\n');
            }
        }
        if (nrOfPaths < paths.length) {
            text.append("\n   ...");
        }
        return text.toString();
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{ShiftByCalledMethodPath.class, ShiftByCallingMethodPath.class};
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        return this.createRendererNodeText(element);
    }
}

