/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.UseMethodsAsCalledRoots;
import com.sap.jvm.profiling.snapshot.elements.UseMethodsAsCallingRoots;
import com.sap.jvm.profiling.snapshot.elements.util.MethodsWithInlineBase;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class MethodSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedMethods";
    private static final int MAX_RENDER_METHODS = 3;
    private static final int MAX_TOOL_TIP_METHODS = 20;
    private TextNode methodsNode;
    private RendererNode root;

    public MethodSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.methodsNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.methodsNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        this.methodsNode.setText(this.getRenderText((MethodsWithInlineBase)element));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        return this.getToolTipText((MethodsWithInlineBase)element);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{UseMethodsAsCalledRoots.class, UseMethodsAsCallingRoots.class};
    }

    private String getRenderText(MethodsWithInlineBase base) {
        MethodObject[] methods = base.getMethods();
        int nrOfMethods = Math.min(3, methods.length);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < nrOfMethods; ++i) {
            if (i > 0) {
                result.append(",");
            }
            MethodObject method = methods[i];
            result.append(method.getMethodClass().getName());
            result.append('.');
            result.append(method.getName());
            String signature = method.getSignature();
            if (signature.length() == 0) {
                result.append("()");
                continue;
            }
            result.append("(..)");
        }
        if (nrOfMethods < methods.length) {
            result.append(",...");
        }
        return result.toString();
    }

    private String getToolTipText(MethodsWithInlineBase base) {
        MethodObject[] methods = base.getMethods();
        int nrOfMethods = Math.min(20, methods.length);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < nrOfMethods; ++i) {
            result.append("   ");
            result.append(methods[i].getFullName());
            result.append('\n');
        }
        if (nrOfMethods < methods.length) {
            result.append("   ...\n");
        }
        return result.toString();
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        return this.getRenderText((MethodsWithInlineBase)element);
    }
}

