/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.presentation.impl.resource.context.Utils;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.FilterByMonitor;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class MonitorSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedMonitors";
    private static final int MAX_RENDER_NAMES = 3;
    private static final int MAX_NAME_LENGTH = 17;
    private static final int MAX_TOOL_TIP_NAMES = 20;
    private TextNode nameNode;
    private RendererNode root;

    public MonitorSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.nameNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.nameNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        FilterByMonitor impl = (FilterByMonitor)element;
        this.nameNode.setText(Utils.getRenderText(MonitorSelectionContextCreator.toString(impl.getFilter().getMonitors()), 3, 17));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        FilterByMonitor impl = (FilterByMonitor)element;
        return Utils.getToolTipText(MonitorSelectionContextCreator.toString(impl.getFilter().getMonitors()), 20);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{FilterByMonitor.class};
    }

    private static String[] toString(MonitorObject[] monitors) {
        String[] result = new String[monitors.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = monitors[i].getClassObject().getName() + "[" + monitors[i].getObjectId() + "]";
        }
        return result;
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        FilterByMonitor impl = (FilterByMonitor)element;
        return Utils.getRenderText(MonitorSelectionContextCreator.toString(impl.getFilter().getMonitors()), 3, 17);
    }
}

