/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.presentation.impl.resource.context.Utils;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.FilterByNetworkHost;
import com.sap.jvm.profiling.snapshot.net.NetworkHost;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class NetworkHostSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedNetworkHosts";
    private static final int MAX_RENDER_NAMES = 3;
    private static final int MAX_NAME_LENGTH = 20;
    private static final int MAX_TOOL_TIP_NAMES = 20;
    private TextNode nameNode;
    private RendererNode root;

    public NetworkHostSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.nameNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.nameNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        FilterByNetworkHost impl = (FilterByNetworkHost)element;
        this.nameNode.setText(Utils.getRenderText(NetworkHostSelectionContextCreator.toString(impl.getHosts()), 3, 20));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        FilterByNetworkHost impl = (FilterByNetworkHost)element;
        return Utils.getToolTipText(NetworkHostSelectionContextCreator.toString(impl.getHosts()), 20);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{FilterByNetworkHost.class};
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        FilterByNetworkHost impl = (FilterByNetworkHost)element;
        return Utils.getRenderText(NetworkHostSelectionContextCreator.toString(impl.getHosts()), 3, 20);
    }

    private static String[] toString(NetworkHost[] hosts) {
        String[] result = new String[hosts.length];
        for (int i = 0; i < result.length; ++i) {
            String hostname = hosts[i].getHostname();
            String address = hosts[i].getAddress().toString();
            result[i] = address.equals(hostname) ? address : hostname + "/" + address;
        }
        return result;
    }
}

