/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.presentation.impl.resource.context.Utils;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.FilterByNetworkService;
import com.sap.jvm.profiling.snapshot.net.NetworkConnectionSideType;
import com.sap.jvm.profiling.snapshot.net.NetworkService;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class NetworkServiceSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedNetworkServices";
    private static final int MAX_RENDER_NAMES = 3;
    private static final int MAX_NAME_LENGTH = 20;
    private static final int MAX_TOOL_TIP_NAMES = 20;
    private TextNode nameNode;
    private RendererNode root;

    public NetworkServiceSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.nameNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.nameNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        FilterByNetworkService impl = (FilterByNetworkService)element;
        this.nameNode.setText(Utils.getRenderText(NetworkServiceSelectionContextCreator.toString(impl.getServices()), 3, 20));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        FilterByNetworkService impl = (FilterByNetworkService)element;
        return Utils.getToolTipText(NetworkServiceSelectionContextCreator.toString(impl.getServices()), 20);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{FilterByNetworkService.class};
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        FilterByNetworkService impl = (FilterByNetworkService)element;
        return Utils.getRenderText(NetworkServiceSelectionContextCreator.toString(impl.getServices()), 3, 20);
    }

    private static String[] toString(NetworkService[] services) {
        String[] result = new String[services.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = services[i].getServiceName() + ":" + services[i].getPort() + (services[i].getSideType() == NetworkConnectionSideType.SERVER ? "[server," : (services[i].getSideType() == NetworkConnectionSideType.CLIENT ? "[client," : "[unconnected,")) + (services[i].isStream() ? "tcp]" : "udp]");
        }
        return result;
    }
}

