/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.presentation.impl.resource.context.Utils;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.UsePackagesAsCalledRoots;
import com.sap.jvm.profiling.snapshot.elements.UsePackagesAsCallingRoots;
import com.sap.jvm.profiling.snapshot.elements.UseSubPackagesAsCalledRoots;
import com.sap.jvm.profiling.snapshot.elements.UseSubPackagesAsCallingRoots;
import com.sap.jvm.profiling.snapshot.elements.util.PackagesWithInlineBase;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class PackageSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedPackages";
    private static final int MAX_RENDER_PACKAGES = 3;
    private static final int MAX_PACKAGE_NAME = 15;
    private static final int MAX_TOOL_TIP_PACKAGES = 20;
    private TextNode packageNode;
    private RendererNode root;

    public PackageSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.packageNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.packageNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        PackagesWithInlineBase impl = (PackagesWithInlineBase)element;
        this.packageNode.setText(Utils.getRenderText(Utils.toString(impl.getPackages(), ""), 3, 15));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        PackagesWithInlineBase impl = (PackagesWithInlineBase)element;
        return Utils.getToolTipText(Utils.toString(impl.getPackages(), ""), 20);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{UsePackagesAsCalledRoots.class, UsePackagesAsCallingRoots.class, UseSubPackagesAsCalledRoots.class, UseSubPackagesAsCallingRoots.class};
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        PackagesWithInlineBase impl = (PackagesWithInlineBase)element;
        return Utils.getRenderText(Utils.toString(impl.getPackages(), ""), 3, 15);
    }
}

