/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.presentation.impl.resource.context.Utils;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.FilterByParameterValues;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class ParameterValueSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedParameterValues";
    private static final int MAX_RENDER_VALUES = 3;
    private static final int MAX_VALUE_NAME = 25;
    private static final int MAX_TOOL_TIP_VALUES = 20;
    private TextNode valueNode;
    private RendererNode root;

    public ParameterValueSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.valueNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.valueNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        FilterByParameterValues impl = (FilterByParameterValues)element;
        this.valueNode.setText(Utils.getRenderText(Utils.toString(impl.getValues()), 3, 25));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        FilterByParameterValues impl = (FilterByParameterValues)element;
        return Utils.getToolTipText(Utils.toString(impl.getValues()), 20);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{FilterByParameterValues.class};
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        FilterByParameterValues impl = (FilterByParameterValues)element;
        return Utils.getRenderText(Utils.toString(impl.getValues()), 3, 25);
    }
}

