/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.presentation.impl.resource.context.Utils;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.FilterByReentrantLock;
import com.sap.jvm.profiling.snapshot.sync.ReentrantLockObject;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class ReentrantLockSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedReentrantLocks";
    private static final int MAX_RENDER_NAMES = 3;
    private static final int MAX_NAME_LENGTH = 17;
    private static final int MAX_TOOL_TIP_NAMES = 20;
    private TextNode nameNode;
    private RendererNode root;

    public ReentrantLockSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.nameNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.nameNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        FilterByReentrantLock impl = (FilterByReentrantLock)element;
        this.nameNode.setText(Utils.getRenderText(ReentrantLockSelectionContextCreator.toString(impl.getFilter().getLocks()), 3, 17));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        FilterByReentrantLock impl = (FilterByReentrantLock)element;
        return Utils.getToolTipText(ReentrantLockSelectionContextCreator.toString(impl.getFilter().getLocks()), 20);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{FilterByReentrantLock.class};
    }

    private static String[] toString(ReentrantLockObject[] locks) {
        String[] result = new String[locks.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Long.toString(locks[i].getObjectId());
        }
        return result;
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        FilterByReentrantLock impl = (FilterByReentrantLock)element;
        return Utils.getRenderText(ReentrantLockSelectionContextCreator.toString(impl.getFilter().getLocks()), 3, 17);
    }
}

