/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.tbs.elements.FilterByRunningType;
import com.sap.jvm.profiling.snapshot.tbs.elements.RunningType;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;
import java.util.Arrays;
import java.util.HashSet;

public class RunningTypeSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedRunningTypes";
    private TextNode idNode;
    private RendererNode root;

    public RunningTypeSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.idNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.idNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        FilterByRunningType impl = (FilterByRunningType)element;
        StringBuilder result = new StringBuilder();
        HashSet<RunningType> selected = new HashSet<RunningType>(Arrays.asList(impl.getRunningTypes()));
        if (selected.contains((Object)RunningType.COMPILED)) {
            result.append(I18n._s((String)"compiled"));
            result.append(", ");
        }
        if (selected.contains((Object)RunningType.INTERPRETED)) {
            result.append(I18n._s((String)"interpreted"));
            result.append(", ");
        }
        if (selected.contains((Object)RunningType.NATIVE)) {
            result.append(I18n._s((String)"native"));
            result.append(", ");
        }
        if (selected.contains((Object)RunningType.COMPILED_NON_NATIVE)) {
            result.append(I18n._s((String)"compiled non-native"));
            result.append(", ");
        }
        if (selected.contains((Object)RunningType.INLINED_NON_NATIVE)) {
            result.append(I18n._s((String)"inlined non-native"));
            result.append(", ");
        }
        if (selected.contains((Object)RunningType.INTERPRETED_NON_NATIVE)) {
            result.append(I18n._s((String)"interpreted non-native"));
            result.append(", ");
        }
        if (selected.contains((Object)RunningType.COMPILED_NATIVE)) {
            result.append(I18n._s((String)"compiled native"));
            result.append(", ");
        }
        if (selected.contains((Object)RunningType.INLINED_NATIVE)) {
            result.append(I18n._s((String)"inlined native"));
            result.append(", ");
        }
        if (selected.contains((Object)RunningType.INTERPRETED_NATIVE)) {
            result.append(I18n._s((String)"interpreted native"));
            result.append(", ");
        }
        if (selected.contains((Object)RunningType.COMPILED_NON_NATIVE_TIER1)) {
            result.append(I18n._s((String)"compiled non-native tier 1"));
            result.append(", ");
        }
        if (selected.contains((Object)RunningType.INLINED_NON_NATIVE_TIER1)) {
            result.append(I18n._s((String)"inlined non-native tier 1"));
            result.append(", ");
        }
        if (selected.contains((Object)RunningType.COMPILED_NATIVE_TIER1)) {
            result.append(I18n._s((String)"compiled native tier 1"));
            result.append(", ");
        }
        if (selected.contains((Object)RunningType.INLINED_NATIVE_TIER1)) {
            result.append(I18n._s((String)"inlined native tier 1"));
            result.append(", ");
        }
        if (selected.contains((Object)RunningType.OTHER)) {
            result.append(I18n._ss((String)"other running type", (String)"other"));
            result.append(", ");
        }
        String text = result.toString();
        this.idNode.setText(text.substring(0, text.length() - 2));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        FilterByRunningType impl = (FilterByRunningType)element;
        StringBuilder result = new StringBuilder();
        HashSet<RunningType> selected = new HashSet<RunningType>(Arrays.asList(impl.getRunningTypes()));
        if (selected.contains((Object)RunningType.COMPILED)) {
            result.append(I18n._s((String)"includes compiled methods"));
            result.append('\n');
        }
        if (selected.contains((Object)RunningType.INTERPRETED)) {
            result.append(I18n._s((String)"includes interpreted methods"));
            result.append('\n');
        }
        if (selected.contains((Object)RunningType.NATIVE)) {
            result.append(I18n._s((String)"includes native methods"));
            result.append('\n');
        }
        if (selected.contains((Object)RunningType.COMPILED_NON_NATIVE)) {
            result.append(I18n._s((String)"includes compiled but not inlined non-native methods"));
            result.append('\n');
        }
        if (selected.contains((Object)RunningType.INLINED_NON_NATIVE)) {
            result.append(I18n._s((String)"includes inlined non-native methods"));
            result.append('\n');
        }
        if (selected.contains((Object)RunningType.INTERPRETED_NON_NATIVE)) {
            result.append(I18n._s((String)"includes interpreted non-native methods"));
            result.append('\n');
        }
        if (selected.contains((Object)RunningType.COMPILED_NATIVE)) {
            result.append(I18n._s((String)"includes compiled but not inlined native methods"));
            result.append('\n');
        }
        if (selected.contains((Object)RunningType.INLINED_NATIVE)) {
            result.append(I18n._s((String)"includes inlined native methods"));
            result.append('\n');
        }
        if (selected.contains((Object)RunningType.INTERPRETED_NATIVE)) {
            result.append(I18n._s((String)"includes interpreted native methods"));
            result.append('\n');
        }
        if (selected.contains((Object)RunningType.COMPILED_NON_NATIVE_TIER1)) {
            result.append(I18n._s((String)"includes compiled but not inlined non-native methods in tier 1"));
            result.append('\n');
        }
        if (selected.contains((Object)RunningType.INLINED_NON_NATIVE_TIER1)) {
            result.append(I18n._s((String)"includes inlined non-native methods in tier 1"));
            result.append('\n');
        }
        if (selected.contains((Object)RunningType.COMPILED_NATIVE_TIER1)) {
            result.append(I18n._s((String)"includes compiled but not inlined native methods in tier 1"));
            result.append('\n');
        }
        if (selected.contains((Object)RunningType.INLINED_NATIVE_TIER1)) {
            result.append(I18n._s((String)"includes inlined native methods tier 1"));
            result.append('\n');
        }
        if (selected.contains((Object)RunningType.OTHER)) {
            result.append(I18n._s((String)"includes other methods"));
            result.append('\n');
        }
        return result.toString();
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{FilterByRunningType.class};
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        return this.createRendererNode(element, session).asString();
    }
}

