/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.presentation.impl.resource.context.Utils;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.FilterBySocketConnection;
import com.sap.jvm.profiling.snapshot.net.NetworkConnection;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class SocketConnectionSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedSocketConnections";
    private static final int MAX_RENDER_NAMES = 3;
    private static final int MAX_NAME_LENGTH = 20;
    private static final int MAX_TOOL_TIP_NAMES = 20;
    private TextNode nameNode;
    private RendererNode root;

    public SocketConnectionSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.nameNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.nameNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        FilterBySocketConnection impl = (FilterBySocketConnection)element;
        this.nameNode.setText(Utils.getRenderText(SocketConnectionSelectionContextCreator.toString(impl.getConnections()), 3, 20));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        FilterBySocketConnection impl = (FilterBySocketConnection)element;
        return Utils.getToolTipText(SocketConnectionSelectionContextCreator.toString(impl.getConnections()), 20);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{FilterBySocketConnection.class};
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        FilterBySocketConnection impl = (FilterBySocketConnection)element;
        return Utils.getRenderText(SocketConnectionSelectionContextCreator.toString(impl.getConnections()), 3, 20);
    }

    private static String[] toString(NetworkConnection[] connections) {
        String[] result = new String[connections.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = connections[i].getLocalAddress() + ":" + connections[i].getLocalPort() + "=>" + connections[i].getRemoteAddress() + ":" + connections[i].getRemotePort() + (connections[i].isStreamSocket() ? " [tcp]" : " [udp]");
        }
        return result;
    }
}

