/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.presentation.impl.resource.context.Utils;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.AbstractFilterBySynchronizationEvent;
import com.sap.jvm.profiling.snapshot.elements.FilterByBlockedEvent;
import com.sap.jvm.profiling.snapshot.elements.FilterByBlockingEvent;
import com.sap.jvm.profiling.snapshot.resource.SynchronizationEventId;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class SynchronizationEventSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedSynchronizationEvents";
    private static final int MAX_RENDER_NAMES = 3;
    private static final int MAX_NAME_LENGTH = 17;
    private static final int MAX_TOOL_TIP_NAMES = 20;
    private TextNode nameNode;
    private RendererNode root;

    public SynchronizationEventSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.nameNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.nameNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        AbstractFilterBySynchronizationEvent impl = (AbstractFilterBySynchronizationEvent)element;
        this.nameNode.setText(Utils.getRenderText(SynchronizationEventSelectionContextCreator.toString(impl.getFilter().getEvents()), 3, 17));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        AbstractFilterBySynchronizationEvent impl = (AbstractFilterBySynchronizationEvent)element;
        return Utils.getToolTipText(SynchronizationEventSelectionContextCreator.toString(impl.getFilter().getEvents()), 20);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{FilterByBlockedEvent.class, FilterByBlockingEvent.class};
    }

    private static String[] toString(SynchronizationEventId[] events) {
        String[] result = new String[events.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Long.toString(events[i].getIndex());
        }
        return result;
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        AbstractFilterBySynchronizationEvent impl = (AbstractFilterBySynchronizationEvent)element;
        return Utils.getRenderText(SynchronizationEventSelectionContextCreator.toString(impl.getFilter().getEvents()), 3, 17);
    }
}

