/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.presentation.impl.resource.context.Utils;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.AbstractFilterByThreadId;
import com.sap.jvm.profiling.snapshot.elements.ThreadElements;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class ThreadIdSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedThreadIds";
    private static final int MAX_RENDER_IDS = 3;
    private static final int MAX_ID_LENGTH = 17;
    private static final int MAX_TOOL_TIP_IDS = 20;
    private TextNode idNode;
    private RendererNode root;

    public ThreadIdSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.idNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.idNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        AbstractFilterByThreadId impl = (AbstractFilterByThreadId)element;
        this.idNode.setText(Utils.getRenderText(ThreadIdSelectionContextCreator.toString(impl.getIds(), impl.getNames()), 3, 17));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        AbstractFilterByThreadId impl = (AbstractFilterByThreadId)element;
        return Utils.getToolTipText(ThreadIdSelectionContextCreator.toString(impl.getIds(), impl.getNames()), 20);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{ThreadElements.FilterByThreadId.class, ThreadElements.FilterByBlockedThreadId.class, ThreadElements.FilterByBlockingThreadId.class};
    }

    private static String[] toString(long[] ids, UTF8String[] names) {
        String[] result = new String[ids.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = names[i].toString() + "[" + ids[i] + "]";
        }
        return result;
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        AbstractFilterByThreadId impl = (AbstractFilterByThreadId)element;
        return Utils.getRenderText(ThreadIdSelectionContextCreator.toString(impl.getIds(), impl.getNames()), 3, 17);
    }
}

