/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.presentation.impl.resource.context.Utils;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.AbstractFilterByThreadName;
import com.sap.jvm.profiling.snapshot.elements.ThreadElements;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class ThreadNameSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedThreadNames";
    private static final int MAX_RENDER_NAMES = 3;
    private static final int MAX_NAME_LENGTH = 17;
    private static final int MAX_TOOL_TIP_NAMES = 20;
    private TextNode nameNode;
    private RendererNode root;

    public ThreadNameSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.nameNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.nameNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        AbstractFilterByThreadName impl = (AbstractFilterByThreadName)element;
        this.nameNode.setText(Utils.getRenderText(Utils.toString(impl.getNames(), ""), 3, 17));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        AbstractFilterByThreadName impl = (AbstractFilterByThreadName)element;
        return Utils.getToolTipText(Utils.toString(impl.getNames(), ""), 20);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{ThreadElements.FilterByThreadName.class, ThreadElements.FilterByBlockedThreadName.class, ThreadElements.FilterByBlockingThreadName.class};
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        AbstractFilterByThreadName impl = (AbstractFilterByThreadName)element;
        return Utils.getRenderText(Utils.toString(impl.getNames(), ""), 3, 17);
    }
}

