/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.presentation.impl.resource.context.Utils;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.ThreadRunName;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class ThreadRunContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedThreadIds";
    private static final int MAX_NAME_LENGTH = 17;
    private TextNode nameNode;
    private RendererNode root;

    public ThreadRunContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.nameNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, viewer.newMultiChildNode(viewer.newSpaceNode(4), this.nameNode));
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        ThreadRunName impl = (ThreadRunName)element;
        this.nameNode.setText(Utils.getRenderText(new String[]{impl.getName().toString()}, 1, 17));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        ThreadRunName impl = (ThreadRunName)element;
        return Utils.getToolTipText(new String[]{impl.getName().toString()}, 1);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{ThreadRunName.class};
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        ThreadRunName impl = (ThreadRunName)element;
        return Utils.getRenderText(new String[]{impl.getName().toString()}, 1, 17);
    }
}

