/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.presentation.typed.entries.NormalPackage;
import com.sap.jvm.profiling.snapshot.filter.ClassFilter;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.framecombiner.FilterEntity;

public class Utils {
    public static String[] toString(ClassObject[] classes) {
        String[] result = new String[classes.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = classes[i].getName();
        }
        return result;
    }

    public static String[] toString(UTF8String[] strings, String suffix) {
        String[] result = new String[strings.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = strings[i].toString() + suffix;
        }
        return result;
    }

    public static String[] toString(PackageName[] packages, String suffix) {
        String[] result = new String[packages.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = NormalPackage.getDisplayName(packages[i]) + suffix;
        }
        return result;
    }

    public static String[] toString(MethodFilter[] filters) {
        String[] result = new String[filters.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = filters[i].getName();
        }
        return result;
    }

    public static String[] toString(ClassFilter[] filters) {
        String[] result = new String[filters.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = filters[i].getName();
        }
        return result;
    }

    public static String[] toString(FilterEntity[] entities) {
        String[] result = new String[entities.length];
        for (int i = 0; i < result.length; ++i) {
            MethodFilter filter = entities[i].getFilter();
            result[i] = filter == null ? I18n._s((String)"<none>") : filter.getName();
        }
        return result;
    }

    public static String[] toString(Parameter[] values) {
        String[] result = new String[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = values[i].toString();
        }
        return result;
    }

    public static String[] toString(long[] values) {
        String[] result = new String[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Long.toString(values[i]);
        }
        return result;
    }

    public static String[] toString(int[] values) {
        String[] result = new String[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Integer.toString(values[i]);
        }
        return result;
    }

    public static String getRenderText(String[] parts, int maxParts, int maxPartsLength) {
        int nrOfParts = Math.min(maxParts, parts.length);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < nrOfParts; ++i) {
            String name;
            if (i > 0) {
                result.append(",");
            }
            if ((name = parts[i]).length() > maxPartsLength) {
                result.append(".." + name.substring(name.length() - maxPartsLength + 2));
                continue;
            }
            result.append(name);
        }
        if (nrOfParts < parts.length) {
            result.append(",...");
        }
        return result.toString();
    }

    public static String getToolTipText(String[] parts, int maxParts) {
        int nrOfParts = Math.min(maxParts, parts.length);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < nrOfParts; ++i) {
            result.append("   ");
            result.append(parts[i]);
            result.append('\n');
        }
        if (nrOfParts < parts.length) {
            result.append("   ...\n");
        }
        return result.toString();
    }
}

