/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.thread.report;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ResourceLeakType;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHint;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintResourceLeak;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintTopConsumer;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.TopConsumerType;
import com.sap.jvm.profiling.thread.ThreadDumpsSummary;
import com.sap.jvm.profiling.ui.graph.BarGraphChart;
import com.sap.jvm.profiling.ui.graph.axes.BarGraphAxisCaptionProvider;
import com.sap.jvm.profiling.ui.graph.axes.RasterCalculationAdapter;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.viewer.renderer.BarsChartNode;
import com.sap.jvm.profiling.viewer.renderer.ChartNodeInitializer;

public class ThreadDumpReportBarGraphInitializer
implements ChartNodeInitializer<BarGraphChart, BarsChartNode> {
    private TopConsumerType consumerTopType;
    private ResourceLeakType resourceLeakType;
    private ThreadDumpsSummary summary;

    public ThreadDumpReportBarGraphInitializer(ThreadDumpHint hint, ThreadDumpsSummary summary) {
        this.summary = summary;
        if (hint instanceof ThreadDumpHintTopConsumer) {
            ThreadDumpHintTopConsumer topType = (ThreadDumpHintTopConsumer)hint;
            this.consumerTopType = topType.getConsumerType();
        } else if (hint instanceof ThreadDumpHintResourceLeak) {
            ThreadDumpHintResourceLeak resourceHint = (ThreadDumpHintResourceLeak)hint;
            this.resourceLeakType = resourceHint.resourceType();
        }
    }

    @Override
    public String getChartTitle() {
        return null;
    }

    private String getThreadDumpName(int idx) {
        return String.valueOf(idx);
    }

    @Override
    public void init(BarGraphChart chart, BarsChartNode node) {
        chart.setRasterColor(Color.GRAY_90);
        chart.enableVerticalBarTitels(true);
        chart.adjustXAxis(0L, node.getData().getSize());
        double space = (node.getData().getMaxY() - node.getData().getMinY()) * 0.1;
        double minY = node.getData().getMinY() < 0.0 ? node.getData().getMinY() - space : 0.0;
        chart.adjustYAxis(minY, node.getData().getMaxY() + space);
        if (this.consumerTopType != null) {
            this.configureConsumerAxis(this.consumerTopType, chart, node);
        } else if (this.resourceLeakType != null) {
            this.configureResourceLeakAxis(this.resourceLeakType, chart, node);
        } else {
            this.configureNumberAxis(chart, node);
        }
    }

    public void configureConsumerAxis(TopConsumerType type, BarGraphChart chart, BarsChartNode node) {
        switch (type) {
            case FILE_WRITE: 
            case FILE_READ: 
            case SOCKET_READ: 
            case SOCKET_WRITE: 
            case ALLOCATED: {
                this.configureBytesAxis(chart, node);
                break;
            }
            case CPU_TIME: {
                chart.setAxesCaptionProvider(new BarGraphAxisCaptionProvider(){

                    @Override
                    public String provideScaleUnitCaption(double value, double scale_step, double min, double max) {
                        return DataFormatter.getNanosDurationText((long)((long)value));
                    }

                    @Override
                    public String provideAxisTitle(double min, double max) {
                        return null;
                    }

                    @Override
                    public String provideBarIndexCaption(int idx) {
                        return ThreadDumpReportBarGraphInitializer.this.getThreadDumpName(idx);
                    }
                });
            }
        }
    }

    public void configureResourceLeakAxis(ResourceLeakType type, BarGraphChart chart, BarsChartNode node) {
        this.configureNumberAxis(chart, node);
    }

    private void configureBytesAxis(BarGraphChart chart, BarsChartNode node) {
        chart.setRasterAdaptor(new RasterCalculationAdapter(){
            private long[] steps = new long[]{1L, 2L, 5L, 10L, 20L, 50L, 100L, 200L, 512L};

            @Override
            public double adaptRasterSize(double calculatedValue, double min, double max) {
                long factor = 1L;
                while (true) {
                    for (int i = 0; i < this.steps.length; ++i) {
                        long raster = this.steps[i] * factor;
                        if (!(calculatedValue < (double)raster)) continue;
                        return raster;
                    }
                    factor *= 1024L;
                }
            }

            @Override
            public double getRasterOrigin(double rasterSize, double min) {
                return min;
            }
        });
        chart.setAxesCaptionProvider(new BarGraphAxisCaptionProvider(){

            @Override
            public String provideScaleUnitCaption(double value, double scale_step, double min, double max) {
                return DataFormatter.getNrOfBytesText((long)((long)value));
            }

            @Override
            public String provideAxisTitle(double min, double max) {
                return null;
            }

            @Override
            public String provideBarIndexCaption(int idx) {
                return ThreadDumpReportBarGraphInitializer.this.getThreadDumpName(idx);
            }
        });
    }

    private void configureNumberAxis(BarGraphChart chart, BarsChartNode node) {
        chart.setAxesCaptionProvider(new BarGraphAxisCaptionProvider(){

            @Override
            public String provideScaleUnitCaption(double value, double scale_step, double min, double max) {
                return DataFormatter.getNumberText((long)((long)value));
            }

            @Override
            public String provideAxisTitle(double min, double max) {
                return null;
            }

            @Override
            public String provideBarIndexCaption(int idx) {
                return ThreadDumpReportBarGraphInitializer.this.getThreadDumpName(idx);
            }
        });
    }
}

