/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.thread.report;

import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.description.DescriptionViewer;
import com.sap.jvm.profiling.presentation.description.renderer.MarginNode;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReport;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportHintInfo;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportNodes;
import com.sap.jvm.profiling.presentation.impl.typed.thread.ThreadDumpReportProviderImpl;
import com.sap.jvm.profiling.presentation.typed.entries.ElapsedTime;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.BlockingLockInfo;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHint;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintBlockedThread;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.thread.ThreadDumps;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

public class ThreadDumpReportBlockedThread
implements ThreadDumpReport {
    private final DescriptionViewer viewer;
    private final ThreadDumpReportNodes nodes;
    private final ThreadDumpReportProviderImpl provider;
    private static final ThreadDumpReportHintInfo hintInfo = new ThreadDumpReportHintInfo(I18n._s((String)"Blocked Thread"), I18n._s((String)"Shows a thread which is blocked by one or more monitor objects a noticeably proportion of its runnable time.\nA high block rate may result in a minor throughput of the application."), "report/report_blocked_thread.png", "report/report_blocked_thread_disabled.png");

    public ThreadDumpReportBlockedThread(DescriptionViewer viewer, ThreadDumpReportProviderImpl provider, ThreadDumpReportNodes nodes) {
        this.viewer = viewer;
        this.nodes = nodes;
        this.provider = provider;
    }

    @Override
    public RendererNode generateHint(ThreadDumpHint hint) {
        ThreadDumpHintBlockedThread blockedThreadHint = (ThreadDumpHintBlockedThread)hint;
        long blockedTime = blockedThreadHint.getBlockedTime();
        long blockedTimeNs = ThreadDumpReportNodes.convert2nanos(blockedTime);
        long runnableTime = blockedThreadHint.getRunnableTime();
        double expBlockedTime = blockedThreadHint.getExpectedBlockedTime();
        long expBlockedTimeNs = ThreadDumpReportNodes.convert2nanos(expBlockedTime);
        int blockedThreadIndex = blockedThreadHint.getBlockedThreadIndex();
        ThreadDumps threadDumps = hint.getSummary().getThreadDumps();
        ThreadDumpItem firstItem = threadDumps.getThreadRunHead(blockedThreadIndex);
        ThreadDumpItem lastItem = threadDumps.getThreadRunTail(blockedThreadIndex);
        long cpu = lastItem.getCpuTime(false) - firstItem.getCpuTime(false);
        assert (cpu >= 0L);
        RendererNode shortBlockInfo = this.nodes.replace(I18n._s((String)"A thread was blocked for at least {0} which is about {1} of its runnable time in the observed period."), this.nodes.value((ProviderEntry)ElapsedTime.PROTOTYPE.create(blockedTimeNs)), this.nodes.percentage(blockedTime, runnableTime, 0));
        RendererNode detailedThreadInfo = this.nodes.replace(I18n._s((String)"Thread {0} was blocked for at least {1} which is about {2} of its runnable time in the observed period.\nWithin the observed period, the thread consumed {3} CPU time ({4} before the period). \nOn average, an application thread was blocked for {5}.\n"), this.provider.threadLink(blockedThreadIndex, this.viewer), this.nodes.value((ProviderEntry)ElapsedTime.PROTOTYPE.create(blockedTimeNs)), this.nodes.percentage(blockedTime, runnableTime, 1), this.nodes.value((ProviderEntry)ElapsedTime.PROTOTYPE.create(cpu)), this.nodes.value((ProviderEntry)ElapsedTime.PROTOTYPE.create(firstItem.getCpuTime(false))), this.nodes.value((ProviderEntry)ElapsedTime.PROTOTYPE.create(expBlockedTimeNs)));
        String title = blockedThreadHint.getThreadBlockedInfo().size() > 1 ? I18n._s((String)"Locks the thread is blocked on:") : I18n._s((String)"Single lock the thread is blocked on:");
        detailedThreadInfo = this.nodes.lines(detailedThreadInfo, title, this.nodes.lineBreak(), this.createBlockRenderers(blockedThreadHint));
        return this.nodes.hint(hint, shortBlockInfo, detailedThreadInfo, null, hintInfo);
    }

    @Override
    public ThreadDumpReportHintInfo getHintInfo(ThreadDumpHint hint) {
        return hintInfo;
    }

    private RendererNode createBlockRenderers(ThreadDumpHintBlockedThread blockedThreadHint) {
        Collection<BlockingLockInfo> blockingLockInfos = blockedThreadHint.getThreadBlockedInfo();
        ArrayList<BlockingLockInfo> sortedBlockingLockInfos = new ArrayList<BlockingLockInfo>(blockedThreadHint.getThreadBlockedInfo().size());
        sortedBlockingLockInfos.addAll(blockingLockInfos);
        Collections.sort(sortedBlockingLockInfos, new Comparator<BlockingLockInfo>(){

            @Override
            public int compare(BlockingLockInfo lhs, BlockingLockInfo rhs) {
                long val2;
                long val1 = lhs.getBlockedTime();
                return val1 < (val2 = rhs.getBlockedTime()) ? 1 : (val1 > val2 ? -1 : 0);
            }
        });
        RendererNode[] blockedThreadNodes = new RendererNode[sortedBlockingLockInfos.size()];
        for (int pos = 0; pos < sortedBlockingLockInfos.size(); ++pos) {
            BlockingLockInfo blockedThreadInfo = (BlockingLockInfo)sortedBlockingLockInfos.get(pos);
            long threadsBlockedTimeNs = ThreadDumpReportNodes.convert2nanos(blockedThreadInfo.getBlockedTime());
            long runnableTimeNs = ThreadDumpReportNodes.convert2nanos(blockedThreadHint.getRunnableTime());
            MonitorObject lock = blockedThreadInfo.getLock();
            RendererNode timeInfo = this.nodes.replace("Blocking the thread for at least {0} which is {1} of thread's running time.\n", this.nodes.value((ProviderEntry)ElapsedTime.PROTOTYPE.create(threadsBlockedTimeNs)), this.nodes.percentage(threadsBlockedTimeNs, runnableTimeNs, 1));
            ArrayList<RendererNode> threadStacksList = new ArrayList<RendererNode>();
            for (ThreadDumpItem blockedItems : blockedThreadInfo.getBlockedThreadItems()) {
                RendererNode stackInfo = this.nodes.threadLinkAndStack(blockedItems, threadStacksList.isEmpty(), this.provider);
                threadStacksList.add(stackInfo);
            }
            RendererNode[] threadStacks = threadStacksList.toArray(new RendererNode[0]);
            String pattern = threadStacks.length > 1 ? I18n._s((String)"Stacks of the blocked thread:") : I18n._s((String)"Unique stack of the blocked thread:");
            RendererNode stackThreadInfo = this.nodes.lines(this.nodes.line(this.nodes.blockedIcon(), pattern), this.nodes.moreLess(threadStacks, 3));
            ArrayList<ThreadDumpItem> sortedBlockingThreads = new ArrayList<ThreadDumpItem>();
            for (ThreadDumpItem blockingThreadItem : blockedThreadInfo.getBlockingThreads()) {
                sortedBlockingThreads.add(blockingThreadItem);
            }
            Collections.sort(sortedBlockingThreads, new Comparator<ThreadDumpItem>(){

                @Override
                public int compare(ThreadDumpItem lhs, ThreadDumpItem rhs) {
                    String lhsName = lhs.getName().toString();
                    String rhsName = rhs.getName().toString();
                    return lhsName.compareTo(rhsName);
                }
            });
            RendererNode[] blockingThreadNodes = new RendererNode[sortedBlockingThreads.size()];
            for (int i = 0; i < sortedBlockingThreads.size(); ++i) {
                RendererNode threadLink;
                blockingThreadNodes[i] = threadLink = this.nodes.threadLinkAndStack((ThreadDumpItem)sortedBlockingThreads.get(i), i == 0, this.provider);
            }
            pattern = sortedBlockingThreads.size() > 1 ? I18n._s((String)"Blocking threads:") : I18n._s((String)"Single blocking thread:");
            RendererNode blockingThreadInfo = this.nodes.lines(this.nodes.line(this.nodes.blockingIcon(), pattern), this.nodes.moreLess(blockingThreadNodes, 3));
            MarginNode<?> detailLockInfo = this.nodes.lines(timeInfo, stackThreadInfo, blockingThreadInfo);
            detailLockInfo = this.viewer.newMarginNode(detailLockInfo, this.nodes.stackMargin());
            RendererNode threadInfo = this.nodes.replace(I18n._s((String)"Lock object {0}"), this.nodes.lock(lock));
            blockedThreadNodes[pos] = this.nodes.toggleNode(threadInfo, detailLockInfo, pos == 0 && sortedBlockingLockInfos.size() == 1);
            ++pos;
        }
        return this.nodes.moreLess(blockedThreadNodes, 5);
    }
}

