/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.thread.report;

import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.description.DescriptionViewer;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReport;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportHintInfo;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportNodes;
import com.sap.jvm.profiling.presentation.impl.typed.thread.ThreadDumpReportProviderImpl;
import com.sap.jvm.profiling.presentation.typed.entries.ElapsedTime;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHint;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintBusyLoop;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.thread.ThreadDumps;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;

public class ThreadDumpReportBusyLoop
implements ThreadDumpReport {
    private final DescriptionViewer viewer;
    private final ThreadDumpReportNodes nodes;
    private final ThreadDumpReportProviderImpl provider;
    private static final ThreadDumpReportHintInfo hintInfo = new ThreadDumpReportHintInfo(I18n._s((String)"Busy Loop"), I18n._s((String)"Shows a thread with a very high CPU consumption (near to burning a single CPU core) and which repeatedly executes a small fraction of application code at the same time.\nA typical reason for this is a thread doing a periodic task without pauses (Thread.sleep calls) or a actual live lock in application code (e.g. a loop without exit)."), "report/report_busy_loop.png", "report/report_busy_loop_disabled.png");

    public ThreadDumpReportBusyLoop(DescriptionViewer viewer, ThreadDumpReportProviderImpl provider, ThreadDumpReportNodes nodes) {
        this.viewer = viewer;
        this.nodes = nodes;
        this.provider = provider;
    }

    @Override
    public RendererNode generateHint(ThreadDumpHint hint) {
        ThreadDumpHintBusyLoop liveLockHint = (ThreadDumpHintBusyLoop)hint;
        ThreadDumps threadDumps = liveLockHint.getSummary().getThreadDumps();
        int startIndex = liveLockHint.getThreadDumpIndex();
        int threadIndex = liveLockHint.getThreadRunIndex();
        ThreadDumpItem[] threadRun = threadDumps.getThreadRun(threadIndex);
        int startDumpIndex = threadDumps.getThreadRunStartIndex(threadRun);
        int endDumpIndex = threadDumps.getThreadRunEndIndex(threadRun);
        StackFrames stackFrames = null;
        int maxIndex = startIndex;
        for (int i = startIndex; i <= endDumpIndex; ++i) {
            StackFrames curFrames = threadDumps.getStackFrame(threadRun[i].getStackTraceIndex());
            if (stackFrames != null && curFrames.getNrOfFrames() <= stackFrames.getNrOfFrames()) continue;
            stackFrames = curFrames;
            maxIndex = i;
        }
        assert (stackFrames != null && stackFrames.getNrOfFrames() >= liveLockHint.getStackBottomPrefix());
        MethodObject method = stackFrames.getMethod(liveLockHint.getStackBottomPrefix() - 1);
        RendererNode liveLockInfo = this.nodes.replace(I18n._s((String)"A thread seems to be trapped in a busy loop in method {0}."), this.nodes.method(method, false));
        RendererNode detailedLiveLockInfo = this.nodes.replace(I18n._s((String)"With a confidence of {0}, thread {1} seems to be trapped in a busy loop in method {2}."), this.nodes.percentage(hint.getImportance(), 0), this.provider.threadLink(threadIndex, this.viewer), this.nodes.method(method, true));
        ThreadDumpItem item = threadDumps.getThreadDumpItem(maxIndex, threadIndex);
        RendererNode stackRenderer = this.nodes.stack(this.provider, item, 10, stackFrames.getNrOfFrames(), stackFrames.getNrOfFrames() - liveLockHint.getStackBottomPrefix());
        stackRenderer = this.viewer.newMarginNode(stackRenderer, this.nodes.stackMargin());
        stackRenderer = this.nodes.smallFont(stackRenderer);
        long deltaTimeNs = ThreadDumpReportNodes.convert2nanos(liveLockHint.getSummary().getElapsedTimeDiff(startIndex, endDumpIndex));
        long totalTimeNs = ThreadDumpReportNodes.convert2nanos(liveLockHint.getSummary().getElapsedTimeDiff(startDumpIndex, endDumpIndex));
        assert (deltaTimeNs > 0L);
        double proportion = (double)deltaTimeNs / (double)totalTimeNs;
        RendererNode progressInfo = this.nodes.replace(I18n._s((String)"The thread consumed {0} of a CPU core in the last {1}.\nThis is about {2} of the thread's running time in the observed interval.\n"), this.nodes.percentage(liveLockHint.getCPURatio(), 1), this.nodes.value((ProviderEntry)ElapsedTime.PROTOTYPE.create(deltaTimeNs)), this.nodes.percentage(proportion, 1));
        detailedLiveLockInfo = this.nodes.lines(detailedLiveLockInfo, progressInfo, I18n._s((String)"The thread was executing the following stack:"), stackRenderer);
        return this.nodes.hint(hint, liveLockInfo, detailedLiveLockInfo, null, hintInfo);
    }

    @Override
    public ThreadDumpReportHintInfo getHintInfo(ThreadDumpHint hint) {
        return hintInfo;
    }
}

