/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.thread.report;

import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.description.DescriptionViewer;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReport;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportHintInfo;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportNodes;
import com.sap.jvm.profiling.presentation.impl.typed.thread.ThreadDumpReportProviderImpl;
import com.sap.jvm.profiling.presentation.typed.entries.Timestamp;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHint;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintDeadlock;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.thread.ThreadDumps;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class ThreadDumpReportDeadlock
implements ThreadDumpReport {
    private final DescriptionViewer viewer;
    private final ThreadDumpReportNodes nodes;
    private final ThreadDumpReportProviderImpl provider;
    private static final ThreadDumpReportHintInfo hintInfo = new ThreadDumpReportHintInfo(I18n._s((String)"Deadlock"), I18n._s((String)"Shows a deadlock cylce of threads that block each other.\nAs the involved threads never can continue with application excution, such a deadlock situation is definitely erronous."), "report/report_deadlock.png", "report/report_deadlock_disabled.png");

    public ThreadDumpReportDeadlock(DescriptionViewer viewer, ThreadDumpReportProviderImpl provider, ThreadDumpReportNodes nodes) {
        this.viewer = viewer;
        this.nodes = nodes;
        this.provider = provider;
    }

    @Override
    public RendererNode generateHint(ThreadDumpHint hint) {
        ThreadDumpHintDeadlock deadLockHint = (ThreadDumpHintDeadlock)hint;
        int dumpIndex = deadLockHint.getDumpIndex();
        int numCycleThreads = deadLockHint.getDeadlockCycle().size();
        long timestamp = deadLockHint.getSummary().getThreadDumps().getTimeStamp(dumpIndex);
        int latestDumpIndex = deadLockHint.getSummary().getThreadDumps().getNumDumps() - 1;
        RendererNode shortDeadlockInfo = this.nodes.replace(I18n._s((String)"Found a deadlock starting at {0} which contains {1} threads blocking each other."), this.nodes.value(new Timestamp(timestamp)), numCycleThreads);
        RendererNode detailedDeadlockInfo = this.nodes.replace(I18n._s((String)"Found a deadlock in {0} starting at {1} which contains {2} threads blocking each other.\n"), this.provider.dumpLink(latestDumpIndex, this.viewer), this.nodes.value(new Timestamp(timestamp)), numCycleThreads);
        RendererNode cycleThreadNodes = this.createDeadlockCycleRenderer(deadLockHint);
        RendererNode blockedThreadsNode = null;
        int numBlockedThreads = deadLockHint.getBlockedThreadHeads().size();
        if (numBlockedThreads > 0) {
            RendererNode blockedThreads = this.createBlockedThreadRenderer(deadLockHint);
            blockedThreadsNode = this.nodes.lines(this.nodes.replace(I18n._s((String)"{0} The cycle indirectly blocks additional {1} threads.\n"), this.nodes.blockedIcon(), numBlockedThreads), blockedThreads);
        } else {
            blockedThreadsNode = this.nodes.replace(I18n._s((String)"{0} The cycle does not block any additional threads."), this.nodes.blockedIcon());
        }
        detailedDeadlockInfo = this.nodes.lines(detailedDeadlockInfo, this.nodes.replace(I18n._s((String)"{0} Deadlock cycle containing the following threads:\n"), this.nodes.deadlockIcon()), cycleThreadNodes, this.nodes.lineBreak(), blockedThreadsNode);
        return this.nodes.hint(hint, shortDeadlockInfo, detailedDeadlockInfo, null, hintInfo);
    }

    @Override
    public ThreadDumpReportHintInfo getHintInfo(ThreadDumpHint hint) {
        return hintInfo;
    }

    private RendererNode createDeadlockCycleRenderer(ThreadDumpHintDeadlock deadLockHint) {
        ThreadDumps threadDumps = deadLockHint.getSummary().getThreadDumps();
        RendererNode[] cycleThreadNodes = new RendererNode[deadLockHint.getDeadlockCycle().size()];
        int pos = 0;
        for (ThreadDumpItem item : deadLockHint.getDeadlockCycle()) {
            int blockingthreadIndex = threadDumps.threadIndex2ThreadRunIndex(deadLockHint.getDumpIndex(), item.getBlockingThreadIndex());
            assert (blockingthreadIndex >= 0);
            RendererNode detailInfo = this.nodes.replace(I18n._s((String)"{0} waiting for lock object {1}\n"), this.nodes.blockedIcon(), this.nodes.lock(item.getMonitorObject()));
            int stackTraceIndex = item.getStackTraceIndex();
            assert (stackTraceIndex != -1);
            StackFrames frames = threadDumps.getStackFrame(stackTraceIndex);
            RendererNode stack = this.nodes.stack(this.provider, item, 5, frames.getNrOfFrames(), 0);
            detailInfo = this.nodes.lines(detailInfo, stack);
            detailInfo = this.viewer.newMarginNode(detailInfo, this.nodes.stackMargin());
            detailInfo = this.nodes.smallFont(detailInfo);
            RendererNode threadInfo = this.nodes.replace(I18n._s((String)"{0} blocked by thread {1}"), this.nodes.notBold(this.provider.threadLink(item, this.viewer)), this.nodes.notBold(this.provider.threadLink(blockingthreadIndex, this.viewer)));
            cycleThreadNodes[pos++] = this.nodes.toggleNode(threadInfo, detailInfo, false);
        }
        return this.nodes.lines(cycleThreadNodes);
    }

    private RendererNode createBlockedThreadRenderer(ThreadDumpHintDeadlock deadLockHint) {
        Map<Integer, List<ThreadDumpItem>> blockedThreads = deadLockHint.getBlockedThreads();
        if (blockedThreads.isEmpty()) {
            return null;
        }
        ArrayList<RendererNode> blockedThreadLines = new ArrayList<RendererNode>(blockedThreads.keySet().size());
        for (Integer dumpIndex : blockedThreads.keySet()) {
            ArrayList sortedBlockedThreads = new ArrayList(blockedThreads.size());
            sortedBlockedThreads.addAll(blockedThreads.get(dumpIndex));
            Collections.sort(sortedBlockedThreads, new Comparator<ThreadDumpItem>(){

                @Override
                public int compare(ThreadDumpItem item1, ThreadDumpItem item2) {
                    String lhsName = item1.getName().toString();
                    String rhsName = item2.getName().toString();
                    return lhsName.compareTo(rhsName);
                }
            });
            RendererNode[] blockingThreadNodes = new RendererNode[sortedBlockedThreads.size()];
            for (int i = 0; i < sortedBlockedThreads.size(); ++i) {
                if (i > 20) {
                    int skipped = sortedBlockedThreads.size() - i;
                    RendererNode skipNode = this.nodes.comment(this.nodes.text(String.format(I18n._s((String)"<skipping %d threads>"), skipped)));
                    blockingThreadNodes[i] = this.viewer.newMarginNode(skipNode, this.nodes.stackMargin());
                    break;
                }
                ThreadDumpItem item = (ThreadDumpItem)sortedBlockedThreads.get(i);
                blockingThreadNodes[i] = this.nodes.threadLinkAndStack(item, false, this.provider);
            }
            long timestamp = deadLockHint.getSummary().getThreadDumps().getTimeStamp(dumpIndex.intValue());
            RendererNode blockedThreadsNode = this.nodes.replace(I18n._s((String)"Thread(s) blocked since {0}:\n{1}"), this.nodes.value(new Timestamp(timestamp)), this.nodes.notBold(this.nodes.moreLess(blockingThreadNodes, 3)));
            blockedThreadLines.add(blockedThreadsNode);
        }
        return this.nodes.lines(blockedThreadLines);
    }
}

