/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.thread.report;

import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.description.DescriptionViewer;
import com.sap.jvm.profiling.presentation.description.renderer.MarginNode;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReport;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportHintInfo;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportNodes;
import com.sap.jvm.profiling.presentation.impl.typed.thread.ThreadDumpReportProviderImpl;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHint;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintHotspot;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.thread.ThreadDumps;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class ThreadDumpReportHotspot
implements ThreadDumpReport {
    private final DescriptionViewer viewer;
    private final ThreadDumpReportNodes nodes;
    private final ThreadDumpReportProviderImpl provider;
    private static final ThreadDumpReportHintInfo hintInfo = new ThreadDumpReportHintInfo(I18n._s((String)"Method Hotspot"), I18n._s((String)"Shows a method which was seen noticeably often being executed when a thread dump was taken.\nTo a certain degree this is a sign of a performance bottleneck in the method.\nPerforming a Performance Hotspot Trace could substantiate the suspicion."), "report/report_method_hotspot.png", "report/report_method_hotspot_disabled.png");

    public ThreadDumpReportHotspot(DescriptionViewer viewer, ThreadDumpReportProviderImpl provider, ThreadDumpReportNodes nodes) {
        this.viewer = viewer;
        this.nodes = nodes;
        this.provider = provider;
    }

    @Override
    public RendererNode generateHint(ThreadDumpHint hint) {
        ThreadDumpHintHotspot hotspotHint = (ThreadDumpHintHotspot)hint;
        ThreadDumps threadDumps = hotspotHint.getSummary().getThreadDumps();
        MethodObject method = hotspotHint.getHotspotMethod();
        double proportion = (double)hotspotHint.getNumberHits() / (double)hotspotHint.getTotalNumberHits();
        RendererNode methodInfo = this.nodes.replace(I18n._s((String)"The method {0} seems to be a hotspot in application execution.\nAbout {1} of the execution time was spent in this method."), this.nodes.method(method, false), this.nodes.percentage(proportion, 0));
        RendererNode detailedMethodInfo = this.nodes.replace(I18n._s((String)"Method {0} seems to be a hotspot in application execution.\nAbout {1} of the execution time was spent in this method.\n"), this.nodes.method(method, true), this.nodes.percentage(proportion, 1));
        RendererNode threadDetails = null;
        Map<Integer, Integer> threadHints = this.createThreadHits(hotspotHint.getStackPrefixInfo(), threadDumps);
        int numThreads = threadHints.keySet().size();
        if (numThreads > 1) {
            threadDetails = this.nodes.replace(I18n._s((String)"There were {0} different threads processing the method.\nThe method was mainly executed by following threads:\n"), numThreads);
            RendererNode threadInfos = this.createThreadList(threadHints, hotspotHint);
            threadDetails = this.nodes.lines(threadDetails, threadInfos);
        } else {
            int threadRunIndex = threadHints.keySet().iterator().next();
            threadDetails = this.nodes.replace(I18n._s((String)"Only thread {0} processed the method."), this.provider.threadLink(threadRunIndex, this.viewer));
        }
        RendererNode stacksDetails = null;
        RendererNode stackList = this.createStackList(hotspotHint);
        stacksDetails = this.nodes.lines(stacksDetails, stackList);
        detailedMethodInfo = this.nodes.lines(detailedMethodInfo, threadDetails, stacksDetails);
        return this.nodes.hint(hint, methodInfo, detailedMethodInfo, null, hintInfo);
    }

    @Override
    public ThreadDumpReportHintInfo getHintInfo(ThreadDumpHint hint) {
        return hintInfo;
    }

    private Map<Integer, Integer> createThreadHits(Iterable<ThreadDumpHintHotspot.StackPrefixInfo> stackInfos, ThreadDumps threadDumps) {
        HashMap<Integer, Integer> threadHits = new HashMap<Integer, Integer>();
        for (ThreadDumpHintHotspot.StackPrefixInfo stackInfo : stackInfos) {
            for (ThreadDumpItem item : stackInfo.getItems()) {
                int dumpIndex = threadDumps.threadDumpItem2DumpIndex(item);
                int threadRunIndex = threadDumps.threadIndex2ThreadRunIndex(dumpIndex, item.getThreadIndex());
                Integer numHits = (Integer)threadHits.get(threadRunIndex);
                if (numHits == null) {
                    numHits = 0;
                }
                threadHits.put(threadRunIndex, numHits + 1);
            }
        }
        return threadHits;
    }

    private RendererNode createStackList(ThreadDumpHintHotspot hotspotHint) {
        ArrayList stacks = new ArrayList();
        int numStacks = hotspotHint.getStackPrefixInfo().size();
        boolean differentStacks = numStacks > 1;
        RendererNode stacksDetails = null;
        stacksDetails = differentStacks ? this.nodes.replace(I18n._s((String)"In total, there were {0} different stacks with this method on top.\n"), numStacks) : this.nodes.replace(I18n._s((String)"Only the following single type of stack had this method on top:\n"), new Object[0]);
        int hitSum = 0;
        int numVisible = 0;
        for (ThreadDumpHintHotspot.StackPrefixInfo stackInfo : hotspotHint.getStackPrefixInfo()) {
            int hits = stackInfo.getNumHits();
            if (2 * hitSum <= hotspotHint.getNumberHits() && (hits > 1 || hitSum == 0)) {
                ++numVisible;
            }
            hitSum += hits;
            assert (!stackInfo.getItems().isEmpty());
            ThreadDumpItem item = stackInfo.getItems().get(0);
            int visibleFrames = Math.min(10, stackInfo.getStackPrefix());
            RendererNode stack = this.nodes.simpleStack(this.provider, item, visibleFrames, stackInfo.getStackPrefix(), 0);
            stack = this.viewer.newMarginNode(stack, this.nodes.stackMargin());
            stack = this.nodes.smallFont(stack);
            RendererNode stackNode = null;
            stackNode = differentStacks ? this.nodes.replace(I18n._s((String)"{0} of the runnable threads were seen executing the following stack:\n\n{1}"), this.nodes.percentage(stackInfo.getNumHits(), hotspotHint.getTotalNumberHits(), 1), this.nodes.notBold(stack)) : stack;
            stacks.add((MarginNode<?>)stackNode);
        }
        RendererNode stackList = null;
        if (stacks.size() > 0) {
            assert (numVisible > 0);
            stackList = this.nodes.moreLess(stacks.toArray(new RendererNode[0]), numVisible);
        }
        return this.nodes.lines(stacksDetails, stackList);
    }

    private RendererNode createThreadList(final Map<Integer, Integer> threadHits, ThreadDumpHintHotspot hotspotHint) {
        ArrayList<Integer> sortedThreads = new ArrayList<Integer>(threadHits.size());
        sortedThreads.addAll(threadHits.keySet());
        Collections.sort(sortedThreads, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                int val2;
                int val1 = (Integer)threadHits.get(o1);
                return val1 < (val2 = ((Integer)threadHits.get(o2)).intValue()) ? 1 : (val1 > val2 ? -1 : 0);
            }
        });
        ArrayList<RendererNode> threadLines = new ArrayList<RendererNode>();
        int hitSum = 0;
        int numVisible = 0;
        for (Integer threadRunIndex : sortedThreads) {
            int hits = threadHits.get(threadRunIndex);
            if (2 * hitSum <= hotspotHint.getNumberHits() && (hits > 1 || hitSum == 0)) {
                ++numVisible;
            }
            hitSum += hits;
            RendererNode threadLink = this.provider.threadLink(threadRunIndex, this.viewer);
            threadLines.add(threadLink);
            if (threadLines.size() < 20) continue;
            int skipped = sortedThreads.size() - threadLines.size();
            threadLines.add(this.nodes.comment(this.nodes.text(String.format(I18n._s((String)"<skipping %d threads>"), skipped))));
            break;
        }
        RendererNode threadInfos = null;
        if (threadLines.size() > 0) {
            threadInfos = this.nodes.moreLess(threadLines.toArray(new RendererNode[0]), numVisible);
            threadInfos = this.viewer.newMarginNode(threadInfos, this.nodes.stackMargin());
            threadInfos = this.nodes.smallFont(threadInfos);
        }
        return threadInfos;
    }
}

