/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.thread.report;

import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.description.DescriptionViewer;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReport;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportHintInfo;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportNodes;
import com.sap.jvm.profiling.presentation.impl.typed.thread.ThreadDumpReportProviderImpl;
import com.sap.jvm.profiling.presentation.typed.entries.ElapsedTime;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytes;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Timestamp;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHint;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintInactiveThread;
import com.sap.jvm.profiling.thread.SocketObject;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.thread.ThreadDumps;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;

public class ThreadDumpReportInactiveThread
implements ThreadDumpReport {
    private final DescriptionViewer viewer;
    private final ThreadDumpReportNodes nodes;
    private final ThreadDumpReportProviderImpl provider;
    private static final ThreadDumpReportHintInfo hintInactiveInfo = new ThreadDumpReportHintInfo(I18n._s((String)"Passive Thread"), I18n._s((String)"Shows an apparently runnable thread which does no progress in application execution for a conspicuously long time.\nThe most propable reason for this behaviour is a CPU overload situation in the system in which this thread could not be scheduled.\nBad response times could be the consequence."), "report/report_passive_thread.png", "report/report_passive_thread_disabled.png");
    private static final ThreadDumpReportHintInfo hintIOInfo = new ThreadDumpReportHintInfo(I18n._s((String)"Waiting for Network I/O"), I18n._s((String)"Shows a thread which was waiting for data from a socket connection for a conspicuously long time.\nBad response times of the peer could be the reason for this behaviour (e.g. evaluating a database request).\nAs long as the thread is waiting for an answer, it cannot process with application execution."), "report/report_waiting_for_io.png", "report/report_waiting_for_io_disabled.png");

    public ThreadDumpReportInactiveThread(DescriptionViewer viewer, ThreadDumpReportProviderImpl provider, ThreadDumpReportNodes nodes) {
        this.viewer = viewer;
        this.nodes = nodes;
        this.provider = provider;
    }

    @Override
    public RendererNode generateHint(ThreadDumpHint hint) {
        ThreadDumpHintInactiveThread inactiveThread = (ThreadDumpHintInactiveThread)hint;
        if (inactiveThread.isProcessingNetworkIO()) {
            return this.generateInactiveIOThread(inactiveThread);
        }
        return this.generateInactiveThread(inactiveThread);
    }

    protected RendererNode generateInactiveIOThread(ThreadDumpHintInactiveThread ioThreadHint) {
        String unknown;
        ThreadDumps dumps = ioThreadHint.getSummary().getThreadDumps();
        int threadRunIndex = ioThreadHint.getThreadRunIndex();
        int dumpStartIndex = ioThreadHint.getThreadDumpStartIndex();
        int dumpEndIndex = ioThreadHint.getThreadDumpEndIndex();
        int[] threadRange = dumps.getThreadRunRange(threadRunIndex);
        long deltaTimeNs = ThreadDumpReportNodes.convert2nanos(ioThreadHint.getSummary().getElapsedTimeDiff(dumpStartIndex, dumpEndIndex));
        long threadTimeNs = ThreadDumpReportNodes.convert2nanos(ioThreadHint.getSummary().getElapsedTimeDiff(threadRange[0], threadRange[1]));
        assert (0L < deltaTimeNs && deltaTimeNs <= threadTimeNs);
        String hostName = unknown = I18n._s((String)"<unknown>");
        String port = unknown;
        String localPort = unknown;
        SocketObject socketInfo = ioThreadHint.getSocketInfo();
        if (socketInfo != null) {
            socketInfo.resolveHostnames(dumps.getSession().getHostNameManager());
            hostName = socketInfo.getEffectiveRemoteHostname();
            port = Integer.toString(socketInfo.getRemotePort());
            localPort = Integer.toString(socketInfo.getLocalPort());
        }
        RendererNode methodInfo = this.nodes.replace(I18n._s((String)"A thread was reading from host {0} port {1} without transferring bytes for at least {2}."), hostName, port, this.nodes.value((ProviderEntry)ElapsedTime.PROTOTYPE.create(deltaTimeNs)));
        ThreadDumpItem item = dumps.getThreadDumpItem(dumpStartIndex, threadRunIndex);
        double proportion = (double)deltaTimeNs / (double)threadTimeNs;
        RendererNode detailedThreadInfo = this.nodes.replace(I18n._s((String)"Thread {0} was waiting to receive data from host {1} port {2} (local port: {3}) for at least {4} between {5} and {6}.\nDuring {7} of the its running time within the observed period, the thread did not transfer any data from the network connection.\nPrior to this, the thread read {8} and wrote {9} in network I/O.\n"), this.provider.threadLink(item, ioThreadHint.getThreadRunIndex(), this.viewer), hostName, port, localPort, this.nodes.value((ProviderEntry)ElapsedTime.PROTOTYPE.create(deltaTimeNs)), this.nodes.value(new Timestamp(dumps.getTimeStamp(dumpStartIndex))), this.nodes.value(new Timestamp(dumps.getTimeStamp(dumpEndIndex))), this.nodes.percentage(proportion, 0), this.nodes.value((ProviderEntry)NrOfBytes.PROTOTYPE.create(item.getSocketBytesRead(false))), this.nodes.value((ProviderEntry)NrOfBytes.PROTOTYPE.create(item.getSocketBytesWritten(false))));
        StackFrames stackFrames = dumps.getStackFrame(ioThreadHint.getStackTraceIndex());
        RendererNode threadInfos = this.nodes.stack(this.provider, item, 10, stackFrames.getNrOfFrames(), 0);
        if (threadInfos != null) {
            threadInfos = this.viewer.newMarginNode(threadInfos, this.nodes.stackMargin());
            threadInfos = this.nodes.smallFont(threadInfos);
            detailedThreadInfo = this.nodes.lines(detailedThreadInfo, I18n._s((String)"The thread's stack:"), threadInfos);
        }
        return this.nodes.hint(ioThreadHint, methodInfo, detailedThreadInfo, null, hintIOInfo);
    }

    protected RendererNode generateInactiveThread(ThreadDumpHintInactiveThread inactiveThread) {
        ThreadDumps dumps = inactiveThread.getSummary().getThreadDumps();
        int threadRunIndex = inactiveThread.getThreadRunIndex();
        int dumpStartIndex = inactiveThread.getThreadDumpStartIndex();
        int dumpEndIndex = inactiveThread.getThreadDumpEndIndex();
        int[] threadRange = dumps.getThreadRunRange(threadRunIndex);
        long deltaTimeNs = ThreadDumpReportNodes.convert2nanos(inactiveThread.getSummary().getElapsedTimeDiff(dumpStartIndex, dumpEndIndex));
        long threadTimeNs = ThreadDumpReportNodes.convert2nanos(inactiveThread.getSummary().getElapsedTimeDiff(threadRange[0], threadRange[1]));
        assert (0L < deltaTimeNs && deltaTimeNs <= threadTimeNs);
        double percentage = (double)deltaTimeNs / (double)threadTimeNs;
        StackFrames stackFrames = dumps.getStackFrame(inactiveThread.getStackTraceIndex());
        MethodObject topMethod = stackFrames.getTopMethod();
        RendererNode methodInfo = this.nodes.replace(I18n._s((String)"A runnable thread remained in method {0}\nwithout making any progress for at least {1}."), this.nodes.method(topMethod, false), this.nodes.value((ProviderEntry)ElapsedTime.PROTOTYPE.create(deltaTimeNs)));
        ThreadDumpItem item = dumps.getThreadDumpItem(dumpStartIndex, threadRunIndex);
        RendererNode detailedMethodInfo = this.nodes.replace(I18n._s((String)"The thread {0} paused application execution in method {1} for at least {2} between {3} and {4} although being in state 'running'.\nIt was passive for about {5} of its running time in the observed period.\nThe thread could have been blocked in native or was not scheduled due to a CPU overload situation.\nPrior to this, the thread consumed {6} CPU time.\n"), this.provider.threadLink(threadRunIndex, this.viewer), this.nodes.method(topMethod, true), this.nodes.value((ProviderEntry)ElapsedTime.PROTOTYPE.create(deltaTimeNs)), this.nodes.value(new Timestamp(dumps.getTimeStamp(dumpStartIndex))), this.nodes.value(new Timestamp(dumps.getTimeStamp(dumpEndIndex))), this.nodes.percentage(percentage, 1), this.nodes.value((ProviderEntry)ElapsedTime.PROTOTYPE.create(item.getCpuTime(false))));
        RendererNode threadInfos = this.nodes.stack(this.provider, item, 10, stackFrames.getNrOfFrames(), 0);
        if (threadInfos != null) {
            threadInfos = this.viewer.newMarginNode(threadInfos, this.nodes.stackMargin());
            threadInfos = this.nodes.smallFont(threadInfos);
            detailedMethodInfo = this.nodes.lines(detailedMethodInfo, I18n._s((String)"The thread's stack:"), threadInfos);
        }
        return this.nodes.hint(inactiveThread, methodInfo, detailedMethodInfo, null, hintInactiveInfo);
    }

    @Override
    public ThreadDumpReportHintInfo getHintInfo(ThreadDumpHint hint) {
        ThreadDumpHintInactiveThread inactiveThread = (ThreadDumpHintInactiveThread)hint;
        if (inactiveThread.isProcessingNetworkIO()) {
            return hintIOInfo;
        }
        return hintInactiveInfo;
    }
}

