/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.thread.report;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportResourceLeak;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportTopConsumer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.axis.DurationAxisModel;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ResourceLeakType;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHint;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintResourceLeak;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintTopConsumer;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.TopConsumerType;
import com.sap.jvm.profiling.ui.graph.LineGraphSelectionToolTipProvider;
import com.sap.jvm.profiling.ui.graph.LineGraphSimpleChart;
import com.sap.jvm.profiling.ui.graph.axes.AxisCaptionProviderBase;
import com.sap.jvm.profiling.ui.graph.axes.RasterCalculationAdapter;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.utils.GraphTools;
import com.sap.jvm.profiling.viewer.renderer.ChartNodeInitializer;
import com.sap.jvm.profiling.viewer.renderer.LineChartNode;
import java.util.List;

public class ThreadDumpReportLineGraphInitializer
implements ChartNodeInitializer<LineGraphSimpleChart, LineChartNode> {
    private String title;
    private TopConsumerType consumerTopType;
    private ResourceLeakType resourceLeakType;

    public ThreadDumpReportLineGraphInitializer(ThreadDumpHint hint) {
        if (hint instanceof ThreadDumpHintTopConsumer) {
            ThreadDumpHintTopConsumer topType = (ThreadDumpHintTopConsumer)hint;
            this.consumerTopType = topType.getConsumerType();
            ThreadDumpReportTopConsumer.ConsumerTypeInfo info = ThreadDumpReportTopConsumer.ConsumerTypeInfo.getInfo(this.consumerTopType);
            this.title = info.getValueTypeText();
        } else if (hint instanceof ThreadDumpHintResourceLeak) {
            ThreadDumpHintResourceLeak resourceHint = (ThreadDumpHintResourceLeak)hint;
            this.resourceLeakType = resourceHint.resourceType();
            ThreadDumpReportResourceLeak.ResourceLeakTypeInfo info = ThreadDumpReportResourceLeak.ResourceLeakTypeInfo.getInfo(this.resourceLeakType);
            this.title = info.getValueTypeText();
        }
    }

    @Override
    public String getChartTitle() {
        return this.title != null ? this.title : I18n._s((String)"Thread Dump Report Graph");
    }

    @Override
    public void init(LineGraphSimpleChart chart, LineChartNode node) {
        chart.setXRasterAdapter(GraphTools.RASTER_MILLIS_DURATION);
        chart.setXAxisCaptionProvider(GraphTools.AXIS_CAPTION_MILLIS_DURATION);
        chart.setRasterColor(Color.GRAY_90);
        LineGraphDataSet dataSet = node.getData().get(0);
        double space = (dataSet.getMaxX() - dataSet.getMinX()) * 0.05;
        chart.adjustXAxis(dataSet.getMinX(), dataSet.getMaxX() + space, false);
        double minY = 0.0;
        double maxY = Double.MIN_VALUE;
        for (LineGraphDataSet set : node.getData()) {
            minY = Math.min(set.getMinY(), minY);
            maxY = Math.max(set.getMaxY(), maxY);
        }
        space = (maxY - minY) * 0.3;
        chart.adjustYAxis(minY, maxY + space, false);
        if (this.consumerTopType != null) {
            this.configureConsumerAxis(this.consumerTopType, chart, node);
        } else if (this.resourceLeakType != null) {
            this.configureResourceLeakAxis(this.resourceLeakType, chart, node);
        } else {
            chart.setYRasterAdapter(GraphTools.RASTER_Y_NR_OF_BYTES);
            chart.setYAxisCaptionProvider(GraphTools.AXIS_CAPTION_NR_OF_BYTES);
        }
        chart.addLineGraphSelectionToolTipProvider(new LineGraphSelectionToolTipProvider(){

            @Override
            public String provideSelectedValueToolTip(LineGraphDataSet graph, List<Value2D> values) {
                StringBuilder toolTip = new StringBuilder();
                for (int i = 0; i < values.size(); ++i) {
                    Value2D v = values.get(i);
                    Object data = graph.getData(v);
                    if (data == null || !(data instanceof String)) continue;
                    toolTip.append((String)data);
                    if (i >= values.size() - 1) continue;
                    toolTip.append("\n \n");
                }
                return toolTip.toString();
            }

            @Override
            public String provideHorizontalSelectionText(double min, double max) {
                return null;
            }
        });
        chart.refresh();
    }

    public void configureConsumerAxis(TopConsumerType type, LineGraphSimpleChart chart, LineChartNode node) {
        switch (type) {
            case FILE_WRITE: 
            case FILE_READ: 
            case SOCKET_READ: 
            case SOCKET_WRITE: 
            case ALLOCATED: {
                this.configureBytesAxis(chart, node);
                break;
            }
            case CPU_TIME: {
                chart.setYRasterAdapter(GraphTools.RASTER_DURATION);
                chart.setYAxisCaptionProvider(new AxisCaptionProviderBase(){
                    DurationAxisModel model = new DurationAxisModel();

                    @Override
                    public String provideScaleUnitCaption(double value, double scale_step, double min, double max) {
                        return this.model.getTickLabel((long)value, (long)scale_step, (long)min, (long)max);
                    }
                });
            }
        }
    }

    public void configureResourceLeakAxis(ResourceLeakType type, LineGraphSimpleChart chart, LineChartNode node) {
        this.configureNumberAxis(chart, node);
    }

    private void configureBytesAxis(LineGraphSimpleChart chart, LineChartNode node) {
        chart.setYRasterAdapter(new RasterCalculationAdapter(){
            private long[] steps = new long[]{1L, 2L, 5L, 10L, 20L, 50L, 100L, 200L, 512L};

            @Override
            public double adaptRasterSize(double calculatedValue, double min, double max) {
                long factor = 1L;
                while (true) {
                    for (int i = 0; i < this.steps.length; ++i) {
                        long raster = this.steps[i] * factor;
                        if (!(calculatedValue < (double)raster)) continue;
                        return raster;
                    }
                    factor *= 1024L;
                }
            }

            @Override
            public double getRasterOrigin(double rasterSize, double min) {
                return 0.0;
            }
        });
        chart.setYAxisCaptionProvider(new AxisCaptionProviderBase(){

            @Override
            public String provideScaleUnitCaption(double value, double scale_step, double min, double max) {
                return DataFormatter.getNrOfBytesText((long)((long)value));
            }
        });
    }

    private void configureNumberAxis(LineGraphSimpleChart chart, LineChartNode node) {
        chart.setYAxisCaptionProvider(new AxisCaptionProviderBase(){

            @Override
            public String provideScaleUnitCaption(double value, double scale_step, double min, double max) {
                return DataFormatter.getNumberText((long)((long)value));
            }
        });
    }
}

