/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.thread.report;

import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.description.DescriptionViewer;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReport;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportHintInfo;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportNodes;
import com.sap.jvm.profiling.presentation.impl.typed.thread.ThreadDumpReportProviderImpl;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHint;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintLockContention;
import com.sap.jvm.profiling.thread.ThreadDumps;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import java.util.ArrayList;
import java.util.List;

public class ThreadDumpReportLockContention
implements ThreadDumpReport {
    private final DescriptionViewer viewer;
    private final ThreadDumpReportNodes nodes;
    private final ThreadDumpReportProviderImpl provider;
    private static final ThreadDumpReportHintInfo hintInfo = new ThreadDumpReportHintInfo(I18n._s((String)"Lock Contention"), I18n._s((String)"Shows a monitor object on which threads are blocked noticeably often.\nA high lock contention may form a serious performance bottleneck."), "report/report_lock_contention.png", "report/report_lock_contention_disabled.png");

    public ThreadDumpReportLockContention(DescriptionViewer viewer, ThreadDumpReportProviderImpl provider, ThreadDumpReportNodes nodes) {
        this.viewer = viewer;
        this.nodes = nodes;
        this.provider = provider;
    }

    @Override
    public RendererNode generateHint(ThreadDumpHint hint) {
        ThreadDumpHintLockContention lockHint = (ThreadDumpHintLockContention)hint;
        ThreadDumps dumps = lockHint.getSummary().getThreadDumps();
        MonitorObject lock = lockHint.getMonitorObject();
        RendererNode shortLockInfo = this.nodes.replace(I18n._s((String)"{0} of all blocked threads where blocked by a lock of type {1}."), this.nodes.percentage(lockHint.getNumThreadsBlocked(), lockHint.getTotalNumBlocked(), 0), lock.getClassObject().getFullName());
        RendererNode detailedLockInfo = this.nodes.replace(I18n._s((String)"{0} of all blocked threads where blocked by lock object {1}."), this.nodes.percentage(lockHint.getNumThreadsBlocked(), lockHint.getTotalNumBlocked(), 1), this.nodes.lock(lock));
        RendererNode additionalInfo = this.nodes.replace(I18n._s((String)"On average, {0} threads were blocked on this lock."), this.nodes.floatValue((double)lockHint.getNumThreadsBlocked() / (double)lockHint.getNumDumpsWithBlocked(), 1));
        additionalInfo = lockHint.keepsThreadsBlocked() ? this.nodes.lines(additionalInfo, I18n._s((String)"All threads that became blocked by this lock remained in blocked state.")) : this.nodes.lines(additionalInfo, I18n._s((String)"Threads that became blocked by this lock could leave the blocked state."));
        detailedLockInfo = this.nodes.lines(detailedLockInfo, additionalInfo, this.nodes.lineBreak(), this.nodes.replace("{0} {1}\n", this.nodes.blockingIcon(), I18n._s((String)"Blocking threads:")), this.createStackListRenderer(lockHint, lockHint.getBlockingThreadInfo()), this.nodes.lineBreak(), this.nodes.replace("{0} {1}\n", this.nodes.blockedIcon(), I18n._s((String)"Blocked threads:")), this.createStackListRenderer(lockHint, lockHint.getBlockedThreadInfo()));
        return this.nodes.hint(hint, shortLockInfo, detailedLockInfo, null, hintInfo);
    }

    @Override
    public ThreadDumpReportHintInfo getHintInfo(ThreadDumpHint hint) {
        return hintInfo;
    }

    private RendererNode createStackListRenderer(ThreadDumpHintLockContention lockHint, List<ThreadDumpHintLockContention.ThreadStackInfo> threadInfos) {
        ArrayList<RendererNode> threadStacks = new ArrayList<RendererNode>();
        for (ThreadDumpHintLockContention.ThreadStackInfo threadInfo : threadInfos) {
            RendererNode expandableThreadLink = this.nodes.threadLinkAndStack(threadInfo.getThreadDumpItem(), false, this.provider);
            threadStacks.add(expandableThreadLink);
            if (threadStacks.size() < 20) continue;
            int skipped = threadInfos.size() - threadStacks.size();
            RendererNode skipNode = this.nodes.comment(this.nodes.text(String.format(I18n._s((String)"<skipping %d threads>"), skipped)));
            threadStacks.add(this.viewer.newMarginNode(skipNode, this.nodes.stackMargin()));
            break;
        }
        return this.nodes.moreLess(threadStacks.toArray(new RendererNode[0]), 5);
    }
}

