/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.thread.report;

import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.core.type.MonitorObjectUsage;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.icons.ImageRepository;
import com.sap.jvm.profiling.presentation.description.DescriptionViewer;
import com.sap.jvm.profiling.presentation.description.renderer.ExpandNode;
import com.sap.jvm.profiling.presentation.description.renderer.Margin;
import com.sap.jvm.profiling.presentation.description.renderer.MarginNode;
import com.sap.jvm.profiling.presentation.description.renderer.RendererStyle;
import com.sap.jvm.profiling.presentation.description.renderer.StyleNode;
import com.sap.jvm.profiling.presentation.description.renderer.ToggleNode;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportHintInfo;
import com.sap.jvm.profiling.presentation.impl.typed.thread.ThreadDumpReportProviderImpl;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.EntryRenderer;
import com.sap.jvm.profiling.presentation.typed.TypedModelRendererFactory;
import com.sap.jvm.profiling.presentation.typed.entries.BaseQuantity;
import com.sap.jvm.profiling.presentation.typed.entries.MonitorObjectEntry;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMethod;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.SocketObjectEntry;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHint;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintUrgency;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.viewer.renderer.ChangeItalicsNode;
import com.sap.jvm.profiling.viewer.renderer.OverlayImageNode;
import com.sap.jvm.profiling.viewer.renderer.PercentageBarNode;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ThreadDumpReportNodes {
    public static final int SMALL_TEXT_SPACE = 5;
    public static final int SMALL_FONT_SIZE = -1;
    public static final int NORMAL_FONT_SIZE = 0;
    public static final int MEDIUM_FONT_SIZE = 2;
    public static final int LARGE_FONT_SIZE = 4;
    public static final int MAX_THREADS_IN_LIST = 20;
    private final DescriptionViewer viewer;
    private final Map<ImageDescription, RendererNode> imageRenderers;
    private RendererNode linebrk;
    private RendererNode smallspace;
    private final URI[] urgencyIconURI;
    private final RendererNode[] plusMinusIcon;
    private final RendererNode[] expandCollapseIcon;
    private final RendererNode[] rightDownArrowIcon;
    private final RendererNode[] zoomIcon;
    private final RendererNode[] checkboxIcon;
    private final RendererNode[] directoryIcon;
    private final RendererNode[] moreLessIcon;
    private final EntryContext entryContex;
    private final RendererNode questionIcon;
    private final RendererNode blockedImage;
    private final RendererNode blockingImage;
    private final RendererNode deadlockImage;
    private static final String[] units = new String[]{I18n._s((String)"per millisecond"), I18n._s((String)"per second"), I18n._s((String)"per minute"), I18n._s((String)"per hour")};
    private static final double[] unitFactors = new double[]{0.001, 1.0, 60.0, 3600.0};

    public ThreadDumpReportNodes(DescriptionViewer viewer, EntryContext entryContex) {
        this.viewer = viewer;
        this.entryContex = entryContex;
        this.imageRenderers = new HashMap<ImageDescription, RendererNode>();
        this.linebrk = viewer.newLineBreakNode();
        this.smallspace = viewer.newSpaceNode(5);
        this.urgencyIconURI = new URI[ThreadDumpHintUrgency.values().length];
        this.urgencyIconURI[ThreadDumpHintUrgency.NOTE.getId()] = ImageRepository.getImageURI("decorators/info.gif");
        this.urgencyIconURI[ThreadDumpHintUrgency.ERROR.getId()] = ImageRepository.getImageURI("navigation/false.gif");
        this.urgencyIconURI[ThreadDumpHintUrgency.SUSPICION.getId()] = ImageRepository.getImageURI("decorators/help_contents.gif");
        this.urgencyIconURI[ThreadDumpHintUrgency.WARNING.getId()] = ImageRepository.getImageURI("decorators/warning.gif");
        this.plusMinusIcon = new RendererNode[]{this.image(ImageRepository.getImageURI("navigation/plus.gif"), I18n._s((String)"Show more details")), this.image(ImageRepository.getImageURI("navigation/minus.gif"), I18n._s((String)"Show less details"))};
        this.expandCollapseIcon = new RendererNode[]{this.image(ImageRepository.getImageURI("navigation/expand.gif"), I18n._s((String)"Show more details")), this.image(ImageRepository.getImageURI("navigation/collapse.gif"), I18n._s((String)"Show less details"))};
        this.blockedImage = this.image(ImageRepository.getImageURI("views/monitor_locked.gif"), I18n._s((String)"Blocked thread"));
        this.blockingImage = this.image(ImageRepository.getImageURI("views/key_lock.png"), I18n._s((String)"Blocking thread"));
        this.deadlockImage = this.image(ImageRepository.getImageURI("types/deadlock_cycle.png"), I18n._s((String)"Deadlock cycle"));
        this.rightDownArrowIcon = new RendererNode[]{this.image(ImageRepository.getImageURI("report/arrow_right.gif"), I18n._s((String)"Show more details")), this.image(ImageRepository.getImageURI("report/arrow_down.gif"), I18n._s((String)"Show less details"))};
        this.zoomIcon = new RendererNode[]{this.image(ImageRepository.getImageURI("navigation/zoom_in.gif"), I18n._s((String)"Show more details")), this.image(ImageRepository.getImageURI("navigation/zoom_out.gif"), I18n._s((String)"Show less details"))};
        this.checkboxIcon = new RendererNode[]{this.image(ImageRepository.getImageURI("decorators/checkbox_selected.gif"), I18n._s((String)"Activated")), this.image(ImageRepository.getImageURI("decorators/checkbox.gif"), I18n._s((String)"Deactivated"))};
        this.directoryIcon = new RendererNode[]{this.image(ImageRepository.getImageURI("decorators/folder_opened.gif"), I18n._s((String)"Collapse section")), this.image(ImageRepository.getImageURI("decorators/folder_closed_disabled.gif"), I18n._s((String)"Expand section"))};
        this.moreLessIcon = new RendererNode[]{this.image(ImageRepository.getImageURI("decorators/called_method.gif"), I18n._s((String)"Show more Details")), this.image(ImageRepository.getImageURI("decorators/calling_method.gif"), I18n._s((String)"Show less details"))};
        this.questionIcon = this.image(ImageRepository.getImageURI("decorators/help_contents.gif"), I18n._s((String)"Show description"));
    }

    public RendererNode blockedIcon() {
        return this.blockedImage;
    }

    public RendererNode blockingIcon() {
        return this.blockingImage;
    }

    public RendererNode deadlockIcon() {
        return this.deadlockImage;
    }

    public RendererNode bar(double proportion) {
        assert (0.0 <= proportion && proportion <= 1.0);
        PercentageBarNode percentageNode = this.viewer.newPercentageBarNode();
        percentageNode.setPercentage(1.0, proportion, 0.0);
        RendererNode result = this.viewer.newStyleNode(percentageNode, RendererStyle.IMG);
        result = this.viewer.getRendererTheme().decorate("threaddumpreport.percentage-bar", this.viewer, result);
        return result;
    }

    public RendererNode bar(int val, int maxVal) {
        return this.bar((double)val / (double)maxVal);
    }

    public RendererNode percentage(double proportion, int numDec) {
        assert (0.0 <= proportion && proportion <= 1.0);
        return this.text(DataFormatter.getPercentage((double)proportion, (int)numDec));
    }

    public RendererNode percentage(long val, long maxVal, int numDec) {
        assert (0L <= val && val <= maxVal);
        return this.percentage((double)val / (double)maxVal, numDec);
    }

    public String floatValue(double value, int numDec) {
        return DataFormatter.getNumberText((double)value, (int)numDec);
    }

    public RendererNode lineBreak() {
        return this.linebrk;
    }

    public RendererNode smallFont(RendererNode node) {
        return this.viewer.newFontSizeChangeNode(-1, node);
    }

    public RendererNode normalFont(RendererNode node) {
        return this.viewer.newFontSizeChangeNode(0, node);
    }

    public RendererNode mediumFont(RendererNode node) {
        return this.viewer.newFontSizeChangeNode(2, node);
    }

    public RendererNode largeFont(RendererNode node) {
        return this.viewer.newFontSizeChangeNode(4, node);
    }

    public RendererNode bold(RendererNode node) {
        return this.viewer.newChangeBoldNode(true, node);
    }

    public RendererNode notBold(RendererNode node) {
        return this.viewer.newChangeBoldNode(false, node);
    }

    public RendererNode postAlign(RendererNode node) {
        return this.viewer.newStyleNode(node, RendererStyle.POST_ALIGN_NODE, true);
    }

    private RendererNode convert2Node(Object obj) {
        RendererNode result = null;
        if (obj instanceof RendererNode) {
            result = (RendererNode)obj;
        } else if (obj instanceof String) {
            result = this.text((String)obj);
        } else if (obj instanceof Integer) {
            result = this.text(Integer.toString((Integer)obj));
        } else if (obj instanceof Long) {
            result = this.text(Long.toString((Long)obj));
        } else if (obj instanceof Float) {
            result = this.text(Float.toString(((Float)obj).floatValue()));
        } else if (obj instanceof Double) {
            result = this.text(Double.toString((Double)obj));
        } else {
            assert (false);
            result = this.text(obj.toString());
        }
        return result;
    }

    public RendererNode line(Object ... lineParts) {
        ArrayList<RendererNode> formatedLine = new ArrayList<RendererNode>();
        for (int i = 0; i < lineParts.length; ++i) {
            Object linePart = lineParts[i];
            if (linePart == null) continue;
            if (linePart instanceof RendererNode[]) {
                RendererNode[] parts = (RendererNode[])linePart;
                for (int j = 0; j < parts.length; ++j) {
                    if (parts[j] == null) continue;
                    RendererNode lineNode = this.convert2Node(parts[j]);
                    formatedLine.add(lineNode);
                }
                continue;
            }
            RendererNode lineNode = this.convert2Node(linePart);
            formatedLine.add(lineNode);
        }
        int size = formatedLine.size();
        if (size > 1) {
            size = 2 * size - 1;
        }
        RendererNode[] result = new RendererNode[size];
        int i = 0;
        for (RendererNode node : formatedLine) {
            if (i < size) {
                result[i++] = node;
            }
            if (i >= size) continue;
            result[i++] = this.smallspace;
        }
        return this.viewer.newMultiChildNode(result);
    }

    public RendererNode line(RendererNode ... lineParts) {
        return this.line((Object[])lineParts);
    }

    public RendererNode line(List<RendererNode> lineParts) {
        return this.line(lineParts.toArray(new RendererNode[0]));
    }

    public RendererNode lines(Object ... lines) {
        ArrayList<RendererNode> formatedLines = new ArrayList<RendererNode>();
        for (int i = 0; i < lines.length; ++i) {
            Object line = lines[i];
            if (line == null) continue;
            if (line instanceof RendererNode[]) {
                RendererNode[] lineParts = (RendererNode[])line;
                for (int j = 0; j < lineParts.length; ++j) {
                    RendererNode node;
                    if (lineParts[j] == null || (node = lineParts[j]) == this.linebrk && j == lineParts.length - 1) continue;
                    formatedLines.add(node);
                }
                continue;
            }
            RendererNode lineNode = this.convert2Node(line);
            formatedLines.add(lineNode);
        }
        int size = formatedLines.size();
        if (size > 1) {
            size = 2 * size - 1;
        }
        RendererNode[] result = new RendererNode[size];
        int i = 0;
        for (RendererNode node : formatedLines) {
            if (i < size) {
                result[i++] = node;
            }
            if (i >= size) continue;
            result[i++] = this.linebrk;
        }
        return this.viewer.newMultiChildNode(result);
    }

    public RendererNode lines(RendererNode ... lines) {
        return this.lines((Object[])lines);
    }

    public RendererNode lines(List<RendererNode> lines) {
        return this.lines(lines.toArray(new RendererNode[0]));
    }

    public RendererNode text(String text) {
        assert (text.equals(text.trim()));
        return this.viewer.newTextNode(text);
    }

    public RendererNode value(ProviderEntry entry) {
        try {
            EntryRenderer entryRenderer = TypedModelRendererFactory.getRenderer(this.viewer, this.viewer.getRendererTheme().getSpec(), entry);
            return entryRenderer.getRenderer(entry, this.entryContex, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.viewer.newTextNode("<unknown>");
        }
    }

    public RendererNode valueBar(long value, long maxValue, BaseQuantity<?> prototype) {
        try {
            Object entry = prototype.create(value, maxValue);
            EntryRenderer entryRenderer = TypedModelRendererFactory.getRenderer(this.viewer, this.viewer.getRendererTheme().getSpec(), entry);
            return entryRenderer.getRenderer((ProviderEntry)entry, this.entryContex, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.viewer.newTextNode(Long.toString(value) + " max: " + Long.toString(maxValue));
        }
    }

    public RendererNode replace(String textPattern, Object ... arguments) {
        ArrayList<ReplacementNode> replacements = new ArrayList<ReplacementNode>(arguments.length + 1);
        replacements.add(new ReplacementNode("\n", this.lineBreak()));
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] != null) {
                RendererNode replacement = this.convert2Node(arguments[i]);
                replacements.add(new ReplacementNode("{" + i + "}", this.bold(replacement)));
                continue;
            }
            replacements.add(new ReplacementNode("{" + i + "}", null));
        }
        return this.replaceImpl(textPattern, replacements);
    }

    private RendererNode replaceImpl(String textPattern, List<ReplacementNode> replacements) {
        ArrayList<Integer> cutPoints = new ArrayList<Integer>();
        for (ReplacementNode rep : replacements) {
            this.findMarker(textPattern, cutPoints, rep.marker, 0);
        }
        Collections.sort(cutPoints);
        if (cutPoints.size() == 0) {
            return this.viewer.newTextNode(textPattern);
        }
        ArrayList<String> parts = new ArrayList<String>(cutPoints.size() + 1);
        int lastPos = 0;
        for (int cutPoint : cutPoints) {
            if (cutPoint == lastPos) continue;
            parts.add(textPattern.substring(lastPos, cutPoint));
            lastPos = cutPoint;
        }
        if (lastPos != textPattern.length()) {
            parts.add(textPattern.substring(lastPos));
        }
        ArrayList<RendererNode> result = new ArrayList<RendererNode>(parts.size());
        for (int i = 0; i < parts.size(); ++i) {
            String part = (String)parts.get(i);
            boolean replaced = false;
            for (ReplacementNode rep : replacements) {
                if (!part.equals(rep.marker)) continue;
                if (rep.replacement != null) {
                    result.add(rep.replacement);
                }
                replaced = true;
                break;
            }
            if (replaced) continue;
            result.add(this.viewer.newTextNode(part));
        }
        return this.viewer.newMultiChildNode(result.toArray(new RendererNode[0]));
    }

    private void findMarker(String textPattern, ArrayList<Integer> cutPoints, String marker, int startPos) {
        int pos = textPattern.indexOf(marker, startPos);
        if (pos >= 0) {
            cutPoints.add(pos);
            cutPoints.add(pos + marker.length());
            this.findMarker(textPattern, cutPoints, marker, pos + marker.length());
        }
    }

    public RendererNode image(URI imageURI, String description) {
        ImageDescription imageDesc = new ImageDescription(imageURI, description);
        RendererNode result = this.imageRenderers.get(imageDesc);
        if (result == null) {
            result = this.viewer.newImageNode(imageURI, description);
            this.imageRenderers.put(imageDesc, result);
        }
        return this.viewer.newStyleNode(result, RendererStyle.IMG);
    }

    RendererNode urgencyImage(URI imageURI, String description, ThreadDumpHintUrgency urgency) {
        URI urgencyOverlay = this.urgencyIconURI[urgency.getId()];
        assert (urgencyOverlay != null);
        OverlayImageNode iconNode = this.viewer.newOverlayImageNode(new URI[]{imageURI, urgencyOverlay}, null, description);
        iconNode.setIndices(new int[]{0, 1});
        return iconNode;
    }

    public ToggleNode<?> expandCollapseToggle(RendererNode[] icons, boolean opened) {
        assert (icons.length == 2);
        int index = opened ? 1 : 0;
        return this.viewer.newToggleNode(icons[index], icons[1 - index]);
    }

    private RendererNode linkStyle(RendererNode child) {
        return this.viewer.newColorNode(255, -1, -1, -1, -1, -1, -1, child);
    }

    RendererNode moreLess(RendererNode[] nodes, int numVisible) {
        Margin verticalGap = new Margin(0, 10);
        MarginNode<?> moreDetailsText = this.text(String.format(I18n._s((String)"%d more"), nodes.length - numVisible));
        moreDetailsText = this.linkStyle(moreDetailsText);
        moreDetailsText = this.line(this.moreLessIcon[0], moreDetailsText);
        moreDetailsText = this.viewer.newMarginNode(moreDetailsText, verticalGap);
        MarginNode<?> lessDetailsText = this.text(I18n._s((String)"less"));
        lessDetailsText = this.linkStyle(lessDetailsText);
        lessDetailsText = this.line(this.moreLessIcon[1], lessDetailsText);
        lessDetailsText = this.viewer.newMarginNode(lessDetailsText, verticalGap);
        int effNumVisible = numVisible;
        if (numVisible < 10 && (double)nodes.length < 1.5 * (double)numVisible) {
            effNumVisible = nodes.length;
        }
        return this.list(nodes, effNumVisible, moreDetailsText, lessDetailsText);
    }

    RendererNode list(RendererNode[] nodes, int numVisible, RendererNode moreNode, RendererNode lessNode) {
        if (nodes.length <= numVisible) {
            return this.lines(nodes);
        }
        RendererNode[] visibleNodes = new RendererNode[numVisible];
        System.arraycopy(nodes, 0, visibleNodes, 0, visibleNodes.length);
        RendererNode[] hiddenNodes = new RendererNode[nodes.length - numVisible];
        System.arraycopy(nodes, numVisible, hiddenNodes, 0, hiddenNodes.length);
        ToggleNode<?> moreDetailsToggle = this.viewer.newToggleNode(moreNode, this.viewer.newNopNode());
        ToggleNode<?> hiddenStackToggle = this.viewer.newToggleNode(this.viewer.newNopNode(), this.lines(hiddenNodes));
        ToggleNode<?> lessDetailsToggle = this.viewer.newToggleNode(this.viewer.newNopNode(), lessNode);
        ExpandNode<?> moreDetails = this.viewer.newExpandNode(moreDetailsToggle, new ToggleNode[]{moreDetailsToggle, hiddenStackToggle, lessDetailsToggle});
        ExpandNode<?> lessDetails = this.viewer.newExpandNode(lessDetailsToggle, new ToggleNode[]{moreDetailsToggle, hiddenStackToggle, lessDetailsToggle});
        return this.lines(new Object[]{visibleNodes, this.viewer.newMultiChildNode(moreDetails, this.viewer.newMultiChildNode(hiddenStackToggle, lessDetails))});
    }

    RendererNode threadLinkAndStack(ThreadDumpItem item, boolean expanded, ThreadDumpReportProviderImpl provider) {
        RendererNode threadLink = provider.threadLink(item, this.viewer);
        StackFrames frames = provider.getSummary().getThreadDumps().getStackFrame(item.getStackTraceIndex());
        RendererNode stack = this.stack(provider, item, 5, frames.getNrOfFrames(), 0);
        stack = this.viewer.newMarginNode(stack, this.stackMargin());
        stack = this.smallFont(stack);
        return this.toggleNode(threadLink, stack, expanded);
    }

    public RendererNode toggleNode(RendererNode title, RendererNode child, RendererNode[] icons, boolean expanded, boolean prepend) {
        ToggleNode<?> detailInfoToggle = expanded ? this.viewer.newToggleNode(child, this.viewer.newNopNode()) : this.viewer.newToggleNode(this.viewer.newNopNode(), child);
        ToggleNode<?> toggleNode = this.expandCollapseToggle(icons, expanded);
        RendererNode expandNode = this.viewer.newExpandNode(toggleNode, new ToggleNode[]{detailInfoToggle, toggleNode});
        expandNode = this.viewer.newStyleNode(expandNode, RendererStyle.IMG);
        RendererNode titleLine = prepend ? this.line(expandNode, title) : this.line(title, expandNode);
        return this.viewer.newMultiChildNode(titleLine, detailInfoToggle);
    }

    public RendererNode toggleNode(RendererNode titleOpen, RendererNode childOpen, RendererNode titleClosed, RendererNode childClosed) {
        ToggleNode<?> childToggle = this.viewer.newToggleNode(childOpen, childClosed);
        ToggleNode<?> titleToggle = this.viewer.newToggleNode(titleOpen, titleClosed);
        ExpandNode<?> expandNode = this.viewer.newExpandNode(titleToggle, new ToggleNode[]{childToggle, titleToggle});
        return this.viewer.newMultiChildNode(expandNode, childToggle);
    }

    RendererNode toggleNode(RendererNode title, RendererNode child, boolean expanded) {
        return this.toggleNode(title, child, this.expandCollapseIcon, expanded, true);
    }

    private RendererNode frameObjects(ThreadDumpItem item, int frameIndex, boolean topFrame) {
        List objs;
        ArrayList<RendererNode> frameObjects = new ArrayList<RendererNode>();
        if (topFrame) {
            if (item.getMonitorObject() != null) {
                MonitorObjectUsage usage = null;
                switch (item.getStatus()) {
                    case THREAD_STATUS_LOCK_WAIT: {
                        usage = MonitorObjectUsage.BLOCKED;
                        break;
                    }
                    case THREAD_STATUS_OBJECT_WAIT: {
                        usage = MonitorObjectUsage.WAITING;
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                RendererNode monitorRenderer = this.value(new MonitorObjectEntry(item.getMonitorObject(), usage));
                frameObjects.add(monitorRenderer);
            } else if (item.getSocketInfo() != null) {
                RendererNode socketRenderer = this.value(new SocketObjectEntry(item.getSocketInfo()));
                frameObjects.add(socketRenderer);
            }
        }
        List list = objs = frameIndex >= 0 ? item.getFrameMonitorObjects(frameIndex) : item.getNoFrameMonitorObjects();
        if (objs != null) {
            for (MonitorObject monitor2 : objs) {
                RendererNode monitorRenderer = this.value(new MonitorObjectEntry(monitor2, MonitorObjectUsage.LOCKED));
                frameObjects.add(monitorRenderer);
            }
        }
        if (frameObjects.isEmpty()) {
            return null;
        }
        return this.lines(frameObjects);
    }

    private RendererNode frame(ThreadDumpReportProviderImpl provider, StackFrames frames, ThreadDumpItem item, int frameIndex, boolean showFrameObjects) {
        RendererNode frameRenderer = null;
        if (frameIndex >= 0) {
            MethodObject pureMethod = frames.getMethod(frameIndex);
            RendererNode methodRenderer = this.value(new NormalMethod(pureMethod));
            MethodLocation methodLocation = frames.getMethodLocation(frameIndex);
            RendererNode lineRenderer = null;
            int lineNo = methodLocation.getLineNumber();
            String fileName = methodLocation.getMethod().getMethodClass().getFilename();
            lineRenderer = lineNo != 0 ? (fileName != null && fileName.length() > 0 ? this.text(String.format("(%s:%d)", fileName, lineNo)) : this.text(I18n._s((String)"(line {0})", (Object[])new Object[]{lineNo}))) : this.text(I18n._s((String)"line: unknown"));
            lineRenderer = provider.link(this.viewer, "method-source-lookup", Long.toString(pureMethod.getId()), lineRenderer);
            provider.addMethodLink(pureMethod);
            frameRenderer = this.line(methodRenderer, lineRenderer);
        }
        if (showFrameObjects) {
            MarginNode<?> frameObjects = this.frameObjects(item, frames.getNrOfFrames() - frameIndex - 1, frameIndex == frames.getNrOfFrames() - 1);
            if (frameObjects != null && frameIndex >= 0) {
                frameObjects = this.viewer.newMarginNode(frameObjects, new Margin(20, 10));
                frameRenderer = this.toggleNode(frameRenderer, frameObjects, this.rightDownArrowIcon, true, false);
            } else if (frameIndex < 0) {
                frameRenderer = frameObjects;
            }
        }
        return frameRenderer;
    }

    private RendererNode stackImpl(ThreadDumpReportProviderImpl provider, ThreadDumpItem item, int maxVisibleFrames, int maxFrames, int numSkipFrames, boolean frameObjects) {
        if (frameObjects && item.getSocketInfo() != null) {
            item.getSocketInfo().resolveHostnames(provider.getEntryContext().getSession().getHostNameManager());
        }
        StackFrames frames = provider.getSummary().getThreadDumps().getStackFrame(item.getStackTraceIndex());
        int nrOfFrames = frames.getNrOfFrames();
        int numVisibleFrames = Math.min(maxVisibleFrames, maxFrames - numSkipFrames);
        int numHiddenFrames = maxFrames - numVisibleFrames - numSkipFrames;
        RendererNode[] visibleFrames = new RendererNode[numVisibleFrames];
        for (int i = 0; i < numVisibleFrames; ++i) {
            int frameIndex = nrOfFrames - 1 - numSkipFrames - i;
            visibleFrames[i] = this.frame(provider, frames, item, frameIndex, frameObjects);
        }
        RendererNode result = null;
        if (numSkipFrames > 0) {
            result = this.skipTopFramesNote(numSkipFrames);
            result = this.viewer.newMultiChildNode(result, this.lineBreak(), this.lines(visibleFrames));
        } else {
            result = this.lines(visibleFrames);
        }
        MarginNode<?> noneFrameObjects = this.frame(provider, frames, item, -1, frameObjects);
        if (noneFrameObjects != null) {
            noneFrameObjects = this.viewer.newMarginNode(noneFrameObjects, new Margin(0, 10));
        }
        if (numHiddenFrames == 0) {
            if (noneFrameObjects != null) {
                result = this.lines(new Object[]{visibleFrames, noneFrameObjects});
            }
            if (maxFrames < nrOfFrames) {
                result = this.skipBottomFramesNote(result);
            }
        } else {
            RendererNode hiddenStackRenderer;
            RendererNode[] hiddenFrames = new RendererNode[numHiddenFrames];
            for (int i = 0; i < numHiddenFrames; ++i) {
                int frameIndex = nrOfFrames - 1 - numVisibleFrames - numSkipFrames - i;
                hiddenFrames[i] = this.frame(provider, frames, item, frameIndex, frameObjects);
            }
            RendererNode rendererNode = hiddenStackRenderer = noneFrameObjects != null ? this.lines(new Object[]{hiddenFrames, noneFrameObjects}) : this.lines(hiddenFrames);
            if (maxFrames < nrOfFrames) {
                hiddenStackRenderer = this.skipBottomFramesNote(hiddenStackRenderer);
            }
            MarginNode<?> moreDetailsText = this.lines(I18n._s((String)"all methods"));
            moreDetailsText = this.linkStyle(moreDetailsText);
            moreDetailsText = this.line(this.moreLessIcon[0], moreDetailsText);
            moreDetailsText = this.viewer.newMarginNode(moreDetailsText, new Margin(0, 10));
            MarginNode<?> lessDetailsText = this.lines(I18n._s((String)"less methods"));
            lessDetailsText = this.linkStyle(lessDetailsText);
            lessDetailsText = this.line(this.moreLessIcon[1], lessDetailsText);
            lessDetailsText = this.viewer.newMarginNode(lessDetailsText, new Margin(0, 10));
            ToggleNode<?> moreDetailsToggle = this.viewer.newToggleNode(moreDetailsText, this.viewer.newNopNode());
            ToggleNode<?> hiddenStackToggle = this.viewer.newToggleNode(this.viewer.newNopNode(), hiddenStackRenderer);
            ToggleNode<?> lessDetailsToggle = this.viewer.newToggleNode(this.viewer.newNopNode(), lessDetailsText);
            ExpandNode<?> moreDetails = this.viewer.newExpandNode(moreDetailsToggle, new ToggleNode[]{moreDetailsToggle, hiddenStackToggle, lessDetailsToggle});
            ExpandNode<?> lessDetails = this.viewer.newExpandNode(lessDetailsToggle, new ToggleNode[]{moreDetailsToggle, hiddenStackToggle, lessDetailsToggle});
            result = this.lines(result, this.viewer.newMultiChildNode(moreDetails, this.lines(hiddenStackToggle, lessDetails)));
        }
        return this.smallFont(result);
    }

    RendererNode stack(ThreadDumpReportProviderImpl provider, ThreadDumpItem item, int maxVisibleFrames, int maxFrames, int numSkipFrames) {
        return this.stackImpl(provider, item, maxVisibleFrames, maxFrames, numSkipFrames, true);
    }

    RendererNode simpleStack(ThreadDumpReportProviderImpl provider, ThreadDumpItem item, int maxVisibleFrames, int maxFrames, int numSkipFrames) {
        return this.stackImpl(provider, item, maxVisibleFrames, maxFrames, numSkipFrames, false);
    }

    private RendererNode skipBottomFramesNote(RendererNode rendererNode) {
        MarginNode<?> divergentFrames = this.text(I18n._s((String)"<skipping divergent frames>"));
        divergentFrames = this.viewer.newMarginNode(this.comment(divergentFrames), new Margin(5, 10));
        return this.lines(rendererNode, divergentFrames);
    }

    private RendererNode skipTopFramesNote(int numSkipFrames) {
        RendererNode skippedFrames = this.text(I18n._s((String)"<skipping max. {0} frames>", (Object[])new Object[]{numSkipFrames}));
        return this.comment(skippedFrames);
    }

    public RendererNode comment(RendererNode node) {
        ChangeItalicsNode<? extends RendererNode> result = this.viewer.newChangeItalicsNode(true, node);
        return this.viewer.newColorNode(0x808080, -1, -1, -1, -1, -1, -1, result);
    }

    public Margin stackMargin() {
        return new Margin(20, 10);
    }

    public RendererNode lock(MonitorObject lock) {
        String clazz = lock.getClassObject().getFullName();
        long id = lock.getObjectId();
        return this.line(clazz, I18n._s((String)"[id = {0}]", (Object[])new Object[]{id}));
    }

    public RendererNode hint(ThreadDumpHint hint, RendererNode hintShortRenderer, RendererNode hintDetailedRenderer, RendererNode additionalDetailsRenderer, ThreadDumpReportHintInfo hintInfo) {
        return this.hint(hint, hintShortRenderer, hintDetailedRenderer, additionalDetailsRenderer, hintInfo.getTitle(), hintInfo.getDecription(), hintInfo.getEnableIcon());
    }

    public RendererNode hint(ThreadDumpHint hint, RendererNode hintShortRenderer, RendererNode hintDetailedRenderer, RendererNode additionalDetailsRenderer, String hintTitle, String description, String iconKey) {
        Margin infoMargin = new Margin(70, 10);
        MarginNode<?> hintShort = this.mediumFont(hintShortRenderer);
        hintShort = this.viewer.newMarginNode(hintShort, new Margin(70, 10));
        RendererNode descriptionNode = this.replace(description, new Object[0]);
        descriptionNode = this.viewer.newMarginNode(descriptionNode, new Margin(20, 20));
        descriptionNode = this.toggleNode(this.line(this.questionIcon, I18n._s((String)"Additional information")), descriptionNode, this.rightDownArrowIcon, false, false);
        descriptionNode = this.viewer.newMarginNode(descriptionNode, new Margin(0, 20));
        RendererNode hintDetailed = this.mediumFont(this.lines(hintDetailedRenderer, this.comment(descriptionNode)));
        hintDetailed = this.viewer.newStyleNode(hintDetailed, RendererStyle.NOTE_WIDE);
        if (additionalDetailsRenderer != null) {
            MarginNode<?> additionalDetails = this.viewer.newMarginNode(additionalDetailsRenderer, infoMargin);
            ToggleNode<?> detailsToggle = this.viewer.newToggleNode(additionalDetails, this.viewer.newNopNode());
            ToggleNode<?> moreDetails = this.expandCollapseToggle(this.expandCollapseIcon, true);
            RendererNode moreDetailsIcon = this.viewer.newExpandNode(moreDetails, new ToggleNode[]{detailsToggle, moreDetails});
            moreDetailsIcon = this.viewer.newStyleNode(moreDetailsIcon, RendererStyle.IMG);
            RendererNode moreDetailsText = this.text(I18n._s((String)"Details"));
            moreDetailsText = this.normalFont(moreDetailsText);
            moreDetailsText = this.linkStyle(moreDetailsText);
            moreDetailsIcon = this.line(moreDetailsIcon, moreDetailsText);
            hintDetailed = this.lines(hintDetailed, moreDetailsIcon, detailsToggle);
        }
        hintDetailed = this.viewer.newMarginNode(hintDetailed, infoMargin);
        ToggleNode<?> dataRows = this.viewer.newToggleNode(hintShort, hintDetailed);
        URI uri = ImageRepository.getImageURI(iconKey);
        StyleNode<?> iconRenderer = this.urgencyImage(uri, description, hint.getUrgency());
        iconRenderer = this.viewer.newStyleNode(iconRenderer, RendererStyle.IMG);
        ToggleNode<?> plusMinus = this.expandCollapseToggle(this.plusMinusIcon, false);
        ExpandNode<?> expandRenderer = this.viewer.newExpandNode(plusMinus, new ToggleNode[]{dataRows, plusMinus});
        RendererNode titleRow = this.line(expandRenderer, iconRenderer, hintTitle);
        titleRow = this.largeFont(titleRow);
        RendererNode result = this.lines(titleRow, dataRows, this.linebrk);
        return result;
    }

    String[] valuePerTimeStr(double valuePerSecond, String unitStr) {
        double value = valuePerSecond;
        int unit = 0;
        while (true) {
            double d;
            value = valuePerSecond * unitFactors[unit];
            if (!(d < 1.0) || unit >= units.length - 1) break;
            ++unit;
        }
        int dec = ThreadDumpReportNodes.decimals(value);
        String valueStr = this.floatValue(value, dec);
        return new String[]{valueStr, units[unit]};
    }

    RendererNode valuePerTime(double valuePerSecond, String unitStr) {
        String[] valueWithUnit = this.valuePerTimeStr(valuePerSecond, unitStr);
        return this.line(valueWithUnit[0], valueWithUnit[1]);
    }

    RendererNode method(MethodObject method, boolean full) {
        String methodName = method.getName();
        String signature = method.getSignature();
        StringBuilder result = new StringBuilder();
        if (full) {
            String fullClassName = method.getMethodClass().getFullName();
            StringBuilder shortSignature = new StringBuilder();
            String[] shortSignatures = signature.split(",");
            for (int i = 0; i < shortSignatures.length; ++i) {
                if (i > 0) {
                    shortSignature.append(',');
                }
                int index = shortSignatures[i].lastIndexOf(46);
                shortSignature.append(shortSignatures[i].substring(index + 1));
            }
            result.append(fullClassName);
            result.append('.');
            result.append(methodName);
            result.append('(');
            result.append((CharSequence)shortSignature);
            result.append(')');
        } else {
            String className = method.getMethodClass().getName();
            result.append(className);
            result.append('.');
            result.append(methodName);
            if (signature.length() > 0) {
                result.append("(...)");
            } else {
                result.append("()");
            }
        }
        return this.text(result.toString());
    }

    public static int decimals(double valueRaw) {
        long cmpValue;
        double value = valueRaw;
        int dec = 0;
        long factor = 1L;
        while (dec < 5 && !((double)(cmpValue = (long)((double)factor * value)) >= 0.95 * value)) {
            ++dec;
            factor *= 10L;
        }
        return dec;
    }

    public static double convert2seconds(long milliseconds) {
        return (double)milliseconds / 1000.0;
    }

    public static long convert2nanos(long milliseconds) {
        return 1000000L * milliseconds;
    }

    public static long convert2nanos(double milliseconds) {
        return (long)(1000000.0 * milliseconds);
    }

    public DescriptionViewer getViewer() {
        return this.viewer;
    }

    public RendererNode[] getZoomIcon() {
        return this.zoomIcon;
    }

    public RendererNode[] getCheckboxIcon() {
        return this.checkboxIcon;
    }

    public RendererNode[] getDirectoryIcon() {
        return this.directoryIcon;
    }

    public RendererNode smallspace() {
        return this.smallspace;
    }

    final class ImageDescription {
        private URI imageURI;
        private final String description;

        public ImageDescription(URI imageURI, String description) {
            this.imageURI = imageURI;
            this.description = description;
        }

        public URI getImageURI() {
            return this.imageURI;
        }

        public String getDescription() {
            return this.description;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.imageURI == null ? 0 : this.imageURI.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImageDescription other = (ImageDescription)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            return !(this.imageURI == null ? other.imageURI != null : !this.imageURI.equals(other.imageURI));
        }

        private ThreadDumpReportNodes getOuterType() {
            return ThreadDumpReportNodes.this;
        }
    }

    private static class ReplacementNode {
        public final String marker;
        public final RendererNode replacement;

        public ReplacementNode(String marker, RendererNode replacement) {
            this.marker = marker;
            this.replacement = replacement;
        }
    }
}

