/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.thread.report;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.description.DescriptionViewer;
import com.sap.jvm.profiling.presentation.description.renderer.RendererStyle;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReport;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportHintInfo;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportLineGraphInitializer;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportNodes;
import com.sap.jvm.profiling.presentation.impl.typed.thread.ThreadDumpReportProviderImpl;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ResourceLeakType;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHint;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintResourceLeak;
import com.sap.jvm.profiling.thread.ThreadDumps;
import com.sap.jvm.profiling.ui.graph.LineGraphChart;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.viewer.renderer.LineChartNode;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class ThreadDumpReportResourceLeak
implements ThreadDumpReport {
    private final DescriptionViewer viewer;
    private final ThreadDumpReportNodes nodes;

    public ThreadDumpReportResourceLeak(DescriptionViewer viewer, ThreadDumpReportProviderImpl provider, ThreadDumpReportNodes nodes) {
        this.viewer = viewer;
        this.nodes = nodes;
    }

    @Override
    public RendererNode generateHint(ThreadDumpHint hint) {
        ThreadDumpHintResourceLeak resourceLeakHint = (ThreadDumpHintResourceLeak)hint;
        ResourceLeakTypeInfo info = ResourceLeakTypeInfo.getInfo(resourceLeakHint.resourceType());
        RendererNode shortInfo = this.nodes.replace(I18n._s((String)"The system increased the {0} with an average speed of {1}."), info.getConsumeValueText(), this.nodes.valuePerTime(resourceLeakHint.valueGradient(), info.getUnit()));
        int decimalsMin = ThreadDumpReportNodes.decimals(resourceLeakHint.minValue());
        int decimalsMax = ThreadDumpReportNodes.decimals(resourceLeakHint.maxValue());
        int decimals = Math.max(decimalsMin, decimalsMax);
        RendererNode valueCompareRow = this.nodes.replace(I18n._s((String)"Within the observed period, the resource had a minimum value of {0} and a maximum value of {1}."), this.nodes.floatValue(resourceLeakHint.minValue(), decimals), this.nodes.floatValue(resourceLeakHint.maxValue(), decimals));
        RendererNode detailedInfo = this.nodes.lines(shortInfo, valueCompareRow);
        RendererNode lineChart = this.createLineChart(resourceLeakHint);
        RendererNode chartNode = this.viewer.newDivisionNode(lineChart);
        chartNode = this.viewer.newStyleNode(chartNode, RendererStyle.GRAPH);
        ThreadDumpReportHintInfo hintInfo = this.getHintInfo(resourceLeakHint);
        return this.nodes.hint(hint, shortInfo, detailedInfo, chartNode, hintInfo);
    }

    @Override
    public ThreadDumpReportHintInfo getHintInfo(ThreadDumpHint hint) {
        ThreadDumpHintResourceLeak resourceLeakHint = (ThreadDumpHintResourceLeak)hint;
        ResourceLeakTypeInfo info = ResourceLeakTypeInfo.getInfo(resourceLeakHint.resourceType());
        ThreadDumpReportHintInfo hintInfo = new ThreadDumpReportHintInfo(info.getValueTypeText(), I18n._s((String)"Given the consumption values of a specifc resource, a general trend in the system is approximated.\nIf the system is expected to continuously increase the resource consumption (e.g. number of open files or sockets),\n sooner or later the application might stop when reaching a certain limit given by the operating system."), info.getImageURI(), info.getDisabledImageURI());
        return hintInfo;
    }

    private RendererNode createLineChart(ThreadDumpHintResourceLeak resourceLeakHint) {
        LineChartNode lineChart = this.viewer.newLineChartNode();
        double[] values = resourceLeakHint.values();
        ThreadDumps threadDumps = resourceLeakHint.getSummary().getThreadDumps();
        TimeZone timezone = threadDumps.getSession().getTimeZone();
        ResourceLeakTypeInfo info = ResourceLeakTypeInfo.getInfo(resourceLeakHint.resourceType());
        ThreadDumpReportLineGraphInitializer graphInit = new ThreadDumpReportLineGraphInitializer(resourceLeakHint);
        LineGraphDataSet dataSet = LineGraphChart.createDataSet(graphInit.getChartTitle());
        dataSet.setGraphColor(new Color(23, 149, 247));
        dataSet.setValueColor(Color.RED);
        dataSet.setDrawingStyle(LineGraphDataSet.GraphStyle.CONNECTED_POINTS);
        if (values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                long timepoint = resourceLeakHint.getSummary().getThreadDumps().getTimeStamp(i);
                String tooltip = I18n._s((String)"System progress\n'{0}'\nat {1}\n{2} {3}", (Object[])new Object[]{threadDumps.getDumpName(i), DataFormatter.getTimeStampLong((long)timepoint, (TimeZone)timezone), values[i], info.getUnit()});
                dataSet.addValue((double)timepoint, values[i], tooltip);
            }
        }
        lineChart.setGraphInitializer(graphInit);
        lineChart.setData(dataSet);
        return lineChart;
    }

    static class ResourceLeakTypeInfo {
        private final String imageURI;
        private final String disabledImageURI;
        private final String unit;
        private final String valueTypeText;
        private final String consumeValueText;
        private static Map<ResourceLeakType, ResourceLeakTypeInfo> infos = ResourceLeakTypeInfo.initConsumerTypeInfo();

        private ResourceLeakTypeInfo(String valueTypeText, String valueText, String unit, String imageURIKey, String disabledImageURI) {
            this.valueTypeText = valueTypeText;
            this.consumeValueText = valueText;
            this.imageURI = imageURIKey;
            this.disabledImageURI = disabledImageURI;
            this.unit = unit;
        }

        public static ResourceLeakTypeInfo getInfo(ResourceLeakType resourceType) {
            return infos.get((Object)resourceType);
        }

        private static Map<ResourceLeakType, ResourceLeakTypeInfo> initConsumerTypeInfo() {
            HashMap<ResourceLeakType, ResourceLeakTypeInfo> info = new HashMap<ResourceLeakType, ResourceLeakTypeInfo>();
            try {
                info.put(ResourceLeakType.SOCKETS_OPEN, new ResourceLeakTypeInfo(I18n._s((String)"Growing Number of Sockets"), I18n._s((String)"number of sockets"), I18n._s((String)"sockets"), "report/report_resource_leak_sockets.png", "report/report_resource_leak_sockets_disabled.png"));
                info.put(ResourceLeakType.FILES_OPEN, new ResourceLeakTypeInfo(I18n._s((String)"Growing Number of Open Files"), I18n._s((String)"number of open files"), I18n._s((String)"files"), "report/report_resource_leak_files.png", "report/report_resource_leak_files_disabled.png"));
                info.put(ResourceLeakType.NUM_THREADS, new ResourceLeakTypeInfo(I18n._s((String)"Growing Number of Threads"), I18n._s((String)"number of threads"), I18n._s((String)"threads"), "report/report_resource_leak_threads.png", "report/report_resource_leak_threads_disabled.png"));
                info.put(ResourceLeakType.NUM_LOCKED_THREADS, new ResourceLeakTypeInfo(I18n._s((String)"Growing Number of Blocked Threads"), I18n._s((String)"number of blocked threads"), I18n._s((String)"threads"), "report/report_resource_leak_locked_threads.png", "report/report_resource_leak_locked_threads_disabled.png"));
                info.put(ResourceLeakType.NUM_IO_THREADS, new ResourceLeakTypeInfo(I18n._s((String)"Growing Number of Threads in I/O"), I18n._s((String)"number of threads in I/O"), I18n._s((String)"threads"), "report/report_resource_leak_io_threads.png", "report/report_resource_leak_io_threads_disabled.png"));
                for (ResourceLeakType type : ResourceLeakType.values()) {
                    assert (info.get((Object)type) != null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return Collections.unmodifiableMap(info);
        }

        public String getValueTypeText() {
            return this.valueTypeText;
        }

        public String getConsumeValueText() {
            return this.consumeValueText;
        }

        public String getImageURI() {
            return this.imageURI;
        }

        public String getDisabledImageURI() {
            return this.disabledImageURI;
        }

        public String getUnit() {
            return this.unit;
        }
    }
}

