/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.thread.report;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.icons.ImageRepository;
import com.sap.jvm.profiling.presentation.description.DescriptionViewer;
import com.sap.jvm.profiling.presentation.description.renderer.TableNode;
import com.sap.jvm.profiling.presentation.description.renderer.TableStyle;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportNodes;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLAxisChartNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLBarChartNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLPieChartNode;
import com.sap.jvm.profiling.presentation.impl.typed.thread.ThreadDumpReportProviderImpl;
import com.sap.jvm.profiling.presentation.typed.entries.ElapsedTime;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Timestamp;
import com.sap.jvm.profiling.thread.ThreadDumpsSummary;
import com.sap.jvm.profiling.ui.graph.AxisChart;
import com.sap.jvm.profiling.ui.graph.PieGraphChart;
import com.sap.jvm.profiling.ui.graph.SingleBarValueChart;
import com.sap.jvm.profiling.ui.graph.dataset.AccSingleBarDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.PieGraphDataSet;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.utils.GraphTools;
import com.sap.jvm.profiling.viewer.renderer.AxisChartNode;
import com.sap.jvm.profiling.viewer.renderer.BarChartNode;
import com.sap.jvm.profiling.viewer.renderer.ChartNodeInitializer;
import com.sap.jvm.profiling.viewer.renderer.PieChartNode;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import java.awt.Canvas;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JLabel;

public class ThreadDumpReportSummary {
    public static final String COLORS_TAG = "threaddump.thread.states_pie";
    private final DescriptionViewer viewer;
    private final ThreadDumpReportNodes nodes;

    public ThreadDumpReportSummary(ThreadDumpReportProviderImpl provider, ThreadDumpReportNodes nodes) {
        this.viewer = nodes.getViewer();
        this.nodes = nodes;
    }

    public RendererNode createSummarySection(ThreadDumpsSummary summary) {
        TableNode<?> tbLayout;
        RendererNode threadDumpsOverview = this.createThreadDumpsOverview(summary);
        RendererNode threadStatesOverview = this.createThreadsStateOverview(summary);
        int dumpsCount = summary.getThreadDumps().getNumDumps();
        if (dumpsCount > 1) {
            RendererNode threadCompareValues = this.createThreadDumpCompareValues(summary);
            tbLayout = this.viewer.newTable(null, new double[]{1.0, 1.0, 1.0, 97.0}, false, false, -1, new RendererNode[][]{{threadStatesOverview, this.viewer.newSpaceNode(50), threadCompareValues, this.viewer.newSpaceNode(1)}}, null);
        } else {
            tbLayout = this.viewer.newTable(null, new double[]{1.0, 99.0}, false, false, -1, new RendererNode[][]{{threadStatesOverview, this.viewer.newSpaceNode(1)}}, null);
        }
        return this.nodes.lines(threadDumpsOverview, this.nodes.line(tbLayout));
    }

    public RendererNode createConnectionsSection(ThreadDumpsSummary summary) {
        ProfilingSession session = summary.getThreadDumps().getSession();
        HashMap<String, HashSet<Integer>> connections = new HashMap<String, HashSet<Integer>>();
        for (Object c : summary.getSocketConnections()) {
            c.resolveHostnames(session.getHostNameManager());
            String host = c.getEffectiveRemoteHostname();
            HashSet<Integer> ports = (HashSet<Integer>)connections.get(host);
            if (ports == null) {
                ports = new HashSet<Integer>();
                connections.put(host, ports);
            }
            ports.add(Integer.valueOf(c.getRemotePort()));
        }
        if (connections.size() == 0) {
            return null;
        }
        int totalConnections = 0;
        for (Set ports : connections.values()) {
            totalConnections += ports.size();
        }
        int totalHosts = connections.size();
        RendererNode infoNode = this.nodes.replace("At least {0} connections were established to {1} different hosts:", totalConnections, totalHosts);
        TableStyle style = new TableStyle();
        style.setHeaderBackground("#eee");
        style.setHeaderCellPadding(3, 6, 3, 6);
        style.setContentCellPadding(2, 10, 2, 10);
        style.setColumnAlignment(0, TableStyle.Align.LEFT);
        style.setColumnAlignment(1, TableStyle.Align.RIGHT);
        RendererNode[][] content = new RendererNode[connections.size()][2];
        int i = 0;
        for (String host : connections.keySet()) {
            content[i][0] = this.nodes.text(host);
            int maxPortsToShow = 6;
            Set ports = (Set)connections.get(host);
            if (ports.size() > 1) {
                Integer[] portsArr = ports.toArray(new Integer[ports.size()]);
                StringBuilder value = new StringBuilder(String.valueOf(portsArr[0]));
                for (int j = 1; j < portsArr.length; ++j) {
                    int left = portsArr.length - j;
                    if (j >= maxPortsToShow && left > 1) {
                        value.append(I18n._s((String)", ... ({0} skipped)", (Object[])new Object[]{left}));
                        break;
                    }
                    value.append(", ");
                    value.append(String.valueOf(portsArr[j]));
                }
                content[i][1] = this.nodes.text(value.toString());
            } else {
                Iterator iterator = ports.iterator();
                while (iterator.hasNext()) {
                    int p = (Integer)iterator.next();
                    content[i][1] = this.nodes.text(String.valueOf(p));
                }
            }
            ++i;
        }
        TableNode<?> thConnectionsTableNode = this.viewer.newTable(new String[]{I18n._s((String)"Remote Host"), I18n._s((String)"Remote Port")}, new double[]{1.0, 1.0}, true, true, -1, content, style);
        return this.nodes.lines(infoNode, this.nodes.lineBreak(), thConnectionsTableNode);
    }

    private RendererNode createThreadDumpCompareValues(ThreadDumpsSummary summary) {
        long socketWritten;
        long fileWritten;
        long created = summary.getNumCreatedThreads();
        long finished = summary.getNumFinishedThreads();
        long total = created + finished;
        HTMLBarChartNode barThreads = null;
        if (total > 0L) {
            barThreads = (HTMLBarChartNode)this.viewer.newBarChartNode();
            AccSingleBarDataSet threadsData = new AccSingleBarDataSet();
            Color createColor = new Color(231, 215, 71);
            Color finishedColor = new Color(249, 244, 206);
            threadsData.setMaxValue(total);
            threadsData.addValue(created, createColor);
            threadsData.addValue(finished, finishedColor);
            threadsData.setInlinedText("");
            threadsData.setRangeMarker(0L, created, I18n._s((String)"{0} created", (Object[])new Object[]{created}), createColor);
            threadsData.setRangeMarker(created, total, I18n._s((String)"{0} finished", (Object[])new Object[]{finished}), finishedColor);
            barThreads.setData(threadsData);
            barThreads.setBounds(330, 70);
            barThreads.setGraphInitializer(new ChartNodeInitializer<SingleBarValueChart, BarChartNode>(){

                @Override
                public void init(SingleBarValueChart chart, BarChartNode node) {
                    chart.setType(SingleBarValueChart.Type.HORIZONTAL);
                    chart.enableShadows(true);
                    chart.setLeftMargin(10);
                }

                @Override
                public String getChartTitle() {
                    return null;
                }
            });
        }
        ProfilingSession session = summary.getThreadDumps().getSession();
        HTMLBarChartNode barCPU = null;
        if (session.getSystemInfo() != null) {
            int numCores = session.getSystemInfo().getNrOfCpus();
            numCores = Math.max(numCores, 1);
            barCPU = (HTMLBarChartNode)this.viewer.newBarChartNode();
            barCPU = (HTMLBarChartNode)this.viewer.newBarChartNode();
            AccSingleBarDataSet cpuData = new AccSingleBarDataSet();
            long cpuUtilization = (long)(100.0 * summary.getCPUUtilization() / (double)numCores);
            long elapsed = 100L;
            Color cpuColor = new Color(113, 150, 231);
            Color nonCpuColor = new Color(201, 218, 255);
            cpuData.setMaxValue(elapsed);
            cpuData.addValue(cpuUtilization, cpuColor);
            cpuData.addValue(elapsed - cpuUtilization, nonCpuColor);
            cpuData.setInlinedText("");
            cpuData.setRangeMarker(0L, cpuUtilization, I18n._s((String)"{0}% CPU utilization", (Object[])new Object[]{cpuUtilization}), cpuColor);
            barCPU.setData(cpuData);
            barCPU.setBounds(330, 70);
            barCPU.setGraphInitializer(new ChartNodeInitializer<SingleBarValueChart, BarChartNode>(){

                @Override
                public void init(SingleBarValueChart chart, BarChartNode node) {
                    chart.setType(SingleBarValueChart.Type.HORIZONTAL);
                    chart.enableShadows(true);
                    chart.setLeftMargin(10);
                }

                @Override
                public String getChartTitle() {
                    return null;
                }
            });
        }
        HTMLBarChartNode barFiles = null;
        long fileRead = summary.getFileBytesReadDiff();
        long fileTotal = fileRead + (fileWritten = summary.getFileBytesWrittenDiff());
        if (fileTotal > 0L) {
            barFiles = (HTMLBarChartNode)this.viewer.newBarChartNode();
            AccSingleBarDataSet filesData = new AccSingleBarDataSet();
            Color readColor = new Color(92, 135, 46);
            Color writtenColor = new Color(179, 212, 143);
            filesData.setMaxValue(fileTotal);
            filesData.addValue(fileRead, readColor);
            filesData.addValue(fileWritten, writtenColor);
            filesData.setInlinedText("");
            filesData.setRangeMarker(0L, fileRead, I18n._s((String)"{0} read", (Object[])new Object[]{DataFormatter.getNrOfBytesText((long)fileRead)}), readColor);
            filesData.setRangeMarker(fileRead, fileTotal, I18n._s((String)"{0} written", (Object[])new Object[]{DataFormatter.getNrOfBytesText((long)fileWritten)}), writtenColor);
            barFiles.setData(filesData);
            barFiles.setBounds(330, 70);
            barFiles.setGraphInitializer(new ChartNodeInitializer<SingleBarValueChart, BarChartNode>(){

                @Override
                public void init(SingleBarValueChart chart, BarChartNode node) {
                    chart.setType(SingleBarValueChart.Type.HORIZONTAL);
                    chart.enableShadows(true);
                    chart.setLeftMargin(10);
                }

                @Override
                public String getChartTitle() {
                    return null;
                }
            });
        }
        HTMLBarChartNode barSock = null;
        long socketRead = summary.getSocketBytesReadDiff();
        long socketTotal = socketRead + (socketWritten = summary.getSocketBytesWrittenDiff());
        if (socketTotal > 0L) {
            barSock = (HTMLBarChartNode)this.viewer.newBarChartNode();
            AccSingleBarDataSet sockData = new AccSingleBarDataSet();
            Color readColor = new Color(67, 183, 140);
            Color writtenColor = new Color(206, 237, 226);
            sockData.setMaxValue(socketTotal);
            sockData.addValue(socketRead, readColor);
            sockData.addValue(socketWritten, writtenColor);
            sockData.setInlinedText("");
            sockData.setRangeMarker(0L, socketRead, I18n._s((String)"{0} read", (Object[])new Object[]{DataFormatter.getNrOfBytesText((long)socketRead)}), readColor);
            sockData.setRangeMarker(socketRead, socketTotal, I18n._s((String)"{0} written", (Object[])new Object[]{DataFormatter.getNrOfBytesText((long)socketWritten)}), writtenColor);
            barSock.setData(sockData);
            barSock.setBounds(330, 70);
            barSock.setGraphInitializer(new ChartNodeInitializer<SingleBarValueChart, BarChartNode>(){

                @Override
                public void init(SingleBarValueChart chart, BarChartNode node) {
                    chart.setType(SingleBarValueChart.Type.HORIZONTAL);
                    chart.enableShadows(true);
                    chart.setLeftMargin(10);
                }

                @Override
                public String getChartTitle() {
                    return null;
                }
            });
        }
        ArrayList<RendererNode[]> rows = new ArrayList<RendererNode[]>();
        if (barThreads != null) {
            rows.add(new RendererNode[]{this.nodes.mediumFont(this.nodes.bold(this.nodes.text(I18n._s((String)"Threads")))), barThreads});
        }
        if (barCPU != null) {
            rows.add(new RendererNode[]{this.nodes.mediumFont(this.nodes.bold(this.nodes.text(I18n._s((String)"CPU")))), barCPU});
        }
        if (barFiles != null) {
            rows.add(new RendererNode[]{this.nodes.mediumFont(this.nodes.bold(this.nodes.text(I18n._s((String)"File I/O")))), barFiles});
        }
        if (barSock != null) {
            rows.add(new RendererNode[]{this.nodes.mediumFont(this.nodes.bold(this.nodes.text(I18n._s((String)"Network I/O")))), barSock});
        }
        RendererNode[][] rowsA = (RendererNode[][])rows.toArray((T[])new RendererNode[rows.size()][]);
        TableNode<?> table = this.viewer.newTable(null, new double[]{1.0, 120.0}, false, false, -1, rowsA, null);
        return table;
    }

    private RendererNode createThreadsStateOverview(ThreadDumpsSummary summary) {
        HTMLPieChartNode pie = (HTMLPieChartNode)this.viewer.newPieChartNode();
        PieGraphDataSet data = new PieGraphDataSet(I18n._s((String)"Thread States"));
        pie.setLegendEnabled(true);
        pie.setLegendItemsWithPercentEnabled(true);
        data.setRotateCW(true);
        data.set3DRepresentation(false);
        data.setFixedToolTips(false);
        data.setPercentDigits(1);
        ThreadDumpsSummary.ThreadStateStatistic stat = summary.getNumThreadState();
        int[] colors = this.viewer.getRendererTheme().getColors(COLORS_TAG);
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        list.add(new Object[]{stat.numRunnable, I18n._s((String)"Running Threads"), new Color(colors[0])});
        list.add(new Object[]{stat.numSleeping, I18n._s((String)"Sleeping Threads"), new Color(colors[1])});
        list.add(new Object[]{stat.numWaiting, I18n._s((String)"Waiting Threads"), new Color(colors[4])});
        list.add(new Object[]{stat.numLocked, I18n._s((String)"Blocked Threads"), new Color(colors[3])});
        list.add(new Object[]{stat.numIO, I18n._s((String)"I/O Threads"), new Color(colors[2])});
        Collections.sort(list, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                int v1 = (Integer)o1[0];
                int v2 = (Integer)o2[0];
                return v1 - v2;
            }
        });
        for (Object[] v : list) {
            if ((Integer)v[0] <= 0) continue;
            data.addValue(((Integer)v[0]).intValue(), (String)v[1], (Color)v[2]);
        }
        data.setStartAngle(90);
        pie.setData(data);
        pie.setBounds(550, 330);
        pie.setGraphInitializer(new ChartNodeInitializer<PieGraphChart, PieChartNode>(){

            @Override
            public void init(PieGraphChart chart, PieChartNode node) {
                chart.enableTransparentFixedToolTips(false);
            }

            @Override
            public String getChartTitle() {
                return null;
            }
        });
        return pie;
    }

    private RendererNode createThreadDumpsOverview(final ThreadDumpsSummary summary) {
        RendererNode[][] rendererNodeArray;
        ProfilingSession session = summary.getThreadDumps().getSession();
        RendererNode[] totalNumDumps = new RendererNode[]{this.nodes.image(ImageRepository.getImageURI("decorators/sum.gif"), I18n._s((String)"The total number of triggered thread dumps")), this.nodes.smallspace(), this.nodes.replace("{0} thread dumps were triggered within {1}", summary.getThreadDumps().getNumDumps(), this.nodes.value((ProviderEntry)ElapsedTime.PROTOTYPE.create(ThreadDumpReportNodes.convert2nanos(summary.getElapsedTimeDiff()))))};
        RendererNode[] cpuTime = new RendererNode[]{this.nodes.image(ImageRepository.getImageURI("vm_monitor/cpu_time.png"), I18n._s((String)"The CPU time all threads have consumed within the observed period")), this.nodes.smallspace(), this.nodes.replace("{0} threads contributed a total CPU consumption of {1}", summary.getTotalNumThreads(), this.nodes.value((ProviderEntry)ElapsedTime.PROTOTYPE.create(summary.getCPUTimeDiff())))};
        int numCPUs = 0;
        if (session.getSystemInfo() != null) {
            numCPUs = session.getSystemInfo().getNrOfCpus();
        }
        double avgUtilization = (double)Math.round(10.0 * summary.getCPUUtilization()) / 10.0;
        avgUtilization = Math.max(avgUtilization, 0.1);
        RendererNode[] cpuCores = new RendererNode[]{this.nodes.image(ImageRepository.getImageURI("vm_monitor/cpu_load.png"), I18n._s((String)"The fraction of CPU cores that were utilized on average within the observed period")), this.nodes.smallspace(), numCPUs > 0 ? this.nodes.replace("{0} of {1} cpu cores were utilized on average.", this.nodes.floatValue(avgUtilization, 1), numCPUs) : this.nodes.replace("{0} cpu cores were utilized on average.", this.nodes.floatValue(avgUtilization, 1))};
        RendererNode[] deadlocks = null;
        int deadlockDumpIndex = summary.getThreadDumps().getFirstDeadlockedDump();
        if (deadlockDumpIndex >= 0) {
            long deadlockTimestamp = summary.getThreadDumps().getTimeStamp(deadlockDumpIndex);
            deadlocks = new RendererNode[]{this.nodes.deadlockIcon(), this.nodes.smallspace(), this.nodes.replace("There is a deadlock situation starting at {0} !", this.nodes.value(new Timestamp(deadlockTimestamp)))};
        }
        if (deadlocks != null) {
            RendererNode[][] rendererNodeArrayArray = new RendererNode[4][];
            rendererNodeArrayArray[0] = totalNumDumps;
            rendererNodeArrayArray[1] = cpuTime;
            rendererNodeArrayArray[2] = cpuCores;
            rendererNodeArray = rendererNodeArrayArray;
            rendererNodeArrayArray[3] = deadlocks;
        } else {
            RendererNode[][] rendererNodeArray2 = new RendererNode[3][];
            rendererNodeArray2[0] = totalNumDumps;
            rendererNodeArray2[1] = cpuTime;
            rendererNodeArray = rendererNodeArray2;
            rendererNodeArray2[2] = cpuCores;
        }
        TableNode<?> summaryTable = this.viewer.newTable(null, null, false, false, -1, rendererNodeArray, null);
        int dumpsCount = summary.getThreadDumps().getNumDumps();
        if (dumpsCount > 1) {
            RendererNode space = this.nodes.lineBreak();
            HTMLAxisChartNode timeAxis = (HTMLAxisChartNode)this.viewer.newAxisChartNode(1, 1);
            timeAxis.setGraphInitializer(new ChartNodeInitializer<AxisChart, AxisChartNode>(){

                @Override
                public void init(AxisChart chart, AxisChartNode node) {
                    long start = summary.getThreadDumps().getTimeStamp(0);
                    long end = summary.getThreadDumps().getTimeStamp(summary.getThreadDumps().getNumDumps() - 1);
                    chart.adjustAxis(0.0, end - start);
                    chart.setPaddingStart(47);
                    chart.setPaddingEnd(22);
                    chart.setRasterAdapter(GraphTools.RASTER_MILLIS_DURATION);
                    chart.setAxisCaptionProvider(GraphTools.AXIS_CAPTION_MILLIS_DURATION);
                }

                @Override
                public String getChartTitle() {
                    return null;
                }
            });
            Font f = new JLabel().getFont();
            Canvas c = new Canvas();
            int height = (int)((double)c.getFontMetrics(f).getHeight() * 2.5);
            timeAxis.setBounds(1030, height);
            HTMLBarChartNode barThreadDumps = (HTMLBarChartNode)this.viewer.newBarChartNode();
            AccSingleBarDataSet threadDumpsData = new AccSingleBarDataSet();
            threadDumpsData.setInlinedText(null);
            threadDumpsData.setMaxValue(summary.getElapsedTimeDiff());
            threadDumpsData.setValueMarker(0L, "1", Color.GRAY);
            if (dumpsCount > 100) {
                long value = threadDumpsData.getMaxValue();
                threadDumpsData.addValue(value, Color.GRAY_90);
                threadDumpsData.setValueMarker(value, String.valueOf(dumpsCount), Color.GRAY);
                for (int i = 1; i < dumpsCount - 1; ++i) {
                    value = summary.getThreadDumps().getTimeStamp(i) - summary.getThreadDumps().getTimeStamp(0);
                    threadDumpsData.highlightValue(value);
                }
            } else {
                long accValue = 0L;
                for (int i = 1; i < summary.getThreadDumps().getNumDumps(); ++i) {
                    long value = summary.getElapsedTimeDiff(i - 1, i);
                    threadDumpsData.addValue(value, i % 2 == 0 ? Color.GRAY_80 : Color.GRAY_90);
                    threadDumpsData.setValueMarker(accValue += value, String.valueOf(i + 1), Color.GRAY);
                }
            }
            barThreadDumps.setData(threadDumpsData);
            barThreadDumps.setBounds(1030, 75);
            barThreadDumps.setGraphInitializer(new ChartNodeInitializer<SingleBarValueChart, BarChartNode>(){

                @Override
                public void init(SingleBarValueChart chart, BarChartNode node) {
                    chart.setType(SingleBarValueChart.Type.HORIZONTAL);
                    chart.enableShadows(true);
                    chart.flipBarLables(true);
                    chart.setLeftMargin(35);
                }

                @Override
                public String getChartTitle() {
                    return null;
                }
            });
            return this.nodes.lines(summaryTable, space, barThreadDumps, timeAxis);
        }
        return this.nodes.lines(summaryTable);
    }
}

