/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.thread.report;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.description.DescriptionViewer;
import com.sap.jvm.profiling.presentation.description.renderer.RendererStyle;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReport;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportHintInfo;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportLineGraphInitializer;
import com.sap.jvm.profiling.presentation.impl.thread.report.ThreadDumpReportNodes;
import com.sap.jvm.profiling.presentation.impl.typed.thread.ThreadDumpReportProviderImpl;
import com.sap.jvm.profiling.presentation.typed.EntryRenderer;
import com.sap.jvm.profiling.presentation.typed.TypedModelRendererFactory;
import com.sap.jvm.profiling.presentation.typed.entries.BaseQuantity;
import com.sap.jvm.profiling.presentation.typed.entries.ElapsedTime;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytes;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytesPerSecond;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHint;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintTopConsumer;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.TopConsumerType;
import com.sap.jvm.profiling.thread.ThreadDumps;
import com.sap.jvm.profiling.thread.ThreadDumpsSummary;
import com.sap.jvm.profiling.ui.graph.LineGraphChart;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.viewer.renderer.LineChartNode;
import com.sap.jvm.profiling.viewer.renderer.MultiChildNode;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class ThreadDumpReportTopConsumer
implements ThreadDumpReport {
    private final DescriptionViewer viewer;
    private final ThreadDumpReportNodes nodes;
    private final ThreadDumpReportProviderImpl provider;

    public ThreadDumpReportTopConsumer(DescriptionViewer viewer, ThreadDumpReportProviderImpl provider, ThreadDumpReportNodes nodes) {
        this.viewer = viewer;
        this.nodes = nodes;
        this.provider = provider;
    }

    @Override
    public RendererNode generateHint(ThreadDumpHint hint) {
        ThreadDumpHintTopConsumer topConsumerHint = (ThreadDumpHintTopConsumer)hint;
        ThreadDumpsSummary summary = topConsumerHint.getSummary();
        ConsumerTypeInfo info = ConsumerTypeInfo.getInfo(topConsumerHint.getConsumerType());
        int threadRunIndex = topConsumerHint.getThreadRunIndex();
        int[] threadRunRange = summary.getThreadDumps().getThreadRunRange(threadRunIndex);
        long totalElapsedNs = ThreadDumpReportNodes.convert2nanos(summary.getElapsedTimeDiff());
        long threadElapsedNs = ThreadDumpReportNodes.convert2nanos(summary.getElapsedTimeDiff(threadRunRange[0], threadRunRange[1]));
        long threadElapsedMs = summary.getElapsedTimeDiff(threadRunRange[0], threadRunRange[1]);
        long value = topConsumerHint.getValueIncrease();
        double percentage = (double)value / (double)topConsumerHint.getTotalIncrease();
        MultiChildNode<? extends RendererNode> unitNode = info.getUnitText() != null ? this.viewer.newMultiChildNode(this.viewer.newSpaceNode(5), this.viewer.newChangeBoldNode(false, this.nodes.text(info.getUnitText()))) : null;
        RendererNode shortInfo = this.nodes.replace(I18n._s((String)"A single thread consumed {0}{1} which is about {2} of the system's total of {3}{4}."), this.nodes.value((ProviderEntry)info.getValueEntity().create(value)), unitNode, this.nodes.percentage(percentage, 0), this.nodes.value((ProviderEntry)info.getValueEntity().create(topConsumerHint.getTotalIncrease())), unitNode);
        RendererNode valueAvgRateRow = null;
        if (info.getValuePerSecondEntitiy() != null) {
            long avgValueRateS = (long)(1.0E9 * topConsumerHint.getValueRate());
            long avgSystemRateS = 1000L * topConsumerHint.getTotalIncrease() / threadElapsedMs;
            valueAvgRateRow = this.nodes.replace(I18n._s((String)"The thread's average rate is about {0}, whereas the system's average rate is about {1}."), this.nodes.value((ProviderEntry)info.getValuePerSecondEntitiy().create(avgValueRateS)), this.nodes.value((ProviderEntry)info.getValuePerSecondEntitiy().create(avgSystemRateS)));
        }
        RendererNode historyInfoRow = this.nodes.replace(I18n._s((String)"The thread consumed {0} {1} before the dumps were taken."), this.nodes.value((ProviderEntry)info.getValueEntity().create(topConsumerHint.getValueBefore())), unitNode);
        RendererNode threadInfoLine = this.nodes.replace(I18n._s((String)"Within its runnable time of {0}, thread {1} consumed {2}{3}.\nThis is about {4} of the system's total of {5}{6} within the observed interval of {7}."), this.nodes.value((ProviderEntry)ElapsedTime.PROTOTYPE.create(threadElapsedNs)), this.provider.threadLink(threadRunIndex, this.viewer), this.nodes.value((ProviderEntry)info.getValueEntity().create(value)), unitNode, this.nodes.percentage(percentage, 1), this.nodes.value((ProviderEntry)info.getValueEntity().create(topConsumerHint.getTotalIncrease())), unitNode, this.nodes.value((ProviderEntry)ElapsedTime.PROTOTYPE.create(totalElapsedNs)));
        RendererNode cpuCoreInfoLine = null;
        if (topConsumerHint.getConsumerType() == TopConsumerType.CPU_TIME) {
            double core = (double)value / (double)threadElapsedNs;
            cpuCoreInfoLine = this.nodes.replace(I18n._s((String)"On average, the thread consumed {0} of a CPU core."), this.nodes.percentage(core, 1));
        }
        RendererNode detailedInfoRows = this.nodes.lines(threadInfoLine, cpuCoreInfoLine, valueAvgRateRow, historyInfoRow);
        RendererNode lineChart = this.createLineChart(topConsumerHint, summary);
        RendererNode chartNode = this.viewer.newDivisionNode(lineChart);
        chartNode = this.viewer.newStyleNode(chartNode, RendererStyle.GRAPH);
        ThreadDumpReportHintInfo hintInfo = this.getHintInfo(topConsumerHint);
        return this.nodes.hint(hint, shortInfo, detailedInfoRows, chartNode, hintInfo);
    }

    @Override
    public ThreadDumpReportHintInfo getHintInfo(ThreadDumpHint hint) {
        ThreadDumpHintTopConsumer topConsumerHint = (ThreadDumpHintTopConsumer)hint;
        ConsumerTypeInfo info = ConsumerTypeInfo.getInfo(topConsumerHint.getConsumerType());
        ThreadDumpReportHintInfo hintInfo = new ThreadDumpReportHintInfo(info.getValueTypeText(), I18n._s((String)"Shows a thread which consumes a specifiy type of resource like CPU or memory much more than most of the other threads.\nThis behaviour could be intentional, but in most cases it is worth checking the high consumption and asymetric behaviour."), info.getImageURI(), info.getDisabledImageURI());
        return hintInfo;
    }

    public String value(long value, BaseQuantity<?> prototype) {
        try {
            Object entry = prototype.create(value);
            EntryRenderer entryRenderer = TypedModelRendererFactory.getRenderer(this.viewer, this.viewer.getRendererTheme().getSpec(), entry);
            return entryRenderer.getToolTip((ProviderEntry)entry, this.provider.getEntryContext(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private RendererNode createLineChart(ThreadDumpHintTopConsumer hint, ThreadDumpsSummary summary) {
        int startIndex;
        LineChartNode lineChart = this.viewer.newLineChartNode();
        ThreadDumpReportLineGraphInitializer graphLineInit = new ThreadDumpReportLineGraphInitializer(hint);
        int threadRunIndex = hint.getThreadRunIndex();
        int[] threadRunRange = summary.getThreadDumps().getThreadRunRange(threadRunIndex);
        LineGraphDataSet dataSet = LineGraphChart.createDataSet(graphLineInit.getChartTitle());
        dataSet.setGraphColor(new Color(23, 149, 247));
        dataSet.setValueColor(Color.RED);
        dataSet.setDrawingStyle(LineGraphDataSet.GraphStyle.CONNECTED_POINTS);
        ThreadDumps threadDumps = hint.getSummary().getThreadDumps();
        TimeZone timezone = threadDumps.getSession().getTimeZone();
        ConsumerTypeInfo info = ConsumerTypeInfo.getInfo(hint.getConsumerType());
        long[] values = hint.getValues();
        for (int i = startIndex = threadRunRange[0]; i <= threadRunRange[1]; ++i) {
            long timestamp = threadDumps.getTimeStamp(i);
            long duration = timestamp - threadDumps.getTimeStamp(startIndex);
            long deltaValue = values[i] - values[startIndex];
            String tooltip = I18n._s((String)"Top Consumer progress in last {0}\n'{1}'\nat {2}\n{3}: {4}", (Object[])new Object[]{this.value(ThreadDumpReportNodes.convert2nanos(duration), ElapsedTime.PROTOTYPE), threadDumps.getDumpName(i), DataFormatter.getTimeStampLong((long)timestamp, (TimeZone)timezone), info.getDescription(), this.value(deltaValue, info.getValueEntity())});
            dataSet.addValue((double)duration, (double)deltaValue, tooltip);
        }
        lineChart.setGraphInitializer(graphLineInit);
        lineChart.setData(dataSet);
        LineGraphDataSet avgDataSet = LineGraphChart.createDataSet(graphLineInit.getChartTitle());
        avgDataSet.setGraphColor(Color.GRAY_40);
        avgDataSet.setValueColor(Color.GRAY_20);
        avgDataSet.setDrawingStyle(LineGraphDataSet.GraphStyle.CONNECTED_POINTS_DOTTED);
        long[] avgValues = hint.getAvgValues();
        for (int i = startIndex; i <= threadRunRange[1]; ++i) {
            long timestamp = threadDumps.getTimeStamp(i);
            long duration = timestamp - threadDumps.getTimeStamp(startIndex);
            long deltaAvgValue = avgValues[i] - avgValues[startIndex];
            String tooltip = I18n._s((String)"System progress (without Top Consumer)\nin last {0}\n'{1}'\nat {2}\n{3}: {4}", (Object[])new Object[]{this.value(ThreadDumpReportNodes.convert2nanos(duration), ElapsedTime.PROTOTYPE), threadDumps.getDumpName(i), DataFormatter.getTimeStampLong((long)timestamp, (TimeZone)timezone), info.getDescription(), this.value(deltaAvgValue, info.getValueEntity())});
            avgDataSet.addValue((double)duration, (double)deltaAvgValue, tooltip);
        }
        lineChart.addDataSet(avgDataSet);
        return this.viewer.newStyleNode(lineChart, RendererStyle.GRAPH);
    }

    static class ConsumerTypeInfo {
        private final String imageURI;
        private final String disabledImageURI;
        private final String description;
        private final String valueTypeText;
        private final String unitText;
        private final BaseQuantity<?> valueRendererEntitiy;
        private final BaseQuantity<?> valuePerSecondEntitiy;
        private static Map<TopConsumerType, ConsumerTypeInfo> infos = ConsumerTypeInfo.initConsumerTypeInfo();

        private ConsumerTypeInfo(String valueTypeText, String unitText, String description, String imageURIKey, String disabledImageURI, BaseQuantity<?> valueEntitiy, BaseQuantity<?> valuePerSecondEntitiy) {
            this.valueTypeText = valueTypeText;
            this.unitText = unitText;
            this.valueRendererEntitiy = valueEntitiy;
            this.valuePerSecondEntitiy = valuePerSecondEntitiy;
            this.imageURI = imageURIKey;
            this.disabledImageURI = disabledImageURI;
            this.description = description;
        }

        public static ConsumerTypeInfo getInfo(TopConsumerType consumerType) {
            return infos.get((Object)consumerType);
        }

        private static Map<TopConsumerType, ConsumerTypeInfo> initConsumerTypeInfo() {
            HashMap<TopConsumerType, ConsumerTypeInfo> info = new HashMap<TopConsumerType, ConsumerTypeInfo>();
            try {
                info.put(TopConsumerType.CPU_TIME, new ConsumerTypeInfo(I18n._s((String)"CPU Top Consumer"), I18n._s((String)"CPU time"), I18n._s((String)"CPU time"), "report/report_top_consumer_cpu.png", "report/report_top_consumer_cpu_disabled.png", ElapsedTime.PROTOTYPE, null));
                info.put(TopConsumerType.ALLOCATED, new ConsumerTypeInfo(I18n._s((String)"Memory Top Consumer"), null, I18n._s((String)"Memory allocated"), "report/report_top_consumer_memory.png", "report/report_top_consumer_memory_disabled.png", NrOfBytes.PROTOTYPE, NrOfBytesPerSecond.PROTOTYPE));
                info.put(TopConsumerType.SOCKET_READ, new ConsumerTypeInfo(I18n._s((String)"Socket Read Top Consumer"), null, I18n._s((String)"Data read from sockets"), "report/report_top_consumer_socket_read.png", "report/report_top_consumer_socket_read_disabled.png", NrOfBytes.PROTOTYPE, NrOfBytesPerSecond.PROTOTYPE));
                info.put(TopConsumerType.SOCKET_WRITE, new ConsumerTypeInfo(I18n._s((String)"Socket Write Top Consumer"), null, I18n._s((String)"Data written to sockets"), "report/report_top_consumer_socket_write.png", "report/report_top_consumer_socket_write_disabled.png", NrOfBytes.PROTOTYPE, NrOfBytesPerSecond.PROTOTYPE));
                info.put(TopConsumerType.FILE_READ, new ConsumerTypeInfo(I18n._s((String)"File Read Top Consumer"), null, I18n._s((String)"Data read from files"), "report/report_top_consumer_file_read.png", "report/report_top_consumer_file_read_disabled.png", NrOfBytes.PROTOTYPE, NrOfBytesPerSecond.PROTOTYPE));
                info.put(TopConsumerType.FILE_WRITE, new ConsumerTypeInfo(I18n._s((String)"File Write Top Consumer"), null, I18n._s((String)"Data written to files"), "report/report_top_consumer_file_write.png", "report/report_top_consumer_file_write_disabled.png", NrOfBytes.PROTOTYPE, NrOfBytesPerSecond.PROTOTYPE));
                for (TopConsumerType type : TopConsumerType.values()) {
                    assert (info.get((Object)type) != null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return Collections.unmodifiableMap(info);
        }

        public String getValueTypeText() {
            return this.valueTypeText;
        }

        public BaseQuantity<?> getValueEntity() {
            return this.valueRendererEntitiy;
        }

        public BaseQuantity<?> getValuePerSecondEntitiy() {
            return this.valuePerSecondEntitiy;
        }

        public String getImageURI() {
            return this.imageURI;
        }

        public String getDisabledImageURI() {
            return this.disabledImageURI;
        }

        public String getDescription() {
            return this.description;
        }

        public String getUnitText() {
            return this.unitText;
        }
    }
}

