/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed;

import com.sap.jvm.profiling.presentation.typed.AxisModel;
import com.sap.jvm.profiling.presentation.typed.TypedValueSetModel;
import com.sap.jvm.profiling.ui.graph.BarGraphToolTipProvider;
import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.axes.BarGraphAxisCaptionProvider;
import com.sap.jvm.profiling.ui.graph.axes.RangeLineAxisAdapter;
import com.sap.jvm.profiling.ui.graph.axes.RasterCalculationAdapter;
import com.sap.jvm.profiling.ui.graph.dataset.BarGraphDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.ColoredBarGraphDataSet;
import com.sap.jvm.profiling.viewer.graph.BarGraphRenderer;
import com.sap.jvm.util.pair.LongPair;

public abstract class AbstractBarGraphRenderer
implements BarGraphRenderer {
    protected final TypedValueSetModel model;
    protected final GraphChartContainer container;
    protected final AxisModel axisModel;
    protected final int column;
    protected final int idx;

    public AbstractBarGraphRenderer(TypedValueSetModel model, int column, int idx, GraphChartContainer container, AxisModel axisModel) {
        this.model = model;
        this.container = container;
        this.axisModel = axisModel;
        this.column = column;
        this.idx = idx;
    }

    private static long d2l(double v) {
        if (v < 0.0) {
            return (long)(v - 0.5);
        }
        return (long)(v + 0.5);
    }

    private RangeLineAxisAdapter getRangeLineAxisAdapter() {
        long max;
        long min;
        ColoredBarGraphDataSet data = this.getDataSet();
        if (this.model.getNrOfRows() == 0) {
            min = 0L;
            max = 1L;
        } else {
            max = min = AbstractBarGraphRenderer.d2l(data.getValue(0));
            for (int i = 1; i < this.model.getNrOfRows(); ++i) {
                min = Math.min(min, AbstractBarGraphRenderer.d2l(data.getValue(i)));
                max = Math.max(max, AbstractBarGraphRenderer.d2l(data.getValue(i)));
            }
        }
        LongPair range = this.axisModel.getRange(min, max);
        final long finalMin = range.getFirst();
        final long finalMax = range.getSecond();
        return new RangeLineAxisAdapter(){

            @Override
            public double adjustMax(double currentMin, double currentMax) {
                return finalMax;
            }

            @Override
            public double adjustMin(double currentMin, double currentMax) {
                String suffix = AbstractBarGraphRenderer.this.axisModel.getCaptionSuffix(finalMin, finalMax);
                if (suffix != null) {
                    AbstractBarGraphRenderer.this.container.setChartTitle(AbstractBarGraphRenderer.this.model.getColumnName(AbstractBarGraphRenderer.this.column) + suffix, AbstractBarGraphRenderer.this.idx);
                }
                return finalMin;
            }
        };
    }

    @Override
    public BarGraphAxisCaptionProvider getAxisCaptionProvider() {
        return new BarGraphAxisCaptionProvider(){

            @Override
            public String provideBarIndexCaption(int index) {
                return AbstractBarGraphRenderer.this.model.getRowName(index);
            }

            @Override
            public String provideScaleUnitCaption(double value, double tickSize, double min, double max) {
                return AbstractBarGraphRenderer.this.axisModel.getTickLabel(AbstractBarGraphRenderer.d2l(value), AbstractBarGraphRenderer.d2l(tickSize), AbstractBarGraphRenderer.d2l(min), AbstractBarGraphRenderer.d2l(max));
            }

            @Override
            public String provideAxisTitle(double min, double max) {
                return "";
            }
        };
    }

    @Override
    public RasterCalculationAdapter getRasterCalculationAdapter() {
        return new RasterCalculationAdapter(){

            @Override
            public double adaptRasterSize(double calculatedValue, double min, double max) {
                return AbstractBarGraphRenderer.this.axisModel.getMajorTickSize(Math.max(1L, AbstractBarGraphRenderer.d2l(calculatedValue)), AbstractBarGraphRenderer.d2l(min), AbstractBarGraphRenderer.d2l(max));
            }
        };
    }

    @Override
    public BarGraphToolTipProvider getToolTipProvider() {
        return new BarGraphToolTipProvider(){

            @Override
            public String provideToolTip(BarGraphDataSet data, int index) {
                return AbstractBarGraphRenderer.this.model.getRowToolTip(index) + "\n" + AbstractBarGraphRenderer.this.model.getToolTip(index, AbstractBarGraphRenderer.this.column);
            }
        };
    }

    @Override
    public RangeLineAxisAdapter getYAxisAdapter() {
        return this.getRangeLineAxisAdapter();
    }
}

