/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed;

import com.sap.jvm.profiling.presentation.typed.TypedModel;
import com.sap.jvm.profiling.resource.AbstractResource;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ProgressReporterListener;
import com.sap.jvm.profiling.resource.ProgressReporterListenerAdapter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.viewer.TaskManager;

public abstract class AbstractModelImpl
extends AbstractResource
implements TypedModel {
    private volatile TaskManager taskManager;

    protected AbstractModelImpl(TaskManager taskManager, ResourceName name) {
        super(name);
        this.taskManager = taskManager;
    }

    protected final boolean runBackgroundTask(Runnable runner) {
        TaskManager tmpManager = this.taskManager;
        if (tmpManager == null) {
            return false;
        }
        tmpManager.performBackgroundTask(runner);
        return true;
    }

    protected final boolean runForegroundTask(Runnable runner) {
        TaskManager tmpManager = this.taskManager;
        if (tmpManager == null) {
            return false;
        }
        tmpManager.performForegroundTask(runner);
        return true;
    }

    protected final void setTaskManager(TaskManager taskManager) {
        assert (this.taskManager == null || taskManager == null);
        this.taskManager = taskManager;
    }

    protected final ProgressReporter getRootCreationProgressReporter() {
        TaskManager tmpManager = this.taskManager;
        if (tmpManager == null) {
            return this.getCancellingProgressReporter();
        }
        return tmpManager.getRootCreationProgressReporter();
    }

    protected final ProgressReporter getNodeCreationProgressReporter() {
        TaskManager tmpManager = this.taskManager;
        if (tmpManager == null) {
            return this.getCancellingProgressReporter();
        }
        return tmpManager.getNodeCreationProgressReporter();
    }

    private ProgressReporter getCancellingProgressReporter() {
        ProgressReporter result = new ProgressReporter();
        result.addListener((ProgressReporterListener)new ProgressReporterListenerAdapter(){

            public boolean shouldCancel() {
                return true;
            }
        });
        return result;
    }
}

