/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed;

import com.sap.jvm.profiling.core.type.ArrayClassObject;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.presentation.impl.typed.AbstractModelImpl;
import com.sap.jvm.profiling.presentation.typed.TypedColumnBasedModel;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.TypedSelectableModel;
import com.sap.jvm.profiling.presentation.typed.entries.CalledMethod;
import com.sap.jvm.profiling.presentation.typed.entries.CallingMethod;
import com.sap.jvm.profiling.presentation.typed.entries.FileDescriptor;
import com.sap.jvm.profiling.presentation.typed.entries.NormalArrayLength;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClass;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassLoader;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFileId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFileName;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFilterEntity;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFilterEntry;
import com.sap.jvm.profiling.presentation.typed.entries.NormalGcEventId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalGcId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMethod;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMethodInvocationId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMonitorId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkAddress;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkConnectionType;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkEndpointType;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkLatencyId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkPort;
import com.sap.jvm.profiling.presentation.typed.entries.NormalPackage;
import com.sap.jvm.profiling.presentation.typed.entries.NormalPackagePart;
import com.sap.jvm.profiling.presentation.typed.entries.NormalParameterSpec;
import com.sap.jvm.profiling.presentation.typed.entries.NormalParameterValue;
import com.sap.jvm.profiling.presentation.typed.entries.NormalReentrantLockId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalSocketId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalString;
import com.sap.jvm.profiling.presentation.typed.entries.NormalSynchronizationEventId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadAnnotation;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadName;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.filter.ProfilingFilterStoreEntry;
import com.sap.jvm.profiling.snapshot.framecombiner.CombinedEntity;
import com.sap.jvm.profiling.snapshot.framecombiner.FilterEntity;
import com.sap.jvm.profiling.snapshot.gc.GcEventId;
import com.sap.jvm.profiling.snapshot.net.NetworkConnection;
import com.sap.jvm.profiling.snapshot.net.NetworkHost;
import com.sap.jvm.profiling.snapshot.net.NetworkService;
import com.sap.jvm.profiling.snapshot.resource.InlineFilterExtractor;
import com.sap.jvm.profiling.snapshot.resource.SynchronizationEventId;
import com.sap.jvm.profiling.snapshot.sync.ReentrantLockObject;
import com.sap.jvm.profiling.snapshot.tbs.elements.RunningType;
import com.sap.jvm.profiling.viewer.TaskManager;
import com.sap.jvm.util.pair.IntPair;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public abstract class AbstractSelectableColumnBasedModel
extends AbstractModelImpl
implements TypedColumnBasedModel,
TypedSelectableModel {
    private final TypedColumnSpec spec;
    private final int normalClassIndex;
    private final int normalClassLoaderIndex;
    private final int normalMethodIndex;
    private final int calledMethodIndex;
    private final int callingMethodIndex;
    private final int normalPackageIndex;
    private final int normalPackagePartIndex;
    private final int normalThreadIdIndex;
    private final int normalThreadNameIndex;
    private final int normalFileNameIndex;
    private final int normalFileIdIndex;
    private final int normalSocketIdIndex;
    private final int normalLocalAddressIndex;
    private final int normalLocalPortIndex;
    private final int normalRemoteAddressIndex;
    private final int normalRemotePortIndex;
    private final int normalConnectionTypeIndex;
    private final int normalServiceNameIndex;
    private final int normalServerClientIndex;
    private final int normalHostnameIndex;
    private final int fileDescriptorIndex;
    private final int normalArrayLengthIndex;
    private final int normalParameterSpecIndex;
    private final int normalParameterValueIndex;
    private final int normalMethodInvocationIdIndex;
    private final int normalThreadAnnotationIndex;
    private final int normalFilterEntryIndex;
    private final int normalFilterEntityIndex;
    private final int normalMonitorIndex;
    private final int normalReentrantLockIndex;
    private final int normalSynchronizationEventIndex;
    private final int normalNetworkLatencyIdIndex;
    private final int gcIdIndex;
    private final int gcEventIdIndex;
    private int searchColumn;
    private int typeColumn;

    protected AbstractSelectableColumnBasedModel(TaskManager taskManager, ResourceName name, TypedColumnSpec spec) {
        super(taskManager, name);
        this.spec = spec;
        this.searchColumn = -1;
        this.typeColumn = -1;
        this.normalClassIndex = this.getTypeIndex(NormalClass.class);
        this.normalClassLoaderIndex = this.getTypeIndex(NormalClassLoader.class);
        this.normalMethodIndex = this.getTypeIndex(NormalMethod.class);
        this.calledMethodIndex = this.getTypeIndex(CalledMethod.class);
        this.callingMethodIndex = this.getTypeIndex(CallingMethod.class);
        this.normalPackageIndex = this.getTypeIndex(NormalPackage.class);
        this.normalPackagePartIndex = this.getTypeIndex(NormalPackagePart.class);
        this.normalThreadIdIndex = this.getTypeIndex(NormalThreadId.class);
        this.normalThreadNameIndex = this.getTypeIndex(NormalThreadName.class);
        this.normalFileNameIndex = this.getTypeIndex(NormalFileName.class);
        this.normalFileIdIndex = this.getTypeIndex(NormalFileId.class);
        this.normalSocketIdIndex = this.getTypeIndex(NormalSocketId.class);
        this.normalLocalAddressIndex = this.getTypeIndex(NormalNetworkAddress.class);
        this.normalLocalPortIndex = this.getTypeIndex(NormalNetworkPort.class);
        this.normalRemoteAddressIndex = this.getTypeIndex2(NormalNetworkAddress.class);
        this.normalRemotePortIndex = this.getTypeIndex2(NormalNetworkPort.class);
        this.normalConnectionTypeIndex = this.getTypeIndex(NormalNetworkConnectionType.class);
        this.normalServiceNameIndex = this.getTypeIndex(NormalString.class);
        this.normalServerClientIndex = this.getTypeIndex(NormalNetworkEndpointType.class);
        this.normalHostnameIndex = this.getTypeIndex(NormalString.class);
        this.fileDescriptorIndex = this.getTypeIndex(FileDescriptor.class);
        this.normalParameterSpecIndex = this.getTypeIndex(NormalParameterSpec.class);
        this.normalParameterValueIndex = this.getTypeIndex(NormalParameterValue.class);
        this.normalMethodInvocationIdIndex = this.getTypeIndex(NormalMethodInvocationId.class);
        this.normalThreadAnnotationIndex = this.getTypeIndex(NormalThreadAnnotation.class);
        this.normalFilterEntryIndex = this.getTypeIndex(NormalFilterEntry.class);
        this.normalFilterEntityIndex = this.getTypeIndex(NormalFilterEntity.class);
        this.normalMonitorIndex = this.getTypeIndex(NormalMonitorId.class);
        this.normalReentrantLockIndex = this.getTypeIndex(NormalReentrantLockId.class);
        this.normalSynchronizationEventIndex = this.getTypeIndex(NormalSynchronizationEventId.class);
        this.normalNetworkLatencyIdIndex = this.getTypeIndex(NormalNetworkLatencyId.class);
        this.normalArrayLengthIndex = this.getTypeIndex(NormalArrayLength.class);
        this.gcIdIndex = this.getTypeIndex(NormalGcId.class);
        this.gcEventIdIndex = this.getTypeIndex(NormalGcEventId.class);
    }

    private int getTypeIndex(Class<?> type) {
        for (int i = 0; i < this.spec.getNrOfColumns(); ++i) {
            if (this.spec.getColumnType(i) != type) continue;
            if (this.searchColumn == -1) {
                this.searchColumn = i;
            }
            if (this.typeColumn == -1) {
                this.typeColumn = i;
            }
            return i;
        }
        return -1;
    }

    private int getTypeIndex2(Class<?> type) {
        int first = -1;
        for (int i = 0; i < this.spec.getNrOfColumns(); ++i) {
            if (this.spec.getColumnType(i) != type) continue;
            if (this.searchColumn == -1) {
                this.searchColumn = i;
            }
            if (this.typeColumn == -1) {
                this.typeColumn = i;
            }
            if (first == -1) {
                first = i;
                continue;
            }
            return i;
        }
        return -1;
    }

    @Override
    public ClassObject[] getSelectedClasses() {
        if (this.normalClassIndex == -1) {
            return new ClassObject[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(this.normalClassIndex);
        ClassObject[] selectedClasses = new ClassObject[selectedEntries.length];
        for (int i = 0; i < selectedEntries.length; ++i) {
            NormalClass clazz = (NormalClass)selectedEntries[i];
            selectedClasses[i] = clazz.getClassObject();
        }
        return selectedClasses;
    }

    @Override
    public ArrayClassObject[] getSelectedArrays() {
        if (this.normalClassIndex == -1) {
            return new ArrayClassObject[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(this.normalClassIndex);
        ArrayClassObject[] selectedClasses = new ArrayClassObject[selectedEntries.length];
        for (int i = 0; i < selectedEntries.length; ++i) {
            NormalClass clazz = (NormalClass)selectedEntries[i];
            if (!clazz.getClassObject().isArrayClass()) {
                return new ArrayClassObject[0];
            }
            selectedClasses[i] = (ArrayClassObject)clazz.getClassObject();
        }
        return selectedClasses;
    }

    @Override
    public int[] getSelectedArrayLengths() {
        if (this.normalArrayLengthIndex == -1) {
            return new int[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(this.normalArrayLengthIndex);
        int[] selectedLengths = new int[selectedEntries.length];
        for (int i = 0; i < selectedEntries.length; ++i) {
            NormalArrayLength arrayLength = (NormalArrayLength)selectedEntries[i];
            selectedLengths[i] = arrayLength.getLength();
        }
        return selectedLengths;
    }

    @Override
    public boolean onlyArraysSelected() {
        if (this.normalClassIndex == -1) {
            return false;
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(this.normalClassIndex);
        if (selectedEntries.length == 0) {
            return false;
        }
        for (int i = 0; i < selectedEntries.length; ++i) {
            NormalClass clazz = (NormalClass)selectedEntries[i];
            if (clazz.getClassObject().isArrayClass()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ProfilingFilterStoreEntry[] getSelectedFilterEntries() {
        if (this.normalFilterEntryIndex == -1) {
            return new ProfilingFilterStoreEntry[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(this.normalFilterEntryIndex);
        ProfilingFilterStoreEntry[] selectedFilters = new ProfilingFilterStoreEntry[selectedEntries.length];
        for (int i = 0; i < selectedEntries.length; ++i) {
            NormalFilterEntry filter = (NormalFilterEntry)selectedEntries[i];
            selectedFilters[i] = filter.getEntry();
        }
        return selectedFilters;
    }

    @Override
    public FilterEntity[] getSelectedFilterEntities() {
        if (this.normalFilterEntityIndex == -1) {
            return new FilterEntity[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(this.normalFilterEntityIndex);
        ArrayList<FilterEntity> result = new ArrayList<FilterEntity>();
        for (int i = 0; i < selectedEntries.length; ++i) {
            NormalFilterEntity filter = (NormalFilterEntity)selectedEntries[i];
            result.add(filter.getEntity());
        }
        return result.toArray(new FilterEntity[result.size()]);
    }

    @Override
    public CombinedEntity[] getSelectedEntities() {
        if (this.normalFilterEntryIndex == -1) {
            return new CombinedEntity[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(this.normalFilterEntryIndex);
        ArrayList<CombinedEntity> result = new ArrayList<CombinedEntity>();
        for (int i = 0; i < selectedEntries.length; ++i) {
            NormalFilterEntry filter = (NormalFilterEntry)selectedEntries[i];
            if (filter.getEntity() == null) continue;
            result.add(filter.getEntity());
        }
        return result.toArray(new CombinedEntity[result.size()]);
    }

    @Override
    public ClassLoaderObject[] getSelectedClassLoaders() {
        if (this.normalClassLoaderIndex == -1) {
            return new ClassLoaderObject[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(this.normalClassLoaderIndex);
        ClassLoaderObject[] selectedLoaders = new ClassLoaderObject[selectedEntries.length];
        for (int i = 0; i < selectedEntries.length; ++i) {
            NormalClassLoader loader = (NormalClassLoader)selectedEntries[i];
            selectedLoaders[i] = loader.getClassLoader();
        }
        return selectedLoaders;
    }

    @Override
    public MethodObject[] getSelectedMethods() {
        int index = this.normalMethodIndex;
        if (index == -1) {
            index = this.calledMethodIndex;
        }
        if (index == -1) {
            index = this.callingMethodIndex;
        }
        if (index == -1) {
            return new MethodObject[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(index);
        if (selectedEntries.length == 0) {
            return new MethodObject[0];
        }
        MethodObject[] selectedMethods = new MethodObject[selectedEntries.length];
        if (selectedEntries[0].getClass() == NormalMethod.class) {
            for (int i = 0; i < selectedEntries.length; ++i) {
                NormalMethod method = (NormalMethod)selectedEntries[i];
                selectedMethods[i] = method.getMethod();
            }
        } else if (selectedEntries[0].getClass() == CalledMethod.class) {
            for (int i = 0; i < selectedEntries.length; ++i) {
                CalledMethod method = (CalledMethod)selectedEntries[i];
                selectedMethods[i] = method.getMethod();
            }
        } else if (selectedEntries[0].getClass() == CallingMethod.class) {
            for (int i = 0; i < selectedEntries.length; ++i) {
                CallingMethod method = (CallingMethod)selectedEntries[i];
                selectedMethods[i] = method.getMethod();
            }
        } else assert (false);
        return selectedMethods;
    }

    @Override
    public PackageName[] getSelectedPackages() {
        int index;
        int n = index = this.normalPackageIndex >= 0 ? this.normalPackageIndex : this.normalPackagePartIndex;
        if (index == -1) {
            return new PackageName[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(index);
        if (selectedEntries.length == 0) {
            return new PackageName[0];
        }
        PackageName[] selectedPackages = new PackageName[selectedEntries.length];
        if (selectedEntries[0].getClass() == NormalPackage.class) {
            for (int i = 0; i < selectedEntries.length; ++i) {
                NormalPackage pkg = (NormalPackage)selectedEntries[i];
                selectedPackages[i] = pkg.getPackage();
            }
        } else if (selectedEntries[0].getClass() == NormalPackagePart.class) {
            for (int i = 0; i < selectedEntries.length; ++i) {
                NormalPackagePart pkg = (NormalPackagePart)selectedEntries[i];
                selectedPackages[i] = pkg.getPackage();
            }
        } else assert (false);
        return selectedPackages;
    }

    @Override
    public long[] getSelectedThreadIds() {
        if (this.normalThreadIdIndex == -1) {
            return new long[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(this.normalThreadIdIndex);
        if (selectedEntries.length == 0) {
            return new long[0];
        }
        long[] selectedThreads = new long[selectedEntries.length];
        for (int i = 0; i < selectedEntries.length; ++i) {
            selectedThreads[i] = ((NormalThreadId)selectedEntries[i]).getId();
        }
        return selectedThreads;
    }

    protected abstract <R> R[][] getSelectedPaths(R[][] var1);

    @Override
    public MethodLocation[][] getSelectedMethodPaths() {
        return this.getSelectedPaths(new MethodLocation[0][]);
    }

    @Override
    public FilterEntity[][] getSelectedFilterEntityPaths() {
        return this.getSelectedPaths(new FilterEntity[0][]);
    }

    protected abstract <R> R[] getSelectedRowTypes(R[] var1);

    @Override
    public MethodFilter[] getSelectedMethodFilters() {
        return this.getSelectedRowTypes(new MethodFilter[0]);
    }

    @Override
    public RunningType[] getSelectedRunningTypes() {
        return this.getSelectedRowTypes(new RunningType[0]);
    }

    @Override
    public IntPair[] getSelectedIntPairs() {
        return this.getSelectedRowTypes(new IntPair[0]);
    }

    @Override
    public UTF8String[] getSelectedThreadNames() {
        int index = this.normalThreadNameIndex;
        if (index == -1) {
            return new UTF8String[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(index);
        if (selectedEntries.length == 0) {
            return new UTF8String[0];
        }
        UTF8String[] selectedThreads = new UTF8String[selectedEntries.length];
        for (int i = 0; i < selectedEntries.length; ++i) {
            selectedThreads[i] = ((NormalThreadName)selectedEntries[i]).getName();
        }
        return selectedThreads;
    }

    @Override
    public long[] getSelectedFileIds(boolean index) {
        int column = this.normalFileIdIndex;
        if (column == -1) {
            return new long[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(column);
        if (selectedEntries.length == 0) {
            return new long[0];
        }
        long[] selectedFileIds = new long[selectedEntries.length];
        for (int i = 0; i < selectedEntries.length; ++i) {
            selectedFileIds[i] = index ? ((NormalFileId)selectedEntries[i]).getIndex() : ((NormalFileId)selectedEntries[i]).getId();
        }
        return selectedFileIds;
    }

    @Override
    public long[] getSelectedSocketIds(boolean index) {
        int column = this.normalSocketIdIndex;
        if (column == -1) {
            return new long[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(column);
        if (selectedEntries.length == 0) {
            return new long[0];
        }
        long[] selectedSocketIds = new long[selectedEntries.length];
        for (int i = 0; i < selectedEntries.length; ++i) {
            selectedSocketIds[i] = index ? ((NormalSocketId)selectedEntries[i]).getIndex() : ((NormalSocketId)selectedEntries[i]).getId();
        }
        return selectedSocketIds;
    }

    @Override
    public NetworkConnection[] getSelectedSocketConnections() {
        int localAddress = this.normalLocalAddressIndex;
        int localPort = this.normalLocalPortIndex;
        int remoteAddress = this.normalRemoteAddressIndex;
        int remotePort = this.normalRemotePortIndex;
        int connectionType = this.normalConnectionTypeIndex;
        if (localAddress == -1 || localPort == -1 || remoteAddress == -1 || remotePort == -1 || connectionType == -1) {
            return new NetworkConnection[0];
        }
        ProviderEntry[] selectedLocalAddresses = this.getSelectedEntries(localAddress);
        ProviderEntry[] selectedLocalPorts = this.getSelectedEntries(localPort);
        ProviderEntry[] selectedRemoteAddresses = this.getSelectedEntries(remoteAddress);
        ProviderEntry[] selectedRemotePorts = this.getSelectedEntries(remotePort);
        ProviderEntry[] selectedConnectionTypes = this.getSelectedEntries(connectionType);
        if (selectedLocalAddresses.length == 0 || selectedLocalPorts.length == 0 || selectedRemoteAddresses.length == 0 || selectedRemotePorts.length == 0 || selectedConnectionTypes.length == 0) {
            return new NetworkConnection[0];
        }
        assert (selectedLocalAddresses.length == selectedLocalPorts.length && selectedLocalPorts.length == selectedRemoteAddresses.length && selectedRemoteAddresses.length == selectedRemotePorts.length && selectedRemotePorts.length == selectedConnectionTypes.length);
        NetworkConnection[] selectedConnections = new NetworkConnection[selectedLocalAddresses.length];
        for (int i = 0; i < selectedConnections.length; ++i) {
            selectedConnections[i] = new NetworkConnection(((NormalNetworkAddress)selectedLocalAddresses[i]).getAddress(), ((NormalNetworkPort)selectedLocalPorts[i]).getPort(), ((NormalNetworkAddress)selectedRemoteAddresses[i]).getAddress(), ((NormalNetworkPort)selectedRemotePorts[i]).getPort(), ((NormalNetworkConnectionType)selectedConnectionTypes[i]).isStreamSocket());
        }
        return selectedConnections;
    }

    @Override
    public NetworkService[] getSelectedNetworkServices() {
        int serviceName = this.normalServiceNameIndex;
        int port = this.normalLocalPortIndex;
        int serverClient = this.normalServerClientIndex;
        int connectionType = this.normalConnectionTypeIndex;
        if (serviceName == -1 || port == -1 || serverClient == -1 || connectionType == -1) {
            return new NetworkService[0];
        }
        ProviderEntry[] selectedServiceNames = this.getSelectedEntries(serviceName);
        ProviderEntry[] selectedPorts = this.getSelectedEntries(port);
        ProviderEntry[] selectedServerClients = this.getSelectedEntries(serverClient);
        ProviderEntry[] selectedConnectionTypes = this.getSelectedEntries(connectionType);
        if (selectedServiceNames.length == 0 || selectedPorts.length == 0 || selectedServerClients.length == 0 || selectedConnectionTypes.length == 0) {
            return new NetworkService[0];
        }
        assert (selectedServiceNames.length == selectedPorts.length && selectedPorts.length == selectedServerClients.length && selectedServerClients.length == selectedConnectionTypes.length);
        NetworkService[] selectedServices = new NetworkService[selectedServiceNames.length];
        for (int i = 0; i < selectedServices.length; ++i) {
            selectedServices[i] = new NetworkService(((NormalString)selectedServiceNames[i]).getString(), ((NormalNetworkPort)selectedPorts[i]).getPort(), ((NormalNetworkEndpointType)selectedServerClients[i]).getSideType(), ((NormalNetworkConnectionType)selectedConnectionTypes[i]).isStreamSocket());
        }
        return selectedServices;
    }

    @Override
    public NetworkHost[] getSelectedNetworkHosts() {
        int hostname = this.normalHostnameIndex;
        int address = this.normalLocalAddressIndex;
        if (hostname == -1 || address == -1) {
            return new NetworkHost[0];
        }
        ProviderEntry[] selectedHostnames = this.getSelectedEntries(hostname);
        ProviderEntry[] selectedAddresses = this.getSelectedEntries(address);
        if (selectedHostnames.length == 0 || selectedAddresses.length == 0) {
            return new NetworkHost[0];
        }
        assert (selectedHostnames.length == selectedAddresses.length);
        NetworkHost[] selectedHosts = new NetworkHost[selectedHostnames.length];
        for (int i = 0; i < selectedHostnames.length; ++i) {
            selectedHosts[i] = new NetworkHost(((NormalString)selectedHostnames[i]).getString(), ((NormalNetworkAddress)selectedAddresses[i]).getAddress());
        }
        return selectedHosts;
    }

    @Override
    public long[] getSelectedFileDescriptors() {
        int column = this.fileDescriptorIndex;
        if (column == -1) {
            return new long[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(column);
        if (selectedEntries.length == 0) {
            return new long[0];
        }
        long[] selectedFds = new long[selectedEntries.length];
        for (int i = 0; i < selectedEntries.length; ++i) {
            selectedFds[i] = ((FileDescriptor)selectedEntries[i]).getFd();
        }
        return selectedFds;
    }

    @Override
    public UTF8String[] getSelectedFileNames() {
        int index = this.normalFileNameIndex;
        if (index == -1) {
            return new UTF8String[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(index);
        if (selectedEntries.length == 0) {
            return new UTF8String[0];
        }
        UTF8String[] selectedFiles = new UTF8String[selectedEntries.length];
        for (int i = 0; i < selectedEntries.length; ++i) {
            selectedFiles[i] = ((NormalFileName)selectedEntries[i]).getName();
        }
        return selectedFiles;
    }

    @Override
    public String[] getSelectedParameterSpecs() {
        int index = this.normalParameterSpecIndex;
        if (index == -1) {
            return new String[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(index);
        if (selectedEntries.length == 0) {
            return new String[0];
        }
        String[] selectedParameterSpecs = new String[selectedEntries.length];
        for (int i = 0; i < selectedEntries.length; ++i) {
            NormalParameterSpec paramSpec = (NormalParameterSpec)selectedEntries[i];
            selectedParameterSpecs[i] = paramSpec.getSpecification();
        }
        return selectedParameterSpecs;
    }

    @Override
    public Parameter[] getSelectedParameterValues() {
        int index = this.normalParameterValueIndex;
        if (index == -1) {
            return new Parameter[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(index);
        if (selectedEntries.length == 0) {
            return new Parameter[0];
        }
        Parameter[] selectedParameterValues = new Parameter[selectedEntries.length];
        for (int i = 0; i < selectedEntries.length; ++i) {
            NormalParameterValue paramValue = (NormalParameterValue)selectedEntries[i];
            selectedParameterValues[i] = paramValue.getValue();
        }
        return selectedParameterValues;
    }

    @Override
    public long[] getSelectedMethodInvocationIds() {
        int index = this.normalMethodInvocationIdIndex;
        if (index == -1) {
            return new long[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(index);
        if (selectedEntries.length == 0) {
            return new long[0];
        }
        long[] selectedIdValues = new long[selectedEntries.length];
        for (int i = 0; i < selectedEntries.length; ++i) {
            NormalMethodInvocationId invocationId = (NormalMethodInvocationId)selectedEntries[i];
            selectedIdValues[i] = invocationId.getId();
        }
        return selectedIdValues;
    }

    @Override
    public String[] getSelectedThreadAnnotations() {
        int index = this.normalThreadAnnotationIndex;
        if (index == -1) {
            return new String[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(index);
        if (selectedEntries.length == 0) {
            return new String[0];
        }
        String[] selectedThreadAnnotations = new String[selectedEntries.length];
        for (int i = 0; i < selectedEntries.length; ++i) {
            NormalThreadAnnotation threadAnnotation = (NormalThreadAnnotation)selectedEntries[i];
            selectedThreadAnnotations[i] = threadAnnotation.getValue();
        }
        return selectedThreadAnnotations;
    }

    @Override
    public MonitorObject[] getSelectedMonitors() {
        if (this.normalMonitorIndex == -1 || this.normalClassIndex == -1) {
            return new MonitorObject[0];
        }
        ProviderEntry[] selectedObjectIds = this.getSelectedEntries(this.normalMonitorIndex);
        ProviderEntry[] selectedClasses = this.getSelectedEntries(this.normalClassIndex);
        assert (selectedObjectIds.length == selectedClasses.length);
        MonitorObject[] selectedMonitors = new MonitorObject[selectedObjectIds.length];
        for (int i = 0; i < selectedObjectIds.length; ++i) {
            NormalMonitorId id = (NormalMonitorId)selectedObjectIds[i];
            NormalClass clazz = (NormalClass)selectedClasses[i];
            selectedMonitors[i] = new MonitorObject(id.getId(), clazz.getClassObject());
        }
        return selectedMonitors;
    }

    @Override
    public ReentrantLockObject[] getSelectedReentrantLocks() {
        if (this.normalReentrantLockIndex == -1) {
            return new ReentrantLockObject[0];
        }
        ProviderEntry[] selectedObjectIds = this.getSelectedEntries(this.normalReentrantLockIndex);
        ReentrantLockObject[] selectedLocks = new ReentrantLockObject[selectedObjectIds.length];
        for (int i = 0; i < selectedObjectIds.length; ++i) {
            NormalReentrantLockId id = (NormalReentrantLockId)selectedObjectIds[i];
            selectedLocks[i] = new ReentrantLockObject(id.getId());
        }
        return selectedLocks;
    }

    @Override
    public SynchronizationEventId[] getSelectedSynchronizationEvents() {
        if (this.normalSynchronizationEventIndex == -1) {
            return new SynchronizationEventId[0];
        }
        ProviderEntry[] selectedEvents = this.getSelectedEntries(this.normalSynchronizationEventIndex);
        SynchronizationEventId[] result = new SynchronizationEventId[selectedEvents.length];
        for (int i = 0; i < selectedEvents.length; ++i) {
            NormalSynchronizationEventId id = (NormalSynchronizationEventId)selectedEvents[i];
            result[i] = new SynchronizationEventId(id.getId(), id.getIndex());
        }
        return result;
    }

    @Override
    public long[] getSelectedNetworkLatencyIds() {
        int index = this.normalNetworkLatencyIdIndex;
        if (index == -1) {
            return new long[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(index);
        if (selectedEntries.length == 0) {
            return new long[0];
        }
        long[] selectedIdValues = new long[selectedEntries.length];
        for (int i = 0; i < selectedEntries.length; ++i) {
            NormalNetworkLatencyId latencyId = (NormalNetworkLatencyId)selectedEntries[i];
            selectedIdValues[i] = latencyId.getId();
        }
        return selectedIdValues;
    }

    protected final MethodFilter getFilterForInlinedPackages(PackageName[] packages) {
        boolean hasInlined = false;
        for (PackageName pkg : packages) {
            if (!pkg.isInlinedAway()) continue;
            hasInlined = true;
            break;
        }
        if (hasInlined) {
            return InlineFilterExtractor.getInlineFilter(this.getResourceName());
        }
        return null;
    }

    @Override
    public long[] getSelectedGcIds() {
        if (this.gcEventIdIndex != -1) {
            GcEventId[] gcEvents = this.getSelectedGcEventIds();
            LinkedHashSet<Long> selectedGCsSet = new LinkedHashSet<Long>();
            for (GcEventId event : gcEvents) {
                selectedGCsSet.add(event.getGcNumber());
            }
            long[] selectedGcIds = new long[selectedGCsSet.size()];
            int i = 0;
            for (Long gcId : selectedGCsSet) {
                selectedGcIds[i++] = gcId;
            }
            return selectedGcIds;
        }
        int column = this.gcIdIndex;
        if (column == -1) {
            return new long[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(column);
        long[] selectedGcIds = new long[selectedEntries.length];
        for (int i = 0; i < selectedEntries.length; ++i) {
            selectedGcIds[i] = ((NormalGcId)selectedEntries[i]).getId();
        }
        return selectedGcIds;
    }

    public GcEventId[] getSelectedGcEventIds() {
        int column = this.gcEventIdIndex;
        if (column == -1) {
            return new GcEventId[0];
        }
        ProviderEntry[] selectedEntries = this.getSelectedEntries(column);
        if (selectedEntries.length == 0) {
            return new GcEventId[0];
        }
        GcEventId[] selectedGcEventIds = new GcEventId[selectedEntries.length];
        for (int i = 0; i < selectedEntries.length; ++i) {
            selectedGcEventIds[i] = ((NormalGcEventId)selectedEntries[i]).getId();
        }
        return selectedGcEventIds;
    }
}

