/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed;

import com.sap.jvm.profiling.presentation.typed.TreeChildCombiner;
import com.sap.jvm.profiling.presentation.typed.entries.MixedProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;

public final class MixedNodesTreeChildCombiner
implements TreeChildCombiner {
    private final int maxNumNodes;
    private final Class<?> combineEntryClazz;

    public MixedNodesTreeChildCombiner(int maxNumNodes, Class<?> combineEntryClazz) {
        this.maxNumNodes = maxNumNodes;
        this.combineEntryClazz = combineEntryClazz;
    }

    @Override
    public int[] getChildrenToCombine(ProviderEntry[] children) {
        int[] posArray = new int[children.length];
        int foundValidNodes = 0;
        boolean combine = false;
        int posIndex = 0;
        for (int pos = 0; pos < children.length; ++pos) {
            ProviderEntry entry = children[pos];
            if (entry == null) {
                return null;
            }
            if (entry instanceof MixedProviderEntry && ((MixedProviderEntry)entry).getProviderEntry().getClass().equals(this.combineEntryClazz)) {
                if (foundValidNodes > this.maxNumNodes && !combine) {
                    combine = true;
                    posArray[posIndex++] = pos;
                    continue;
                }
                if (combine) continue;
                ++foundValidNodes;
                continue;
            }
            if (!combine) continue;
            combine = false;
            posArray[posIndex++] = pos;
        }
        int[] result = new int[posIndex];
        System.arraycopy(posArray, 0, result, 0, posIndex);
        return result;
    }

    @Override
    public boolean regardSortOrder() {
        return false;
    }
}

