/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed;

import com.sap.jvm.profiling.presentation.typed.TypedValueSetModel;
import com.sap.jvm.profiling.ui.graph.PieGraphToolTipProvider;
import com.sap.jvm.profiling.ui.graph.dataset.PieGraphDataSet;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.viewer.graph.PieGraphRenderer;
import java.util.ArrayList;
import java.util.HashSet;

public final class PieGraphRendererImpl
implements PieGraphRenderer {
    private final TypedValueSetModel model;
    private final int column;

    public PieGraphRendererImpl(TypedValueSetModel model, int column) {
        this.model = model;
        this.column = column;
    }

    @Override
    public PieGraphDataSet getDataSet(boolean markSelected) {
        PieGraphDataSet dataSet = new PieGraphDataSet(this.model.getColumnName(this.column));
        int[] selectedRows = this.model.getSelectedRows();
        HashSet<Integer> selection = new HashSet<Integer>();
        if (markSelected) {
            for (int selectedEntry : selectedRows) {
                selection.add(selectedEntry);
            }
        }
        for (int i = 0; i < this.model.getNrOfRows(); ++i) {
            int index = dataSet.addValue(this.model.getValue(i, this.column), this.model.getRowName(i), new Color(this.model.getRowColor(i)));
            if (!selection.contains(i)) continue;
            dataSet.getPiece(index).setSelection(true);
        }
        return dataSet;
    }

    @Override
    public PieGraphToolTipProvider getToolTipProvider() {
        return new PieGraphToolTipProvider(){

            @Override
            public String provideToolTip(PieGraphDataSet pie, PieGraphDataSet.PiePiece piece) {
                ArrayList<PieGraphDataSet.PiePiece> pieces = pie.getPieces();
                for (int i = 0; i < pieces.size(); ++i) {
                    if (pieces.get(i) != piece) continue;
                    return PieGraphRendererImpl.this.model.getRowToolTip(i) + "\n" + PieGraphRendererImpl.this.model.getToolTip(i, PieGraphRendererImpl.this.column);
                }
                return null;
            }
        };
    }
}

