/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public final class SortHistory {
    private static final int VERSION = 0;
    private final int[] columns;
    private final int[] directions;
    private int nrOfNeededSorts;

    public SortHistory(int nrOfColumns) {
        this.columns = new int[nrOfColumns];
        this.directions = new int[nrOfColumns];
        for (int i = 0; i < nrOfColumns; ++i) {
            this.columns[i] = -1;
        }
    }

    public SortHistory(ResourceReader reader, ProgressReporter reporter) throws IOException {
        int i;
        reader.readVersion(0, 0);
        this.columns = new int[reader.readInt32()];
        for (i = 0; i < this.columns.length; ++i) {
            this.columns[i] = reader.readInt32();
        }
        this.directions = new int[reader.readInt32()];
        for (i = 0; i < this.directions.length; ++i) {
            this.directions[i] = reader.readInt32();
        }
        this.nrOfNeededSorts = reader.readInt32();
    }

    private SortHistory(int[] columns, int[] directions, int nrOfNeededSorts) {
        this.columns = (int[])columns.clone();
        this.directions = (int[])directions.clone();
        this.nrOfNeededSorts = nrOfNeededSorts;
    }

    public SortHistory copy() {
        return new SortHistory(this.columns, this.directions, this.nrOfNeededSorts);
    }

    public void notifySortPerformed(int column, int direction) {
        if (direction == 0) {
            this.nrOfNeededSorts = 0;
            for (int i = 0; i < this.columns.length; ++i) {
                this.columns[i] = -1;
            }
        } else {
            for (int i = 0; i < this.columns.length; ++i) {
                if (this.columns[i] != column) continue;
                System.arraycopy(this.columns, 0, this.columns, 1, i);
                System.arraycopy(this.directions, 0, this.directions, 1, i);
                this.columns[0] = column;
                this.directions[0] = direction;
                return;
            }
            System.arraycopy(this.columns, 0, this.columns, 1, this.nrOfNeededSorts);
            System.arraycopy(this.directions, 0, this.directions, 1, this.nrOfNeededSorts);
            this.columns[0] = column;
            this.directions[0] = direction;
            ++this.nrOfNeededSorts;
        }
    }

    public int getNrOfNeededSorts() {
        return this.nrOfNeededSorts;
    }

    public int getSortingColumn(int sortNr) {
        assert (sortNr < this.nrOfNeededSorts);
        return this.columns[sortNr];
    }

    public int getSortingDirection(int sortNr) {
        assert (sortNr < this.nrOfNeededSorts);
        return this.directions[sortNr];
    }

    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.columns.length);
        for (int column : this.columns) {
            writer.writeInt32(column);
        }
        writer.writeInt32(this.directions.length);
        for (int direction : this.directions) {
            writer.writeInt32(direction);
        }
        writer.writeInt32(this.nrOfNeededSorts);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = this.getNrOfNeededSorts() - 1; i >= 0; --i) {
            result.append("column " + this.getSortingColumn(i) + " ");
            result.append(this.getSortingDirection(i) > 0 ? "ascending" : "descending");
            if (i <= 0) continue;
            result.append(" -> ");
        }
        return result.toString();
    }

    public int getMaxNumberOfColumns() {
        return this.columns.length;
    }
}

