/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.axis.AbsoluteTimeStampAxisModel;
import com.sap.jvm.profiling.presentation.typed.AxisModel;
import com.sap.jvm.profiling.presentation.typed.TypedTimeSeriesModel;
import com.sap.jvm.profiling.ui.graph.axes.LineGraphAxisCaptionProvider;
import com.sap.jvm.profiling.ui.graph.axes.RangeLineAxisAdapter;
import com.sap.jvm.profiling.ui.graph.axes.RasterCalculationAdapter;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.viewer.series.TimeSeriesRenderer;
import java.util.ArrayList;

public class TimeSeriesRendererImpl
implements TimeSeriesRenderer {
    protected final TypedTimeSeriesModel model;
    protected final AxisModel xAxisModel;
    protected final AxisModel[] yAxisModels;
    private Class<?> firstYAxisType;
    private Class<?> secondYAxisType;
    protected final int area;
    private final long xOffset;

    public TimeSeriesRendererImpl(TypedTimeSeriesModel model, int area, AxisModel xAxisModel, AxisModel[] yAxisModels, long xOffset) {
        this.model = model;
        this.xAxisModel = xAxisModel;
        this.yAxisModels = yAxisModels;
        this.area = area;
        this.xOffset = xOffset;
        for (int i = 0; i < model.getAreaSize(area); ++i) {
            if (!model.isGraphVisible(area, i)) continue;
            Class<?> type = model.getYAxisBaseType(area, i);
            Object dataSet = model.getGraph(area, i, xOffset);
            if (!(dataSet instanceof LineGraphDataSet)) continue;
            boolean forcedSec = model.isForcedSecondary(area, i);
            if (this.firstYAxisType == null && !forcedSec) {
                this.firstYAxisType = type;
                continue;
            }
            if (this.firstYAxisType == type && !forcedSec) continue;
            this.secondYAxisType = type;
        }
    }

    private static long d2l(double v) {
        if (v < 0.0) {
            return (long)(v - 0.5);
        }
        return (long)(v + 0.5);
    }

    private RangeLineAxisAdapter getRangeLineAxisAdapter(final double min, final double max) {
        return new RangeLineAxisAdapter(){

            @Override
            public double adjustMax(double currentMin, double currentMax) {
                return max;
            }

            @Override
            public double adjustMin(double currentMin, double currentMax) {
                return min;
            }
        };
    }

    private LineGraphAxisCaptionProvider getAxisCaptionProvider(final AxisModel axisModel, final String caption) {
        return new LineGraphAxisCaptionProvider(){

            @Override
            public String provideScaleUnitCaption(double value, double tickSize, double min, double max) {
                if (axisModel == null) {
                    return DataFormatter.getNumberText((double)value);
                }
                return axisModel.getTickLabel(TimeSeriesRendererImpl.d2l(value), TimeSeriesRendererImpl.d2l(tickSize), TimeSeriesRendererImpl.d2l(min), TimeSeriesRendererImpl.d2l(max));
            }

            @Override
            public String provideAxisTitle(double min, double max) {
                return caption;
            }
        };
    }

    private LineGraphAxisCaptionProvider getAxisValueProvider(final AxisModel axisModel) {
        return new LineGraphAxisCaptionProvider(){

            @Override
            public String provideScaleUnitCaption(double value, double tickSize, double min, double max) {
                return axisModel.getToolTip((long)value);
            }

            @Override
            public String provideAxisTitle(double min, double max) {
                return "";
            }
        };
    }

    private RasterCalculationAdapter getRasterCalculationAdapter(final AxisModel axisModel) {
        if (axisModel == null) {
            return new RasterCalculationAdapter();
        }
        return new RasterCalculationAdapter(){

            @Override
            public double adaptRasterSize(double calculatedValue, double min, double max) {
                long lmax;
                long lmin = TimeSeriesRendererImpl.d2l(min);
                if (lmin >= (lmax = TimeSeriesRendererImpl.d2l(max))) {
                    return max - min;
                }
                double size = axisModel.getMajorTickSize(TimeSeriesRendererImpl.d2l(calculatedValue), TimeSeriesRendererImpl.d2l(min), TimeSeriesRendererImpl.d2l(max));
                if (size > max - min) {
                    int nrOfLabels;
                    long newStep = TimeSeriesRendererImpl.d2l(calculatedValue);
                    do {
                        size = axisModel.getMajorTickSize(newStep, TimeSeriesRendererImpl.d2l(min), TimeSeriesRendererImpl.d2l(max));
                        nrOfLabels = (int)((max - min) / size);
                        if (min == 0.0) {
                            ++nrOfLabels;
                        }
                        if (nrOfLabels > 2) {
                            return size * 2.0;
                        }
                        long oldStep = newStep;
                        if (oldStep != (newStep = TimeSeriesRendererImpl.d2l((double)newStep * 0.8)) || --newStep != 0L) continue;
                        return size;
                    } while (nrOfLabels < 2);
                }
                return size;
            }

            @Override
            public double getRasterOrigin(double rasterSize, double min) {
                if (axisModel instanceof AbsoluteTimeStampAxisModel) {
                    return ((AbsoluteTimeStampAxisModel)axisModel).getRasterOrigin();
                }
                return 0.0;
            }
        };
    }

    @Override
    public LineGraphAxisCaptionProvider getXAxisCaptionProvider() {
        return this.getAxisCaptionProvider(this.xAxisModel, this.model.getCaptionForAxisType(this.model.getXAxisType()));
    }

    @Override
    public RasterCalculationAdapter getXAxisRasterAdapter() {
        return this.getRasterCalculationAdapter(this.xAxisModel);
    }

    @Override
    public RangeLineAxisAdapter getXAxisRangeAdapter() {
        return this.getRangeLineAxisAdapter(this.model.getMinX(), this.model.getMaxX());
    }

    @Override
    public LineGraphAxisCaptionProvider getYAxisCaptionProvider() {
        for (int i = 0; i < this.model.getAreaSize(this.area); ++i) {
            Class<?> type;
            if (!this.model.isGraphVisible(this.area, i) || !this.isPrimary(this.area, i) || (type = this.model.getYAxisBaseType(this.area, i)) == null) continue;
            return this.getAxisCaptionProvider(this.yAxisModels[i], this.model.getCaptionForAxisType(type));
        }
        return null;
    }

    @Override
    public String getMaxYAxisCaption() {
        RangeLineAxisAdapter rangeAdapter = this.getYAxisRangeAdapter();
        double min = rangeAdapter.adjustMin(0.0, 0.0);
        double max = rangeAdapter.adjustMax(0.0, 0.0);
        double raster = this.getYAxisRasterAdapter().adaptRasterSize((max - min) / 10.0, min, max);
        double val = raster < 0.5 ? max : max - (double)((long)(max + 0.5) % (long)(raster + 0.5));
        return this.getYAxisCaptionProvider().provideScaleUnitCaption(val, raster, min, max);
    }

    @Override
    public RasterCalculationAdapter getYAxisRasterAdapter() {
        for (int i = 0; i < this.model.getAreaSize(this.area); ++i) {
            if (!this.model.isGraphVisible(this.area, i) || !this.isPrimary(this.area, i)) continue;
            return this.getRasterCalculationAdapter(this.yAxisModels[i]);
        }
        return null;
    }

    @Override
    public RangeLineAxisAdapter getYAxisRangeAdapter() {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < this.model.getAreaSize(this.area); ++i) {
            Object graph;
            if (!this.model.isGraphVisible(this.area, i) || !this.isPrimary(this.area, i) || !((graph = this.model.getGraph(this.area, i, this.xOffset)) instanceof LineGraphDataSet)) continue;
            LineGraphDataSet dataSet = (LineGraphDataSet)graph;
            min = Math.min(min, dataSet.getMinY());
            max = Math.max(max, dataSet.getMaxY());
        }
        if (min >= max) {
            max = min + 2.0;
        }
        return this.getRangeLineAxisAdapter(min, max);
    }

    @Override
    public LineGraphAxisCaptionProvider getY2AxisCaptionProvider() {
        for (int i = 0; i < this.model.getAreaSize(this.area); ++i) {
            if (!this.model.isGraphVisible(this.area, i) || !this.isSecondary(this.area, i)) continue;
            Class<?> type = this.model.getYAxisType(this.area, i);
            return this.getAxisCaptionProvider(this.yAxisModels[i], this.model.getCaptionForAxisType(type));
        }
        return this.getYAxisCaptionProvider();
    }

    @Override
    public String getMaxY2AxisCaption() {
        RangeLineAxisAdapter rangeAdapter = this.getY2AxisRangeAdapter();
        double min = rangeAdapter.adjustMin(0.0, 0.0);
        double max = rangeAdapter.adjustMax(0.0, 0.0);
        double raster = this.getY2AxisRasterAdapter().adaptRasterSize((max - min) / 10.0, min, max);
        double val = raster < 0.5 ? max : max - (double)((long)(max + 0.5) % (long)(raster + 0.5));
        return this.getY2AxisCaptionProvider().provideScaleUnitCaption(val, raster, min, max);
    }

    @Override
    public RasterCalculationAdapter getY2AxisRasterAdapter() {
        for (int i = 0; i < this.model.getAreaSize(this.area); ++i) {
            if (!this.model.isGraphVisible(this.area, i) || !this.isSecondary(this.area, i)) continue;
            return this.getRasterCalculationAdapter(this.yAxisModels[i]);
        }
        return this.getYAxisRasterAdapter();
    }

    @Override
    public RangeLineAxisAdapter getY2AxisRangeAdapter() {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        boolean hasY2Axis = false;
        for (int i = 0; i < this.model.getAreaSize(this.area); ++i) {
            Object graph;
            if (!this.model.isGraphVisible(this.area, i) || !this.isSecondary(this.area, i) || !((graph = this.model.getGraph(this.area, i, this.xOffset)) instanceof LineGraphDataSet)) continue;
            LineGraphDataSet dataSet = (LineGraphDataSet)graph;
            min = Math.min(min, dataSet.getMinY());
            max = Math.max(max, dataSet.getMaxY());
            hasY2Axis = true;
        }
        if (!hasY2Axis) {
            return this.getYAxisRangeAdapter();
        }
        if (min >= max) {
            max = min + 2.0;
        }
        return this.getRangeLineAxisAdapter(min, max);
    }

    @Override
    public Object[] getGraphsForY() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.model.getAreaSize(this.area); ++i) {
            if (!this.model.isGraphVisible(this.area, i) || !this.isPrimary(this.area, i)) continue;
            Object graph = this.model.getGraph(this.area, i, this.xOffset);
            result.add(graph);
        }
        return result.toArray(new Object[result.size()]);
    }

    @Override
    public Object[] getGraphsForY2() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.model.getAreaSize(this.area); ++i) {
            if (!this.model.isGraphVisible(this.area, i) || !this.isSecondary(this.area, i)) continue;
            result.add(this.model.getGraph(this.area, i, this.xOffset));
        }
        return result.toArray(new Object[result.size()]);
    }

    private boolean isPrimary(int areaIndex, int idx) {
        Class<?> type = this.model.getYAxisBaseType(areaIndex, idx);
        if (type == null || this.model.isForcedPrimary(areaIndex, idx)) {
            return true;
        }
        return this.firstYAxisType == type && !this.model.isForcedSecondary(areaIndex, idx);
    }

    private boolean isSecondary(int areaIndex, int idx) {
        Class<?> type = this.model.getYAxisBaseType(areaIndex, idx);
        if (this.model.isForcedPrimary(areaIndex, idx)) {
            return false;
        }
        if (this.secondYAxisType == this.firstYAxisType) {
            return this.model.isForcedSecondary(areaIndex, idx);
        }
        return type != null && type != this.firstYAxisType;
    }

    @Override
    public LineGraphAxisCaptionProvider getYAxisValueProvider(int index) {
        int c = index;
        for (int i = 0; i < this.model.getAreaSize(this.area); ++i) {
            if (!this.model.isGraphVisible(this.area, i) || !this.isPrimary(this.area, i)) continue;
            if (c <= 0) {
                return this.getAxisValueProvider(this.yAxisModels[i]);
            }
            --c;
        }
        return null;
    }

    @Override
    public LineGraphAxisCaptionProvider getY2AxisValueProvider(int index) {
        int c = index;
        for (int i = 0; i < this.model.getAreaSize(this.area); ++i) {
            if (!this.model.isGraphVisible(this.area, i) || !this.isSecondary(this.area, i)) continue;
            if (c <= 0) {
                return this.getAxisValueProvider(this.yAxisModels[i]);
            }
            --c;
        }
        return this.getYAxisValueProvider(0);
    }
}

