/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed;

import com.sap.jvm.profiling.presentation.impl.typed.PlaceholderItemImpl;
import com.sap.jvm.profiling.viewer.tree.TreeModel;
import com.sap.jvm.profiling.viewer.tree.TreeModelItem;

public final class TreeModelFullForwardIterator {
    private TreeModelItem item;
    private final TreeModel model;

    public TreeModelFullForwardIterator(TreeModel model) {
        TreeModelItem[] roots = model.getRootItems();
        this.model = model;
        this.item = roots.length == 0 ? null : roots[0];
    }

    public boolean hasNext() {
        return this.item != null;
    }

    public TreeModelItem next() {
        assert (this.model.isValid(this.item));
        TreeModelItem result = this.item;
        do {
            this.advance();
        } while (this.item != null && this.item instanceof PlaceholderItemImpl);
        return result;
    }

    private void advance() {
        TreeModelItem[] children = this.item.getChildren();
        if (children.length > 0) {
            this.item = children[0];
            return;
        }
        TreeModelItem[] subItems = this.item.getSubItems();
        if (subItems.length > 0) {
            this.item = subItems[0];
            return;
        }
        while (this.item != null) {
            TreeModelItem[] items = this.item.getSiblings(this.model);
            if (this.item.getIndex() + 1 < items.length) {
                this.item = items[this.item.getIndex() + 1];
                return;
            }
            if (!this.item.isSubItem() && this.item.getParent() != null && (subItems = this.item.getParent().getSubItems()).length > 0) {
                this.item = subItems[0];
                return;
            }
            this.item = this.item.getParent();
        }
    }
}

