/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed;

import com.sap.jvm.profiling.viewer.tree.PlaceholderItem;
import com.sap.jvm.profiling.viewer.tree.TreeModel;
import com.sap.jvm.profiling.viewer.tree.TreeModelItem;

public abstract class TreeModelItemImpl
implements TreeModelItem {
    private static final int IS_EXPANDED = 1;
    private static final int SHOWS_SUB_ITEMS = 2;
    private static final int IS_SELECTED = 4;
    static final int HAS_CHILDREN = 8;
    static final int HAS_SUB_ITEMS = 16;
    static final int IS_NORMAL_ITEM = 32;
    static final int IS_PLACEHOLDER_ITEM = 64;
    static final int IS_OTHER_CHILDREN_ITEM = 128;
    static final int IS_SKIPPED_CHILDREN_ITEM = 256;
    static final int IS_SUB_ITEM = 512;
    private static final TreeModelItemImpl[] NO_ITEMS = new TreeModelItemImpl[0];
    private TreeModelItemImpl parent;
    private int index;
    private int state;
    private TreeModelItemImpl[] children;
    private TreeModelItemImpl[] subItems;

    TreeModelItemImpl(TreeModelItemImpl parent, int index, int state) {
        this.parent = parent;
        this.index = index;
        this.state = state;
        this.children = NO_ITEMS;
        this.subItems = NO_ITEMS;
    }

    @Override
    public final TreeModelItemImpl getParent() {
        return this.parent;
    }

    public final void setParent(TreeModelItemImpl parent) {
        this.parent = parent;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    final void setIndex(int index) {
        this.index = index;
    }

    @Override
    public final boolean hasChildren() {
        return (this.state & 8) != 0;
    }

    public final TreeModelItemImpl[] getChildren() {
        return this.children;
    }

    final void setChildren(TreeModelItemImpl[] children) {
        this.children = children;
    }

    @Override
    public final boolean hasSubItems() {
        return (this.state & 0x10) != 0;
    }

    public final TreeModelItemImpl[] getSubItems() {
        return this.subItems;
    }

    final void setSubItems(TreeModelItemImpl[] subItems) {
        this.subItems = subItems;
    }

    public final TreeModelItemImpl[] getSubsOrChildren() {
        if (this.showsSubItems()) {
            return this.subItems;
        }
        return this.children;
    }

    final void setSubsOrChildren(TreeModelItemImpl[] items) {
        if (this.showsSubItems()) {
            this.setSubItems(items);
        } else {
            this.setChildren(items);
        }
    }

    final boolean hasSubsOrChildren() {
        if (this.showsSubItems()) {
            return this.hasSubItems();
        }
        return this.hasChildren();
    }

    public final TreeModelItemImpl[] getSiblings(TreeModel model) {
        if (this.parent == null) {
            return (TreeModelItemImpl[])model.getRootItems();
        }
        if (this.isSubItem()) {
            return this.parent.subItems;
        }
        return this.parent.getChildren();
    }

    @Override
    public final boolean isSubItem() {
        return (this.state & 0x200) != 0;
    }

    @Override
    public final boolean showsSubItems() {
        return (this.state & 2) != 0;
    }

    final void setShowsSubItems(boolean showsSubItems) {
        this.state = showsSubItems ? (this.state |= 2) : (this.state &= 0xFFFFFFFD);
    }

    @Override
    public final boolean isExpanded() {
        return (this.state & 1) != 0;
    }

    public final void setExpanded(boolean expanded) {
        this.state = expanded ? (this.state |= 1) : (this.state &= 0xFFFFFFFE);
    }

    @Override
    public final boolean isExpandable() {
        return this.hasSubsOrChildren();
    }

    final void inhibitExpand() {
        if (this.showsSubItems()) {
            this.state &= 0xFFFFFFEF;
            this.subItems = NO_ITEMS;
        } else {
            this.state &= 0xFFFFFFF7;
            this.children = NO_ITEMS;
        }
    }

    @Override
    public final boolean isSelected() {
        return (this.state & 4) != 0;
    }

    public final void setSelected(boolean selected) {
        this.state = selected ? (this.state |= 4) : (this.state &= 0xFFFFFFFB);
    }

    @Override
    public final boolean isNormalItem() {
        return (this.state & 0x20) != 0;
    }

    @Override
    public final boolean isMultiItem() {
        return (this.state & 0x180) != 0;
    }

    @Override
    public final boolean isPlaceholderItem() {
        return (this.state & 0x40) != 0;
    }

    @Override
    public final boolean isOtherChildrenItem() {
        return (this.state & 0x80) != 0;
    }

    @Override
    public final boolean isSkippedChildrenItem() {
        return (this.state & 0x100) != 0;
    }

    public abstract boolean containsNode(Object var1);

    public abstract TreeModelItemImpl copy(TreeModelItemImpl var1);

    protected void copyState(TreeModelItemImpl copy) {
        TreeModelItemImpl[] oldSubItems;
        copy.setExpanded(this.isExpanded());
        copy.setSelected(this.isSelected());
        copy.setShowsSubItems(this.showsSubItems());
        TreeModelItemImpl[] oldChildren = this.getChildren();
        if (this.hasChildren() && oldChildren.length > 0 && !(oldChildren[0] instanceof PlaceholderItem)) {
            TreeModelItemImpl[] newChildren = new TreeModelItemImpl[oldChildren.length];
            for (int i = 0; i < newChildren.length; ++i) {
                newChildren[i] = oldChildren[i].copy(copy);
            }
            copy.setChildren(newChildren);
        }
        if ((oldSubItems = this.getSubItems()) != null && oldSubItems.length > 0 && !(oldSubItems[0] instanceof PlaceholderItem)) {
            TreeModelItemImpl[] newSubItems = new TreeModelItemImpl[oldSubItems.length];
            for (int i = 0; i < newSubItems.length; ++i) {
                newSubItems[i] = oldSubItems[i].copy(copy);
            }
            copy.setSubItems(newSubItems);
        }
    }
}

