/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed;

import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.EntryRenderer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.table.TableColumnResizer;
import com.sap.jvm.profiling.viewer.tree.TreeColumnResizer;

public final class TypedColumnResizerImpl
implements TreeColumnResizer,
TableColumnResizer {
    private final int[] minTypeWidths;
    private final int[] maxTypeWidths;
    private final EntryRenderer[] renderers;
    private boolean isReady;
    private final EntryContext context;
    private final ColumnContext[] columnContexts;

    public TypedColumnResizerImpl(EntryRenderer[] renderers, EntryContext context, ColumnContext[] columnContexts) {
        this.renderers = renderers;
        this.minTypeWidths = new int[renderers.length];
        this.maxTypeWidths = new int[renderers.length];
        this.context = context;
        this.columnContexts = columnContexts;
    }

    @Override
    public void setMinTypeWidths(int[] minTypeWidths) {
        System.arraycopy(minTypeWidths, 0, this.minTypeWidths, 0, minTypeWidths.length);
    }

    @Override
    public void setMaxTypeWidths(int[] maxTypeWidths) {
        System.arraycopy(maxTypeWidths, 0, this.maxTypeWidths, 0, maxTypeWidths.length);
    }

    private boolean ensureReady(RendererInfo rendererInfo) {
        if (this.isReady) {
            return true;
        }
        for (int i = 0; i < this.renderers.length; ++i) {
            if (this.renderers[i] != null) {
                if (this.minTypeWidths[i] == 0) {
                    this.minTypeWidths[i] = rendererInfo.getWidth(this.renderers[i].getMinimumVersion(rendererInfo, this.context, this.columnContexts[i]));
                }
                if (this.maxTypeWidths[i] != 0) continue;
                this.maxTypeWidths[i] = rendererInfo.getWidth(this.renderers[i].getMaximumVersion(rendererInfo, this.context, this.columnContexts[i]));
                continue;
            }
            assert (false);
            return false;
        }
        this.isReady = true;
        return true;
    }

    @Override
    public int resizeFirstColumnAfterExpand(int firstColunmOffset, int columnWidth, int minFirstColumnWidth, RendererInfo rendererInfo) {
        if (!this.ensureReady(rendererInfo)) {
            return columnWidth;
        }
        if (columnWidth - firstColunmOffset < Math.max(this.minTypeWidths[0], minFirstColumnWidth)) {
            return Math.max(this.minTypeWidths[0], minFirstColumnWidth) + firstColunmOffset;
        }
        return columnWidth;
    }

    @Override
    public int[] getInitialSizes(int availableWidth, int[] columnWidths, int[] minColumnWidths, boolean[] visible, RendererInfo rendererInfo) {
        return this.getInitialSizes(availableWidth, 0, columnWidths, minColumnWidths, visible, rendererInfo);
    }

    @Override
    public int[] getInitialSizes(int availableWidth, int maxFirstColumnOffset, int[] columnWidths, int[] minColumnWidths, boolean[] visible, RendererInfo rendererInfo) {
        this.ensureReady(rendererInfo);
        int offset = maxFirstColumnOffset;
        int[] result = new int[this.renderers.length];
        int initialWidth = 0;
        for (int i = 0; i < visible.length; ++i) {
            result[i] = Math.max(columnWidths[i], Math.max(this.minTypeWidths[i] + offset, minColumnWidths[i]));
            offset = 0;
            if (!visible[i]) continue;
            initialWidth += result[i];
        }
        return this.resizeAfterWidthChange(availableWidth, availableWidth - initialWidth, result, minColumnWidths, visible, rendererInfo);
    }

    @Override
    public int[] resizeAfterColumnChange(int availableWidth, int[] columnWidths, int[] minColumnWidths, boolean[] visible, RendererInfo rendererInfo) {
        return this.resizeAfterColumnChange(availableWidth, 0, columnWidths, minColumnWidths, visible, rendererInfo);
    }

    @Override
    public int[] resizeAfterColumnChange(int availableWidth, int maxFirstColumnOffset, int[] columnWidths, int[] minColumnWidths, boolean[] visible, RendererInfo rendererInfo) {
        this.ensureReady(rendererInfo);
        int offset = maxFirstColumnOffset;
        int[] result = new int[this.renderers.length];
        int[] maxExpansion = new int[result.length];
        int initialWidth = 0;
        int toMaxExpand = 0;
        for (int i = 0; i < visible.length; ++i) {
            int max = 0;
            if (columnWidths[i] <= 1) {
                result[i] = Math.max(this.minTypeWidths[i] + offset, minColumnWidths[i]);
                max = Math.max(result[i], Math.max(this.maxTypeWidths[i] + offset, minColumnWidths[i]));
            } else {
                result[i] = columnWidths[i];
            }
            offset = 0;
            if (!visible[i]) continue;
            initialWidth += result[i];
            maxExpansion[i] = Math.max(max - result[i], 0);
            toMaxExpand += maxExpansion[i];
        }
        int widthDiff = availableWidth - initialWidth;
        if (widthDiff <= 0) {
            return result;
        }
        if (toMaxExpand <= widthDiff) {
            for (int i = 0; i < result.length; ++i) {
                int n = i;
                result[n] = result[n] + maxExpansion[i];
            }
            return result;
        }
        double factor = (double)widthDiff / (double)toMaxExpand;
        for (int i = 0; i < columnWidths.length; ++i) {
            int n = i;
            result[n] = result[n] + (int)((double)maxExpansion[i] * factor);
        }
        return result;
    }

    @Override
    public int[] resizeAfterWidthChange(int availableWidth, int widthDiff, int[] columnWidths, int[] minColumnWidths, boolean[] visible, RendererInfo rendererInfo) {
        return this.resizeAfterWidthChange(availableWidth, widthDiff, 0, columnWidths, minColumnWidths, visible, rendererInfo);
    }

    @Override
    public int[] resizeAfterWidthChange(int availableWidth, int widthDiff, int maxFirstColumnOffset, int[] columnWidths, int[] minColumnWidths, boolean[] visible, RendererInfo rendererInfo) {
        int i;
        this.ensureReady(rendererInfo);
        int[] result = (int[])columnWidths.clone();
        int overallWidth = 0;
        for (int i2 = 0; i2 < result.length; ++i2) {
            if (!visible[i2]) continue;
            overallWidth += result[i2];
        }
        if (widthDiff < 0) {
            int i3;
            if (overallWidth < availableWidth) {
                return result;
            }
            int[] maxShrink = new int[result.length];
            int offset = maxFirstColumnOffset;
            int toMaxShrink = 0;
            for (i3 = 0; i3 < result.length; ++i3) {
                int min = Math.max(this.minTypeWidths[i3] + offset, minColumnWidths[i3]);
                offset = 0;
                maxShrink[i3] = Math.max(result[i3] - min, 0);
                if (!visible[i3]) continue;
                toMaxShrink += maxShrink[i3];
            }
            if (toMaxShrink <= -widthDiff) {
                for (i3 = 0; i3 < result.length; ++i3) {
                    int n = i3;
                    result[n] = result[n] - maxShrink[i3];
                }
                return result;
            }
            double factor = (double)(-widthDiff) / (double)toMaxShrink;
            for (int i4 = 0; i4 < columnWidths.length; ++i4) {
                int n = i4;
                result[n] = result[n] - (int)((double)maxShrink[i4] * factor);
            }
            return result;
        }
        if (overallWidth > availableWidth) {
            return result;
        }
        int[] maxExpansion = new int[result.length];
        int offset = maxFirstColumnOffset;
        int toMaxExpand = 0;
        for (i = 0; i < result.length; ++i) {
            int max = Math.max(result[i], Math.max(this.maxTypeWidths[i] + offset, minColumnWidths[i]));
            offset = 0;
            maxExpansion[i] = Math.max(max - result[i], 0);
            if (!visible[i]) continue;
            toMaxExpand += maxExpansion[i];
        }
        if (toMaxExpand <= widthDiff) {
            for (i = 0; i < result.length; ++i) {
                int n = i;
                result[n] = result[n] + maxExpansion[i];
            }
            return result;
        }
        double factor = (double)widthDiff / (double)toMaxExpand;
        for (int i5 = 0; i5 < columnWidths.length; ++i5) {
            int n = i5;
            result[n] = result[n] + (int)((double)maxExpansion[i5] * factor);
        }
        return result;
    }
}

