/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed;

import com.sap.jvm.profiling.presentation.impl.typed.renderer.ArrayLengthRangeRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.BasicSampleDistributionRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.BooleanTypeRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.CalledJRubyOfJavaMethodRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.CalledMethodRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.CallingMethodRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.DeadlockCycleEntryRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.DetailedSampleDistributionRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.FileDescriptorRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.GcCauseEntryRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.GcG1CollectionSetEntryRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.GcG1YoungListTargetSelReasonEntryRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.GcTypeEntryRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.InterpretedFractionRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.LoadAverageRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.MemoryUsageBeforeAndAfterRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.MixedProviderEntryRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.MonitorObjectEntryRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalArrayLengthRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalClassLoaderRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalClassRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalClassTypeRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalFileIdRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalFileNameRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalFilterEntityRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalFilterEntryRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalGcEventIdRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalGcIdRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalMethodAndReceiverRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalMethodInvocationIdRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalMethodRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalMonitorIdRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalNetworkAddressRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalNetworkConnectionTypeRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalNetworkEndpointTypeRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalNetworkLatencyIdRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalNetworkPortRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalPackagePartRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalPackageRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalParameterSpecRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalParameterValueRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalReentrantLockIdRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalSocketIdRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalStringRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalSynchronizationEventIdRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalThreadAnnotationRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalThreadDumpAlertTypeRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalThreadDumpLinkRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalThreadIdRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalThreadNameRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NrOfBytesByAgeRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NrOfObjectsByAgeRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NrOfObjectsMaxRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.ProgressRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.SocketObjectEntryRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.StackFrameEntryRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.ThreadDumpCPUGrowthRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.ThreadDumpNrOfBytesRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.ThreadDumpThreadStatesRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.ThreadStatusEntryRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.TimestampRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.axis.DurationAxisModel;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.axis.PercentageAxisModel;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.axis.TimeStampAxisModel;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.quantity.BaseQuantityRendererSpec;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.quantity.DurationRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.quantity.ElapsedTimeRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.quantity.MemoryUsageRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.quantity.SpecBasedRenderer;
import com.sap.jvm.profiling.presentation.typed.AxisModel;
import com.sap.jvm.profiling.presentation.typed.EntryRenderer;
import com.sap.jvm.profiling.presentation.typed.QuantityRenderer;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.presentation.typed.RendererThemeSpec;
import com.sap.jvm.profiling.presentation.typed.TypedModelRenderer;
import com.sap.jvm.profiling.presentation.typed.entries.ArrayLengthRange;
import com.sap.jvm.profiling.presentation.typed.entries.ArrayLengthRangePers;
import com.sap.jvm.profiling.presentation.typed.entries.BaseQuantity;
import com.sap.jvm.profiling.presentation.typed.entries.BasicTimeDistributionEntry;
import com.sap.jvm.profiling.presentation.typed.entries.BasicTimeDistributionEntryDiff;
import com.sap.jvm.profiling.presentation.typed.entries.BooleanType;
import com.sap.jvm.profiling.presentation.typed.entries.CalledJRubyOrJavaMethod;
import com.sap.jvm.profiling.presentation.typed.entries.CalledMethod;
import com.sap.jvm.profiling.presentation.typed.entries.CallingMethod;
import com.sap.jvm.profiling.presentation.typed.entries.DeadlockCycleEntry;
import com.sap.jvm.profiling.presentation.typed.entries.DetailedTimeDistributionEntry;
import com.sap.jvm.profiling.presentation.typed.entries.DetailedTimeDistributionEntryDiff;
import com.sap.jvm.profiling.presentation.typed.entries.Duration;
import com.sap.jvm.profiling.presentation.typed.entries.ElapsedTime;
import com.sap.jvm.profiling.presentation.typed.entries.FileDescriptor;
import com.sap.jvm.profiling.presentation.typed.entries.GcCauseEntry;
import com.sap.jvm.profiling.presentation.typed.entries.GcG1CollectionSetEntry;
import com.sap.jvm.profiling.presentation.typed.entries.GcG1YoungListTargetSelReasonEntry;
import com.sap.jvm.profiling.presentation.typed.entries.GcTypeEntry;
import com.sap.jvm.profiling.presentation.typed.entries.InterpretedFraction;
import com.sap.jvm.profiling.presentation.typed.entries.LoadAverage;
import com.sap.jvm.profiling.presentation.typed.entries.MemoryUsage;
import com.sap.jvm.profiling.presentation.typed.entries.MemoryUsageBeforeAndAfter;
import com.sap.jvm.profiling.presentation.typed.entries.MemoryUsageDiff;
import com.sap.jvm.profiling.presentation.typed.entries.MixedProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.MonitorObjectEntry;
import com.sap.jvm.profiling.presentation.typed.entries.NormalArrayLength;
import com.sap.jvm.profiling.presentation.typed.entries.NormalArrayLengthPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClass;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassLoader;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassLoaderPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassType;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFileId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFileIdPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFileName;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFilterEntity;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFilterEntityPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFilterEntry;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFilterEntryPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalGcEventId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalGcId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMethod;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMethodAndReceiver;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMethodInvocationId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMethodInvocationIdPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMethodPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMonitorId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMonitorIdPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkAddress;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkAddressPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkConnectionType;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkConnectionTypePers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkEndpointType;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkEndpointTypePers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkLatencyId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkLatencyIdPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkPort;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkPortPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalPackage;
import com.sap.jvm.profiling.presentation.typed.entries.NormalPackagePart;
import com.sap.jvm.profiling.presentation.typed.entries.NormalPackagePartPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalPackagePers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalParameterSpec;
import com.sap.jvm.profiling.presentation.typed.entries.NormalParameterSpecPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalParameterValue;
import com.sap.jvm.profiling.presentation.typed.entries.NormalParameterValuePers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalReentrantLockId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalReentrantLockIdPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalSocketId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalSocketIdPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalString;
import com.sap.jvm.profiling.presentation.typed.entries.NormalStringPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalSynchronizationEventId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalSynchronizationEventIdPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadAnnotation;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadAnnotationPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadDumpAlertType;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadDumpLink;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadIdPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadName;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytesByAge;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfObjectsByAge;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfObjectsMax;
import com.sap.jvm.profiling.presentation.typed.entries.Progress;
import com.sap.jvm.profiling.presentation.typed.entries.SocketObjectEntry;
import com.sap.jvm.profiling.presentation.typed.entries.StackFrameEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ThreadDumpCPUGrowth;
import com.sap.jvm.profiling.presentation.typed.entries.ThreadDumpNrOfBytes;
import com.sap.jvm.profiling.presentation.typed.entries.ThreadDumpThreadStates;
import com.sap.jvm.profiling.presentation.typed.entries.ThreadStatusEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Timestamp;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public final class TypedModelRendererImpl
implements TypedModelRenderer {
    private static final HashMap<RendererThemeSpec, RendererThemeImpl> themes = new HashMap();
    private final RendererThemeImpl theme;
    private final ModelViewer viewer;
    private final HashMap<Class<?>, EntryRenderer> renderers;
    private final HashMap<Class<?>, AxisModel> axisModels;
    private static final HashMap<Class<?>, Constructor<?>> ctorsForTypes = new HashMap();
    private static final HashMap<Class<?>, Class<?>> typeToRendererMapping = new HashMap();
    private static final HashMap<Class<?>, BaseQuantityRendererSpec> typeToSpecMapping = new HashMap();

    public TypedModelRendererImpl() {
        this.theme = null;
        this.viewer = null;
        this.renderers = null;
        this.axisModels = null;
    }

    public TypedModelRendererImpl(RendererThemeImpl theme) {
        this.theme = theme;
        this.viewer = null;
        this.renderers = null;
        this.axisModels = null;
    }

    private TypedModelRendererImpl(TypedModelRendererImpl base, ModelViewer viewer) {
        this.viewer = viewer;
        this.theme = base.theme;
        this.renderers = new HashMap();
        this.axisModels = new HashMap();
        this.addRenderers();
    }

    private TypedModelRendererImpl(TypedModelRendererImpl base, ModelViewer viewer, Class<?> entryClass) {
        this.viewer = viewer;
        this.theme = base.theme;
        this.renderers = new HashMap();
        this.axisModels = new HashMap();
        if (typeToRendererMapping.containsKey(entryClass)) {
            this.addRenderer(entryClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRenderers() {
        for (Class<?> entryClass : typeToRendererMapping.keySet()) {
            this.addRenderer(entryClass);
        }
        Class<TypedModelRendererImpl> clazz = TypedModelRendererImpl.class;
        synchronized (TypedModelRendererImpl.class) {
            HashMap typeToSpecMappingCopy = new HashMap(typeToSpecMapping);
            // ** MonitorExit[clazz] (shouldn't be in output)
            for (Map.Entry entry : typeToSpecMappingCopy.entrySet()) {
                SpecBasedRenderer renderer = new SpecBasedRenderer(this.viewer, this.theme, (BaseQuantityRendererSpec)entry.getValue());
                this.renderers.put((Class<?>)entry.getKey(), renderer);
                this.axisModels.put((Class<?>)entry.getKey(), renderer.getAxisModel());
            }
            this.renderers.put(MixedProviderEntry.class, new MixedProviderEntryRenderer(this.viewer, this.theme, this));
            this.axisModels.put(PercentageAxisModel.class, new PercentageAxisModel());
            this.axisModels.put(DurationAxisModel.class, new DurationAxisModel());
            this.axisModels.put(TimeStampAxisModel.class, new TimeStampAxisModel());
            return;
        }
    }

    private static void addRendererMapping(Class<?> type, Class<? extends EntryRenderer> rendererClass) {
        typeToRendererMapping.put(type, rendererClass);
        try {
            Constructor<? extends EntryRenderer> ctor = rendererClass.getDeclaredConstructor(ModelViewer.class, RendererThemeImpl.class);
            ctorsForTypes.put(rendererClass, ctor);
        }
        catch (NoSuchMethodException | SecurityException e) {
            Trace.error((Throwable)e, (String)"Could not get constructor");
        }
    }

    private static void addRendererMapping(Class<? extends BaseQuantity<?>> type) {
        try {
            Field f = type.getDeclaredField("SPEC");
            BaseQuantityRendererSpec spec = (BaseQuantityRendererSpec)f.get(null);
            assert (!typeToSpecMapping.containsKey(type));
            typeToSpecMapping.put(type, spec);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            Trace.error((Throwable)e, (String)"Could not get field");
        }
    }

    private void addRenderer(Class<?> entryClass) {
        Class<?> rendererClass = typeToRendererMapping.get(entryClass);
        Constructor<?> ctor = ctorsForTypes.get(rendererClass);
        try {
            EntryRenderer renderer = (EntryRenderer)ctor.newInstance(this.viewer, this.theme);
            this.renderers.put(entryClass, renderer);
            if (renderer instanceof QuantityRenderer) {
                QuantityRenderer quantityRenderer = (QuantityRenderer)((Object)renderer);
                this.axisModels.put(entryClass, quantityRenderer.getAxisModel());
            }
        }
        catch (IllegalArgumentException e) {
            Trace.error((Throwable)e, (String)"Could not invoke constructor");
        }
        catch (InstantiationException e) {
            Trace.error((Throwable)e, (String)"Could not invoke constructor");
        }
        catch (IllegalAccessException e) {
            Trace.error((Throwable)e, (String)"Could not invoke constructor");
        }
        catch (InvocationTargetException e) {
            Trace.error((Throwable)e, (String)"Could not invoke constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized EntryRenderer getRenderer(Class<?> entryType) {
        if (entryType == null) {
            return null;
        }
        EntryRenderer renderer = this.renderers.get(entryType);
        if (renderer != null) {
            return renderer;
        }
        if (!BaseQuantity.class.isAssignableFrom(entryType)) return this.renderers.get(entryType);
        Class<TypedModelRendererImpl> clazz = TypedModelRendererImpl.class;
        synchronized (TypedModelRendererImpl.class) {
            if (!typeToSpecMapping.containsKey(entryType)) {
                TypedModelRendererImpl.addRendererMapping(entryType);
            }
            BaseQuantityRendererSpec spec = typeToSpecMapping.get(entryType);
            SpecBasedRenderer specRenderer = new SpecBasedRenderer(this.viewer, this.theme, spec);
            this.renderers.put(entryType, specRenderer);
            this.axisModels.put(entryType, specRenderer.getAxisModel());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.renderers.get(entryType);
        }
    }

    @Override
    public RendererNode getRendererForPlaceholder(String text) {
        return this.viewer.newTextNode(text);
    }

    @Override
    public ModelViewer getModelViewer() {
        return this.viewer;
    }

    @Override
    public RendererThemeSpec getThemeSpec() {
        return this.theme.getSpec();
    }

    public int getAdditionalLeading() {
        return this.theme.getAdditionalLeading();
    }

    public int getAdditionalAscent() {
        return this.theme.getAdditionalAscent();
    }

    public int getAdditionalDescent() {
        return this.theme.getAdditionalDescent();
    }

    public synchronized void dispose() {
        for (EntryRenderer renderer : this.renderers.values()) {
            renderer.dispose();
        }
    }

    private RendererThemeImpl getTheme(RendererThemeSpec spec) {
        assert (spec != null);
        RendererThemeImpl rendererTheme = themes.get(spec);
        if (rendererTheme == null) {
            try {
                rendererTheme = new RendererThemeImpl(spec);
                themes.put(spec, rendererTheme);
            }
            catch (IOException e) {
                Trace.warn((Throwable)e, (String)"Could not load theme");
            }
        }
        return rendererTheme;
    }

    public synchronized TypedModelRendererImpl getForViewer(ModelViewer modelViewer, RendererThemeSpec spec) {
        RendererThemeImpl rendererTheme = this.getTheme(spec);
        if (rendererTheme == null) {
            return new TypedModelRendererImpl(this, modelViewer);
        }
        return new TypedModelRendererImpl(new TypedModelRendererImpl(rendererTheme), modelViewer);
    }

    public synchronized TypedModelRendererImpl getForViewer(ModelViewer modelViewer, RendererThemeSpec spec, Class<?> entryType) {
        RendererThemeImpl rendererTheme = this.getTheme(spec);
        if (rendererTheme == null) {
            return new TypedModelRendererImpl(this, modelViewer, entryType);
        }
        return new TypedModelRendererImpl(new TypedModelRendererImpl(rendererTheme), modelViewer, entryType);
    }

    @Override
    public RendererTheme getTheme() {
        return this.theme;
    }

    @Override
    public AxisModel getAxisModel(Class<?> entryType) {
        EntryRenderer renderer;
        AxisModel result = this.axisModels.get(entryType);
        if (result == null && (renderer = this.getRenderer(entryType)) instanceof QuantityRenderer) {
            result = ((QuantityRenderer)((Object)renderer)).getAxisModel();
        }
        return result;
    }

    static {
        TypedModelRendererImpl.addRendererMapping(NormalClassLoader.class, NormalClassLoaderRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalClassLoaderPers.class, NormalClassLoaderRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalClass.class, NormalClassRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalClassPers.class, NormalClassRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalClassType.class, NormalClassTypeRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalFilterEntry.class, NormalFilterEntryRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalFilterEntryPers.class, NormalFilterEntryRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalFilterEntity.class, NormalFilterEntityRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalFilterEntityPers.class, NormalFilterEntityRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalMethod.class, NormalMethodRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalMethodAndReceiver.class, NormalMethodAndReceiverRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalMethodPers.class, NormalMethodRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalPackage.class, NormalPackageRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalPackagePers.class, NormalPackageRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalPackagePart.class, NormalPackagePartRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalPackagePartPers.class, NormalPackagePartRenderer.class);
        TypedModelRendererImpl.addRendererMapping(CalledMethod.class, CalledMethodRenderer.class);
        TypedModelRendererImpl.addRendererMapping(ElapsedTime.class, ElapsedTimeRenderer.class);
        TypedModelRendererImpl.addRendererMapping(CallingMethod.class, CallingMethodRenderer.class);
        TypedModelRendererImpl.addRendererMapping(MemoryUsage.class, MemoryUsageRenderer.class);
        TypedModelRendererImpl.addRendererMapping(MemoryUsageDiff.class, MemoryUsageRenderer.class);
        TypedModelRendererImpl.addRendererMapping(MemoryUsageBeforeAndAfter.class, MemoryUsageBeforeAndAfterRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NrOfBytesByAge.class, NrOfBytesByAgeRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NrOfObjectsByAge.class, NrOfObjectsByAgeRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalParameterSpec.class, NormalParameterSpecRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalParameterSpecPers.class, NormalParameterSpecRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalThreadAnnotation.class, NormalThreadAnnotationRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalThreadAnnotationPers.class, NormalThreadAnnotationRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalThreadId.class, NormalThreadIdRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalThreadIdPers.class, NormalThreadIdRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalThreadName.class, NormalThreadNameRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalFileName.class, NormalFileNameRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalArrayLength.class, NormalArrayLengthRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalArrayLengthPers.class, NormalArrayLengthRenderer.class);
        TypedModelRendererImpl.addRendererMapping(Duration.class, DurationRenderer.class);
        TypedModelRendererImpl.addRendererMapping(BasicTimeDistributionEntry.class, BasicSampleDistributionRenderer.class);
        TypedModelRendererImpl.addRendererMapping(BasicTimeDistributionEntryDiff.class, BasicSampleDistributionRenderer.class);
        TypedModelRendererImpl.addRendererMapping(DetailedTimeDistributionEntry.class, DetailedSampleDistributionRenderer.class);
        TypedModelRendererImpl.addRendererMapping(DetailedTimeDistributionEntryDiff.class, DetailedSampleDistributionRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalMonitorId.class, NormalMonitorIdRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalMonitorIdPers.class, NormalMonitorIdRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalParameterValue.class, NormalParameterValueRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalParameterValuePers.class, NormalParameterValueRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalMethodInvocationId.class, NormalMethodInvocationIdRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalMethodInvocationIdPers.class, NormalMethodInvocationIdRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalReentrantLockId.class, NormalReentrantLockIdRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalReentrantLockIdPers.class, NormalReentrantLockIdRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalString.class, NormalStringRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalSynchronizationEventId.class, NormalSynchronizationEventIdRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalSynchronizationEventIdPers.class, NormalSynchronizationEventIdRenderer.class);
        TypedModelRendererImpl.addRendererMapping(BooleanType.class, BooleanTypeRenderer.class);
        TypedModelRendererImpl.addRendererMapping(Timestamp.class, TimestampRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalStringPers.class, NormalStringRenderer.class);
        TypedModelRendererImpl.addRendererMapping(ArrayLengthRange.class, ArrayLengthRangeRenderer.class);
        TypedModelRendererImpl.addRendererMapping(ArrayLengthRangePers.class, ArrayLengthRangeRenderer.class);
        TypedModelRendererImpl.addRendererMapping(FileDescriptor.class, FileDescriptorRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalFileId.class, NormalFileIdRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalFileIdPers.class, NormalFileIdRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalGcId.class, NormalGcIdRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalGcEventId.class, NormalGcEventIdRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalMonitorId.class, NormalMonitorIdRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalMonitorIdPers.class, NormalMonitorIdRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalSocketId.class, NormalSocketIdRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalSocketIdPers.class, NormalSocketIdRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalNetworkAddress.class, NormalNetworkAddressRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalNetworkAddressPers.class, NormalNetworkAddressRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalNetworkConnectionType.class, NormalNetworkConnectionTypeRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalNetworkConnectionTypePers.class, NormalNetworkConnectionTypeRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalNetworkEndpointType.class, NormalNetworkEndpointTypeRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalNetworkEndpointTypePers.class, NormalNetworkEndpointTypeRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalNetworkLatencyId.class, NormalNetworkLatencyIdRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalNetworkLatencyIdPers.class, NormalNetworkLatencyIdRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalNetworkPort.class, NormalNetworkPortRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalNetworkPortPers.class, NormalNetworkPortRenderer.class);
        TypedModelRendererImpl.addRendererMapping(GcCauseEntry.class, GcCauseEntryRenderer.class);
        TypedModelRendererImpl.addRendererMapping(GcTypeEntry.class, GcTypeEntryRenderer.class);
        TypedModelRendererImpl.addRendererMapping(CalledJRubyOrJavaMethod.class, CalledJRubyOfJavaMethodRenderer.class);
        TypedModelRendererImpl.addRendererMapping(ThreadStatusEntry.class, ThreadStatusEntryRenderer.class);
        TypedModelRendererImpl.addRendererMapping(DeadlockCycleEntry.class, DeadlockCycleEntryRenderer.class);
        TypedModelRendererImpl.addRendererMapping(MonitorObjectEntry.class, MonitorObjectEntryRenderer.class);
        TypedModelRendererImpl.addRendererMapping(SocketObjectEntry.class, SocketObjectEntryRenderer.class);
        TypedModelRendererImpl.addRendererMapping(StackFrameEntry.class, StackFrameEntryRenderer.class);
        TypedModelRendererImpl.addRendererMapping(LoadAverage.class, LoadAverageRenderer.class);
        TypedModelRendererImpl.addRendererMapping(InterpretedFraction.class, InterpretedFractionRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalThreadDumpAlertType.class, NormalThreadDumpAlertTypeRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NormalThreadDumpLink.class, NormalThreadDumpLinkRenderer.class);
        TypedModelRendererImpl.addRendererMapping(ThreadDumpThreadStates.class, ThreadDumpThreadStatesRenderer.class);
        TypedModelRendererImpl.addRendererMapping(ThreadDumpCPUGrowth.class, ThreadDumpCPUGrowthRenderer.class);
        TypedModelRendererImpl.addRendererMapping(ThreadDumpNrOfBytes.class, ThreadDumpNrOfBytesRenderer.class);
        TypedModelRendererImpl.addRendererMapping(NrOfObjectsMax.class, NrOfObjectsMaxRenderer.class);
        TypedModelRendererImpl.addRendererMapping(Progress.class, ProgressRenderer.class);
        TypedModelRendererImpl.addRendererMapping(GcG1YoungListTargetSelReasonEntry.class, GcG1YoungListTargetSelReasonEntryRenderer.class);
        TypedModelRendererImpl.addRendererMapping(GcG1CollectionSetEntry.class, GcG1CollectionSetEntryRenderer.class);
    }
}

