/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed;

import com.sap.jvm.profiling.presentation.impl.typed.TypedReportModelImpl;
import com.sap.jvm.profiling.presentation.typed.Elements;
import com.sap.jvm.profiling.presentation.typed.TypedReportProvider;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.Resource;
import com.sap.jvm.profiling.resource.ResourceHandler;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;

public class TypedReportModelCreator
implements ResourceHandler {
    public boolean canHandle(ResourceName name) {
        return name.endsWithType((ResourceNameElement)new Elements.CreateTypedReportModel());
    }

    public Resource create(ResourceName name, ProgressReporter reporter) throws IOException {
        assert (this.canHandle(name));
        ResourceName providerName = name.stripLastElement();
        ResourceManager manager = name.getResourceManager();
        Resource rawProvider = manager.get(providerName, reporter);
        if (rawProvider instanceof TypedReportProvider) {
            TypedReportProvider provider = (TypedReportProvider)rawProvider;
            TypedReportModelImpl model = new TypedReportModelImpl(provider, name);
            return model;
        }
        Trace.error((String)"Expected typed report provider but got %s for resource <%s>", (Object[])new Object[]{rawProvider.getClass().getName(), name.toString()});
        throw new IOException("Wrong type");
    }

    public Resource read(ResourceName name, ResourceReader reader, ProgressReporter reporter) throws IOException {
        ResourceName providerName = name.stripLastElement();
        ResourceManager manager = name.getResourceManager();
        TypedReportProvider provider = (TypedReportProvider)manager.get(providerName, reporter);
        TypedReportModelImpl model = new TypedReportModelImpl(provider, name);
        model.read(reader, reporter);
        return model;
    }

    public void write(ResourceName name, Resource resource, ResourceWriter writer, ProgressReporter reporter) throws IOException {
        TypedReportModelImpl model = (TypedReportModelImpl)resource;
        model.write(writer, reporter);
    }

    public long calculateWriteWork(ResourceName name, Resource resource) {
        TypedReportModelImpl model = (TypedReportModelImpl)resource;
        return model.calculateWriteWork();
    }
}

