/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed;

import com.sap.jvm.profiling.presentation.impl.typed.AbstractModelImpl;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.presentation.typed.RendererThemeSpec;
import com.sap.jvm.profiling.presentation.typed.TypedModelRenderer;
import com.sap.jvm.profiling.presentation.typed.TypedModelRendererFactory;
import com.sap.jvm.profiling.presentation.typed.TypedReportModel;
import com.sap.jvm.profiling.presentation.typed.TypedReportProvider;
import com.sap.jvm.profiling.resource.BasicResourceReader;
import com.sap.jvm.profiling.resource.BasicResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.ScreenModelViewer;
import com.sap.jvm.profiling.viewer.ScreenViewState;
import com.sap.jvm.profiling.viewer.report.ReportLinkHandler;
import com.sap.jvm.profiling.viewer.report.ReportLinkResolver;
import com.sap.jvm.profiling.viewer.report.ReportModel;
import com.sap.jvm.profiling.viewer.report.ReportModelListener;
import com.sap.jvm.profiling.viewer.report.ReportViewState;
import com.sap.jvm.tracing.Trace;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TypedReportModelImpl
extends AbstractModelImpl
implements TypedReportModel {
    private static final int VERSION = 1;
    private String title;
    private ModelViewer viewer;
    private final TypedReportProvider provider;
    private TypedModelRenderer renderer;
    private final ArrayList<ReportModelListener> listeners;
    private RendererThemeSpec themeSpec;
    private boolean initialized;
    private ScreenViewState initialState;
    private final Map<String, ResourceName> locationToNameMapping = new ConcurrentHashMap<String, ResourceName>();
    private final Map<String, ReportLinkResolver> linkResolvers = new HashMap<String, ReportLinkResolver>();
    private final Map<String, ReportLinkHandler> linkHandlers = new HashMap<String, ReportLinkHandler>();

    TypedReportModelImpl(TypedReportProvider provider, ResourceName name) {
        super(null, name);
        this.provider = provider;
        this.viewer = null;
        this.listeners = new ArrayList();
        this.themeSpec = null;
    }

    private TypedReportModelImpl(TypedReportProvider provider, ResourceName name, ModelViewer viewer, RendererThemeSpec themeSpec, Map<String, ResourceName> locationToName, ScreenViewState initialState) {
        super(viewer.getTaskManager(), name);
        this.provider = provider;
        this.viewer = viewer;
        this.renderer = TypedModelRendererFactory.get(viewer, themeSpec);
        this.listeners = new ArrayList();
        this.themeSpec = themeSpec;
        for (Map.Entry<String, ResourceName> entry : locationToName.entrySet()) {
            this.locationToNameMapping.put(entry.getKey(), entry.getValue());
        }
        this.initialState = initialState;
    }

    @Override
    public ModelViewer getViewer() {
        return this.viewer;
    }

    @Override
    public ReportModel copy(ModelViewer newViewer) {
        return new TypedReportModelImpl(this.provider, this.getResourceName(), newViewer, this.themeSpec, this.locationToNameMapping, this.initialState);
    }

    @Override
    public String getTitle() {
        return this.title != null ? this.title : this.provider.getTitle();
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getIconKey() {
        return this.provider.getIconKey();
    }

    @Override
    public TypedReportProvider getProvider() {
        return this.provider;
    }

    public boolean isModifiable() {
        return true;
    }

    public ResourceName[] getDependents() {
        return null;
    }

    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(1, 1);
        this.title = reader.readBoolean() ? reader.readString() : null;
        int locations = reader.readInt32();
        for (int i = 0; i < locations; ++i) {
            String location = reader.readString();
            ResourceName name = reader.readResourceName();
            this.locationToNameMapping.put(location, name);
        }
        if (reader.readBoolean()) {
            this.initialState = new ReportViewState((BasicResourceReader)reader, reporter);
        }
    }

    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        writer.writeBoolean(this.title != null);
        if (this.title != null) {
            writer.writeString(this.title);
        }
        writer.writeInt32(this.locationToNameMapping.size());
        for (Map.Entry<String, ResourceName> entry : this.locationToNameMapping.entrySet()) {
            writer.writeString(entry.getKey());
            entry.getValue().write(writer);
        }
        ScreenViewState state = this.initialState != null ? this.initialState : this.getState();
        writer.writeBoolean(state instanceof ReportViewState);
        if (state instanceof ReportViewState) {
            state.write((BasicResourceWriter)writer, reporter);
        }
    }

    public long calculateWriteWork() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ReportModelListener listener) {
        ArrayList<ReportModelListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(ReportModelListener listener) {
        ReportModelListener reportModelListener = listener;
        synchronized (reportModelListener) {
            return this.listeners.remove(listener);
        }
    }

    @Override
    public void setViewer(ModelViewer viewer, RendererThemeSpec spec) {
        this.viewer = viewer;
        this.setTaskManager(viewer.getTaskManager());
        this.renderer = TypedModelRendererFactory.get(viewer, spec);
        this.themeSpec = spec;
        this.provider.setTheme(spec);
    }

    @Override
    public void removeViewer() {
        this.initialState = this.getState();
        this.setTaskManager(null);
        this.viewer = null;
    }

    private ScreenViewState getState() {
        if (this.viewer instanceof ScreenModelViewer) {
            return ((ScreenModelViewer)this.viewer).getViewState();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureDataCreated(ProgressReporter reporter) throws IOException {
        TypedReportModelImpl typedReportModelImpl = this;
        synchronized (typedReportModelImpl) {
            if (this.initialized) {
                return;
            }
        }
        this.provider.createReportData(reporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createData() {
        boolean dataSetsCreated;
        TypedReportModelImpl typedReportModelImpl = this;
        synchronized (typedReportModelImpl) {
            dataSetsCreated = this.initialized;
        }
        if (dataSetsCreated) {
            this.notifyReportCreated(null);
            return;
        }
        this.runBackgroundTask(new Runnable(){

            @Override
            public void run() {
                final ProgressReporter reporter = TypedReportModelImpl.this.getRootCreationProgressReporter();
                IOException createException = null;
                try {
                    TypedReportModelImpl.this.ensureDataCreated(reporter);
                }
                catch (IOException e) {
                    Trace.error((Throwable)e, (String)"Could not create the report");
                    createException = e;
                }
                catch (Throwable t) {
                    Trace.error((Throwable)t, (String)"Could not create the report");
                    createException = new IOException("Could not create the report");
                    createException.initCause(t);
                }
                final IOException finalCreateException = createException;
                if (!TypedReportModelImpl.this.runForegroundTask(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (finalCreateException == null) {
                            TypedReportModelImpl typedReportModelImpl = TypedReportModelImpl.this;
                            synchronized (typedReportModelImpl) {
                                if (!TypedReportModelImpl.this.initialized) {
                                    TypedReportModelImpl.this.initialized = true;
                                }
                            }
                            TypedReportModelImpl.this.setupViewerImpl();
                        }
                        reporter.finish();
                        TypedReportModelImpl.this.notifyReportCreated(finalCreateException);
                    }
                })) {
                    reporter.finish();
                }
            }
        });
    }

    @Override
    public boolean dataCreated() {
        return this.initialized;
    }

    @Override
    public void changeTheme(RendererThemeSpec spec) {
        this.themeSpec = spec;
        this.provider.setTheme(spec);
    }

    @Override
    public RendererTheme getTheme() {
        if (this.renderer != null) {
            return this.renderer.getTheme();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ReportModelListener> getListenerCopy() {
        ArrayList<ReportModelListener> arrayList = this.listeners;
        synchronized (arrayList) {
            return new ArrayList<ReportModelListener>(this.listeners);
        }
    }

    private void notifyReportCreated(final IOException exception) {
        for (final ReportModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.dataCreated(TypedReportModelImpl.this, exception);
                }
            });
        }
    }

    private synchronized void setupViewerImpl() {
        if (this.initialState != null) {
            if (this.viewer instanceof ScreenModelViewer) {
                ((ScreenModelViewer)this.viewer).setViewState(this.initialState);
            }
            this.initialState = null;
        }
    }

    @Override
    public File getReportDataDirectory() {
        return this.provider.getReportDataDirectory();
    }

    @Override
    public void addLinkLocation(String location, ResourceName name) {
        assert (location != null);
        assert (name != null);
        this.locationToNameMapping.put(location, name);
    }

    @Override
    public void setLinkResolver(String location, ReportLinkResolver resolver) {
        assert (location != null);
        if (resolver == null) {
            this.linkResolvers.remove(location);
        } else {
            this.linkResolvers.put(location, resolver);
        }
    }

    @Override
    public void setLinkHandler(String location, ReportLinkHandler handler) {
        assert (location != null);
        if (handler == null) {
            this.linkHandlers.remove(location);
        } else {
            this.linkHandlers.put(location, handler);
        }
    }

    @Override
    public ResourceName getResourceNameForLink(String location, String options) {
        ReportLinkResolver resolver = this.linkResolvers.get(location);
        if (resolver != null) {
            return resolver.getResourceName(location, options);
        }
        return this.locationToNameMapping.get(location);
    }

    @Override
    public boolean handleLink(ReportLinkHandler.LinkVisualizer visualizer, String location, String options) {
        ReportLinkHandler handler = this.linkHandlers.get(location);
        if (handler != null) {
            return handler.handleLink(visualizer, location, options);
        }
        return false;
    }
}

