/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.AbstractSelectableColumnBasedModel;
import com.sap.jvm.profiling.presentation.impl.typed.SortHistory;
import com.sap.jvm.profiling.presentation.impl.typed.TypedColumnResizerImpl;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XmlModelViewer;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XmlTableExporter;
import com.sap.jvm.profiling.presentation.typed.ColumnBasedModel;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.EntryRenderer;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.presentation.typed.RendererThemeSpec;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.TypedModelRenderer;
import com.sap.jvm.profiling.presentation.typed.TypedModelRendererFactory;
import com.sap.jvm.profiling.presentation.typed.TypedTableModel;
import com.sap.jvm.profiling.presentation.typed.TypedTableProvider;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.SummarizedProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;
import com.sap.jvm.profiling.resource.BasicResourceReader;
import com.sap.jvm.profiling.resource.BasicResourceWriter;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.util.column.Column;
import com.sap.jvm.profiling.snapshot.util.column.SortableColumn;
import com.sap.jvm.profiling.snapshot.util.column.UniqueSortableColumn;
import com.sap.jvm.profiling.util.IntArrayList;
import com.sap.jvm.profiling.util.splitarray.SplitArray32;
import com.sap.jvm.profiling.viewer.ColumnViewState;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.ScreenModelViewer;
import com.sap.jvm.profiling.viewer.ScreenViewState;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.table.TableColumnResizer;
import com.sap.jvm.profiling.viewer.table.TableModelItemFilter;
import com.sap.jvm.profiling.viewer.table.TableModelListener;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.threads.RunWaiter;
import com.sap.jvm.util.threads.ThreadRunner;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public final class TypedTableModelImpl
extends AbstractSelectableColumnBasedModel
implements TypedTableModel {
    private static final int VERSION = 1;
    private int[] items;
    private int[] filteredItems;
    private int nrOfSelectedItems;
    private int[] selectionState;
    private Object filterLock = new Object();
    private final TypedTableProvider<?> provider;
    private TypedModelRenderer renderer;
    private final EntryRenderer[] entryRenderers;
    private final ArrayList<TableModelListener> listeners;
    private final ArrayList<TableModelItemFilter> filters;
    private SortHistory sortHistory;
    private String visibleSets;
    private boolean[] columnVisibility;
    private int[] columnsOrder;
    private InitialState initialState;
    private boolean defaultState;
    private ModelViewer viewer;
    private String title;
    private boolean allowMixedColumns;

    public TypedTableModelImpl(TypedTableProvider<?> provider, ResourceName name) {
        super(null, name, provider.getColumnSpec());
        TypedColumnSpec spec = provider.getColumnSpec();
        this.provider = provider;
        this.renderer = null;
        this.entryRenderers = new EntryRenderer[provider.getColumnSpec().getNrOfColumns()];
        this.items = null;
        this.filteredItems = null;
        this.viewer = null;
        this.listeners = new ArrayList();
        this.filters = new ArrayList();
        this.sortHistory = new SortHistory(spec.getNrOfColumns());
        this.columnVisibility = new boolean[spec.getNrOfColumns()];
        this.defaultState = true;
        this.setColumnVisibilityImpl(provider.getColumnSpec().getDefaultVisibleSets());
        this.setColumnOrderImpl(null);
        for (int i = 0; i < spec.getNrOfDefaultSorts(); ++i) {
            int column = spec.getDefaultSortColumn(i);
            this.sortHistory.notifySortPerformed(column, spec.getDefaultSortDirection(column));
        }
    }

    private TypedTableModelImpl(TypedTableProvider<?> provider, RendererThemeSpec themeSpec, int[] items, int[] selectionState, int nrOfSelectedItems, SortHistory sortHistory, ModelViewer viewer, InitialState initialState) {
        super(viewer.getTaskManager(), null, provider.getColumnSpec());
        this.provider = provider;
        this.renderer = TypedModelRendererFactory.get(viewer, themeSpec);
        this.entryRenderers = new EntryRenderer[provider.getColumnSpec().getNrOfColumns()];
        this.items = items;
        this.filteredItems = null;
        this.selectionState = selectionState;
        this.nrOfSelectedItems = nrOfSelectedItems;
        this.viewer = viewer;
        this.initialState = initialState;
        this.defaultState = initialState == null;
        this.listeners = new ArrayList();
        this.filters = new ArrayList();
        this.sortHistory = sortHistory;
        this.columnVisibility = new boolean[provider.getColumnSpec().getNrOfColumns()];
        this.setColumnVisibilityImpl(provider.getColumnSpec().getDefaultVisibleSets());
        this.setColumnOrderImpl(null);
        for (int i = 0; i < provider.getColumnSpec().getNrOfColumns(); ++i) {
            this.entryRenderers[i] = this.renderer.getRenderer(provider.getColumnSpec().getColumnType(i));
        }
    }

    @Override
    public ModelViewer getViewer() {
        return this.viewer;
    }

    private void notifyTableCreated(final IOException exception) {
        for (final TableModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.itemsCreated(TypedTableModelImpl.this, exception);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<TableModelListener> getListenerCopy() {
        ArrayList<TableModelListener> arrayList = this.listeners;
        synchronized (arrayList) {
            return new ArrayList<TableModelListener>(this.listeners);
        }
    }

    private void notifyTableChanged() {
        for (final TableModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.tableChanged(TypedTableModelImpl.this);
                }
            });
        }
    }

    private void notifyTableFiltered() {
        for (final TableModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.tableFiltered(TypedTableModelImpl.this);
                }
            });
        }
    }

    @Override
    public TypedTableModelImpl copy(ModelViewer newViewer) {
        TypedTableModelImpl result = new TypedTableModelImpl(this.provider, this.renderer.getThemeSpec(), this.items, (int[])this.selectionState.clone(), this.nrOfSelectedItems, this.sortHistory.copy(), newViewer, this.initialState);
        result.filters.addAll(this.filters);
        result.applyFilters();
        result.setColumnVisibilityImpl(this.getColumnVisibility());
        result.setColumnOrderImpl(this.getColumnOrder());
        return result;
    }

    @Override
    public void setAllowMixedColumns(boolean allowMixed) {
        this.allowMixedColumns = allowMixed;
    }

    @Override
    public void setViewer(ModelViewer viewer, RendererThemeSpec spec) {
        this.viewer = viewer;
        this.setTaskManager(viewer.getTaskManager());
        this.renderer = TypedModelRendererFactory.get(viewer, spec);
        for (int i = 0; i < this.provider.getColumnSpec().getNrOfColumns(); ++i) {
            this.entryRenderers[i] = this.renderer.getRenderer(this.provider.getColumnSpec().getColumnType(i));
        }
    }

    @Override
    public void removeViewer() {
        this.initialState = this.getState();
        this.defaultState = false;
        this.items = null;
        this.filteredItems = null;
        this.setTaskManager(null);
        this.viewer = null;
        for (int i = 0; i < this.entryRenderers.length; ++i) {
            this.entryRenderers[i] = null;
        }
    }

    @Override
    public void changeTheme(RendererThemeSpec spec) {
        if (this.viewer == null) {
            return;
        }
        this.renderer = TypedModelRendererFactory.get(this.viewer, spec);
        for (int i = 0; i < this.provider.getColumnSpec().getNrOfColumns(); ++i) {
            this.entryRenderers[i] = this.renderer.getRenderer(this.provider.getColumnSpec().getColumnType(i));
        }
    }

    @Override
    public RendererTheme getTheme() {
        if (this.renderer != null) {
            return this.renderer.getTheme();
        }
        return null;
    }

    @Override
    public TableColumnResizer getColumnResizer() {
        return new TypedColumnResizerImpl(this.entryRenderers, this.provider.getEntryContext(), this.provider.getColumnContexts());
    }

    @Override
    public String getColumnVisibility() {
        return this.visibleSets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProviderEntry[] getSelectedEntries(int column) {
        ArrayList<ProviderEntry> result = new ArrayList<ProviderEntry>();
        int[] itemsList = null;
        Object object = this.filterLock;
        synchronized (object) {
            itemsList = this.filteredItems == null ? this.items : this.filteredItems;
        }
        for (Object itemId : (Object)itemsList) {
            ProviderEntry entry;
            if (!this.isSelected((int)itemId) || (entry = this.provider.getEntry((int)itemId, column)) == null) continue;
            result.add(entry);
        }
        return result.toArray(new ProviderEntry[result.size()]);
    }

    @Override
    public TypedColumnSpec getSpec() {
        return this.provider.getColumnSpec();
    }

    @Override
    public void setColumnVisibility(String spec) {
        this.setColumnVisibilityImpl(spec);
        for (final TableModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.columnsChanged(TypedTableModelImpl.this);
                }
            });
        }
    }

    private void setColumnVisibilityImpl(String spec) {
        this.visibleSets = spec;
        this.columnVisibility = this.provider.getColumnSpec().getColumnVisibility(this.visibleSets);
    }

    @Override
    public void setColumnOrder(int[] order) {
        this.setColumnOrderImpl(order);
        for (final TableModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.columnsOrderChanged(TypedTableModelImpl.this);
                }
            });
        }
    }

    private void setColumnOrderImpl(int[] order) {
        int nrCols = this.provider.getColumnSpec().getNrOfColumns();
        if (this.columnsOrder == null) {
            this.columnsOrder = new int[nrCols];
        }
        assert (this.columnsOrder.length == nrCols);
        if (order == null) {
            for (int i = 0; i < nrCols; ++i) {
                this.columnsOrder[i] = i;
            }
            return;
        }
        assert (order.length <= nrCols);
        HashSet<Integer> ordered = new HashSet<Integer>();
        for (int i = 0; i < order.length; ++i) {
            int column = order[i];
            assert (column < nrCols);
            this.columnsOrder[i] = column;
            ordered.add(column);
        }
        int idx = order.length;
        for (int i = 0; i < nrCols; ++i) {
            if (ordered.contains(i)) continue;
            this.columnsOrder[idx] = i;
            ++idx;
        }
    }

    @Override
    public int[] getColumnOrder() {
        return (int[])this.columnsOrder.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(TableModelListener listener) {
        ArrayList<TableModelListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureItemsCreated(ProgressReporter reporter) throws IOException {
        TypedTableModelImpl typedTableModelImpl = this;
        synchronized (typedTableModelImpl) {
            if (this.items != null) {
                return;
            }
        }
        this.provider.createTable(reporter);
        this.createTableImpl(reporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createItems() {
        boolean itemsCreated;
        TypedTableModelImpl typedTableModelImpl = this;
        synchronized (typedTableModelImpl) {
            itemsCreated = this.items != null;
        }
        if (itemsCreated) {
            this.notifyTableCreated(null);
            return;
        }
        this.runBackgroundTask(new Runnable(){

            @Override
            public void run() {
                ProgressReporter reporter = TypedTableModelImpl.this.getRootCreationProgressReporter();
                Throwable createException = null;
                try {
                    TypedTableModelImpl.this.ensureItemsCreated(reporter);
                }
                catch (OperationCanceledException e) {
                    createException = e;
                }
                catch (IOException e) {
                    Trace.warn((Throwable)e, (String)"Could not create the table");
                    createException = e;
                }
                catch (Throwable t) {
                    Trace.warn((Throwable)t, (String)"Could not create the table");
                    createException = new IOException("Could not create the table");
                    createException.initCause(t);
                }
                OperationCanceledException finalCreateException = createException;
                if (!TypedTableModelImpl.this.runForegroundTask(new Runnable((IOException)((Object)finalCreateException), reporter){
                    final /* synthetic */ IOException val$finalCreateException;
                    final /* synthetic */ ProgressReporter val$reporter;
                    {
                        this.val$finalCreateException = iOException;
                        this.val$reporter = progressReporter;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (this.val$finalCreateException == null) {
                            TypedTableModelImpl typedTableModelImpl = TypedTableModelImpl.this;
                            synchronized (typedTableModelImpl) {
                                try {
                                    TypedTableModelImpl.this.createTableImpl(this.val$reporter);
                                }
                                catch (OperationCanceledException e) {
                                    this.val$reporter.finish();
                                    TypedTableModelImpl.this.notifyTableCreated((IOException)((Object)e));
                                    return;
                                }
                                TypedTableModelImpl.this.setupViewerImpl();
                            }
                        }
                        this.val$reporter.finish();
                        TypedTableModelImpl.this.notifyTableCreated(this.val$finalCreateException);
                    }
                })) {
                    reporter.finish();
                }
            }
        });
    }

    private void setSelection(int itemId, boolean isSelected) {
        int slot = itemId >> 5;
        int mask = 1 << (itemId & 0x1F);
        if (isSelected) {
            int n = slot;
            this.selectionState[n] = this.selectionState[n] | mask;
        } else {
            int n = slot;
            this.selectionState[n] = this.selectionState[n] & (0xFFFFFFFF ^ mask);
        }
    }

    private synchronized void createTableImpl(ProgressReporter reporter) throws OperationCanceledException {
        if (this.items != null) {
            return;
        }
        this.items = new int[this.provider.getNrOfRows()];
        this.selectionState = new int[(this.items.length + 31) / 32];
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = i;
        }
        long work = this.provider.getCreateTableWork();
        if (this.initialState != null) {
            SortHistory tmpSortHistory = this.initialState.getSortHistory();
            if (tmpSortHistory.getMaxNumberOfColumns() == this.provider.getColumnSpec().getNrOfColumns()) {
                this.sortHistory = tmpSortHistory;
            }
            work += (long)this.getSpec().getUniqueColumns().length;
        }
        reporter.setWork(I18n._s((String)"Preparing the table (<%> %)"), work += (long)this.sortHistory.getNrOfNeededSorts());
        this.provider.tableCreated(reporter);
        if (this.initialState != null) {
            int[] itemsCopy = (int[])this.items.clone();
            this.sortUnique(itemsCopy, reporter);
            IntArrayList selectedItems = this.initialState.getSelectedIndices();
            for (int i = 0; i < selectedItems.size(); ++i) {
                this.setSelection(itemsCopy[selectedItems.get(i)], true);
            }
            this.nrOfSelectedItems = selectedItems.size();
            this.setColumnVisibilityImpl(this.initialState.getColumnVisibility());
        }
        this.sortItems(reporter, false);
    }

    private synchronized void setupViewerImpl() {
        if (this.initialState != null) {
            if (this.viewer instanceof ScreenModelViewer) {
                ScreenModelViewer screenViewer = (ScreenModelViewer)this.viewer;
                screenViewer.setViewState(this.initialState.getViewState());
            }
            this.initialState = null;
            this.defaultState = false;
        }
    }

    private void sortItems(ProgressReporter reporter, boolean onlyLastSort) throws OperationCanceledException {
        if (this.items.length < 2) {
            return;
        }
        EntryContext context = this.provider.getEntryContext();
        int startIndex = onlyLastSort ? 0 : this.sortHistory.getNrOfNeededSorts() - 1;
        int nrOfThreads = this.getResourceName().getSession().getNrOfThreadsForSorting();
        for (int i = startIndex; i >= 0; --i) {
            reporter.reportNextOrThrow();
            int columnIndex = this.sortHistory.getSortingColumn(i);
            if (columnIndex == -1) continue;
            Column column = this.provider.getColumn(columnIndex);
            if (column instanceof SortableColumn) {
                SortableColumn sortableColumn = (SortableColumn)((Object)column);
                if (this.sortHistory.getSortingDirection(i) < 0) {
                    this.items = sortableColumn.sortDescending(this.items, nrOfThreads);
                    continue;
                }
                this.items = sortableColumn.sortAscending(this.items, nrOfThreads);
                continue;
            }
            ProviderEntry[] entries = new ProviderEntry[this.items.length];
            for (int j = 0; j < entries.length; ++j) {
                entries[j] = this.provider.getEntry(j, columnIndex);
            }
            if (this.sortHistory.getSortingDirection(i) < 0) {
                this.mergeSortDescending(this.items, 0, this.items.length, entries, context, nrOfThreads);
                continue;
            }
            this.mergeSortAscending(this.items, 0, this.items.length, entries, context, nrOfThreads);
        }
        this.applyFilters(false);
    }

    @Override
    public String getColumnText(int column) {
        return this.provider.getColumnSpec().getColumnText(column);
    }

    @Override
    public String getColumnToolTip(int column) {
        return this.provider.getColumnSpec().getColumnToolTip(column);
    }

    @Override
    public int getDefaultSortDirection(int column) {
        return this.provider.getColumnSpec().getDefaultSortDirection(column);
    }

    @Override
    public ProviderEntry getEntryForItem(int itemId, int column) {
        return this.provider.getEntry(itemId, column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getItemId(int index) {
        Object object = this.filterLock;
        synchronized (object) {
            if (this.filteredItems != null) {
                return this.filteredItems[index];
            }
            return this.items[index];
        }
    }

    @Override
    public int getNrOfColumns() {
        return this.provider.getColumnSpec().getNrOfColumns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNrOfItems() {
        Object object = this.filterLock;
        synchronized (object) {
            if (this.filteredItems != null) {
                return this.filteredItems.length;
            }
            return this.items.length;
        }
    }

    @Override
    public int getMaxNrOfItems() {
        return this.items.length;
    }

    private EntryRenderer getEntryRenderer(int column, ProviderEntry entry) {
        if (entry == null || !this.allowMixedColumns) {
            return this.entryRenderers[column];
        }
        return this.renderer.getRenderer(entry.getClass());
    }

    @Override
    public RendererNode getRendererForItem(int itemId, int column) {
        ProviderEntry entry = this.provider.getEntry(itemId, column);
        if (entry == null) {
            return this.viewer.newSeparatorNode();
        }
        if (entry instanceof SummarizedProviderEntry) {
            SummarizedProviderEntry summarizedEntry = (SummarizedProviderEntry)entry;
            return this.getEntryRenderer(column, null).getRendererForSummarizedEntry(summarizedEntry.getEntry(), this.provider.getEntryContext(), this.provider.getColumnContext(column), summarizedEntry.getCount());
        }
        return this.getEntryRenderer(column, entry).getRenderer(entry, this.provider.getEntryContext(), this.provider.getColumnContext(column));
    }

    @Override
    public RendererNode getRendererForCombinedItems(int[] itemIds, int column) {
        ProviderEntry[] entries = new ProviderEntry[itemIds.length];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = this.provider.getEntry(itemIds[i], column);
        }
        return this.getEntryRenderer(column, null).getRendererForCombinedItems(entries, this.provider.getEntryContext(), this.provider.getColumnContext(column));
    }

    @Override
    public RendererNode getRendererForSkippedItems(int[] itemIds, int column) {
        ProviderEntry[] entries = new ProviderEntry[itemIds.length];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = this.provider.getEntry(itemIds[i], column);
        }
        return this.getEntryRenderer(column, null).getRendererForSkippedChildren(entries, this.provider.getEntryContext(), this.provider.getColumnContext(column));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getSelectedItemIds() {
        SplitArray32 tmp = new SplitArray32();
        int[] itemsList = null;
        Object object = this.filterLock;
        synchronized (object) {
            itemsList = this.filteredItems == null ? this.items : this.filteredItems;
        }
        for (int i = 0; i < itemsList.length; ++i) {
            if (!this.isSelected(itemsList[i])) continue;
            tmp.resize(tmp.size() + 1L);
            tmp.set(tmp.size() - 1L, itemsList[i]);
        }
        int[] result = new int[(int)tmp.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = tmp.get(i);
        }
        return result;
    }

    @Override
    public boolean isAnySelected() {
        return this.nrOfSelectedItems > 0;
    }

    @Override
    public boolean isSelected(int itemId) {
        int slot = itemId >> 5;
        int mask = 1 << (itemId & 0x1F);
        return (this.selectionState[slot] & mask) != 0;
    }

    @Override
    public boolean isSingleSelected() {
        return this.nrOfSelectedItems == 1;
    }

    @Override
    public boolean isInDefaultState() {
        return this.defaultState;
    }

    @Override
    public int getSortDirection() {
        if (this.sortHistory.getNrOfNeededSorts() == 0) {
            return 0;
        }
        return this.sortHistory.getSortingDirection(0);
    }

    @Override
    public int getSortedColumn() {
        if (this.sortHistory.getNrOfNeededSorts() == 0) {
            return 0;
        }
        return this.sortHistory.getSortingColumn(0);
    }

    @Override
    public String getToolTip(int itemId, int column) {
        ProviderEntry entry = this.provider.getEntry(itemId, column);
        if (entry instanceof SummarizedProviderEntry) {
            SummarizedProviderEntry summarizedEntry = (SummarizedProviderEntry)entry;
            return this.getEntryRenderer(column, null).getTooltTipForSummarizedEntry(summarizedEntry.getEntry(), this.provider.getEntryContext(), this.provider.getColumnContext(column), summarizedEntry.getCount());
        }
        return this.provider.getToolTip(entry, this.getEntryRenderer(column, entry), column);
    }

    @Override
    public String getToolTipForCombinedItems(int[] itemIds, int column) {
        ProviderEntry[] entries = new ProviderEntry[itemIds.length];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = this.provider.getEntry(itemIds[i], column);
        }
        return this.provider.getToolTipForCombinedItems(itemIds, entries, this.getEntryRenderer(column, null), column);
    }

    @Override
    public boolean isColumnVisible(int column) {
        return this.columnVisibility[column];
    }

    @Override
    public boolean isColumnMovable(int column) {
        return !this.provider.getColumnSpec().isColumnFixed(column);
    }

    @Override
    public boolean isComparableWith(ColumnBasedModel other) {
        if (other instanceof TypedTableModel) {
            return this.getSpec().isComparableWith(other.getSpec());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(TableModelListener listener) {
        ArrayList<TableModelListener> arrayList = this.listeners;
        synchronized (arrayList) {
            return this.listeners.remove(listener);
        }
    }

    @Override
    public void setSelection(int[] selectedItemIds) {
        Arrays.fill(this.selectionState, 0);
        for (int id : selectedItemIds) {
            this.setSelection(id, true);
        }
        this.nrOfSelectedItems = selectedItemIds.length;
        final int[] selectedItemIdsCopy = (int[])selectedItemIds.clone();
        for (final TableModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.selectionChanged(TypedTableModelImpl.this, selectedItemIdsCopy);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectAll() {
        int[] itemsList = null;
        Object object = this.filterLock;
        synchronized (object) {
            itemsList = this.filteredItems == null ? this.items : this.filteredItems;
        }
        int[] selection = new int[itemsList.length];
        for (int i = 0; i < selection.length; ++i) {
            selection[i] = itemsList[i];
        }
        this.setSelection(selection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSorting(int column, int order) {
        this.sortHistory.notifySortPerformed(column, order);
        if (this.items == null) {
            return;
        }
        ProgressReporter reporter = new ProgressReporter();
        try {
            this.sortItems(reporter, true);
        }
        catch (OperationCanceledException e) {
            Trace.debug((Throwable)e, (String)"Sorting cancelled");
        }
        finally {
            reporter.finish();
        }
        for (final TableModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.sortingChanged(TypedTableModelImpl.this);
                }
            });
        }
    }

    @Override
    public boolean tableCreated() {
        return this.items != null;
    }

    @Override
    public String getIconKey() {
        return this.provider.getIconKey();
    }

    @Override
    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        return this.provider.getTitle();
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        int version = reader.readVersion(0, 1);
        boolean initStateAvailable = reader.readBoolean();
        this.defaultState = !initStateAvailable;
        InitialState readState = initStateAvailable ? new InitialState(reader, reporter) : null;
        TypedTableModelImpl typedTableModelImpl = this;
        synchronized (typedTableModelImpl) {
            assert (this.items == null);
            this.initialState = readState;
        }
        if (version >= 1) {
            int nrCols = reader.readInt32();
            int[] tmpColumnsOrder = new int[nrCols];
            for (int i = 0; i < nrCols; ++i) {
                tmpColumnsOrder[i] = reader.readInt32();
            }
            if (this.provider.getColumnSpec().getNrOfColumns() == nrCols) {
                this.columnsOrder = tmpColumnsOrder;
            }
        }
        if (reader.hasNext()) {
            boolean hasTitle = reader.readBoolean();
            this.title = hasTitle ? reader.readString() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InitialState getState() {
        TypedTableModelImpl typedTableModelImpl = this;
        synchronized (typedTableModelImpl) {
            if (this.items == null) {
                return null;
            }
        }
        final int[][] copy = new int[1][];
        if (!this.runForegroundTask(new Runnable(){

            @Override
            public void run() {
                copy[0] = (int[])TypedTableModelImpl.this.selectionState.clone();
            }
        })) {
            return null;
        }
        final int[] itemsCopy = new int[this.items.length];
        for (int i = 0; i < itemsCopy.length; ++i) {
            itemsCopy[i] = i;
        }
        ProgressReporter reporter = new ProgressReporter();
        final int[] selectionStateCopy = copy[0];
        try {
            this.sortUnique(itemsCopy, reporter);
        }
        catch (OperationCanceledException e) {
            Trace.debug((Throwable)e, (String)"Sorting cancelled");
        }
        finally {
            reporter.finish();
        }
        final InitialState state = new InitialState();
        if (!this.runForegroundTask(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < itemsCopy.length; ++i) {
                    int itemId = itemsCopy[i];
                    int slot = itemId >> 5;
                    int mask = 1 << (itemId & 0x1F);
                    if ((selectionStateCopy[slot] & mask) == 0) continue;
                    state.addSelectedIndex(i);
                }
                if (TypedTableModelImpl.this.viewer instanceof ScreenModelViewer) {
                    ScreenModelViewer screenViewer = (ScreenModelViewer)TypedTableModelImpl.this.viewer;
                    state.setViewState(screenViewer.getViewState());
                }
                state.setColumnVisibility(TypedTableModelImpl.this.getColumnVisibility());
                state.setSortHistory(TypedTableModelImpl.this.sortHistory.copy());
            }
        })) {
            return null;
        }
        return state;
    }

    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        InitialState state;
        writer.writeVersion(1);
        InitialState initialState = state = this.initialState == null ? this.getState() : this.initialState;
        if (state != null) {
            writer.writeBoolean(true);
            state.write(writer, reporter);
        } else {
            writer.writeBoolean(false);
        }
        writer.writeInt32(this.columnsOrder.length);
        for (int i = 0; i < this.columnsOrder.length; ++i) {
            reporter.reportNextOrThrow();
            writer.writeInt32(this.columnsOrder[i]);
        }
        writer.writeBoolean(this.title != null);
        if (this.title != null) {
            writer.writeString(this.title);
        }
    }

    public long calculateWriteWork() {
        InitialState state;
        InitialState initialState = state = this.initialState == null ? this.getState() : this.initialState;
        if (state == null) {
            return this.columnsOrder.length;
        }
        return state.calculateWriteWork();
    }

    public ResourceName[] getDependents() {
        return null;
    }

    private void sortUnique(int[] toSort, ProgressReporter reporter) throws OperationCanceledException {
        int[] uniqueColumns = this.getSpec().getUniqueColumns();
        int nrOfThreads = this.getResourceName().getSession().getNrOfThreadsForSorting();
        for (int i = 0; i < uniqueColumns.length; ++i) {
            reporter.reportNextOrThrow();
            int columnIndex = uniqueColumns[i];
            Column column = this.provider.getColumn(columnIndex);
            if (column instanceof UniqueSortableColumn) {
                UniqueSortableColumn sortableColumn = (UniqueSortableColumn)((Object)column);
                int[] newIndices = sortableColumn.sortUnique(toSort, nrOfThreads);
                if (newIndices == toSort) continue;
                System.arraycopy(newIndices, 0, toSort, 0, toSort.length);
                continue;
            }
            UniqueEntry[] entries = new UniqueEntry[toSort.length];
            for (int j = 0; j < entries.length; ++j) {
                entries[j] = (UniqueEntry)this.provider.getEntry(j, columnIndex);
            }
            this.mergeSortUnique(toSort, 0, toSort.length, entries, nrOfThreads);
        }
    }

    public boolean isModifiable() {
        return true;
    }

    @Override
    public XmlTableExporter getXmlExporter(boolean selectedOnly) {
        XmlModelViewer xmlViewer = new XmlModelViewer();
        TypedTableModelImpl xmlModel = this.copy(xmlViewer);
        return new XmlTableExporter(xmlModel, selectedOnly);
    }

    private void mergeSortAscending(final int[] in, final int from, int to, final ProviderEntry[] values, final EntryContext context, final int nrOfThreads) {
        assert ((nrOfThreads & nrOfThreads - 1) == 0);
        int len = to - from;
        if (len < 16) {
            for (int i = from + 1; i < to; ++i) {
                int lo = from;
                int hi = i;
                ProviderEntry val = values[in[i]];
                while (lo < hi) {
                    int mid = (lo + hi) / 2;
                    if (val.compareTo(values[in[mid]], context) >= 0) {
                        lo = mid + 1;
                        continue;
                    }
                    hi = mid;
                }
                int tmp = in[i];
                System.arraycopy(in, lo, in, lo + 1, i - lo);
                in[lo] = tmp;
            }
            return;
        }
        final int mid = len / 2 + from;
        if (nrOfThreads > 1) {
            RunWaiter w = ThreadRunner.run((Runnable)new Runnable(){

                @Override
                public void run() {
                    TypedTableModelImpl.this.mergeSortAscending(in, from, mid, values, context, nrOfThreads / 2);
                }
            });
            this.mergeSortAscending(in, mid, to, values, context, nrOfThreads / 2);
            w.waitOnFinish();
        } else {
            this.mergeSortAscending(in, from, mid, values, context, nrOfThreads);
            this.mergeSortAscending(in, mid, to, values, context, nrOfThreads);
        }
        int half = mid - from;
        int[] copy = new int[half];
        System.arraycopy(in, from, copy, 0, half);
        int p1 = 0;
        int p2 = mid;
        ProviderEntry v1 = values[copy[p1]];
        ProviderEntry v2 = values[in[p2]];
        for (int i = from; i < to; ++i) {
            if (v1.compareTo(v2, context) <= 0) {
                in[i] = copy[p1];
                if (++p1 < half) {
                    v1 = values[copy[p1]];
                    continue;
                }
                System.arraycopy(in, p2, in, i + 1, to - i - 1);
                return;
            }
            in[i] = in[p2];
            if (++p2 < to) {
                v2 = values[in[p2]];
                continue;
            }
            System.arraycopy(copy, p1, in, i + 1, to - i - 1);
            return;
        }
    }

    private void mergeSortDescending(final int[] in, final int from, int to, final ProviderEntry[] values, final EntryContext context, final int nrOfThreads) {
        assert ((nrOfThreads & nrOfThreads - 1) == 0);
        int len = to - from;
        if (len < 16) {
            for (int i = from + 1; i < to; ++i) {
                int lo = from;
                int hi = i;
                ProviderEntry val = values[in[i]];
                while (lo < hi) {
                    int mid = (lo + hi) / 2;
                    if (val.compareTo(values[in[mid]], context) <= 0) {
                        lo = mid + 1;
                        continue;
                    }
                    hi = mid;
                }
                int tmp = in[i];
                System.arraycopy(in, lo, in, lo + 1, i - lo);
                in[lo] = tmp;
            }
            return;
        }
        final int mid = len / 2 + from;
        if (nrOfThreads > 1) {
            RunWaiter w = ThreadRunner.run((Runnable)new Runnable(){

                @Override
                public void run() {
                    TypedTableModelImpl.this.mergeSortDescending(in, from, mid, values, context, nrOfThreads / 2);
                }
            });
            this.mergeSortDescending(in, mid, to, values, context, nrOfThreads / 2);
            w.waitOnFinish();
        } else {
            this.mergeSortDescending(in, from, mid, values, context, nrOfThreads);
            this.mergeSortDescending(in, mid, to, values, context, nrOfThreads);
        }
        int half = mid - from;
        int[] copy = new int[half];
        System.arraycopy(in, from, copy, 0, half);
        int p1 = 0;
        int p2 = mid;
        ProviderEntry v1 = values[copy[p1]];
        ProviderEntry v2 = values[in[p2]];
        for (int i = from; i < to; ++i) {
            if (v1.compareTo(v2, context) >= 0) {
                in[i] = copy[p1];
                if (++p1 < half) {
                    v1 = values[copy[p1]];
                    continue;
                }
                System.arraycopy(in, p2, in, i + 1, to - i - 1);
                return;
            }
            in[i] = in[p2];
            if (++p2 < to) {
                v2 = values[in[p2]];
                continue;
            }
            System.arraycopy(copy, p1, in, i + 1, to - i - 1);
            return;
        }
    }

    private void mergeSortUnique(final int[] in, final int from, int to, final UniqueEntry[] values, final int nrOfThreads) {
        assert ((nrOfThreads & nrOfThreads - 1) == 0);
        int len = to - from;
        if (len < 16) {
            for (int i = from + 1; i < to; ++i) {
                int lo = from;
                int hi = i;
                UniqueEntry val = values[in[i]];
                while (lo < hi) {
                    int mid = (lo + hi) / 2;
                    int cmp = val.compareToUnique(values[in[mid]]);
                    if (cmp > 0) {
                        lo = mid + 1;
                        continue;
                    }
                    if (cmp < 0) {
                        hi = mid;
                        continue;
                    }
                    lo = mid;
                    break;
                }
                int tmp = in[i];
                System.arraycopy(in, lo, in, lo + 1, i - lo);
                in[lo] = tmp;
            }
            return;
        }
        final int mid = len / 2 + from;
        if (nrOfThreads > 1) {
            RunWaiter w = ThreadRunner.run((Runnable)new Runnable(){

                @Override
                public void run() {
                    TypedTableModelImpl.this.mergeSortUnique(in, from, mid, values, nrOfThreads / 2);
                }
            });
            this.mergeSortUnique(in, mid, to, values, nrOfThreads / 2);
            w.waitOnFinish();
        } else {
            this.mergeSortUnique(in, from, mid, values, nrOfThreads);
            this.mergeSortUnique(in, mid, to, values, nrOfThreads);
        }
        int half = mid - from;
        int[] copy = new int[half];
        System.arraycopy(in, from, copy, 0, half);
        int p1 = 0;
        int p2 = mid;
        UniqueEntry v1 = values[copy[p1]];
        UniqueEntry v2 = values[in[p2]];
        for (int i = from; i < to; ++i) {
            if (v1.compareToUnique(v2) <= 0) {
                in[i] = copy[p1];
                if (++p1 < half) {
                    v1 = values[copy[p1]];
                    continue;
                }
                System.arraycopy(in, p2, in, i + 1, to - i - 1);
                return;
            }
            in[i] = in[p2];
            if (++p2 < to) {
                v2 = values[in[p2]];
                continue;
            }
            System.arraycopy(copy, p1, in, i + 1, to - i - 1);
            return;
        }
    }

    @Override
    public synchronized void addFilter(TableModelItemFilter filter) {
        this.filters.add(filter);
        this.applyFilters();
    }

    @Override
    public synchronized boolean removeFilter(TableModelItemFilter filter) {
        boolean result = this.filters.remove(filter);
        if (result) {
            this.applyFilters();
        }
        return result;
    }

    @Override
    public void applyFilters() {
        this.applyFilters(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void applyFilters(boolean notify) {
        Object object = this;
        synchronized (object) {
            if (this.items == null) {
                return;
            }
        }
        object = this.filterLock;
        synchronized (object) {
            void var5_9;
            boolean needFiltering = false;
            for (TableModelItemFilter tableModelItemFilter : this.filters) {
                if (tableModelItemFilter.acceptsAll()) continue;
                needFiltering = true;
                break;
            }
            if (!needFiltering) {
                if (this.filteredItems != null) {
                    this.filteredItems = null;
                    this.notifyTableChanged();
                }
                return;
            }
            SplitArray32 filtered = new SplitArray32();
            for (int itemId : this.items) {
                boolean keep = true;
                for (TableModelItemFilter currentFilter : this.filters) {
                    if (currentFilter.accept(this, itemId)) continue;
                    keep = false;
                    break;
                }
                if (!keep) continue;
                filtered.resize(filtered.size() + 1L);
                filtered.set(filtered.size() - 1L, itemId);
            }
            this.filteredItems = new int[(int)filtered.size()];
            boolean bl = false;
            while (var5_9 < this.filteredItems.length) {
                this.filteredItems[var5_9] = filtered.get((int)var5_9);
                ++var5_9;
            }
        }
        if (notify) {
            this.notifyTableFiltered();
        }
    }

    @Override
    protected <R> R[][] getSelectedPaths(R[][] type) {
        return (Object[][])Array.newInstance(type.getClass().getComponentType(), 0);
    }

    @Override
    protected <R> R[] getSelectedRowTypes(R[] rowTypeArray) {
        return (Object[])Array.newInstance(rowTypeArray.getClass().getComponentType(), 0);
    }

    private static class InitialState {
        private IntArrayList selectedIndices;
        private ScreenViewState viewState;
        private String columnVisibility;
        private SortHistory sortHistory;

        public InitialState() {
            this.selectedIndices = new IntArrayList();
        }

        public InitialState(ResourceReader reader, ProgressReporter reporter) throws IOException {
            int nrOfSelectedItems = reader.readInt32();
            this.selectedIndices = new IntArrayList();
            reporter.setMessage(I18n._s((String)"Reading the table model ... (<% %>)"));
            reporter.addToMaximumWork((long)nrOfSelectedItems);
            for (int i = 0; i < nrOfSelectedItems; ++i) {
                if (!reporter.reportNext()) {
                    throw new OperationCanceledException();
                }
                this.selectedIndices.push(reader.readInt32());
            }
            if (reader.readBoolean()) {
                this.viewState = new ColumnViewState((BasicResourceReader)reader);
            }
            this.columnVisibility = reader.readString();
            this.sortHistory = new SortHistory(reader, reporter);
        }

        public IntArrayList getSelectedIndices() {
            return this.selectedIndices;
        }

        public void addSelectedIndex(int selectedIndex) {
            this.selectedIndices.push(selectedIndex);
        }

        public ScreenViewState getViewState() {
            return this.viewState;
        }

        public void setViewState(ScreenViewState viewState) {
            this.viewState = viewState;
        }

        public String getColumnVisibility() {
            return this.columnVisibility;
        }

        public void setColumnVisibility(String columnVisibility) {
            this.columnVisibility = columnVisibility;
        }

        public SortHistory getSortHistory() {
            return this.sortHistory;
        }

        public void setSortHistory(SortHistory sortHistory) {
            this.sortHistory = sortHistory;
        }

        public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
            reporter.setMessage(I18n._s((String)"Writing the table model ... (<% %>)"));
            reporter.addToMaximumWork((long)this.selectedIndices.size());
            writer.writeInt32(this.selectedIndices.size());
            for (int i = 0; i < this.selectedIndices.size(); ++i) {
                if (!reporter.reportNext()) {
                    throw new OperationCanceledException();
                }
                writer.writeInt32(this.selectedIndices.get(i));
            }
            writer.writeBoolean(this.viewState != null);
            if (this.viewState instanceof ColumnViewState) {
                this.viewState.write((BasicResourceWriter)writer, reporter);
            }
            writer.writeString(this.columnVisibility);
            this.sortHistory.write(writer, reporter);
        }

        public long calculateWriteWork() {
            return this.selectedIndices.size();
        }
    }
}

