/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed;

import com.sap.jvm.profiling.presentation.impl.typed.AbstractModelImpl;
import com.sap.jvm.profiling.presentation.impl.typed.TimeSeriesRendererImpl;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.axis.AbsoluteTimeStampAxisModel;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.axis.TimeStampAxisModel;
import com.sap.jvm.profiling.presentation.typed.AxisModel;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.presentation.typed.RendererThemeSpec;
import com.sap.jvm.profiling.presentation.typed.TypedModelRenderer;
import com.sap.jvm.profiling.presentation.typed.TypedModelRendererFactory;
import com.sap.jvm.profiling.presentation.typed.TypedTimeSeriesModel;
import com.sap.jvm.profiling.presentation.typed.TypedTimeSeriesProvider;
import com.sap.jvm.profiling.resource.BasicResourceReader;
import com.sap.jvm.profiling.resource.BasicResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.util.GeneralTimeSeries;
import com.sap.jvm.profiling.snapshot.util.TimestampToBookmarkConverter;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.ScreenModelViewer;
import com.sap.jvm.profiling.viewer.ScreenViewState;
import com.sap.jvm.profiling.viewer.TimeSeriesViewState;
import com.sap.jvm.profiling.viewer.series.TimeSeriesModel;
import com.sap.jvm.profiling.viewer.series.TimeSeriesModelListener;
import com.sap.jvm.profiling.viewer.series.TimeSeriesRenderer;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.ArrayList;

public class TypedTimeSeriesModelImpl
extends AbstractModelImpl
implements TypedTimeSeriesModel {
    private static final int VERSION = 1;
    private String title;
    private ModelViewer viewer;
    private final TypedTimeSeriesProvider provider;
    private TypedModelRenderer renderer;
    private final ArrayList<TimeSeriesModelListener> listeners;
    private RendererThemeSpec themeSpec;
    private String[] visibleSets;
    private boolean[][] areaVisibility;
    private long minX;
    private long maxX;
    private boolean initialized;
    private boolean hasSelection;
    private boolean showAbsoluteTime;
    private long selectionStartTimeStamp;
    private long selectionEndTimeStamp;
    private long visibleRangeStart = -1L;
    private long visibleRangeEnd = -1L;
    private ScreenViewState initialState;
    private boolean detailedValueBar;

    TypedTimeSeriesModelImpl(TypedTimeSeriesProvider provider, ResourceName name) {
        super(null, name);
        this.provider = provider;
        this.viewer = null;
        this.listeners = new ArrayList();
        this.themeSpec = null;
        this.setVisibilityImpl(provider.getDefaultVisivilitySet());
    }

    private TypedTimeSeriesModelImpl(ResourceName name, TypedTimeSeriesProvider provider, ModelViewer viewer, RendererThemeSpec themeSpec, String[] visibleSets, boolean hasSelection, long selectionStartTimeStamp, long selectionEndTimeStamp, long visibleRangeStart, long visibleRangeEnd, boolean showAbsoluteTime, boolean detailedValueBar, ScreenViewState initialState) {
        super(viewer.getTaskManager(), name);
        this.provider = provider;
        this.viewer = viewer;
        this.renderer = TypedModelRendererFactory.get(viewer, themeSpec);
        this.listeners = new ArrayList();
        this.themeSpec = themeSpec;
        this.hasSelection = hasSelection;
        this.selectionStartTimeStamp = selectionStartTimeStamp;
        this.selectionEndTimeStamp = selectionEndTimeStamp;
        this.visibleRangeStart = visibleRangeStart;
        this.visibleRangeEnd = visibleRangeEnd;
        this.showAbsoluteTime = showAbsoluteTime;
        this.detailedValueBar = detailedValueBar;
        this.initialState = initialState;
        this.setVisibilityImpl(visibleSets);
    }

    private void setVisibilityImpl(String[] visibilitySet) {
        this.visibleSets = visibilitySet;
        this.areaVisibility = this.provider.getGraphVisibility(this.visibleSets);
    }

    @Override
    public void setVisibility(String[] visibilitySet) {
        this.setVisibilityImpl(visibilitySet);
        this.notifyVisibilityChanged();
    }

    @Override
    public String[] getVisibilitySet() {
        return this.visibleSets;
    }

    @Override
    public String[] getTags() {
        return this.provider.getTags();
    }

    @Override
    public String getNameOfTag(String tag) {
        return this.provider.getNameOfTag(tag);
    }

    @Override
    public String getTooltipOfTag(String tag) {
        return this.provider.getTooltipOfTag(tag);
    }

    @Override
    public String getGroupNameOfTag(String tag) {
        int l = tag.indexOf(47);
        if (l <= 0) {
            return tag;
        }
        return this.provider.getGroupName(tag.substring(0, l));
    }

    @Override
    public boolean isEmpty(String tag) {
        return this.provider.isEmpty(tag);
    }

    private void notifyVisibilityChanged() {
        this.calcXMinMax();
        for (final TimeSeriesModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.areasChanged(TypedTimeSeriesModelImpl.this);
                }
            });
        }
    }

    private void calcXMinMax() {
        this.minX = Long.MAX_VALUE;
        this.maxX = Long.MIN_VALUE;
        for (int i = 0; i < this.getNrOfAreas(); ++i) {
            for (int j = 0; j < this.getAreaSize(i); ++j) {
                if (this.provider.getSize(i, j) <= 0) continue;
                this.minX = Math.min(this.minX, this.provider.getMinX(i, j));
                this.maxX = Math.max(this.maxX, this.provider.getMaxX(i, j));
            }
        }
        if (this.minX >= this.maxX) {
            ResourceName name = this.getResourceName();
            if (name == null) {
                this.minX = 0L;
                this.maxX = 1L;
            } else {
                Snapshot snapshot = SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name);
                this.minX = 1000L * (snapshot.getStartCollectionTimeStamp() - this.getProfilingStart());
                this.maxX = 1000L * (snapshot.getEndCollectionTimeStamp() - this.getProfilingStart());
            }
        }
    }

    @Override
    public ModelViewer getViewer() {
        return this.viewer;
    }

    @Override
    public TimeSeriesModel copy(ModelViewer newViewer) {
        ScreenViewState state = this.getState();
        if (state == null) {
            state = this.initialState;
        }
        TypedTimeSeriesModelImpl copy = new TypedTimeSeriesModelImpl(this.getResourceName(), this.provider, newViewer, this.themeSpec, this.visibleSets, this.hasSelection, this.selectionStartTimeStamp, this.selectionEndTimeStamp, this.visibleRangeStart, this.visibleRangeEnd, this.showAbsoluteTime, this.detailedValueBar, state);
        copy.minX = this.minX;
        copy.maxX = this.maxX;
        return copy;
    }

    @Override
    public Object getGraph(int areaIndex, int index, long xOffset) {
        return this.provider.getGraph(areaIndex, index, xOffset);
    }

    @Override
    public Object getToolTipProvider() {
        return this.provider.getToolTipProvider();
    }

    @Override
    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        return this.provider.getTitle();
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getIconKey() {
        return this.provider.getIconKey();
    }

    public boolean isModifiable() {
        return true;
    }

    public ResourceName[] getDependents() {
        return null;
    }

    @Override
    public boolean isShowingAbsoluteTime() {
        return this.showAbsoluteTime;
    }

    @Override
    public void setShowAbsoluteTime(boolean absolute) {
        this.showAbsoluteTime = absolute;
    }

    @Override
    public void setDetailedValueBar(boolean detailed) {
        this.detailedValueBar = detailed;
    }

    @Override
    public boolean hasDetailedValueBar() {
        return this.detailedValueBar;
    }

    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(1, 1);
        this.title = reader.readBoolean() ? reader.readString() : null;
        this.hasSelection = reader.readBoolean();
        this.selectionStartTimeStamp = reader.readInt64();
        this.selectionEndTimeStamp = reader.readInt64();
        this.visibleRangeStart = reader.readInt64();
        this.visibleRangeEnd = reader.readInt64();
        this.minX = reader.readInt64();
        this.maxX = reader.readInt64();
        this.visibleSets = new String[reader.readInt32()];
        for (int i = 0; i < this.visibleSets.length; ++i) {
            this.visibleSets[i] = reader.readString();
        }
        this.setVisibilityImpl(this.visibleSets);
        if (reader.readBoolean()) {
            this.initialState = new TimeSeriesViewState((BasicResourceReader)reader, reporter);
        }
    }

    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        writer.writeBoolean(this.title != null);
        if (this.title != null) {
            writer.writeString(this.title);
        }
        writer.writeBoolean(this.hasSelection);
        writer.writeInt64(this.selectionStartTimeStamp);
        writer.writeInt64(this.selectionEndTimeStamp);
        writer.writeInt64(this.visibleRangeStart);
        writer.writeInt64(this.visibleRangeEnd);
        writer.writeInt64(this.minX);
        writer.writeInt64(this.maxX);
        writer.writeInt32(this.visibleSets.length);
        for (String part : this.visibleSets) {
            writer.writeString(part);
        }
        ScreenViewState state = this.initialState != null ? this.initialState : this.getState();
        writer.writeBoolean(state instanceof TimeSeriesViewState);
        if (state instanceof TimeSeriesViewState) {
            state.write((BasicResourceWriter)writer, reporter);
        }
    }

    public long calculateWriteWork() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(TimeSeriesModelListener listener) {
        ArrayList<TimeSeriesModelListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(TimeSeriesModelListener listener) {
        TimeSeriesModelListener timeSeriesModelListener = listener;
        synchronized (timeSeriesModelListener) {
            return this.listeners.remove(listener);
        }
    }

    @Override
    public void setViewer(ModelViewer viewer, RendererThemeSpec spec) {
        this.viewer = viewer;
        this.setTaskManager(viewer.getTaskManager());
        this.renderer = TypedModelRendererFactory.get(viewer, spec);
        this.themeSpec = spec;
    }

    @Override
    public void removeViewer() {
        this.initialState = this.getState();
        this.setTaskManager(null);
        this.viewer = null;
    }

    private ScreenViewState getState() {
        if (this.viewer instanceof ScreenModelViewer) {
            return ((ScreenModelViewer)this.viewer).getViewState();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureDataCreated(ProgressReporter reporter) throws IOException {
        TypedTimeSeriesModelImpl typedTimeSeriesModelImpl = this;
        synchronized (typedTimeSeriesModelImpl) {
            if (this.initialized) {
                return;
            }
        }
        this.provider.createDataSets(reporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createData() {
        boolean dataSetsCreated;
        TypedTimeSeriesModelImpl typedTimeSeriesModelImpl = this;
        synchronized (typedTimeSeriesModelImpl) {
            dataSetsCreated = this.initialized;
        }
        if (dataSetsCreated) {
            this.notifyTimeSeriesCreated(null);
            return;
        }
        this.runBackgroundTask(new Runnable(){

            @Override
            public void run() {
                final ProgressReporter reporter = TypedTimeSeriesModelImpl.this.getRootCreationProgressReporter();
                IOException createException = null;
                try {
                    TypedTimeSeriesModelImpl.this.ensureDataCreated(reporter);
                }
                catch (IOException e) {
                    Trace.warn((Throwable)e, (String)"Could not create the time series");
                    createException = e;
                }
                catch (Throwable t) {
                    Trace.warn((Throwable)t, (String)"Could not create the time series");
                    createException = new IOException("Could not create the time series");
                    createException.initCause(t);
                }
                final IOException finalCreateException = createException;
                if (!TypedTimeSeriesModelImpl.this.runForegroundTask(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (finalCreateException == null) {
                            TypedTimeSeriesModelImpl typedTimeSeriesModelImpl = TypedTimeSeriesModelImpl.this;
                            synchronized (typedTimeSeriesModelImpl) {
                                if (!TypedTimeSeriesModelImpl.this.initialized) {
                                    TypedTimeSeriesModelImpl.this.initialized = true;
                                }
                            }
                            TypedTimeSeriesModelImpl.this.setupViewerImpl();
                        }
                        reporter.finish();
                        TypedTimeSeriesModelImpl.this.notifyTimeSeriesCreated(finalCreateException);
                    }
                })) {
                    reporter.finish();
                }
            }
        });
    }

    @Override
    public boolean dataCreated() {
        return this.initialized;
    }

    @Override
    public int getNrOfAreas() {
        return this.provider.getNrOfAreas();
    }

    @Override
    public int getAreaSize(int area) {
        return this.provider.getNrOfGraphs(area);
    }

    @Override
    public boolean isAreaVisible(int area) {
        for (boolean visible : this.areaVisibility[area]) {
            if (!visible) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isGraphVisible(int area, int index) {
        return this.areaVisibility[area][index];
    }

    @Override
    public String getAreaName(int area) {
        return this.provider.getAreaTitle(area);
    }

    @Override
    public String getGraphName(int area, int index) {
        return this.provider.getGraphLegend(area, index);
    }

    @Override
    public AxisModel getYAxisModel(int area, int index) {
        Class<?> yType = this.provider.getAxisModel(area, index);
        return this.renderer.getAxisModel(yType);
    }

    @Override
    public TimeSeriesRenderer getGraphProvider(int area, long xOffset) {
        Class<?> xType = this.getXAxisType();
        AxisModel xAxisModel = null;
        xAxisModel = xType == AbsoluteTimeStampAxisModel.class ? new AbsoluteTimeStampAxisModel(this.getResourceName().getSession(), this.getProfilingStart()) : this.renderer.getAxisModel(xType);
        AxisModel[] yAxisModels = new AxisModel[this.getAreaSize(area)];
        for (int i = 0; i < yAxisModels.length; ++i) {
            Class<?> yType = this.provider.getAxisModel(area, i);
            yAxisModels[i] = this.renderer.getAxisModel(yType);
        }
        return new TimeSeriesRendererImpl(this, area, xAxisModel, yAxisModels, xOffset);
    }

    @Override
    public long getMinX() {
        return this.minX;
    }

    @Override
    public long getMaxX() {
        return this.maxX;
    }

    @Override
    public long getProfilingStart() {
        return this.getResourceName().getSession().getSystemInfo().getTimeMillis();
    }

    @Override
    public Class<?> getYAxisType(int area, int index) {
        return this.provider.getAxisModel(area, index);
    }

    @Override
    public Class<?> getYAxisBaseType(int area, int index) {
        return this.provider.getBaseAxisModel(area, index);
    }

    @Override
    public boolean isForcedPrimary(int areaIndex, int index) {
        return this.provider.isForcedPrimary(areaIndex, index);
    }

    @Override
    public boolean isForcedSecondary(int areaIndex, int index) {
        return this.provider.isForcedSecondary(areaIndex, index);
    }

    @Override
    public Class<?> getXAxisType() {
        if (this.showAbsoluteTime) {
            return AbsoluteTimeStampAxisModel.class;
        }
        return TimeStampAxisModel.class;
    }

    @Override
    public String getCaptionForAxisType(Class<?> axisType) {
        return "";
    }

    @Override
    public void changeTheme(RendererThemeSpec spec) {
        this.themeSpec = spec;
    }

    @Override
    public RendererTheme getTheme() {
        if (this.renderer != null) {
            return this.renderer.getTheme();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<TimeSeriesModelListener> getListenerCopy() {
        ArrayList<TimeSeriesModelListener> arrayList = this.listeners;
        synchronized (arrayList) {
            return new ArrayList<TimeSeriesModelListener>(this.listeners);
        }
    }

    private void notifyTimeSeriesCreated(final IOException exception) {
        if (exception == null) {
            this.calcXMinMax();
        }
        for (final TimeSeriesModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.dataCreated(TypedTimeSeriesModelImpl.this, exception);
                }
            });
        }
    }

    @Override
    public boolean hasSelection() {
        return this.hasSelection;
    }

    @Override
    public long getSelectedStartTimeStamp() {
        return this.selectionStartTimeStamp;
    }

    @Override
    public long getSelectedEndTimeStamp() {
        return this.selectionEndTimeStamp;
    }

    @Override
    public void clearSelection() {
        if (this.hasSelection) {
            this.hasSelection = false;
            this.notifySelectionChanged();
        }
    }

    @Override
    public void setSelection(long startTimeStamp, long endTimeStamp) {
        if (!this.hasSelection || this.selectionStartTimeStamp != startTimeStamp || this.selectionEndTimeStamp != endTimeStamp) {
            this.hasSelection = true;
            this.selectionStartTimeStamp = startTimeStamp;
            this.selectionEndTimeStamp = endTimeStamp;
            this.notifySelectionChanged();
        }
    }

    @Override
    public long getVisibleRangeStart() {
        return this.visibleRangeStart == -1L ? this.getMinX() : this.visibleRangeStart;
    }

    @Override
    public long getVisibleRangeEnd() {
        return this.visibleRangeEnd == -1L ? this.getMaxX() : this.visibleRangeEnd;
    }

    @Override
    public void setVisibleRange(long startTimeStamp, long endTimeStamp) {
        this.visibleRangeStart = startTimeStamp;
        this.visibleRangeEnd = endTimeStamp;
        this.notifyVisibleRangeChanged();
    }

    private void notifySelectionChanged() {
        for (final TimeSeriesModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.selectionChanged(TypedTimeSeriesModelImpl.this, TypedTimeSeriesModelImpl.this.hasSelection, TypedTimeSeriesModelImpl.this.selectionStartTimeStamp, TypedTimeSeriesModelImpl.this.selectionEndTimeStamp);
                }
            });
        }
    }

    private void notifyVisibleRangeChanged() {
        for (final TimeSeriesModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.visibleRangeChanged(TypedTimeSeriesModelImpl.this, TypedTimeSeriesModelImpl.this.visibleRangeStart, TypedTimeSeriesModelImpl.this.visibleRangeEnd);
                }
            });
        }
    }

    private synchronized void setupViewerImpl() {
        if (this.initialState != null) {
            if (this.viewer instanceof ScreenModelViewer) {
                ScreenModelViewer screenViewer = (ScreenModelViewer)this.viewer;
                screenViewer.setViewState(this.initialState);
            }
            this.initialState = null;
        }
    }

    @Override
    public TimestampToBookmarkConverter getTimestampConverter() {
        return this.provider.getTimestampConverter();
    }

    @Override
    public GeneralTimeSeries getGeneralTimeSeries() {
        return this.provider.getGeneralTimeSeries();
    }
}

