/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed;

import com.sap.jvm.profiling.presentation.typed.TreeAutoExpander;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;

public final class TypedTreeAutoExpander
implements TreeAutoExpander {
    private final double threshold;
    private long startQuantity;
    private long cutOffQuantity;

    public TypedTreeAutoExpander(double threshold) {
        this.threshold = threshold;
    }

    @Override
    public boolean shouldExpandFirstDescending(ProviderEntry[] providerEntries) {
        long sum = 0L;
        long max = 0L;
        for (ProviderEntry entry : providerEntries) {
            if (!(entry instanceof Quantity)) continue;
            long quantity = ((Quantity)entry).getQuantity();
            max = Math.max(max, quantity);
            sum += quantity;
        }
        if (this.startQuantity == -1L) {
            this.startQuantity = sum;
            this.cutOffQuantity = (long)(this.threshold * (double)sum);
        }
        return max > this.cutOffQuantity;
    }

    @Override
    public TypedTreeAutoExpander start() {
        TypedTreeAutoExpander result = new TypedTreeAutoExpander(this.threshold);
        result.startQuantity = -1L;
        return result;
    }
}

