/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed;

import com.sap.jvm.profiling.presentation.typed.TreeChildCombiner;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;

public final class TypedTreeChildCombiner
implements TreeChildCombiner {
    public final double threshold;

    public TypedTreeChildCombiner(double threshold) {
        this.threshold = threshold;
    }

    @Override
    public int[] getChildrenToCombine(ProviderEntry[] children) {
        long sum = 0L;
        for (ProviderEntry entry : children) {
            if (!(entry instanceof Quantity)) continue;
            sum += ((Quantity)entry).getQuantity();
        }
        if (sum == 0L) {
            return null;
        }
        long cutOff = sum - (long)((double)sum * this.threshold);
        int nrToHide = 0;
        for (int i = children.length - 1; i >= 0; --i) {
            Quantity quantity = (Quantity)children[i];
            if ((cutOff -= quantity.getQuantity()) <= 0L) continue;
            ++nrToHide;
        }
        return new int[]{children.length - nrToHide};
    }

    @Override
    public boolean regardSortOrder() {
        return true;
    }
}

