/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.AbstractSelectableColumnBasedModel;
import com.sap.jvm.profiling.presentation.impl.typed.MultiItemImpl;
import com.sap.jvm.profiling.presentation.impl.typed.NormalItemImpl;
import com.sap.jvm.profiling.presentation.impl.typed.OtherChildrenItemImpl;
import com.sap.jvm.profiling.presentation.impl.typed.PlaceholderItemImpl;
import com.sap.jvm.profiling.presentation.impl.typed.SkippedChildrenItemImpl;
import com.sap.jvm.profiling.presentation.impl.typed.SortHistory;
import com.sap.jvm.profiling.presentation.impl.typed.TreeModelFullForwardIterator;
import com.sap.jvm.profiling.presentation.impl.typed.TreeModelItemImpl;
import com.sap.jvm.profiling.presentation.impl.typed.TypedColumnResizerImpl;
import com.sap.jvm.profiling.presentation.impl.typed.TypedTreeAutoExpander;
import com.sap.jvm.profiling.presentation.impl.typed.TypedTreeChildCombiner;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XmlModelViewer;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XmlTreeExporter;
import com.sap.jvm.profiling.presentation.typed.ColumnBasedModel;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.EntryRenderer;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.presentation.typed.RendererThemeSpec;
import com.sap.jvm.profiling.presentation.typed.TreeAutoExpander;
import com.sap.jvm.profiling.presentation.typed.TreeChildCombiner;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.TypedModelRenderer;
import com.sap.jvm.profiling.presentation.typed.TypedModelRendererFactory;
import com.sap.jvm.profiling.presentation.typed.TypedTreeModel;
import com.sap.jvm.profiling.presentation.typed.TypedTreeProvider;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;
import com.sap.jvm.profiling.resource.BasicResourceReader;
import com.sap.jvm.profiling.resource.BasicResourceWriter;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ProgressReporterListener;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.util.ValueTreeNodeBase;
import com.sap.jvm.profiling.util.IntArrayList;
import com.sap.jvm.profiling.util.ObjectIdToIntHashSet;
import com.sap.jvm.profiling.viewer.ColumnViewState;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.ScreenModelViewer;
import com.sap.jvm.profiling.viewer.ScreenViewState;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.tree.MultiItem;
import com.sap.jvm.profiling.viewer.tree.NormalItem;
import com.sap.jvm.profiling.viewer.tree.OtherChildrenItem;
import com.sap.jvm.profiling.viewer.tree.PlaceholderItem;
import com.sap.jvm.profiling.viewer.tree.SkippedChildrenItem;
import com.sap.jvm.profiling.viewer.tree.TreeColumnResizer;
import com.sap.jvm.profiling.viewer.tree.TreeModelForwardIterator;
import com.sap.jvm.profiling.viewer.tree.TreeModelItem;
import com.sap.jvm.profiling.viewer.tree.TreeModelListener;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;

public final class TypedTreeModelImpl
extends AbstractSelectableColumnBasedModel
implements TypedTreeModel {
    private static final int VERSION = 1;
    private static final int EXPANDED_STATE = 1;
    private static final int SELECTED_STATE = 2;
    private static final int SHOWS_SUB_ITEMS_STATE = 4;
    private static final int HAS_CHILDREN = 8;
    private static final int HAS_SUB_ITEMS = 16;
    private static final int NORMAL_ITEM = 32;
    private static final int OTHER_CHILDREN_ITEM = 64;
    private static final int SKIPPED_ITEM = 128;
    private static final int ROOT_ITEM = 256;
    private static final int CHILD_ITEM = 512;
    private static final int SUB_ITEM = 1024;
    private NormalItemImpl[] roots;
    private final TypedTreeProvider<?> provider;
    private TypedModelRenderer renderer;
    private final EntryRenderer[] entryRenderers;
    private final ArrayList<TreeModelListener> listeners;
    private TreeChildCombiner combiner;
    private SortHistory sortHistory;
    private final TreeAutoExpander autoExpander;
    private String visibleSets;
    private boolean[] columnVisibility;
    private int[] columnsOrder;
    private final HashMap<NormalItemImpl, PlaceholderItemImpl> childPlaceholder;
    private final HashMap<NormalItemImpl, PlaceholderItemImpl> subItemPlaceholders;
    private InitialState initialState;
    private boolean defaultState;
    private ModelViewer viewer;
    private String title;

    TypedTreeModelImpl(TypedTreeProvider<?> provider, ResourceName name, TreeChildCombiner combiner) {
        super(null, name, provider.getColumnSpec());
        TypedColumnSpec spec = provider.getColumnSpec();
        this.provider = provider;
        this.renderer = null;
        this.entryRenderers = new EntryRenderer[provider.getColumnSpec().getNrOfColumns()];
        this.roots = null;
        this.viewer = null;
        this.listeners = new ArrayList();
        this.combiner = combiner;
        this.sortHistory = new SortHistory(spec.getNrOfColumns());
        this.autoExpander = new TypedTreeAutoExpander(0.95);
        this.childPlaceholder = new HashMap();
        this.subItemPlaceholders = new HashMap();
        this.columnVisibility = new boolean[spec.getNrOfColumns()];
        this.defaultState = true;
        this.setColumnVisibility(provider.getColumnSpec().getDefaultVisibleSets(), false);
        this.setColumnOrderImpl(null);
        for (int i = 0; i < spec.getNrOfDefaultSorts(); ++i) {
            int column = spec.getDefaultSortColumn(i);
            this.sortHistory.notifySortPerformed(column, spec.getDefaultSortDirection(column));
        }
    }

    private TypedTreeModelImpl(TypedTreeProvider<?> provider, RendererThemeSpec themeSpec, NormalItemImpl[] roots, SortHistory sortHistory, ModelViewer viewer, InitialState initialState) {
        super(viewer.getTaskManager(), null, provider.getColumnSpec());
        this.provider = provider;
        this.renderer = TypedModelRendererFactory.get(viewer, themeSpec);
        this.entryRenderers = new EntryRenderer[provider.getColumnSpec().getNrOfColumns()];
        this.roots = roots;
        this.viewer = viewer;
        this.initialState = initialState;
        this.defaultState = initialState == null;
        this.listeners = new ArrayList();
        this.combiner = new TypedTreeChildCombiner(0.2);
        this.sortHistory = sortHistory;
        this.autoExpander = new TypedTreeAutoExpander(0.95);
        this.childPlaceholder = new HashMap();
        this.subItemPlaceholders = new HashMap();
        this.columnVisibility = new boolean[provider.getColumnSpec().getNrOfColumns()];
        this.setColumnVisibility(provider.getColumnSpec().getDefaultVisibleSets(), false);
        this.setColumnOrderImpl(null);
        for (int i = 0; i < provider.getColumnSpec().getNrOfColumns(); ++i) {
            this.entryRenderers[i] = this.renderer.getRenderer(provider.getColumnSpec().getColumnType(i));
        }
    }

    @Override
    public synchronized ModelViewer getViewer() {
        return this.viewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<TreeModelListener> getListenerCopy() {
        ArrayList<TreeModelListener> arrayList = this.listeners;
        synchronized (arrayList) {
            return new ArrayList<TreeModelListener>(this.listeners);
        }
    }

    private void notifyRootsCreated(final IOException exception) {
        for (final TreeModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.rootsCreated(TypedTreeModelImpl.this, exception);
                }
            });
        }
    }

    private void notifyItemChanged(final TreeModelItem item, final IOException exception) {
        for (final TreeModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.itemChanged(TypedTreeModelImpl.this, item, exception);
                }
            });
        }
    }

    private void notifyTreeChanged() {
        for (final TreeModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.treeChanged(TypedTreeModelImpl.this);
                }
            });
        }
    }

    private void notifySelectionChanged() {
        if (this.roots == null) {
            return;
        }
        for (final TreeModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.selectionChanged(TypedTreeModelImpl.this, TypedTreeModelImpl.this.getSelectedItems());
                }
            });
        }
    }

    private void notifyViewerChanged(final ModelViewer oldViewer, final ModelViewer newViewer) {
        for (final TreeModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.viewerChanged(TypedTreeModelImpl.this, oldViewer, newViewer);
                }
            });
        }
    }

    @Override
    public void collapseItem(TreeModelItem item) {
        if (item.isExpanded()) {
            TreeModelItemImpl itemImpl = (TreeModelItemImpl)item;
            itemImpl.setExpanded(false);
            this.notifyItemChanged(item, null);
        }
    }

    public ResourceName[] getDependents() {
        return null;
    }

    @Override
    public void createRoots() {
        assert (this.roots == null);
        this.runBackgroundTask(new Runnable(){

            @Override
            public void run() {
                Object[] finalInitialNodes;
                ProgressReporter reporter = TypedTreeModelImpl.this.getRootCreationProgressReporter();
                IOException createException = null;
                try {
                    TypedTreeModelImpl.this.provider.createRoots(reporter);
                }
                catch (IOException e) {
                    createException = e;
                }
                catch (Throwable t) {
                    createException = new IOException("Could not create the tree roots");
                    createException.initCause(t);
                }
                final IOException finalCreateException = createException;
                Object[] initalNodes = null;
                if (createException == null && TypedTreeModelImpl.this.initialState != null) {
                    try {
                        initalNodes = TypedTreeModelImpl.this.createNodesForInitialState(reporter);
                    }
                    catch (IOException e) {
                        createException = e;
                    }
                    catch (Throwable t) {
                        createException = new IOException("Could not create the nodes");
                        createException.initCause(t);
                    }
                }
                if (createException == null) {
                    TypedTreeModelImpl.this.provider.rootsCreated();
                }
                if (!TypedTreeModelImpl.this.runForegroundTask(new Runnable(finalInitialNodes = initalNodes, reporter){
                    final /* synthetic */ Object[] val$finalInitialNodes;
                    final /* synthetic */ ProgressReporter val$reporter;
                    {
                        this.val$finalInitialNodes = objectArray;
                        this.val$reporter = progressReporter;
                    }

                    @Override
                    public void run() {
                        if (finalCreateException == null) {
                            TypedTreeModelImpl.this.createRootsImpl(this.val$finalInitialNodes);
                        }
                        this.val$reporter.finish();
                        TypedTreeModelImpl.this.notifyRootsCreated(finalCreateException);
                    }
                })) {
                    reporter.finish();
                }
            }
        });
    }

    @Override
    public void collapseAll() {
        TreeModelForwardIterator it = new TreeModelForwardIterator(this);
        while (it.hasNext()) {
            TreeModelItemImpl item = (TreeModelItemImpl)it.next();
            item.setExpanded(false);
        }
        this.notifyTreeChanged();
    }

    @Override
    public void expandRoots() {
        NormalItemImpl[] rootItems;
        for (NormalItemImpl rootItem : rootItems = this.getRootItems()) {
            TreeModelItemImpl item = rootItem;
            if (!item.isExpandable()) continue;
            this.expandItemNoUpdates(item, false, false);
        }
        this.notifyTreeChanged();
    }

    private Object[] createNodesForInitialState(ProgressReporter reporter) throws IOException {
        int[] uniqueColumns = this.getSpec().getUniqueColumns();
        if (uniqueColumns.length == 0) {
            return new Object[0];
        }
        Comparator<Object> comparator = this.getUniqueComparator(uniqueColumns);
        IntArrayList parentIndices = this.initialState.getParentIndices();
        IntArrayList positions = this.initialState.getPositions();
        Object[] sortedRoots = (Object[])this.provider.getRootNodes().clone();
        Arrays.sort(sortedRoots, comparator);
        HashMap<Object, Object[]> sortedSiblings = new HashMap<Object, Object[]>();
        HashMap<Object, Object[]> sortedSubSiblings = new HashMap<Object, Object[]>();
        int nrOfNodes = parentIndices.size();
        Object[] nodes = new Object[nrOfNodes];
        for (int i = 0; i < nrOfNodes; ++i) {
            Object[] siblings;
            Object parent = null;
            int parentIndex = parentIndices.get(i);
            int position = positions.get(i);
            if (parentIndex >= 0) {
                if (parentIndex >= nodes.length) {
                    throw new IOException("parent index too large");
                }
                parent = nodes[parentIndex];
                if (parent == null) {
                    throw new IOException("missing parent");
                }
            }
            if (position < 0) {
                if (!this.provider.hasSubNodes(parent)) {
                    throw new IOException("missing sub nodes");
                }
                if (!this.provider.hasCreatedSubNodes(parent)) {
                    this.provider.createSubNodes(parent, reporter);
                }
                position = -position - 1;
                siblings = (Object[])sortedSubSiblings.get(parent);
                if (siblings == null && (siblings = this.provider.getSubNodes(parent)).length > 1) {
                    siblings = (Object[])siblings.clone();
                    Arrays.sort(siblings, comparator);
                    sortedSubSiblings.put(parent, siblings);
                }
            } else if (parent == null) {
                siblings = sortedRoots;
            } else {
                if (!this.provider.hasChildren(parent)) {
                    throw new IOException("missing children");
                }
                if (!this.provider.hasCreatedChildren(parent)) {
                    this.provider.createChildren(parent, reporter);
                }
                if ((siblings = (Object[])sortedSiblings.get(parent)) == null && (siblings = this.provider.getChildren(parent)).length > 1) {
                    siblings = (Object[])siblings.clone();
                    Arrays.sort(siblings, comparator);
                    sortedSiblings.put(parent, siblings);
                }
            }
            nodes[i] = siblings[position];
        }
        return nodes;
    }

    private void setupInititalItems(Object[] nodes) {
        ArrayList<TreeModelItemImpl> items = new ArrayList<TreeModelItemImpl>();
        IntArrayList itemData = this.initialState.getItemData();
        int itemDataSize = itemData.size();
        int index = 0;
        while (index < itemDataSize) {
            int i;
            Object[] itemNodes;
            TreeModelItemImpl item;
            int state = itemData.get(index + 1);
            boolean hasChildren = (state & 8) != 0;
            boolean hasSubItems = (state & 0x10) != 0;
            boolean isSubItem = (state & 0x400) != 0;
            boolean isRoot = (state & 0x100) != 0;
            int parentIndex = itemData.get(index);
            TreeModelItemImpl parent = null;
            if (parentIndex >= 0) {
                parent = (TreeModelItemImpl)items.get(parentIndex);
            }
            int itemIndex = -1;
            if (parent == null) {
                assert (isRoot);
                itemIndex = this.roots.length;
            } else if (isSubItem) {
                itemIndex = parent.getSubItems().length;
            } else {
                assert ((state & 0x200) != 0);
                itemIndex = parent.getChildren().length;
            }
            if ((state & 0x20) != 0) {
                Object node = nodes[itemData.get(index + 2)];
                item = new NormalItemImpl(parent, itemIndex, node, hasChildren, hasSubItems, isSubItem);
                index += 3;
            } else if ((state & 0x40) != 0) {
                int nrOfNodes = itemData.get(index + 2);
                itemNodes = new Object[nrOfNodes];
                for (i = 0; i < nrOfNodes; ++i) {
                    itemNodes[i] = nodes[itemData.get(index + 3 + i)];
                }
                item = new OtherChildrenItemImpl(parent, itemIndex, itemNodes, isSubItem);
                index += 3 + nrOfNodes;
            } else {
                assert ((state & 0x80) != 0);
                assert (itemIndex == 0);
                int nrOfNodes = itemData.get(index + 2);
                itemNodes = new Object[nrOfNodes];
                for (i = 0; i < nrOfNodes; ++i) {
                    itemNodes[i] = nodes[itemData.get(index + 3 + i)];
                }
                item = new SkippedChildrenItemImpl(parent, itemNodes, isSubItem);
                index += 3 + nrOfNodes;
            }
            if (parent == null) {
                NormalItemImpl[] newRoots = new NormalItemImpl[this.roots.length + 1];
                System.arraycopy(this.roots, 0, newRoots, 0, this.roots.length);
                newRoots[this.roots.length] = item;
                this.roots = newRoots;
            } else if (isSubItem) {
                TreeModelItemImpl[] oldSubItems = parent.getSubItems();
                TreeModelItemImpl[] newSubItems = new TreeModelItemImpl[oldSubItems.length + 1];
                System.arraycopy(oldSubItems, 0, newSubItems, 0, oldSubItems.length);
                newSubItems[oldSubItems.length] = item;
                parent.setSubItems(newSubItems);
            } else {
                TreeModelItemImpl[] oldChildren = parent.getChildren();
                TreeModelItemImpl[] newChildren = new TreeModelItemImpl[oldChildren.length + 1];
                System.arraycopy(oldChildren, 0, newChildren, 0, oldChildren.length);
                newChildren[oldChildren.length] = item;
                parent.setChildren(newChildren);
            }
            if ((state & 1) != 0) {
                item.setExpanded(true);
            }
            if ((state & 2) != 0) {
                item.setSelected(true);
            }
            if ((state & 4) != 0) {
                item.setShowsSubItems(true);
            }
            items.add(item);
        }
        assert (index == itemDataSize);
    }

    private void createRootsImpl(Object[] initialNodes) {
        if (this.initialState != null) {
            this.roots = new NormalItemImpl[0];
            this.setupInititalItems(initialNodes);
            this.setColumnVisibility(this.initialState.getColumnVisibility(), false);
            SortHistory tmpSortHistory = this.initialState.getSortHistory();
            if (tmpSortHistory.getMaxNumberOfColumns() == this.provider.getColumnSpec().getNrOfColumns()) {
                this.sortHistory = tmpSortHistory;
            }
            if (this.viewer instanceof ScreenModelViewer) {
                ScreenModelViewer screenViewer = (ScreenModelViewer)this.viewer;
                screenViewer.setViewState(this.initialState.getViewState());
            }
            this.initialState = null;
            this.defaultState = false;
        } else {
            Object[] nodes = this.provider.getRootNodes();
            this.roots = new NormalItemImpl[nodes.length];
            for (int i = 0; i < this.roots.length; ++i) {
                this.roots[i] = new NormalItemImpl(null, i, nodes[i], this.provider.hasChildren(nodes[i]), this.provider.hasSubNodes(nodes[i]), false);
            }
            this.sortItems(this.roots);
        }
    }

    private TreeModelItemImpl[] removeOtherChildren(TreeModelItemImpl parent, TreeModelItemImpl[] items) {
        boolean foundOtherChildren = false;
        for (TreeModelItemImpl item : items) {
            if (!item.isOtherChildrenItem()) continue;
            foundOtherChildren = true;
            break;
        }
        if (!foundOtherChildren) {
            return items;
        }
        ArrayList<TreeModelItemImpl> newItems = new ArrayList<TreeModelItemImpl>();
        int index = 0;
        for (int i = 0; i < items.length; ++i) {
            TreeModelItemImpl item;
            item = items[i];
            if (item.isOtherChildrenItem()) {
                OtherChildrenItem ocItem = (OtherChildrenItem)((Object)item);
                boolean isSubItem = items[0].isSubItem();
                for (Object node : ocItem.getNodes()) {
                    item = new NormalItemImpl(parent, index, node, this.provider.hasChildren(node), this.provider.hasSubNodes(node), isSubItem);
                    newItems.add(item);
                    ++index;
                }
                continue;
            }
            item.setIndex(index);
            newItems.add(item);
            ++index;
        }
        return newItems.toArray(new TreeModelItemImpl[0]);
    }

    private TreeModelItemImpl[] addOtherChildren(TreeModelItemImpl parent, TreeModelItemImpl[] items) {
        int fromIndex;
        int toIndex;
        int rangeLength;
        assert (this.removeOtherChildren(parent, items) == items);
        if (items.length < 2) {
            return items;
        }
        int column = 0;
        if (this.combiner.regardSortOrder()) {
            if (this.sortHistory.getNrOfNeededSorts() < 1) {
                return items;
            }
            if (this.sortHistory.getSortingDirection(0) >= 0) {
                return items;
            }
            column = this.sortHistory.getSortingColumn(0);
        }
        ProviderEntry[] entries = new ProviderEntry[items.length];
        for (int i = 0; i < entries.length; ++i) {
            assert (items[i].isNormalItem());
            entries[i] = this.provider.getEntry(((NormalItem)((Object)items[i])).getNode(), column);
        }
        int[] toCombine = this.combiner.getChildrenToCombine(entries);
        if (toCombine == null || toCombine.length == 0) {
            return items;
        }
        TreeModelItemImpl[] newItems = new TreeModelItemImpl[entries.length];
        System.arraycopy(items, 0, newItems, 0, toCombine[0]);
        int newItemPos = toCombine[0];
        for (int i = 0; i < toCombine.length; ++i) {
            int fromIndex2;
            int toIndex2 = i + 1 < toCombine.length ? toCombine[i + 1] : items.length;
            int rangeLength2 = toIndex2 - (fromIndex2 = toCombine[i] + i % 2);
            if (rangeLength2 <= 0) continue;
            if (i % 2 == 0) {
                Object[] nodes = new Object[rangeLength2];
                for (int j = 0; j < rangeLength2; ++j) {
                    nodes[j] = ((NormalItem)((Object)items[fromIndex2 + j])).getNode();
                }
                newItems[newItemPos] = new OtherChildrenItemImpl(parent, newItemPos, nodes, items[0].isSubItem());
                ++newItemPos;
                continue;
            }
            for (int j = 0; j < rangeLength2; ++j) {
                newItems[newItemPos] = items[fromIndex2 + j];
                newItems[newItemPos].setIndex(newItemPos);
                ++newItemPos;
            }
        }
        if (toCombine.length % 2 == 0 && (rangeLength = (toIndex = items.length) - (fromIndex = toCombine[toCombine.length - 1])) > 0) {
            for (int j = 0; j < rangeLength; ++j) {
                newItems[newItemPos] = items[fromIndex + j];
                newItems[newItemPos].setIndex(newItemPos);
                ++newItemPos;
            }
        }
        TreeModelItemImpl[] result = new TreeModelItemImpl[newItemPos];
        System.arraycopy(newItems, 0, result, 0, newItemPos);
        return result;
    }

    private void sortItem(TreeModelItemImpl item, boolean combineChildren) {
        if (!item.isExpanded()) {
            return;
        }
        TreeModelItemImpl[] items = item.getSubsOrChildren();
        items = this.removeOtherChildren(item, items);
        this.sortItems(items);
        if (combineChildren) {
            items = this.addOtherChildren(item, items);
        }
        item.setSubsOrChildren(items);
        for (TreeModelItemImpl curr : items) {
            this.sortItem(curr, combineChildren);
        }
    }

    private void sortItems(TreeModelItemImpl[] items) {
        int i;
        if (items.length < 2) {
            return;
        }
        final EntryContext context = this.provider.getEntryContext();
        for (i = this.sortHistory.getNrOfNeededSorts() - 1; i >= 0; --i) {
            final int column = this.sortHistory.getSortingColumn(i);
            if (column == -1) continue;
            final int multiplier = this.sortHistory.getSortingDirection(i);
            Arrays.sort(items, new Comparator<TreeModelItem>(){

                @Override
                public int compare(TreeModelItem i1, TreeModelItem i2) {
                    assert (!i1.isPlaceholderItem());
                    assert (!i1.isSkippedChildrenItem());
                    assert (!i2.isPlaceholderItem());
                    assert (!i2.isSkippedChildrenItem());
                    if (i1.isOtherChildrenItem()) {
                        assert (!i2.isOtherChildrenItem());
                        return -1;
                    }
                    if (i2.isOtherChildrenItem()) {
                        return 1;
                    }
                    Object o1 = ((NormalItem)i1).getNode();
                    Object o2 = ((NormalItem)i2).getNode();
                    ProviderEntry e1 = TypedTreeModelImpl.this.provider.getEntry(o1, column);
                    ProviderEntry e2 = TypedTreeModelImpl.this.provider.getEntry(o2, column);
                    if (e1 != null && e2 != null) {
                        return multiplier * e1.compareTo(e2, context);
                    }
                    return 0;
                }
            });
        }
        for (i = 0; i < items.length; ++i) {
            items[i].setIndex(i);
        }
    }

    private void sortNodes(Object[] nodes, SortHistory history) {
        if (nodes.length < 2) {
            return;
        }
        final EntryContext context = this.provider.getEntryContext();
        for (int i = history.getNrOfNeededSorts() - 1; i >= 0; --i) {
            final int column = history.getSortingColumn(i);
            if (column == -1) continue;
            final int multiplier = history.getSortingDirection(i);
            Arrays.sort(nodes, new Comparator<Object>(){

                @Override
                public int compare(Object n1, Object n2) {
                    ProviderEntry e1 = TypedTreeModelImpl.this.provider.getEntry(n1, column);
                    ProviderEntry e2 = TypedTreeModelImpl.this.provider.getEntry(n2, column);
                    if (e1 == null) {
                        return e2 == null ? 0 : -multiplier;
                    }
                    if (e2 == null) {
                        return multiplier;
                    }
                    return multiplier * e1.compareTo(e2, context);
                }
            });
        }
    }

    @Override
    public void expandItem(TreeModelItem item, final boolean combineChildren, boolean useAutoExpand) {
        SortHistory currSortHistory;
        assert (item.isExpandable());
        if (item.isExpanded()) {
            return;
        }
        boolean reallyUseExpander = useAutoExpand && !item.showsSubItems() && this.getSortDirection() < 0;
        SortHistory sortHistory = currSortHistory = reallyUseExpander ? this.sortHistory.copy() : null;
        if (this.needsDataCreationInExpand(item, currSortHistory)) {
            final NormalItemImpl normalItem = (NormalItemImpl)item;
            TreeModelItemImpl[] children = normalItem.getSubsOrChildren();
            if (children.length == 1 && children[0] instanceof PlaceholderItem) {
                return;
            }
            final PlaceholderItemImpl placeholder = this.getPlaceholderItem(normalItem);
            normalItem.setSubsOrChildren(new TreeModelItemImpl[]{placeholder});
            normalItem.setExpanded(true);
            this.notifyItemChanged(item, null);
            final ProgressReporter reporter = this.getNodeCreationProgressReporter();
            reporter.addListener((ProgressReporterListener)new ItemCreationListener(placeholder));
            if (!this.runBackgroundTask(new Runnable(){

                @Override
                public void run() {
                    IOException expandException = null;
                    try {
                        TypedTreeModelImpl.this.ensureNodesForExpand(placeholder, reporter, normalItem.getNode(), currSortHistory);
                    }
                    catch (IOException e) {
                        expandException = e;
                    }
                    catch (Throwable t) {
                        Trace.error((Throwable)t, (String)"Could not expand the tree node");
                        expandException = new IOException("Could not create the nodes for expand");
                        expandException.initCause(t);
                    }
                    reporter.finish();
                    final IOException finalExpandException = expandException;
                    TypedTreeModelImpl.this.runForegroundTask(new Runnable(){

                        @Override
                        public void run() {
                            TreeModelItemImpl[] items;
                            boolean wasSelected = placeholder.isSelected();
                            if (placeholder.isSubItem()) {
                                normalItem.setSubItems(new NormalItemImpl[0]);
                            } else {
                                normalItem.setChildren(new NormalItemImpl[0]);
                            }
                            if (placeholder.isSubItem() != normalItem.showsSubItems()) {
                                return;
                            }
                            if (finalExpandException != null) {
                                normalItem.setExpanded(false);
                                normalItem.inhibitExpand();
                            } else {
                                TypedTreeModelImpl.this.expandItemAlreadyCreated(normalItem, combineChildren, currSortHistory);
                            }
                            TypedTreeModelImpl.this.notifyItemChanged(normalItem, finalExpandException);
                            if (wasSelected && (items = normalItem.getSubsOrChildren()).length > 0) {
                                items[0].setSelected(true);
                                TypedTreeModelImpl.this.notifySelectionChanged();
                            }
                        }
                    });
                }
            })) {
                reporter.finish();
            }
        } else {
            this.expandItemAlreadyCreated((TreeModelItemImpl)item, combineChildren, currSortHistory);
            this.notifyItemChanged(item, null);
        }
    }

    public void expandItemNoUpdates(TreeModelItem item, boolean combineChildren, boolean useAutoExpand) {
        SortHistory currSortHistory;
        assert (item.isExpandable());
        if (item.isExpanded()) {
            return;
        }
        boolean reallyUseExpander = useAutoExpand && !item.showsSubItems() && this.getSortDirection() < 0;
        SortHistory sortHistory = currSortHistory = reallyUseExpander ? this.sortHistory.copy() : null;
        if (this.needsDataCreationInExpand(item, currSortHistory)) {
            NormalItemImpl normalItem = (NormalItemImpl)item;
            ProgressReporter reporter = this.getNodeCreationProgressReporter();
            IOException expandException = null;
            try {
                this.ensureNodesForExpand(null, reporter, normalItem.getNode(), currSortHistory);
            }
            catch (IOException e) {
                expandException = e;
            }
            catch (Throwable t) {
                Trace.error((Throwable)t, (String)"Could not expand the tree node");
                expandException = new IOException("Could not create the nodes for expand");
                expandException.initCause(t);
            }
            reporter.finish();
            IOException finalExpandException = expandException;
            if (finalExpandException != null) {
                normalItem.setExpanded(false);
                normalItem.inhibitExpand();
            } else {
                this.expandItemAlreadyCreated(normalItem, combineChildren, currSortHistory);
            }
        } else {
            this.expandItemAlreadyCreated((TreeModelItemImpl)item, combineChildren, currSortHistory);
        }
    }

    private boolean needsDataCreationInExpand(TreeModelItem item, SortHistory history) {
        TreeAutoExpander currExpander;
        if (!item.isNormalItem()) {
            return false;
        }
        NormalItem normalItem = (NormalItem)item;
        if (item.showsSubItems()) {
            return !this.provider.hasCreatedSubNodes(normalItem.getNode());
        }
        Object parent = normalItem.getNode();
        TreeAutoExpander treeAutoExpander = currExpander = history == null ? null : this.autoExpander.start();
        while (this.provider.hasChildren(parent)) {
            if (!this.provider.hasCreatedChildren(parent)) {
                return true;
            }
            if (history == null) {
                return false;
            }
            Object[] nodes = this.provider.getChildren(parent);
            this.sortNodes(nodes, history);
            ProviderEntry[] entries = new ProviderEntry[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                entries[i] = this.provider.getEntry(nodes[i], history.getSortingColumn(0));
            }
            if (!currExpander.shouldExpandFirstDescending(entries)) {
                return true;
            }
            parent = nodes[0];
        }
        return false;
    }

    private PlaceholderItemImpl getPlaceholderItem(NormalItemImpl item) {
        if (item.showsSubItems()) {
            if (!this.subItemPlaceholders.containsKey(item)) {
                this.subItemPlaceholders.put(item, new PlaceholderItemImpl((TreeModelItemImpl)item, true, ""));
            }
            return this.subItemPlaceholders.get(item);
        }
        if (!this.childPlaceholder.containsKey(item)) {
            this.childPlaceholder.put(item, new PlaceholderItemImpl((TreeModelItemImpl)item, false, ""));
        }
        return this.childPlaceholder.get(item);
    }

    private void ensureNodesForExpand(PlaceholderItem placeholder, ProgressReporter reporter, Object startNode, SortHistory history) throws IOException {
        Object[] nodes;
        TreeAutoExpander currExpander;
        Object parent = startNode;
        TreeAutoExpander treeAutoExpander = currExpander = history == null ? null : this.autoExpander.start();
        do {
            if (placeholder != null && placeholder.isSubItem()) {
                if (!this.provider.hasCreatedSubNodes(parent)) {
                    this.provider.createSubNodes(parent, reporter);
                }
                nodes = this.provider.getSubNodes(parent);
            } else {
                if (!this.provider.hasCreatedChildren(parent)) {
                    this.provider.createChildren(parent, reporter);
                }
                nodes = this.provider.getChildren(parent);
            }
            if (history == null) break;
            this.sortNodes(nodes, history);
            ProviderEntry[] entries = new ProviderEntry[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                entries[i] = this.provider.getEntry(nodes[i], history.getSortingColumn(0));
            }
            if (!currExpander.shouldExpandFirstDescending(entries)) break;
            assert (placeholder == null || !placeholder.isSubItem());
        } while (this.provider.hasChildren(parent = nodes[0]));
    }

    private void expandItemAlreadyCreated(TreeModelItemImpl item, boolean combineChildren, SortHistory history) {
        if (history != null && item instanceof NormalItemImpl) {
            this.createSkippedChildrenItem((NormalItemImpl)item, combineChildren, history);
            return;
        }
        if (item.getSubsOrChildren().length == 0) {
            this.createSubsOrChildren(item);
        }
        item.setExpanded(true);
        this.sortItem(item, combineChildren);
    }

    private void createSkippedChildrenItem(NormalItemImpl item, boolean combineChildren, SortHistory history) {
        Object parent = item.getNode();
        TreeAutoExpander currExpander = this.autoExpander.start();
        ArrayList<Object> chain = new ArrayList<Object>();
        while (this.provider.hasChildren(parent)) {
            assert (this.provider.hasCreatedChildren(parent));
            Object[] nodes = this.provider.getChildren(parent);
            this.sortNodes(nodes, history);
            chain.add(nodes[0]);
            ProviderEntry[] entries = new ProviderEntry[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                entries[i] = this.provider.getEntry(nodes[i], history.getSortingColumn(0));
            }
            if (!currExpander.shouldExpandFirstDescending(entries)) break;
            parent = nodes[0];
        }
        if (chain.size() < 4) {
            NormalItemImpl curr = item;
            for (int i = 0; i < chain.size(); ++i) {
                curr.setShowsSubItems(false);
                this.createSubsOrChildren(curr);
                curr.setExpanded(true);
                this.sortItem(curr, combineChildren);
                curr = (NormalItemImpl)curr.getChildren()[0];
            }
            return;
        }
        chain.remove(chain.size() - 1);
        Object lastNode = chain.get(chain.size() - 1);
        chain.remove(chain.size() - 1);
        SkippedChildrenItemImpl skipped = new SkippedChildrenItemImpl((TreeModelItemImpl)item, chain.toArray(), item.showsSubItems());
        item.setChildren(new TreeModelItemImpl[]{skipped});
        item.setExpanded(true);
        item.setShowsSubItems(false);
        NormalItemImpl lastItem = new NormalItemImpl(skipped, 0, lastNode, true, this.provider.hasSubNodes(lastNode), false);
        skipped.setChildren(new TreeModelItemImpl[]{lastItem});
        skipped.setExpanded(true);
        this.createSubsOrChildren(lastItem);
        lastItem.setExpanded(true);
        this.sortItem(lastItem, combineChildren);
    }

    private void createSubsOrChildren(TreeModelItemImpl item) {
        if (item.isNormalItem()) {
            NormalItemImpl normalItem = (NormalItemImpl)item;
            Object[] nodes = item.showsSubItems() ? this.provider.getSubNodes(normalItem.getNode()) : this.provider.getChildren(normalItem.getNode());
            TreeModelItemImpl[] children = new TreeModelItemImpl[nodes.length];
            for (int i = 0; i < children.length; ++i) {
                children[i] = new NormalItemImpl(item, i, nodes[i], this.provider.hasChildren(nodes[i]), this.provider.hasSubNodes(nodes[i]), item.showsSubItems());
            }
            item.setSubsOrChildren(children);
        } else {
            assert (item.isSkippedChildrenItem());
            SkippedChildrenItem skippedItem = (SkippedChildrenItem)((Object)item);
            Object[] nodes = skippedItem.getNodes();
            Object lastNode = nodes[nodes.length - 1];
            TreeModelItemImpl[] children = new TreeModelItemImpl[]{new NormalItemImpl(item, 0, lastNode, this.provider.hasChildren(lastNode), this.provider.hasSubNodes(lastNode), this.provider.isSubNode(lastNode))};
            item.setChildren(children);
        }
    }

    @Override
    public boolean rootsCreated() {
        return this.roots != null;
    }

    @Override
    public void setSelection(TreeModelItem[] selectedItems) {
        TreeModelForwardIterator it = new TreeModelForwardIterator(this);
        while (it.hasNext()) {
            TreeModelItemImpl item = (TreeModelItemImpl)it.next();
            item.setSelected(false);
        }
        for (TreeModelItem item : selectedItems) {
            TreeModelItemImpl itemImpl = (TreeModelItemImpl)item;
            itemImpl.setSelected(true);
        }
        this.notifySelectionChanged();
    }

    @Override
    public void selectAll() {
        TreeModelForwardIterator it = new TreeModelForwardIterator(this);
        while (it.hasNext()) {
            TreeModelItemImpl item = (TreeModelItemImpl)it.next();
            item.setSelected(true);
        }
        this.notifySelectionChanged();
    }

    @Override
    public void setSorting(int column, int order) {
        this.sortHistory.notifySortPerformed(column, order);
        if (this.roots == null) {
            return;
        }
        this.sortItems(this.roots);
        for (NormalItemImpl root : this.roots) {
            this.sortItem(root, true);
        }
        for (final TreeModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.sortingChanged(TypedTreeModelImpl.this);
                }
            });
        }
    }

    @Override
    public void toggleItem(TreeModelItem item, boolean combineChildren) {
        if (item instanceof NormalItem) {
            NormalItemImpl normalItem;
            if (!item.hasSubItems()) {
                return;
            }
            normalItem.setShowsSubItems(!(normalItem = (NormalItemImpl)item).showsSubItems());
            normalItem.setExpanded(false);
            if (normalItem.isExpandable()) {
                this.expandItem(normalItem, combineChildren, false);
            } else {
                this.notifyItemChanged(normalItem, null);
            }
        } else if (item instanceof OtherChildrenItem) {
            OtherChildrenItemImpl otherItem = (OtherChildrenItemImpl)item;
            TreeModelItemImpl parent = otherItem.getParent();
            TreeModelItemImpl[] items = otherItem.getSiblings(this);
            items = this.removeOtherChildren(parent, items);
            this.sortItems(items);
            parent.setSubsOrChildren(items);
            this.notifyItemChanged(parent, null);
        } else if (item instanceof SkippedChildrenItem) {
            SkippedChildrenItemImpl skippedItem = (SkippedChildrenItemImpl)item;
            TreeModelItemImpl parent = skippedItem.getParent();
            Object[] nodes = skippedItem.getNodes();
            TreeModelItemImpl currParent = parent;
            for (Object node : nodes) {
                NormalItemImpl currItem;
                int i;
                boolean isSubNode = this.provider.isSubNode(node);
                currParent.setShowsSubItems(isSubNode);
                currParent.setExpanded(true);
                this.createSubsOrChildren(currParent);
                TreeModelItemImpl[] children = currParent.getSubsOrChildren();
                TreeModelItemImpl[] withOther = this.addOtherChildren(currParent, children);
                NormalItemImpl nextParent = null;
                for (i = 0; i < withOther.length; ++i) {
                    currItem = (NormalItemImpl)withOther[i];
                    if (currItem.getNode() != node) continue;
                    nextParent = currItem;
                    break;
                }
                if (nextParent != null) {
                    currParent.setSubsOrChildren(withOther);
                } else {
                    for (i = 0; i < children.length; ++i) {
                        currItem = (NormalItemImpl)children[i];
                        if (currItem.getNode() != node) continue;
                        nextParent = currItem;
                        break;
                    }
                    assert (nextParent != null);
                }
                currParent = nextParent;
            }
            if (skippedItem.isExpanded()) {
                currParent.setExpanded(true);
                currParent.setSubsOrChildren(skippedItem.getSubsOrChildren());
            }
            for (TreeModelItemImpl child : skippedItem.getSubsOrChildren()) {
                child.setParent(currParent);
            }
            this.sortItem(parent, combineChildren);
            this.notifyItemChanged(parent, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(TreeModelListener listener) {
        ArrayList<TreeModelListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    @Override
    public String getColumnText(int column) {
        return this.provider.getColumnSpec().getColumnText(column);
    }

    @Override
    public String getColumnToolTip(int column) {
        return this.provider.getColumnSpec().getColumnToolTip(column);
    }

    @Override
    public int getDefaultSortDirection(int column) {
        return this.provider.getColumnSpec().getDefaultSortDirection(column);
    }

    @Override
    public int getNrOfColumns() {
        return this.provider.getColumnSpec().getNrOfColumns();
    }

    @Override
    public RendererNode getRendererForCombinedItems(TreeModelItem[] items, int column) {
        Object[] nodes = this.getNodesForCombinedItems(items);
        ProviderEntry[] entries = new ProviderEntry[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            entries[i] = this.provider.getEntry(nodes[i], column);
        }
        return this.entryRenderers[column].getRendererForCombinedItems(entries, this.provider.getEntryContext(), this.provider.getColumnContext(column));
    }

    @Override
    public RendererNode getRendererForSkippedItems(TreeModelItem[] items, int column) {
        Object[] nodes = this.getNodesForCombinedItems(items);
        ProviderEntry[] entries = new ProviderEntry[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            entries[i] = this.provider.getEntry(nodes[i], column);
        }
        return this.entryRenderers[column].getRendererForSkippedChildren(entries, this.provider.getEntryContext(), this.provider.getColumnContext(column));
    }

    private Object[] getNodesForCombinedItems(TreeModelItem[] items) {
        ArrayList<Object> nodes = new ArrayList<Object>();
        for (TreeModelItem item : items) {
            if (item instanceof NormalItemImpl) {
                NormalItemImpl normalItem = (NormalItemImpl)item;
                nodes.add(normalItem.getNode());
                continue;
            }
            if (item instanceof OtherChildrenItem) {
                OtherChildrenItem otherItem = (OtherChildrenItem)item;
                nodes.addAll(Arrays.asList(otherItem.getNodes()));
                continue;
            }
            assert (false);
        }
        return nodes.toArray();
    }

    @Override
    public RendererNode getRendererForItem(TreeModelItem item, int column) {
        if (item instanceof NormalItem) {
            NormalItem normalItem = (NormalItem)item;
            ProviderEntry entry = this.provider.getEntry(normalItem.getNode(), column);
            if (entry != null) {
                return this.entryRenderers[column].getRenderer(entry, this.provider.getEntryContext(), this.provider.getColumnContext(column));
            }
            return null;
        }
        if (item instanceof PlaceholderItem) {
            PlaceholderItem placholder = (PlaceholderItem)item;
            if (column == 0) {
                return this.renderer.getRendererForPlaceholder(placholder.getText());
            }
            return this.renderer.getRendererForPlaceholder("");
        }
        if (item instanceof OtherChildrenItem) {
            OtherChildrenItem otherItem = (OtherChildrenItem)item;
            ProviderEntry[] entries = this.getEntriesForMultiItem(otherItem, column);
            return this.entryRenderers[column].getRendererForOtherChildren(entries, this.provider.getEntryContext(), this.provider.getColumnContext(column));
        }
        if (item instanceof SkippedChildrenItem) {
            if (column != 0) {
                return this.renderer.getRendererForPlaceholder("");
            }
            SkippedChildrenItem skippedItem = (SkippedChildrenItem)item;
            ProviderEntry[] entries = this.getEntriesForMultiItem(skippedItem, column);
            return this.entryRenderers[column].getRendererForSkippedChildren(entries, this.provider.getEntryContext(), this.provider.getColumnContext(column));
        }
        assert (false);
        return null;
    }

    @Override
    public ProviderEntry getEntryForNormalItem(NormalItem item, int column) {
        return this.provider.getEntry(item.getNode(), column);
    }

    @Override
    public ProviderEntry[] getEntriesForMultiItem(MultiItem item, int column) {
        Object[] nodes = item.getNodes();
        ProviderEntry[] entries = new ProviderEntry[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            entries[i] = this.provider.getEntry(nodes[i], column);
        }
        return entries;
    }

    public NormalItemImpl[] getRootItems() {
        if (this.roots == null) {
            return new NormalItemImpl[0];
        }
        return this.roots;
    }

    public TreeModelItemImpl[] getSelectedItems() {
        ArrayList<TreeModelItem> result = new ArrayList<TreeModelItem>();
        TreeModelForwardIterator it = new TreeModelForwardIterator(this);
        while (it.hasNext()) {
            TreeModelItem item = it.next();
            if (!item.isSelected()) continue;
            result.add(item);
        }
        return result.toArray(new TreeModelItemImpl[result.size()]);
    }

    @Override
    public synchronized TypedTreeModelImpl copy(ModelViewer newViewer) {
        if (this.roots == null) {
            return new TypedTreeModelImpl(this.provider, this.renderer.getThemeSpec(), this.roots, this.sortHistory.copy(), newViewer, this.initialState);
        }
        NormalItemImpl[] rootsCopy = new NormalItemImpl[this.roots.length];
        for (int i = 0; i < rootsCopy.length; ++i) {
            rootsCopy[i] = this.roots[i].copy(null);
        }
        TypedTreeModelImpl result = new TypedTreeModelImpl(this.provider, this.renderer.getThemeSpec(), rootsCopy, this.sortHistory.copy(), newViewer, this.initialState);
        result.setColumnVisibility(this.getColumnVisibility(), false);
        result.setColumnOrderImpl(this.getColumnOrder());
        return result;
    }

    @Override
    public synchronized void setViewer(ModelViewer viewer, RendererThemeSpec spec) {
        this.notifyViewerChanged(this.viewer, viewer);
        this.viewer = viewer;
        this.setTaskManager(viewer.getTaskManager());
        this.renderer = TypedModelRendererFactory.get(viewer, spec);
        for (int i = 0; i < this.provider.getColumnSpec().getNrOfColumns(); ++i) {
            this.entryRenderers[i] = this.renderer.getRenderer(this.provider.getColumnSpec().getColumnType(i));
        }
    }

    @Override
    public void removeViewer() {
        this.notifyViewerChanged(this.viewer, null);
        this.initialState = this.getState();
        this.defaultState = false;
        this.roots = null;
        this.setTaskManager(null);
        this.viewer = null;
        for (int i = 0; i < this.entryRenderers.length; ++i) {
            this.entryRenderers[i] = null;
        }
    }

    @Override
    public void changeTheme(RendererThemeSpec spec) {
        if (this.viewer == null) {
            return;
        }
        this.renderer = TypedModelRendererFactory.get(this.viewer, spec);
        for (int i = 0; i < this.provider.getColumnSpec().getNrOfColumns(); ++i) {
            this.entryRenderers[i] = this.renderer.getRenderer(this.provider.getColumnSpec().getColumnType(i));
        }
    }

    @Override
    public RendererTheme getTheme() {
        if (this.renderer != null) {
            return this.renderer.getTheme();
        }
        return null;
    }

    @Override
    public int getSortDirection() {
        if (this.sortHistory.getNrOfNeededSorts() == 0) {
            return 0;
        }
        return this.sortHistory.getSortingDirection(0);
    }

    @Override
    public int getSortedColumn() {
        if (this.sortHistory.getNrOfNeededSorts() == 0) {
            return 0;
        }
        return this.sortHistory.getSortingColumn(0);
    }

    @Override
    public String getToogleToolTip(TreeModelItem item, int column) {
        if (item instanceof NormalItem) {
            NormalItem normalIem = (NormalItem)item;
            ProviderEntry entry = this.provider.getEntry(normalIem.getNode(), column);
            return this.provider.getToggleNormalItemToolTip((NormalItem)item, entry, this.entryRenderers[column], column);
        }
        if (item instanceof MultiItem) {
            MultiItem multiItem = (MultiItem)item;
            Object[] nodes = multiItem.getNodes();
            ProviderEntry[] entries = new ProviderEntry[nodes.length];
            for (int i = 0; i < entries.length; ++i) {
                entries[i] = this.provider.getEntry(nodes[i], column);
            }
            if (item instanceof SkippedChildrenItem) {
                return this.provider.getToggleSkippedChildrenToolTip((SkippedChildrenItem)item, entries, this.entryRenderers[column], column);
            }
            return this.provider.getToggleOtherChildrenToolTip((OtherChildrenItem)item, entries, this.entryRenderers[column], column);
        }
        return null;
    }

    @Override
    public String getToolTip(TreeModelItem item, int column) {
        if (item instanceof NormalItem) {
            NormalItem normalIem = (NormalItem)item;
            ProviderEntry entry = this.provider.getEntry(normalIem.getNode(), column);
            if (entry != null) {
                return this.provider.getNormalToolTip((NormalItem)item, entry, this.entryRenderers[column], column);
            }
        } else if (item instanceof MultiItem) {
            MultiItem multiItem = (MultiItem)item;
            Object[] nodes = multiItem.getNodes();
            ProviderEntry[] entries = new ProviderEntry[nodes.length];
            for (int i = 0; i < entries.length; ++i) {
                entries[i] = this.provider.getEntry(nodes[i], column);
            }
            if (item instanceof SkippedChildrenItem) {
                return this.provider.getSkippedChildrenToolTip((SkippedChildrenItem)item, entries, this.entryRenderers[column], column);
            }
            return this.provider.getOtherChildrenToolTip((OtherChildrenItem)item, entries, this.entryRenderers[column], column);
        }
        return null;
    }

    @Override
    public String getToolTipForCombinedItems(TreeModelItem[] items, int column) {
        Object[] nodes = this.getNodesForCombinedItems(items);
        ProviderEntry[] entries = new ProviderEntry[nodes.length];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = this.provider.getEntry(nodes[i], column);
        }
        return this.provider.getCombinedItemsToolTip(items, entries, this.entryRenderers[column], column);
    }

    @Override
    public boolean isColumnVisible(int column) {
        return this.columnVisibility[column];
    }

    @Override
    public boolean isColumnMovable(int column) {
        return !this.provider.getColumnSpec().isColumnFixed(column);
    }

    @Override
    public boolean isComparableWith(ColumnBasedModel other) {
        return false;
    }

    @Override
    public boolean isValid(TreeModelItem item) {
        return this.isValidImpl(item, false);
    }

    private boolean isValidImpl(TreeModelItem item, boolean useIndex) {
        NormalItemImpl[] items;
        int index = item.getIndex();
        TreeModelItem parent = item.getParent();
        TreeModelItem[] treeModelItemArray = parent == null ? this.roots : (items = item.isSubItem() ? parent.getSubItems() : parent.getChildren());
        if (index < items.length && items[index] == item) {
            return true;
        }
        if (!useIndex) {
            for (NormalItemImpl curr : items) {
                if (curr != item) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(TreeModelListener listener) {
        ArrayList<TreeModelListener> arrayList = this.listeners;
        synchronized (arrayList) {
            return this.listeners.remove(listener);
        }
    }

    @Override
    public TreeColumnResizer getColumnResizer() {
        return new TypedColumnResizerImpl(this.entryRenderers, this.provider.getEntryContext(), this.provider.getColumnContexts());
    }

    @Override
    public Object[] getSelectedNodes() {
        ArrayList<Object> result = new ArrayList<Object>();
        TreeModelForwardIterator it = new TreeModelForwardIterator(this);
        while (it.hasNext()) {
            TreeModelItem item = it.next();
            if (!item.isSelected()) continue;
            if (item instanceof NormalItem) {
                NormalItem normalItem = (NormalItem)item;
                result.add(normalItem.getNode());
                continue;
            }
            if (!(item instanceof MultiItem)) continue;
            MultiItem multiItem = (MultiItem)item;
            for (Object node : multiItem.getNodes()) {
                result.add(node);
            }
        }
        return result.toArray();
    }

    @Override
    public ProviderEntry[] getSelectedEntries(int column) {
        Object[] nodes = this.getSelectedNodes();
        ProviderEntry[] entries = new ProviderEntry[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            entries[i] = this.provider.getEntry(nodes[i], column);
        }
        return entries;
    }

    @Override
    public boolean isAnySelected() {
        return this.getSelectedNodes().length > 0;
    }

    @Override
    public boolean isSingleSelected() {
        return this.getSelectedNodes().length == 1;
    }

    @Override
    public boolean isInDefaultState() {
        return this.defaultState;
    }

    @Override
    public TypedColumnSpec getSpec() {
        return this.provider.getColumnSpec();
    }

    @Override
    public void setColumnVisibility(String spec) {
        this.setColumnVisibility(spec, true);
    }

    private void setColumnVisibility(String spec, boolean informListeners) {
        this.visibleSets = spec;
        this.columnVisibility = this.provider.getColumnSpec().getColumnVisibility(spec);
        if (informListeners) {
            for (final TreeModelListener listener : this.getListenerCopy()) {
                this.runForegroundTask(new Runnable(){

                    @Override
                    public void run() {
                        listener.columnsChanged(TypedTreeModelImpl.this);
                    }
                });
            }
        }
    }

    @Override
    public String getColumnVisibility() {
        return this.visibleSets;
    }

    @Override
    public void setColumnOrder(int[] order) {
        this.setColumnOrderImpl(order);
        for (final TreeModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.columnsOrderChanged(TypedTreeModelImpl.this);
                }
            });
        }
    }

    private void setColumnOrderImpl(int[] order) {
        int nrCols = this.provider.getColumnSpec().getNrOfColumns();
        if (this.columnsOrder == null) {
            this.columnsOrder = new int[nrCols];
        }
        assert (this.columnsOrder.length == nrCols);
        if (order == null) {
            for (int i = 0; i < nrCols; ++i) {
                this.columnsOrder[i] = i;
            }
            return;
        }
        assert (order.length <= nrCols);
        HashSet<Integer> ordered = new HashSet<Integer>();
        for (int i = 0; i < order.length; ++i) {
            int column = order[i];
            assert (column < nrCols);
            this.columnsOrder[i] = column;
            ordered.add(column);
        }
        int idx = order.length;
        for (int i = 0; i < nrCols; ++i) {
            if (ordered.contains(i)) continue;
            this.columnsOrder[idx] = i;
            ++idx;
        }
    }

    @Override
    public int[] getColumnOrder() {
        return (int[])this.columnsOrder.clone();
    }

    @Override
    public boolean canCombineSelectedItems() {
        Object[] nodes;
        TreeModelItem[] selected = this.getSelectedItems();
        if (this.canCombineToOtherChildren(selected, nodes = this.getNodesForItems(selected), false)) {
            return true;
        }
        return this.canCombineToSkippedChildren(selected, nodes);
    }

    @Override
    public boolean canSumSelectedItems() {
        TreeModelItem[] selected = this.getSelectedItems();
        Object[] nodes = this.getNodesForItems(selected);
        return this.canCombineToOtherChildren(selected, nodes, true);
    }

    @Override
    public void combineSelectedItems() {
        Object[] nodes;
        TreeModelItem[] selected = this.getSelectedItems();
        if (this.canCombineToOtherChildren(selected, nodes = this.getNodesForItems(selected), false)) {
            this.combineToOtherChildren((TreeModelItemImpl[])selected, nodes);
        } else if (this.canCombineToSkippedChildren(selected, nodes)) {
            this.combineToSkippedChildren((TreeModelItemImpl[])selected, nodes);
        }
    }

    private Object[] getNodesForItems(TreeModelItem[] items) {
        ArrayList<Object> nodes = new ArrayList<Object>();
        for (TreeModelItem item : items) {
            if (item instanceof NormalItem) {
                nodes.add(((NormalItem)item).getNode());
                continue;
            }
            if (!(item instanceof MultiItem)) continue;
            nodes.addAll(Arrays.asList(((MultiItem)item).getNodes()));
        }
        return nodes.toArray();
    }

    private boolean canCombineToOtherChildren(TreeModelItem[] items, Object[] nodes, boolean allowRoots) {
        if (items.length < 2 || nodes.length < 2) {
            return false;
        }
        Object parent = this.provider.getParent(nodes[0]);
        if (!allowRoots && parent == null) {
            return false;
        }
        for (Object node : nodes) {
            if (parent == this.provider.getParent(node)) continue;
            return false;
        }
        return true;
    }

    private OtherChildrenItemImpl combineToOtherChildren(TreeModelItemImpl[] items, Object[] nodes) {
        Object parent = this.provider.getParent(nodes[0]);
        NormalItemImpl parentItem = null;
        for (TreeModelItemImpl item : items) {
            if (!(item.getParent() instanceof NormalItem)) continue;
            parentItem = (NormalItemImpl)item.getParent();
        }
        if (parentItem == null || parentItem.getNode() != parent) {
            return null;
        }
        HashSet<Object> nodeSet = new HashSet<Object>(Arrays.asList(nodes));
        for (TreeModelItemImpl item : parentItem.getSubsOrChildren()) {
            if (!(item instanceof OtherChildrenItem)) continue;
            Object[] toAdd = ((OtherChildrenItem)((Object)item)).getNodes();
            nodeSet.addAll(Arrays.asList(toAdd));
        }
        ArrayList<TreeModelItemImpl> children = new ArrayList<TreeModelItemImpl>();
        int index = 0;
        for (TreeModelItemImpl item : parentItem.getSubsOrChildren()) {
            NormalItemImpl normalItem;
            if (!(item instanceof NormalItemImpl) || nodeSet.contains((normalItem = (NormalItemImpl)item).getNode())) continue;
            item.setIndex(index);
            ++index;
            children.add(item);
        }
        OtherChildrenItemImpl result = new OtherChildrenItemImpl((TreeModelItemImpl)parentItem, index, nodeSet.toArray(), parentItem.showsSubItems());
        children.add(result);
        parentItem.setSubsOrChildren(children.toArray(new TreeModelItemImpl[children.size()]));
        this.notifyItemChanged(parentItem, null);
        return result;
    }

    private boolean canCombineToSkippedChildren(TreeModelItem[] items, Object[] nodes) {
        int i;
        if (items.length < 3 || nodes.length < 4) {
            return false;
        }
        this.sortNodesByDepth(nodes);
        for (i = 1; i < nodes.length; ++i) {
            if (nodes[i - 1] == this.provider.getParent(nodes[i])) continue;
            return false;
        }
        for (i = 0; i < items.length; ++i) {
            if (items[i] instanceof PlaceholderItemImpl) {
                return false;
            }
            if (!(items[i] instanceof OtherChildrenItemImpl)) continue;
            return false;
        }
        return true;
    }

    private SkippedChildrenItemImpl combineToSkippedChildren(TreeModelItemImpl[] items, Object[] nodes) {
        this.sortNodesByDepth(nodes);
        TreeModelItemImpl firstItem = null;
        TreeModelItemImpl lastItem = null;
        Object firstNode = nodes[0];
        Object lastNode = nodes[nodes.length - 1];
        for (TreeModelItemImpl item : items) {
            if (item.containsNode(firstNode)) {
                assert (firstItem == null);
                firstItem = item;
            }
            if (!item.containsNode(lastNode)) continue;
            assert (lastItem == null);
            lastItem = item;
        }
        assert (firstItem != null);
        assert (lastItem != null);
        assert (firstItem != lastItem);
        if (firstItem instanceof SkippedChildrenItemImpl) {
            TreeModelItemImpl parent = firstItem.getParent();
            NormalItemImpl newFirstItem = new NormalItemImpl(parent, firstItem.getIndex(), firstNode, this.provider.hasChildren(firstNode), this.provider.hasSubNodes(firstNode), this.provider.isSubNode(nodes[1]));
            TreeModelItemImpl[] siblings = firstItem.getSiblings(this);
            assert (siblings[firstItem.getIndex()] == firstItem);
            assert (parent.showsSubItems() == newFirstItem.isSubItem());
            siblings[firstItem.getIndex()] = newFirstItem;
            parent.setSubsOrChildren(siblings);
            firstItem = newFirstItem;
        }
        if (lastItem instanceof SkippedChildrenItemImpl) {
            NormalItemImpl newLastItem = new NormalItemImpl(lastItem.getParent(), 0, lastNode, this.provider.hasChildren(lastNode), this.provider.hasSubNodes(lastNode), lastItem.showsSubItems());
            TreeModelItemImpl[] subsOrChildren = lastItem.getSubsOrChildren();
            for (int i = 0; i < subsOrChildren.length; ++i) {
                subsOrChildren[i].setParent(newLastItem);
            }
            lastItem = newLastItem;
        }
        Object[] skippedNodes = new Object[nodes.length - 2];
        for (int i = 1; i < nodes.length - 1; ++i) {
            skippedNodes[i - 1] = nodes[i];
        }
        SkippedChildrenItemImpl result = new SkippedChildrenItemImpl(firstItem, skippedNodes, firstItem.showsSubItems());
        result.setSubsOrChildren(new TreeModelItemImpl[]{lastItem});
        result.setExpanded(true);
        lastItem.setParent(result);
        firstItem.setSubsOrChildren(new TreeModelItemImpl[]{result});
        this.notifyItemChanged(firstItem, null);
        return result;
    }

    private void sortNodesByDepth(Object[] nodes) {
        Arrays.sort(nodes, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Object parent1 = TypedTreeModelImpl.this.provider.getParent(o1);
                Object parent2 = TypedTreeModelImpl.this.provider.getParent(o2);
                while (parent1 != null) {
                    if (parent2 == null) {
                        return 1;
                    }
                    parent1 = TypedTreeModelImpl.this.provider.getParent(parent1);
                    parent2 = TypedTreeModelImpl.this.provider.getParent(parent2);
                }
                return parent2 == null ? 0 : -1;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        int version = reader.readVersion(0, 1);
        boolean initStateAvailable = reader.readBoolean();
        boolean bl = this.defaultState = !initStateAvailable;
        if (initStateAvailable) {
            InitialState readState = new InitialState(reader, reporter);
            TypedTreeModelImpl typedTreeModelImpl = this;
            synchronized (typedTreeModelImpl) {
                this.initialState = readState;
            }
        }
        if (version >= 1) {
            int nrCols = reader.readInt32();
            int[] tmpColumnsOrder = new int[nrCols];
            for (int i = 0; i < nrCols; ++i) {
                tmpColumnsOrder[i] = reader.readInt32();
            }
            if (this.provider.getColumnSpec().getNrOfColumns() == nrCols) {
                this.columnsOrder = tmpColumnsOrder;
            }
        }
        if (reader.hasNext()) {
            boolean hasTitle = reader.readBoolean();
            String string = this.title = hasTitle ? reader.readString() : null;
        }
        assert (this.roots == null);
    }

    @Override
    public String getIconKey() {
        return this.provider.getIconKey();
    }

    @Override
    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        return this.provider.getTitle();
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InitialState getState() {
        TypedTreeModelImpl typedTreeModelImpl = this;
        synchronized (typedTreeModelImpl) {
            if (this.roots == null) {
                return null;
            }
        }
        final InitialState[] state = new InitialState[1];
        if (!this.runForegroundTask(new Runnable(){

            @Override
            public void run() {
                IntArrayList nodeParentIndices = new IntArrayList();
                IntArrayList nodePositions = new IntArrayList();
                ScreenViewState viewState = null;
                ObjectIdToIntHashSet nodeIndices = TypedTreeModelImpl.this.getNodesToWrite(nodeParentIndices, nodePositions);
                IntArrayList itemData = new IntArrayList();
                TypedTreeModelImpl.this.getItemData(itemData, nodeIndices);
                if (TypedTreeModelImpl.this.viewer instanceof ScreenModelViewer) {
                    ScreenModelViewer screenViewer = (ScreenModelViewer)TypedTreeModelImpl.this.viewer;
                    viewState = screenViewer.getViewState();
                }
                state[0] = new InitialState(nodeParentIndices, nodePositions, itemData, viewState, TypedTreeModelImpl.this.getColumnVisibility(), TypedTreeModelImpl.this.sortHistory);
            }
        })) {
            return null;
        }
        return state[0];
    }

    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        InitialState state;
        writer.writeVersion(1);
        InitialState initialState = state = this.initialState == null ? this.getState() : this.initialState;
        if (state != null) {
            writer.writeBoolean(true);
            state.write(writer, reporter);
        } else {
            writer.writeBoolean(false);
        }
        writer.writeInt32(this.columnsOrder.length);
        for (int i = 0; i < this.columnsOrder.length; ++i) {
            reporter.reportNextOrThrow();
            writer.writeInt32(this.columnsOrder[i]);
        }
        writer.writeBoolean(this.title != null);
        if (this.title != null) {
            writer.writeString(this.title);
        }
    }

    public long calculateWriteWork() {
        InitialState state;
        InitialState initialState = state = this.initialState == null ? this.getState() : this.initialState;
        if (state == null) {
            return this.columnsOrder.length;
        }
        return state.calculateWriteWork();
    }

    private Comparator<Object> getUniqueComparator(final int[] uniqueColumns) {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int compareResult = 0;
                for (int i = 0; i < uniqueColumns.length; ++i) {
                    UniqueEntry e1 = (UniqueEntry)TypedTreeModelImpl.this.provider.getEntry(o1, uniqueColumns[i]);
                    UniqueEntry e2 = (UniqueEntry)TypedTreeModelImpl.this.provider.getEntry(o2, uniqueColumns[i]);
                    if (e1 != null && e2 != null) {
                        compareResult = e1.compareToUnique(e2);
                    }
                    if (compareResult == 0) continue;
                    return compareResult;
                }
                return compareResult;
            }
        };
    }

    private ObjectIdToIntHashSet getNodesToWrite(IntArrayList parentIndices, IntArrayList positions) {
        if (this.roots == null) {
            return null;
        }
        int[] uniqueColums = this.getSpec().getUniqueColumns();
        if (uniqueColums.length == 0) {
            return null;
        }
        Comparator<Object> comparator = this.getUniqueComparator(uniqueColums);
        Object[] sortedRoots = (Object[])this.provider.getRootNodes().clone();
        Arrays.sort(sortedRoots, comparator);
        HashMap<Object, Object[]> sortedSiblings = new HashMap<Object, Object[]>();
        HashMap<Object, Object[]> sortedSubSiblings = new HashMap<Object, Object[]>();
        ObjectIdToIntHashSet nodeInidices = new ObjectIdToIntHashSet(0.25);
        TreeModelFullForwardIterator it = new TreeModelFullForwardIterator(this);
        while (it.hasNext()) {
            TreeModelItem item = it.next();
            if (item instanceof NormalItemImpl) {
                NormalItemImpl normalItem = (NormalItemImpl)item;
                Object node = normalItem.getNode();
                this.addNode(node, nodeInidices, parentIndices, positions, comparator, sortedRoots, sortedSiblings, sortedSubSiblings);
                continue;
            }
            if (!(item instanceof MultiItemImpl)) continue;
            MultiItemImpl multiItem = (MultiItemImpl)item;
            for (Object node : multiItem.getNodes()) {
                this.addNode(node, nodeInidices, parentIndices, positions, comparator, sortedRoots, sortedSiblings, sortedSubSiblings);
            }
        }
        return nodeInidices;
    }

    private void addNode(Object node, ObjectIdToIntHashSet nodeIndices, IntArrayList parentIndices, IntArrayList positions, Comparator<Object> comparator, Object[] sortedRoots, HashMap<Object, Object[]> sortedSiblings, HashMap<Object, Object[]> sortedSubSiblings) {
        Object[] siblings;
        Object parent = this.provider.getParent(node);
        boolean isSubNode = false;
        if (parent == null) {
            siblings = sortedRoots;
        } else if (this.provider.isSubNode(node)) {
            siblings = sortedSubSiblings.get(parent);
            if (siblings == null && (siblings = this.provider.getSubNodes(parent)).length > 1) {
                siblings = (Object[])siblings.clone();
                Arrays.sort(siblings, comparator);
                sortedSubSiblings.put(parent, siblings);
            }
            isSubNode = true;
        } else {
            siblings = sortedSiblings.get(parent);
            if (siblings == null && (siblings = this.provider.getChildren(parent)).length > 1) {
                siblings = (Object[])siblings.clone();
                Arrays.sort(siblings, comparator);
                sortedSiblings.put(parent, siblings);
            }
        }
        if (parent == null) {
            parentIndices.push(-1);
        } else {
            assert (nodeIndices.contains(parent));
            parentIndices.push(nodeIndices.get(parent));
        }
        for (int i = 0; i < siblings.length; ++i) {
            if (siblings[i] != node) continue;
            if (isSubNode) {
                positions.push(-i - 1);
                break;
            }
            positions.push(i);
            break;
        }
        if (parentIndices.size() != positions.size()) {
            Trace.warn((String)"HALLO FEHLER");
        }
        assert (parentIndices.size() == positions.size());
        nodeIndices.add(node, nodeIndices.size());
    }

    private void getItemData(IntArrayList itemData, ObjectIdToIntHashSet nodeIndices) {
        TreeModelFullForwardIterator it = new TreeModelFullForwardIterator(this);
        ObjectIdToIntHashSet itemIndices = new ObjectIdToIntHashSet();
        int itemIndex = 0;
        while (it.hasNext()) {
            int i;
            Object[] nodes;
            TreeModelItemImpl[] children;
            TreeModelItemImpl item = (TreeModelItemImpl)it.next();
            int state = 0;
            if (item.isExpanded() && ((children = item.getSubsOrChildren()).length > 1 || !(children[0] instanceof PlaceholderItemImpl))) {
                state |= 1;
            }
            if (item.isSelected()) {
                state |= 2;
            }
            if (item.showsSubItems()) {
                state |= 4;
            }
            if (item.hasChildren()) {
                state |= 8;
            }
            if (item.hasSubItems()) {
                state |= 0x10;
            }
            state = item.getParent() == null ? (state |= 0x100) : (item.isSubItem() ? (state |= 0x400) : (state |= 0x200));
            TreeModelItemImpl parent = item.getParent();
            int parentItemIndex = -1;
            if (parent != null) {
                assert (itemIndices.contains((Object)parent));
                parentItemIndex = itemIndices.get((Object)parent);
            }
            itemData.push(parentItemIndex);
            if (item instanceof NormalItemImpl) {
                NormalItemImpl normalItem = (NormalItemImpl)item;
                Object node = normalItem.getNode();
                assert (nodeIndices.contains(node));
                itemData.push(state | 0x20);
                itemData.push(nodeIndices.get(node));
            } else if (item instanceof OtherChildrenItemImpl) {
                OtherChildrenItemImpl otherItem = (OtherChildrenItemImpl)item;
                nodes = otherItem.getNodes();
                itemData.push(state | 0x40);
                itemData.push(nodes.length);
                for (i = 0; i < nodes.length; ++i) {
                    assert (nodeIndices.contains(nodes[i]));
                    itemData.push(nodeIndices.get(nodes[i]));
                }
            } else {
                SkippedChildrenItemImpl skippedItem = (SkippedChildrenItemImpl)item;
                nodes = skippedItem.getNodes();
                itemData.push(state | 0x80);
                itemData.push(nodes.length);
                for (i = 0; i < nodes.length; ++i) {
                    assert (nodeIndices.contains(nodes[i]));
                    itemData.push(nodeIndices.get(nodes[i]));
                }
            }
            itemIndices.add((Object)item, itemIndex);
            ++itemIndex;
        }
    }

    public boolean isModifiable() {
        return true;
    }

    @Override
    public XmlTreeExporter getXmlExporter(boolean selectedOnly) {
        XmlModelViewer xmlViewer = new XmlModelViewer();
        TypedTreeModelImpl xmlModel = this.copy(xmlViewer);
        return new XmlTreeExporter(xmlModel, selectedOnly);
    }

    @Override
    protected <R> R[][] getSelectedPaths(R[][] type) {
        Object[] selected = this.getSelectedNodes();
        ArrayList<ValueTreeNodeBase> nodes = new ArrayList<ValueTreeNodeBase>();
        for (int i = 0; i < selected.length; ++i) {
            Object node = selected[i];
            if (!(node instanceof ValueTreeNodeBase)) continue;
            nodes.add((ValueTreeNodeBase)selected[i]);
        }
        Object[][] result = (Object[][])Array.newInstance(type.getClass().getComponentType(), nodes.size());
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Object[])Array.newInstance(type.getClass().getComponentType().getComponentType(), ((ValueTreeNodeBase)nodes.get(i)).getDepth());
            ((ValueTreeNodeBase)nodes.get(i)).fillInPathFromRoots(result[i]);
        }
        return result;
    }

    @Override
    protected <R> R[] getSelectedRowTypes(R[] rowTypeArray) {
        return (Object[])Array.newInstance(rowTypeArray.getClass().getComponentType(), 0);
    }

    private static class InitialState {
        private static final int STATE_VERSION = 0;
        private IntArrayList parentIndices;
        private IntArrayList positions;
        private IntArrayList itemData;
        private ScreenViewState viewState;
        private String columnVisibility;
        private SortHistory sortHistory;

        public InitialState(IntArrayList parentIndices, IntArrayList positions, IntArrayList itemData, ScreenViewState viewState, String columnVisibility, SortHistory sortHistory) {
            this.parentIndices = parentIndices;
            this.positions = positions;
            this.itemData = itemData;
            this.viewState = viewState;
            this.columnVisibility = columnVisibility;
            this.sortHistory = sortHistory;
        }

        public InitialState(ResourceReader reader, ProgressReporter reporter) throws IOException {
            reader.readVersion(0, 0);
            this.parentIndices = new IntArrayList();
            this.positions = new IntArrayList();
            this.itemData = new IntArrayList();
            int nrOfNodes = reader.readInt32();
            reporter.setMessage(I18n._s((String)"Reading the tree model ... (<%> %)"));
            reporter.addToMaximumWork((long)nrOfNodes);
            for (int i = 0; i < nrOfNodes; ++i) {
                if (!reporter.reportNext()) {
                    throw new OperationCanceledException();
                }
                this.parentIndices.push(reader.readInt32());
                this.positions.push(reader.readInt32());
            }
            int itemDataSize = reader.readInt32();
            for (int i = 0; i < itemDataSize; ++i) {
                this.itemData.push(reader.readInt32());
            }
            if (reader.readBoolean()) {
                this.viewState = new ColumnViewState((BasicResourceReader)reader);
            }
            this.columnVisibility = reader.readString();
            this.sortHistory = new SortHistory(reader, reporter);
        }

        public IntArrayList getParentIndices() {
            return this.parentIndices;
        }

        public IntArrayList getPositions() {
            return this.positions;
        }

        public IntArrayList getItemData() {
            return this.itemData;
        }

        public ScreenViewState getViewState() {
            return this.viewState;
        }

        public String getColumnVisibility() {
            return this.columnVisibility;
        }

        public SortHistory getSortHistory() {
            return this.sortHistory;
        }

        public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
            int i;
            writer.writeVersion(0);
            int nrOfNodes = this.positions.size();
            int itemDataSize = this.itemData.size();
            writer.writeInt32(nrOfNodes);
            reporter.setMessage(I18n._s((String)"Writing the tree model ... (<% %>)"));
            reporter.addToMaximumWork((long)(nrOfNodes + itemDataSize));
            for (i = 0; i < nrOfNodes; ++i) {
                reporter.reportNextOrThrow();
                writer.writeInt32(this.parentIndices.get(i));
                writer.writeInt32(this.positions.get(i));
            }
            writer.writeInt32(itemDataSize);
            for (i = 0; i < itemDataSize; ++i) {
                reporter.reportNextOrThrow();
                writer.writeInt32(this.itemData.get(i));
            }
            writer.writeBoolean(this.viewState != null);
            if (this.viewState instanceof ColumnViewState) {
                this.viewState.write((BasicResourceWriter)writer, reporter);
            }
            writer.writeString(this.columnVisibility);
            this.sortHistory.write(writer, reporter);
        }

        public long calculateWriteWork() {
            return this.positions.size() + this.itemData.size();
        }
    }

    private final class ItemCreationListener
    implements ProgressReporterListener {
        private final PlaceholderItemImpl placeholderItem;

        public ItemCreationListener(PlaceholderItemImpl item) {
            this.placeholderItem = item;
        }

        public boolean report(ProgressReporter reporter) {
            String newText = reporter.getActualMessage();
            if (newText != null && !this.placeholderItem.getText().equals(newText)) {
                this.placeholderItem.setText(newText);
                TypedTreeModelImpl.this.notifyItemChanged(this.placeholderItem, null);
            }
            return true;
        }

        public void notifyFinished(ProgressReporter reporter) {
        }

        public boolean shouldCancel() {
            return false;
        }
    }
}

