/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed;

import com.sap.jvm.profiling.presentation.impl.typed.TypedValueSetModelImpl;
import com.sap.jvm.profiling.presentation.typed.Elements;
import com.sap.jvm.profiling.presentation.typed.TypedValueSetProvider;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.Resource;
import com.sap.jvm.profiling.resource.ResourceHandler;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;

public final class TypedValueSetModelCreator
implements ResourceHandler {
    public boolean canHandle(ResourceName name) {
        return name.endsWithType((ResourceNameElement)new Elements.CreateTypedValueSetModel());
    }

    public Resource create(ResourceName name, ProgressReporter reporter) throws IOException {
        assert (this.canHandle(name));
        ResourceName providerName = name.stripLastElement();
        ResourceManager manager = name.getResourceManager();
        Resource rawProvider = manager.get(providerName, reporter);
        if (rawProvider instanceof TypedValueSetProvider) {
            TypedValueSetProvider provider = (TypedValueSetProvider)rawProvider;
            TypedValueSetModelImpl model = new TypedValueSetModelImpl(provider, name);
            return model;
        }
        Trace.error((String)"Expected typed value set provider but got %s for resource <%s>", (Object[])new Object[]{rawProvider.getClass().getName(), name.toString()});
        throw new IOException("Wrong type");
    }

    public Resource read(ResourceName name, ResourceReader reader, ProgressReporter reporter) throws IOException {
        ResourceName providerName = name.stripLastElement();
        ResourceManager manager = name.getResourceManager();
        TypedValueSetProvider provider = (TypedValueSetProvider)manager.get(providerName, reporter);
        TypedValueSetModelImpl model = new TypedValueSetModelImpl(provider, name);
        model.read(reader, reporter);
        return model;
    }

    public void write(ResourceName name, Resource resource, ResourceWriter writer, ProgressReporter reporter) throws IOException {
        TypedValueSetModelImpl model = (TypedValueSetModelImpl)resource;
        model.write(writer, reporter);
    }

    public long calculateWriteWork(ResourceName name, Resource resource) {
        TypedValueSetModelImpl model = (TypedValueSetModelImpl)resource;
        return model.calculateWriteWork();
    }
}

