/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.AbstractSelectableColumnBasedModel;
import com.sap.jvm.profiling.presentation.impl.typed.PercentageBarGraphRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.PieGraphRendererImpl;
import com.sap.jvm.profiling.presentation.impl.typed.ValueBarGraphRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.axis.PercentageAxisModel;
import com.sap.jvm.profiling.presentation.typed.AxisModel;
import com.sap.jvm.profiling.presentation.typed.ColumnBasedModel;
import com.sap.jvm.profiling.presentation.typed.EntryRenderer;
import com.sap.jvm.profiling.presentation.typed.QuantityRenderer;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.presentation.typed.RendererThemeSpec;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.TypedModelRenderer;
import com.sap.jvm.profiling.presentation.typed.TypedModelRendererFactory;
import com.sap.jvm.profiling.presentation.typed.TypedValueSetModel;
import com.sap.jvm.profiling.presentation.typed.TypedValueSetProvider;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.PieGraphChart;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.graph.BarGraphRenderer;
import com.sap.jvm.profiling.viewer.graph.BarGraphRendererProvider;
import com.sap.jvm.profiling.viewer.graph.PieGraphRenderer;
import com.sap.jvm.profiling.viewer.graph.PieGraphRendererProvider;
import com.sap.jvm.profiling.viewer.graph.ValueSetGraphType;
import com.sap.jvm.profiling.viewer.graph.ValueSetModelListener;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;

public final class TypedValueSetModelImpl
extends AbstractSelectableColumnBasedModel
implements TypedValueSetModel {
    private static final int VERSION = 1;
    private final TypedValueSetProvider<?, ?> provider;
    private ModelViewer viewer;
    private ValueSetGraphType type;
    private RendererThemeSpec themeSpec;
    private String visibleSets;
    private boolean[] columnVisibility;
    private TypedModelRenderer renderer;
    private final ArrayList<ValueSetModelListener> listeners;
    private String title;
    private int[] selection;
    private InitialState initialState;
    private boolean defaultState;

    TypedValueSetModelImpl(TypedValueSetProvider<?, ?> provider, ResourceName name) {
        super(null, name, provider.getColumnSpec());
        this.provider = provider;
        this.listeners = new ArrayList();
        this.viewer = null;
        this.themeSpec = null;
        this.columnVisibility = new boolean[provider.getColumnSpec().getNrOfColumns()];
        this.selection = new int[0];
        this.type = new ValueSetGraphType(0);
        this.defaultState = true;
        this.setColumnVisibilityImpl(provider.getColumnSpec().getDefaultVisibleSets());
    }

    private TypedValueSetModelImpl(TypedValueSetProvider<?, ?> provider, RendererThemeSpec themeSpec, ModelViewer viewer, int[] selection, ValueSetGraphType type, String visibleSets, InitialState initialState) {
        super(viewer.getTaskManager(), null, provider.getColumnSpec());
        this.provider = provider;
        this.renderer = TypedModelRendererFactory.get(viewer, themeSpec);
        this.listeners = new ArrayList();
        this.viewer = viewer;
        this.themeSpec = themeSpec;
        this.visibleSets = visibleSets;
        this.columnVisibility = provider.getColumnSpec().getColumnVisibility(visibleSets);
        this.selection = selection;
        this.type = type;
        this.initialState = initialState;
        this.defaultState = initialState == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ValueSetModelListener listener) {
        ArrayList<ValueSetModelListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    @Override
    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        return this.provider.getTitle();
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean removeListener(ValueSetModelListener listener) {
        ValueSetModelListener valueSetModelListener = listener;
        synchronized (valueSetModelListener) {
            return this.listeners.remove(listener);
        }
    }

    public final ResourceName[] getDependents() {
        return null;
    }

    @Override
    public void changeTheme(RendererThemeSpec spec) {
        this.themeSpec = spec;
    }

    @Override
    public TypedValueSetModelImpl copy(ModelViewer newViewer) {
        TypedValueSetModelImpl copy = new TypedValueSetModelImpl(this.provider, this.themeSpec, newViewer, this.selection, this.type, this.visibleSets, this.initialState);
        return copy;
    }

    @Override
    public RendererTheme getTheme() {
        if (this.renderer != null) {
            return this.renderer.getTheme();
        }
        return null;
    }

    @Override
    public void removeViewer() {
        this.initialState = this.getState();
        this.defaultState = false;
        this.setTaskManager(null);
        this.viewer = null;
    }

    @Override
    public void setViewer(ModelViewer viewer, RendererThemeSpec spec) {
        this.viewer = viewer;
        this.setTaskManager(viewer.getTaskManager());
        this.renderer = TypedModelRendererFactory.get(viewer, spec);
        this.themeSpec = spec;
    }

    @Override
    public String getToolTip(int index, int column) {
        Quantity valueEntry = this.provider.getEntry(index, column);
        return this.renderer.getRenderer(valueEntry.getClass()).getToolTipForGraph(valueEntry, this.provider.getEntryContext(), this.provider.getColumnContext(column));
    }

    public boolean isModifiable() {
        return true;
    }

    @Override
    public void createData() {
        if (this.dataCreated()) {
            this.notifyDataCreated(null);
            return;
        }
        this.runBackgroundTask(new Runnable(){

            @Override
            public void run() {
                final ProgressReporter reporter = TypedValueSetModelImpl.this.getRootCreationProgressReporter();
                IOException createException = null;
                try {
                    TypedValueSetModelImpl.this.provider.createStatistic(reporter);
                }
                catch (IOException e) {
                    createException = e;
                }
                catch (Throwable t) {
                    createException = new IOException("Could not create the data");
                    createException.initCause(t);
                }
                TypedValueSetModelImpl.this.provider.valueSetCreated();
                final IOException finalCreateException = createException;
                if (!TypedValueSetModelImpl.this.runForegroundTask(new Runnable(){

                    @Override
                    public void run() {
                        reporter.finish();
                        if (TypedValueSetModelImpl.this.initialState != null) {
                            TypedValueSetModelImpl.access$202(TypedValueSetModelImpl.this, TypedValueSetModelImpl.this.initialState.getSelection());
                            TypedValueSetModelImpl.this.type = TypedValueSetModelImpl.this.initialState.getGraphType();
                            TypedValueSetModelImpl.this.setColumnVisibilityImpl(TypedValueSetModelImpl.this.initialState.getColumnVisibility());
                            TypedValueSetModelImpl.this.initialState = null;
                            TypedValueSetModelImpl.this.defaultState = false;
                        }
                        TypedValueSetModelImpl.this.notifyDataCreated(finalCreateException);
                    }
                })) {
                    reporter.finish();
                }
            }
        });
    }

    @Override
    public boolean dataCreated() {
        return this.provider.getStatistic() != null;
    }

    @Override
    public ModelViewer getViewer() {
        return this.viewer;
    }

    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(1, 1);
        if (reader.hasNext()) {
            boolean hasTitle = reader.readBoolean();
            this.title = hasTitle ? reader.readString() : null;
            this.initialState = new InitialState(reader, reporter);
            this.defaultState = false;
        }
    }

    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        writer.writeBoolean(this.title != null);
        if (this.title != null) {
            writer.writeString(this.title);
        }
        this.getState().write(writer, reporter);
    }

    public long calculateWriteWork() {
        return 0L;
    }

    @Override
    public RendererNode getRenderer(int row, int column) {
        Quantity quantity = this.provider.getEntry(row, column);
        return this.renderer.getRenderer(this.provider.getColumnSpec().getColumnType(column)).getRenderer(quantity, this.provider.getEntryContext(), this.provider.getColumnContext(column));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ValueSetModelListener> getListenerCopy() {
        ArrayList<ValueSetModelListener> arrayList = this.listeners;
        synchronized (arrayList) {
            return new ArrayList<ValueSetModelListener>(this.listeners);
        }
    }

    private final void notifyDataCreated(final IOException exeption) {
        for (final ValueSetModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.dataCreated(TypedValueSetModelImpl.this, exeption);
                }
            });
        }
    }

    @Override
    public long getValue(int row, int column) {
        return this.provider.getValue(row, column);
    }

    @Override
    public BarGraphRendererProvider getPercentageBarGraphProvider() {
        return new BarGraphRendererProvider(){

            @Override
            public BarGraphRenderer getRenderer(int column, int idx, GraphChartContainer container) {
                return new PercentageBarGraphRenderer(TypedValueSetModelImpl.this, column, idx, container, new PercentageAxisModel());
            }
        };
    }

    @Override
    public PieGraphRendererProvider getPieBarGraphProvider() {
        return new PieGraphRendererProvider(){

            @Override
            public PieGraphRenderer getRenderer(int column, int idx, PieGraphChart chart) {
                return new PieGraphRendererImpl(TypedValueSetModelImpl.this, column);
            }
        };
    }

    @Override
    public BarGraphRendererProvider getValueBarGraphProvider() {
        return new BarGraphRendererProvider(){

            @Override
            public BarGraphRenderer getRenderer(int column, int idx, GraphChartContainer container) {
                Class<?> columnType = TypedValueSetModelImpl.this.provider.getColumnSpec().getColumnType(column);
                EntryRenderer er = TypedValueSetModelImpl.this.renderer.getRenderer(columnType);
                AxisModel axisModel = ((QuantityRenderer)((Object)er)).getAxisModel();
                return new ValueBarGraphRenderer(TypedValueSetModelImpl.this, column, idx, container, axisModel);
            }
        };
    }

    @Override
    public String getIconKey() {
        return this.provider.getIconKey();
    }

    @Override
    public String getColumnVisibility() {
        return this.visibleSets;
    }

    @Override
    public TypedColumnSpec getSpec() {
        return this.provider.getColumnSpec();
    }

    @Override
    public void setColumnVisibility(String spec) {
        this.setColumnVisibilityImpl(spec);
        for (final ValueSetModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.columnsChanged(TypedValueSetModelImpl.this);
                }
            });
        }
    }

    private void setColumnVisibilityImpl(String spec) {
        this.visibleSets = spec;
        this.columnVisibility = this.provider.getColumnSpec().getColumnVisibility(this.visibleSets);
    }

    @Override
    public void setColumnOrder(int[] order) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getColumnOrder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypedColumnSpec getColumnSpec() {
        return this.provider.getColumnSpec();
    }

    @Override
    public String getColumnName(int column) {
        return this.provider.getColumnSpec().getColumnText(column);
    }

    @Override
    public String getColumnToolTip(int column) {
        return this.provider.getColumnSpec().getColumnToolTip(column);
    }

    @Override
    public int getNrOfColumns() {
        return this.provider.getColumnSpec().getNrOfColumns();
    }

    @Override
    public int getNrOfRows() {
        return this.provider.getNrOfRows();
    }

    @Override
    public int getRowColor(int row) {
        return this.renderer.getTheme().getColor(this.provider.getRowColorTag(row));
    }

    @Override
    public String getRowName(int row) {
        return this.provider.getRowName(row);
    }

    @Override
    public String getRowToolTip(int row) {
        return this.provider.getRowToolTip(row);
    }

    @Override
    public boolean isColumnVisible(int column) {
        return this.columnVisibility[column];
    }

    @Override
    public void setGraphType(ValueSetGraphType newType) {
        this.type = newType;
        for (final ValueSetModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.graphTypeChanged(TypedValueSetModelImpl.this, TypedValueSetModelImpl.this.type);
                }
            });
        }
    }

    @Override
    public ValueSetGraphType getGraphType() {
        return this.type;
    }

    @Override
    public int[] getSelectedRows() {
        return (int[])this.selection.clone();
    }

    @Override
    public boolean isAnySelected() {
        return this.selection.length > 0;
    }

    @Override
    public boolean isSingleSelected() {
        return this.selection.length == 1;
    }

    @Override
    public boolean isInDefaultState() {
        return this.defaultState;
    }

    @Override
    public boolean isComparableWith(ColumnBasedModel other) {
        return false;
    }

    @Override
    public ProviderEntry[] getSelectedEntries(int column) {
        ProviderEntry[] result = new Quantity[this.selection.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.provider.getEntry(this.selection[i], column);
        }
        return result;
    }

    @Override
    public void setSelectedRows(final int[] rows) {
        this.selection = (int[])rows.clone();
        for (final ValueSetModelListener listener : this.getListenerCopy()) {
            this.runForegroundTask(new Runnable(){

                @Override
                public void run() {
                    listener.selectedRowsChanged(TypedValueSetModelImpl.this, rows);
                }
            });
        }
    }

    private InitialState getState() {
        final InitialState[] result = new InitialState[]{new InitialState(new int[0], new ValueSetGraphType(0), this.getColumnVisibility())};
        this.runForegroundTask(new Runnable(){

            @Override
            public void run() {
                result[0] = new InitialState(TypedValueSetModelImpl.this.getSelectedRows(), TypedValueSetModelImpl.this.getGraphType(), TypedValueSetModelImpl.this.getColumnVisibility());
            }
        });
        return result[0];
    }

    @Override
    public Object getRowType(int row) {
        return this.provider.getRowType(row);
    }

    @Override
    public int getSortDirection() {
        return -1;
    }

    @Override
    public int getSortedColumn() {
        return 0;
    }

    @Override
    public void setSorting(int column, int order) {
    }

    @Override
    protected <R> R[][] getSelectedPaths(R[][] prototype) {
        return (Object[][])Array.newInstance(prototype.getClass().getComponentType(), 0);
    }

    @Override
    protected <R> R[] getSelectedRowTypes(R[] rowTypeArray) {
        int[] selectedRows = this.getSelectedRows();
        int length = selectedRows.length;
        Object[] result = (Object[])Array.newInstance(rowTypeArray.getClass().getComponentType(), length);
        for (int i = 0; i < length; ++i) {
            result[i] = this.getRowType(selectedRows[i]);
        }
        return result;
    }

    static /* synthetic */ int[] access$202(TypedValueSetModelImpl x0, int[] x1) {
        x0.selection = x1;
        return x1;
    }

    private static class InitialState {
        private int[] selection;
        private ValueSetGraphType graphType;
        private String columnVisibility;

        public InitialState(int[] selection, ValueSetGraphType graphType, String columnVisibility) {
            this.selection = selection;
            this.graphType = graphType;
            this.columnVisibility = columnVisibility;
        }

        public InitialState(ResourceReader reader, ProgressReporter reporter) throws IOException {
            int nrOfSelectedItems = reader.readInt32();
            this.selection = new int[nrOfSelectedItems];
            reporter.setMessage(I18n._s((String)"Reading the graph model ... (<% %>)"));
            reporter.addToMaximumWork((long)nrOfSelectedItems);
            for (int i = 0; i < nrOfSelectedItems; ++i) {
                if (!reporter.reportNext()) {
                    throw new OperationCanceledException();
                }
                this.selection[i] = reader.readInt32();
            }
            this.graphType = new ValueSetGraphType(reader);
            this.columnVisibility = reader.readString();
        }

        public int[] getSelection() {
            return this.selection;
        }

        public String getColumnVisibility() {
            return this.columnVisibility;
        }

        public ValueSetGraphType getGraphType() {
            return this.graphType;
        }

        public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
            reporter.setMessage(I18n._s((String)"Writing the table model ... (<% %>)"));
            reporter.addToMaximumWork((long)this.selection.length);
            writer.writeInt32(this.selection.length);
            for (int index : this.selection) {
                if (!reporter.reportNext()) {
                    throw new OperationCanceledException();
                }
                writer.writeInt32(index);
            }
            this.graphType.write(writer);
            writer.writeString(this.columnVisibility);
        }
    }
}

